/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Manager;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.util.ContextName;
import org.apache.catalina.util.IOTools;
import org.apache.catalina.util.ServerInfo;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.tomcat.util.Diagnostics;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.Escape;

public class ManagerServlet
extends HttpServlet
implements ContainerServlet {
    private static final long serialVersionUID = 1L;
    protected File configBase = null;
    protected transient Context context = null;
    protected int debug = 1;
    protected File versioned = null;
    protected transient Host host = null;
    protected transient MBeanServer mBeanServer = null;
    protected ObjectName oname = null;
    protected transient javax.naming.Context global = null;
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.manager");
    protected transient Wrapper wrapper = null;

    @Override
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
        if (wrapper == null) {
            this.context = null;
            this.host = null;
            this.oname = null;
        } else {
            this.context = (Context)wrapper.getParent();
            this.host = (Host)this.context.getParent();
            Engine engine = (Engine)this.host.getParent();
            String string = engine.getName() + ":type=Deployer,host=" + this.host.getName();
            try {
                this.oname = new ObjectName(string);
            }
            catch (Exception exception) {
                this.log(sm.getString("managerServlet.objectNameFail", new Object[]{string}), exception);
            }
        }
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
    }

    public void destroy() {
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        StringManager stringManager = StringManager.getManager((String)"org.apache.catalina.manager", (Enumeration)httpServletRequest.getLocales());
        String string = httpServletRequest.getPathInfo();
        if (string == null) {
            string = httpServletRequest.getServletPath();
        }
        String string2 = httpServletRequest.getParameter("path");
        String string3 = httpServletRequest.getParameter("war");
        String string4 = httpServletRequest.getParameter("config");
        ContextName contextName = null;
        if (string2 != null) {
            contextName = new ContextName(string2, httpServletRequest.getParameter("version"));
        } else if (string4 != null) {
            contextName = ContextName.extractFromPath(string4);
        } else if (string3 != null) {
            contextName = ContextName.extractFromPath(string3);
        }
        String string5 = httpServletRequest.getParameter("type");
        String string6 = httpServletRequest.getParameter("tag");
        boolean bl = false;
        if (httpServletRequest.getParameter("update") != null && httpServletRequest.getParameter("update").equals("true")) {
            bl = true;
        }
        String string7 = httpServletRequest.getParameter("tlsHostName");
        boolean bl2 = false;
        if ("true".equals(httpServletRequest.getParameter("statusLine"))) {
            bl2 = true;
        }
        httpServletResponse.setContentType("text/plain; charset=utf-8");
        httpServletResponse.setHeader("X-Content-Type-Options", "nosniff");
        PrintWriter printWriter = httpServletResponse.getWriter();
        if (string == null) {
            printWriter.println(stringManager.getString("managerServlet.noCommand"));
        } else if (string.equals("/deploy")) {
            if (string3 != null || string4 != null) {
                this.deploy(printWriter, string4, contextName, string3, bl, stringManager);
            } else if (string6 != null) {
                this.deploy(printWriter, contextName, string6, stringManager);
            } else {
                printWriter.println(stringManager.getString("managerServlet.invalidCommand", new Object[]{string}));
            }
        } else if (string.equals("/list")) {
            this.list(printWriter, stringManager);
        } else if (string.equals("/reload")) {
            this.reload(printWriter, contextName, stringManager);
        } else if (string.equals("/resources")) {
            this.resources(printWriter, string5, stringManager);
        } else if (string.equals("/save")) {
            this.save(printWriter, string2, stringManager);
        } else if (string.equals("/serverinfo")) {
            this.serverinfo(printWriter, stringManager);
        } else if (string.equals("/sessions")) {
            this.expireSessions(printWriter, contextName, httpServletRequest, stringManager);
        } else if (string.equals("/expire")) {
            this.expireSessions(printWriter, contextName, httpServletRequest, stringManager);
        } else if (string.equals("/start")) {
            this.start(printWriter, contextName, stringManager);
        } else if (string.equals("/stop")) {
            this.stop(printWriter, contextName, stringManager);
        } else if (string.equals("/undeploy")) {
            this.undeploy(printWriter, contextName, stringManager);
        } else if (string.equals("/findleaks")) {
            this.findleaks(bl2, printWriter, stringManager);
        } else if (string.equals("/vminfo")) {
            this.vmInfo(printWriter, stringManager, httpServletRequest.getLocales());
        } else if (string.equals("/threaddump")) {
            this.threadDump(printWriter, stringManager, httpServletRequest.getLocales());
        } else if (string.equals("/sslConnectorCiphers")) {
            this.sslConnectorCiphers(printWriter, stringManager);
        } else if (string.equals("/sslConnectorCerts")) {
            this.sslConnectorCerts(printWriter, stringManager);
        } else if (string.equals("/sslConnectorTrustedCerts")) {
            this.sslConnectorTrustedCerts(printWriter, stringManager);
        } else if (string.equals("/sslReload")) {
            this.sslReload(printWriter, string7, stringManager);
        } else {
            printWriter.println(stringManager.getString("managerServlet.unknownCommand", new Object[]{string}));
        }
        printWriter.flush();
        printWriter.close();
    }

    public void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        StringManager stringManager = StringManager.getManager((String)"org.apache.catalina.manager", (Enumeration)httpServletRequest.getLocales());
        String string = httpServletRequest.getPathInfo();
        if (string == null) {
            string = httpServletRequest.getServletPath();
        }
        String string2 = httpServletRequest.getParameter("path");
        ContextName contextName = null;
        if (string2 != null) {
            contextName = new ContextName(string2, httpServletRequest.getParameter("version"));
        }
        String string3 = httpServletRequest.getParameter("config");
        String string4 = httpServletRequest.getParameter("tag");
        boolean bl = false;
        if (httpServletRequest.getParameter("update") != null && httpServletRequest.getParameter("update").equals("true")) {
            bl = true;
        }
        httpServletResponse.setContentType("text/plain;charset=utf-8");
        httpServletResponse.setHeader("X-Content-Type-Options", "nosniff");
        PrintWriter printWriter = httpServletResponse.getWriter();
        if (string == null) {
            printWriter.println(stringManager.getString("managerServlet.noCommand"));
        } else if (string.equals("/deploy")) {
            this.deploy(printWriter, string3, contextName, string4, bl, httpServletRequest, stringManager);
        } else {
            printWriter.println(stringManager.getString("managerServlet.unknownCommand", new Object[]{string}));
        }
        printWriter.flush();
        printWriter.close();
    }

    public void init() throws ServletException {
        if (this.wrapper == null || this.context == null) {
            throw new UnavailableException(sm.getString("managerServlet.noWrapper"));
        }
        String string = null;
        try {
            string = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
        }
        Server server = ((Engine)this.host.getParent()).getService().getServer();
        if (server != null) {
            this.global = server.getGlobalNamingContext();
        }
        this.versioned = (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir");
        this.configBase = new File(this.context.getCatalinaBase(), "conf");
        Context context = null;
        Context context2 = null;
        for (Container container = this.context; container != null; container = container.getParent()) {
            if (container instanceof Host) {
                context = container;
            }
            if (!(container instanceof Engine)) continue;
            context2 = container;
        }
        if (context2 != null) {
            this.configBase = new File(this.configBase, context2.getName());
        }
        if (context != null) {
            this.configBase = new File(this.configBase, context.getName());
        }
        if (this.debug >= 1) {
            this.log("init: Associated with Deployer '" + this.oname + "'");
            if (this.global != null) {
                this.log("init: Global resources are available");
            }
        }
    }

    protected void findleaks(boolean bl, PrintWriter printWriter, StringManager stringManager) {
        if (!(this.host instanceof StandardHost)) {
            printWriter.println(stringManager.getString("managerServlet.findleaksFail"));
            return;
        }
        String[] stringArray = ((StandardHost)this.host).findReloadedContextMemoryLeaks();
        if (stringArray.length > 0) {
            if (bl) {
                printWriter.println(stringManager.getString("managerServlet.findleaksList"));
            }
            for (String string : stringArray) {
                if (string.isEmpty()) {
                    string = "/";
                }
                printWriter.println(string);
            }
        } else if (bl) {
            printWriter.println(stringManager.getString("managerServlet.findleaksNone"));
        }
    }

    protected void sslReload(PrintWriter printWriter, String string, StringManager stringManager) {
        Connector[] connectorArray = this.getConnectors();
        boolean bl = false;
        for (Connector connector : connectorArray) {
            SSLHostConfig[] sSLHostConfigArray;
            ProtocolHandler protocolHandler;
            if (!Boolean.TRUE.equals(connector.getProperty("SSLEnabled")) || !((protocolHandler = connector.getProtocolHandler()) instanceof AbstractHttp11Protocol)) continue;
            AbstractHttp11Protocol abstractHttp11Protocol = (AbstractHttp11Protocol)protocolHandler;
            if (string == null || string.length() == 0) {
                bl = true;
                abstractHttp11Protocol.reloadSslHostConfigs();
                continue;
            }
            for (SSLHostConfig sSLHostConfig : sSLHostConfigArray = abstractHttp11Protocol.findSslHostConfigs()) {
                if (!sSLHostConfig.getHostName().equalsIgnoreCase(string)) continue;
                bl = true;
                abstractHttp11Protocol.reloadSslHostConfig(string);
            }
        }
        if (bl) {
            if (string == null || string.length() == 0) {
                printWriter.println(stringManager.getString("managerServlet.sslReloadAll"));
            } else {
                printWriter.println(stringManager.getString("managerServlet.sslReload", new Object[]{string}));
            }
        } else {
            printWriter.println(stringManager.getString("managerServlet.sslReloadFail"));
        }
    }

    protected void vmInfo(PrintWriter printWriter, StringManager stringManager, Enumeration<Locale> enumeration) {
        printWriter.println(stringManager.getString("managerServlet.vminfo"));
        printWriter.print(Diagnostics.getVMInfo(enumeration));
    }

    protected void threadDump(PrintWriter printWriter, StringManager stringManager, Enumeration<Locale> enumeration) {
        printWriter.println(stringManager.getString("managerServlet.threaddump"));
        printWriter.print(Diagnostics.getThreadDump(enumeration));
    }

    protected void sslConnectorCiphers(PrintWriter printWriter, StringManager stringManager) {
        printWriter.println(stringManager.getString("managerServlet.sslConnectorCiphers"));
        Map<String, List<String>> map = this.getConnectorCiphers(stringManager);
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            printWriter.println(entry.getKey());
            for (String string : entry.getValue()) {
                printWriter.print("  ");
                printWriter.println(string);
            }
        }
    }

    private void sslConnectorCerts(PrintWriter printWriter, StringManager stringManager) {
        printWriter.println(stringManager.getString("managerServlet.sslConnectorCerts"));
        Map<String, List<String>> map = this.getConnectorCerts(stringManager);
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            printWriter.println(entry.getKey());
            for (String string : entry.getValue()) {
                printWriter.println(string);
            }
        }
    }

    private void sslConnectorTrustedCerts(PrintWriter printWriter, StringManager stringManager) {
        printWriter.println(stringManager.getString("managerServlet.sslConnectorTrustedCerts"));
        Map<String, List<String>> map = this.getConnectorTrustedCerts(stringManager);
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            printWriter.println(entry.getKey());
            for (String string : entry.getValue()) {
                printWriter.println(string);
            }
        }
    }

    protected synchronized void save(PrintWriter printWriter, String string, StringManager stringManager) {
        ObjectName objectName;
        try {
            objectName = new ObjectName("Catalina:type=StoreConfig");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            this.log(sm.getString("managerServlet.exception"), malformedObjectNameException);
            printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{malformedObjectNameException.toString()}));
            return;
        }
        if (!this.mBeanServer.isRegistered(objectName)) {
            printWriter.println(stringManager.getString("managerServlet.storeConfig.noMBean", new Object[]{objectName}));
            return;
        }
        if (string == null || string.length() == 0 || !string.startsWith("/")) {
            try {
                this.mBeanServer.invoke(objectName, "storeConfig", null, null);
                printWriter.println(stringManager.getString("managerServlet.saved"));
            }
            catch (Exception exception) {
                this.log(sm.getString("managerServlet.error.storeConfig"), exception);
                printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{exception.toString()}));
            }
        } else {
            Context context;
            String string2 = string;
            if (string.equals("/")) {
                string2 = "";
            }
            if ((context = (Context)this.host.findChild(string2)) == null) {
                printWriter.println(stringManager.getString("managerServlet.noContext", new Object[]{string}));
                return;
            }
            try {
                Boolean bl = (Boolean)this.mBeanServer.invoke(objectName, "store", new Object[]{context}, new String[]{"org.apache.catalina.Context"});
                if (bl.booleanValue()) {
                    printWriter.println(stringManager.getString("managerServlet.savedContext", new Object[]{string}));
                } else {
                    printWriter.println(stringManager.getString("managerServlet.savedContextFail", new Object[]{string}));
                }
            }
            catch (Exception exception) {
                this.log(sm.getString("managerServlet.error.storeContextConfig", new Object[]{string}), exception);
                printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{exception.toString()}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void deploy(PrintWriter printWriter, String string, ContextName contextName, String string2, boolean bl, HttpServletRequest httpServletRequest, StringManager stringManager) {
        String string3;
        String string4;
        block30: {
            File file;
            if (string != null && string.length() == 0) {
                string = null;
            }
            if (this.debug >= 1) {
                if (string == null) {
                    this.log("deploy: Deploying web application '" + contextName + "'");
                } else {
                    this.log("deploy: Deploying web application '" + contextName + "' with context configuration at '" + string + "'");
                }
            }
            if (!ManagerServlet.validateContextName(contextName, printWriter, stringManager)) {
                return;
            }
            string4 = contextName.getName();
            String string5 = contextName.getBaseName();
            string3 = contextName.getDisplayName();
            Context context = (Context)this.host.findChild(string4);
            if (context != null && !bl) {
                printWriter.println(stringManager.getString("managerServlet.alreadyContext", new Object[]{string3}));
                return;
            }
            if (string != null && string.startsWith("file:")) {
                string = string.substring("file:".length());
            }
            File file2 = new File(this.host.getAppBaseFile(), string5 + ".war");
            if (string2 == null) {
                if (bl) {
                    file = new File(file2.getAbsolutePath() + ".tmp");
                    if (file.exists() && !file.delete()) {
                        printWriter.println(stringManager.getString("managerServlet.deleteFail", new Object[]{file}));
                    }
                } else {
                    file = file2;
                }
            } else {
                File file3 = new File(this.versioned, string2);
                if (!file3.mkdirs() && !file3.isDirectory()) {
                    printWriter.println(stringManager.getString("managerServlet.mkdirFail", new Object[]{file3}));
                    return;
                }
                file = new File(file3, string5 + ".war");
            }
            if (this.debug >= 2) {
                this.log("Uploading WAR file to " + file);
            }
            try {
                if (this.isServiced(string4)) {
                    printWriter.println(stringManager.getString("managerServlet.inService", new Object[]{string3}));
                    break block30;
                }
                this.addServiced(string4);
                try {
                    if (string != null) {
                        if (!this.configBase.mkdirs() && !this.configBase.isDirectory()) {
                            printWriter.println(stringManager.getString("managerServlet.mkdirFail", new Object[]{this.configBase}));
                            return;
                        }
                        if (!ExpandWar.copy(new File(string), new File(this.configBase, string5 + ".xml"))) {
                            throw new Exception(sm.getString("managerServlet.copyError", new Object[]{string}));
                        }
                    }
                    this.uploadWar(printWriter, httpServletRequest, file, stringManager);
                    if (bl && string2 == null) {
                        if (file2.exists() && !file2.delete()) {
                            printWriter.println(stringManager.getString("managerServlet.deleteFail", new Object[]{file2}));
                            return;
                        }
                        if (!file.renameTo(file2)) {
                            printWriter.println(stringManager.getString("managerServlet.renameFail", new Object[]{file, file2}));
                            return;
                        }
                    }
                    if (string2 != null) {
                        ExpandWar.copy(file, file2);
                    }
                    this.check(string4);
                }
                finally {
                    this.removeServiced(string4);
                }
            }
            catch (Exception exception) {
                this.log(sm.getString("managerServlet.error.deploy", new Object[]{string3}), exception);
                printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{exception.toString()}));
                return;
            }
        }
        this.writeDeployResult(printWriter, stringManager, string4, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deploy(PrintWriter printWriter, ContextName contextName, String string, StringManager stringManager) {
        String string2;
        String string3;
        block9: {
            if (!ManagerServlet.validateContextName(contextName, printWriter, stringManager)) {
                return;
            }
            String string4 = contextName.getBaseName();
            string3 = contextName.getName();
            string2 = contextName.getDisplayName();
            File file = new File(new File(this.versioned, string), string4 + ".war");
            File file2 = new File(this.host.getAppBaseFile(), string4 + ".war");
            try {
                if (this.isServiced(string3)) {
                    printWriter.println(stringManager.getString("managerServlet.inService", new Object[]{string2}));
                    break block9;
                }
                this.addServiced(string3);
                try {
                    if (!file2.delete()) {
                        printWriter.println(stringManager.getString("managerServlet.deleteFail", new Object[]{file2}));
                        return;
                    }
                    ExpandWar.copy(file, file2);
                    this.check(string3);
                }
                finally {
                    this.removeServiced(string3);
                }
            }
            catch (Exception exception) {
                this.log(sm.getString("managerServlet.error.deploy", new Object[]{string2}), exception);
                printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{exception.toString()}));
                return;
            }
        }
        this.writeDeployResult(printWriter, stringManager, string3, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deploy(PrintWriter printWriter, String string, ContextName contextName, String string2, boolean bl, StringManager stringManager) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (this.debug >= 1) {
            if (string != null) {
                if (string2 != null) {
                    this.log("install: Installing context configuration at '" + string + "' from '" + string2 + "'");
                } else {
                    this.log("install: Installing context configuration at '" + string + "'");
                }
            } else if (contextName != null) {
                this.log("install: Installing web application '" + contextName + "' from '" + string2 + "'");
            } else {
                this.log("install: Installing web application from '" + string2 + "'");
            }
        }
        if (!ManagerServlet.validateContextName(contextName, printWriter, stringManager)) {
            return;
        }
        String string3 = contextName.getName();
        String string4 = contextName.getBaseName();
        String string5 = contextName.getDisplayName();
        Context context = (Context)this.host.findChild(string3);
        if (context != null && !bl) {
            printWriter.println(stringManager.getString("managerServlet.alreadyContext", new Object[]{string5}));
            return;
        }
        if (string != null && string.startsWith("file:")) {
            string = string.substring("file:".length());
        }
        if (string2 != null && string2.startsWith("file:")) {
            string2 = string2.substring("file:".length());
        }
        try {
            if (this.isServiced(string3)) {
                printWriter.println(stringManager.getString("managerServlet.inService", new Object[]{string5}));
            } else {
                this.addServiced(string3);
                try {
                    File file;
                    if (string != null) {
                        if (!this.configBase.mkdirs() && !this.configBase.isDirectory()) {
                            printWriter.println(stringManager.getString("managerServlet.mkdirFail", new Object[]{this.configBase}));
                            return;
                        }
                        file = new File(this.configBase, string4 + ".xml");
                        if (file.isFile() && !file.delete()) {
                            printWriter.println(stringManager.getString("managerServlet.deleteFail", new Object[]{file}));
                            return;
                        }
                        ExpandWar.copy(new File(string), file);
                    }
                    if (string2 != null) {
                        file = string2.endsWith(".war") ? new File(this.host.getAppBaseFile(), string4 + ".war") : new File(this.host.getAppBaseFile(), string4);
                        if (file.exists() && !ExpandWar.delete(file)) {
                            printWriter.println(stringManager.getString("managerServlet.deleteFail", new Object[]{file}));
                            return;
                        }
                        ExpandWar.copy(new File(string2), file);
                    }
                    this.check(string3);
                }
                finally {
                    this.removeServiced(string3);
                }
            }
            this.writeDeployResult(printWriter, stringManager, string3, string5);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.log(sm.getString("managerServlet.error.deploy", new Object[]{string5}), throwable);
            printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{throwable.toString()}));
        }
    }

    private void writeDeployResult(PrintWriter printWriter, StringManager stringManager, String string, String string2) {
        Context context = (Context)this.host.findChild(string);
        if (context != null && context.getConfigured() && context.getState().isAvailable()) {
            printWriter.println(stringManager.getString("managerServlet.deployed", new Object[]{string2}));
        } else if (context != null && !context.getState().isAvailable()) {
            printWriter.println(stringManager.getString("managerServlet.deployedButNotStarted", new Object[]{string2}));
        } else {
            printWriter.println(stringManager.getString("managerServlet.deployFailed", new Object[]{string2}));
        }
    }

    protected void list(PrintWriter printWriter, StringManager stringManager) {
        Container[] containerArray;
        if (this.debug >= 1) {
            this.log("list: Listing contexts for virtual host '" + this.host.getName() + "'");
        }
        printWriter.println(stringManager.getString("managerServlet.listed", new Object[]{this.host.getName()}));
        for (Container container : containerArray = this.host.findChildren()) {
            Context context = (Context)container;
            if (context == null) continue;
            String string = context.getPath();
            if (string.equals("")) {
                string = "/";
            }
            List<String> list = null;
            list = context.getState().isAvailable() ? Arrays.asList(string, "running", "" + context.getManager().findSessions().length, context.getDocBase()) : Arrays.asList(string, "stopped", "0", context.getDocBase());
            printWriter.println(StringUtils.join(list, (char)':'));
        }
    }

    protected void reload(PrintWriter printWriter, ContextName contextName, StringManager stringManager) {
        if (this.debug >= 1) {
            this.log("restart: Reloading web application '" + contextName + "'");
        }
        if (!ManagerServlet.validateContextName(contextName, printWriter, stringManager)) {
            return;
        }
        try {
            Context context = (Context)this.host.findChild(contextName.getName());
            if (context == null) {
                printWriter.println(stringManager.getString("managerServlet.noContext", new Object[]{Escape.htmlElementContent((String)contextName.getDisplayName())}));
                return;
            }
            if (context.getName().equals(this.context.getName())) {
                printWriter.println(stringManager.getString("managerServlet.noSelf"));
                return;
            }
            context.reload();
            printWriter.println(stringManager.getString("managerServlet.reloaded", new Object[]{contextName.getDisplayName()}));
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.log(sm.getString("managerServlet.error.reload", new Object[]{contextName.getDisplayName()}), throwable);
            printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{throwable.toString()}));
        }
    }

    protected void resources(PrintWriter printWriter, String string, StringManager stringManager) {
        if (this.debug >= 1) {
            if (string != null) {
                this.log("resources:  Listing resources of type " + string);
            } else {
                this.log("resources:  Listing resources of all types");
            }
        }
        if (this.global == null) {
            printWriter.println(stringManager.getString("managerServlet.noGlobal"));
            return;
        }
        if (string != null) {
            printWriter.println(stringManager.getString("managerServlet.resourcesType", new Object[]{string}));
        } else {
            printWriter.println(stringManager.getString("managerServlet.resourcesAll"));
        }
        this.printResources(printWriter, "", this.global, string, stringManager);
    }

    @Deprecated
    protected void printResources(PrintWriter printWriter, String string, javax.naming.Context context, String string2, Class<?> clazz, StringManager stringManager) {
        this.printResources(printWriter, string, context, string2, stringManager);
    }

    protected void printResources(PrintWriter printWriter, String string, javax.naming.Context context, String string2, StringManager stringManager) {
        try {
            NamingEnumeration<Binding> namingEnumeration = context.listBindings("");
            while (namingEnumeration.hasMore()) {
                Binding binding = namingEnumeration.next();
                Object object = binding.getObject();
                if (object instanceof javax.naming.Context) {
                    this.printResources(printWriter, string + binding.getName() + "/", (javax.naming.Context)object, string2, stringManager);
                    continue;
                }
                if (string2 != null && (object == null || !IntrospectionUtils.isInstance(object.getClass(), (String)string2))) continue;
                printWriter.print(string + binding.getName());
                printWriter.print(':');
                printWriter.print(binding.getClassName());
                printWriter.println();
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.log(sm.getString("managerServlet.error.resources", new Object[]{string2}), throwable);
            printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{throwable.toString()}));
        }
    }

    protected void serverinfo(PrintWriter printWriter, StringManager stringManager) {
        if (this.debug >= 1) {
            this.log("serverinfo");
        }
        try {
            printWriter.println(stringManager.getString("managerServlet.serverInfo", new Object[]{ServerInfo.getServerInfo(), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), System.getProperty("java.runtime.version"), System.getProperty("java.vm.vendor")}));
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.log(sm.getString("managerServlet.error.serverInfo"), throwable);
            printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{throwable.toString()}));
        }
    }

    protected void sessions(PrintWriter printWriter, ContextName contextName, int n, StringManager stringManager) {
        if (this.debug >= 1) {
            this.log("sessions: Session information for web application '" + contextName + "'");
            if (n >= 0) {
                this.log("sessions: Session expiration for " + n + " minutes '" + contextName + "'");
            }
        }
        if (!ManagerServlet.validateContextName(contextName, printWriter, stringManager)) {
            return;
        }
        String string = contextName.getDisplayName();
        try {
            Context context = (Context)this.host.findChild(contextName.getName());
            if (context == null) {
                printWriter.println(stringManager.getString("managerServlet.noContext", new Object[]{Escape.htmlElementContent((String)string)}));
                return;
            }
            Manager manager = context.getManager();
            if (manager == null) {
                printWriter.println(stringManager.getString("managerServlet.noManager", new Object[]{Escape.htmlElementContent((String)string)}));
                return;
            }
            int n2 = 60;
            int n3 = 1;
            int n4 = context.getSessionTimeout();
            if (n4 > 0) {
                n3 = n4 / n2;
                if (n3 * n2 < n4) {
                    ++n3;
                }
                if (0 == n3) {
                    n3 = 1;
                }
                if (n3 * (n2 = n4 / n3) < n4) {
                    ++n2;
                }
            }
            printWriter.println(stringManager.getString("managerServlet.sessions", new Object[]{string}));
            printWriter.println(stringManager.getString("managerServlet.sessiondefaultmax", new Object[]{"" + n4}));
            Session[] sessionArray = manager.findSessions();
            int[] nArray = new int[n2 + 1];
            int n5 = 0;
            int n6 = 0;
            for (Session session : sessionArray) {
                int n7 = (int)(session.getIdleTimeInternal() / 1000L);
                if (n >= 0 && n7 >= n * 60) {
                    session.expire();
                    ++n6;
                }
                if ((n7 = n7 / 60 / n3) < 0) {
                    ++n5;
                    continue;
                }
                if (n7 >= n2) {
                    int n8 = n2;
                    nArray[n8] = nArray[n8] + 1;
                    continue;
                }
                int n9 = n7;
                nArray[n9] = nArray[n9] + 1;
            }
            if (nArray[0] > 0) {
                printWriter.println(stringManager.getString("managerServlet.sessiontimeout", new Object[]{"<" + n3, "" + nArray[0]}));
            }
            for (int i = 1; i < n2; ++i) {
                if (nArray[i] <= 0) continue;
                printWriter.println(stringManager.getString("managerServlet.sessiontimeout", new Object[]{"" + i * n3 + " - <" + (i + 1) * n3, "" + nArray[i]}));
            }
            if (nArray[n2] > 0) {
                printWriter.println(stringManager.getString("managerServlet.sessiontimeout", new Object[]{">=" + n2 * n3, "" + nArray[n2]}));
            }
            if (n5 > 0) {
                printWriter.println(stringManager.getString("managerServlet.sessiontimeout.unlimited", new Object[]{"" + n5}));
            }
            if (n >= 0) {
                printWriter.println(stringManager.getString("managerServlet.sessiontimeout.expired", new Object[]{">" + n, "" + n6}));
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.log(sm.getString("managerServlet.error.sessions", new Object[]{string}), throwable);
            printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{throwable.toString()}));
        }
    }

    protected void expireSessions(PrintWriter printWriter, ContextName contextName, HttpServletRequest httpServletRequest, StringManager stringManager) {
        int n = -1;
        String string = httpServletRequest.getParameter("idle");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.log(sm.getString("managerServlet.error.idleParam", new Object[]{string}));
            }
        }
        this.sessions(printWriter, contextName, n, stringManager);
    }

    protected void start(PrintWriter printWriter, ContextName contextName, StringManager stringManager) {
        if (this.debug >= 1) {
            this.log("start: Starting web application '" + contextName + "'");
        }
        if (!ManagerServlet.validateContextName(contextName, printWriter, stringManager)) {
            return;
        }
        String string = contextName.getDisplayName();
        try {
            Context context = (Context)this.host.findChild(contextName.getName());
            if (context == null) {
                printWriter.println(stringManager.getString("managerServlet.noContext", new Object[]{Escape.htmlElementContent((String)string)}));
                return;
            }
            context.start();
            if (context.getState().isAvailable()) {
                printWriter.println(stringManager.getString("managerServlet.started", new Object[]{string}));
            } else {
                printWriter.println(stringManager.getString("managerServlet.startFailed", new Object[]{string}));
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.log(sm.getString("managerServlet.error.start", new Object[]{string}), throwable);
            printWriter.println(stringManager.getString("managerServlet.startFailed", new Object[]{string}));
            printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{throwable.toString()}));
        }
    }

    protected void stop(PrintWriter printWriter, ContextName contextName, StringManager stringManager) {
        if (this.debug >= 1) {
            this.log("stop: Stopping web application '" + contextName + "'");
        }
        if (!ManagerServlet.validateContextName(contextName, printWriter, stringManager)) {
            return;
        }
        String string = contextName.getDisplayName();
        try {
            Context context = (Context)this.host.findChild(contextName.getName());
            if (context == null) {
                printWriter.println(stringManager.getString("managerServlet.noContext", new Object[]{Escape.htmlElementContent((String)string)}));
                return;
            }
            if (context.getName().equals(this.context.getName())) {
                printWriter.println(stringManager.getString("managerServlet.noSelf"));
                return;
            }
            context.stop();
            printWriter.println(stringManager.getString("managerServlet.stopped", new Object[]{string}));
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.log(sm.getString("managerServlet.error.stop", new Object[]{string}), throwable);
            printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{throwable.toString()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undeploy(PrintWriter printWriter, ContextName contextName, StringManager stringManager) {
        if (this.debug >= 1) {
            this.log("undeploy: Undeploying web application at '" + contextName + "'");
        }
        if (!ManagerServlet.validateContextName(contextName, printWriter, stringManager)) {
            return;
        }
        String string = contextName.getName();
        String string2 = contextName.getBaseName();
        String string3 = contextName.getDisplayName();
        try {
            Context context = (Context)this.host.findChild(string);
            if (context == null) {
                printWriter.println(stringManager.getString("managerServlet.noContext", new Object[]{Escape.htmlElementContent((String)string3)}));
                return;
            }
            if (!this.isDeployed(string)) {
                printWriter.println(stringManager.getString("managerServlet.notDeployed", new Object[]{Escape.htmlElementContent((String)string3)}));
                return;
            }
            if (this.isServiced(string)) {
                printWriter.println(stringManager.getString("managerServlet.inService", new Object[]{string3}));
            } else {
                this.addServiced(string);
                try {
                    context.stop();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                }
                try {
                    File file = new File(this.host.getAppBaseFile(), string2 + ".war");
                    File file2 = new File(this.host.getAppBaseFile(), string2);
                    File file3 = new File(this.configBase, string2 + ".xml");
                    if (file.exists() && !file.delete()) {
                        printWriter.println(stringManager.getString("managerServlet.deleteFail", new Object[]{file}));
                        return;
                    }
                    if (file2.exists() && !ExpandWar.delete(file2, false)) {
                        printWriter.println(stringManager.getString("managerServlet.deleteFail", new Object[]{file2}));
                        return;
                    }
                    if (file3.exists() && !file3.delete()) {
                        printWriter.println(stringManager.getString("managerServlet.deleteFail", new Object[]{file3}));
                        return;
                    }
                    this.check(string);
                }
                finally {
                    this.removeServiced(string);
                }
            }
            printWriter.println(stringManager.getString("managerServlet.undeployed", new Object[]{string3}));
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.log(sm.getString("managerServlet.error.undeploy", new Object[]{string3}), throwable);
            printWriter.println(stringManager.getString("managerServlet.exception", new Object[]{throwable.toString()}));
        }
    }

    protected boolean isDeployed(String string) throws Exception {
        Object[] objectArray = new String[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        Boolean bl = (Boolean)this.mBeanServer.invoke(this.oname, "isDeployed", objectArray, stringArray);
        return bl;
    }

    protected void check(String string) throws Exception {
        Object[] objectArray = new String[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "check", objectArray, stringArray);
    }

    protected boolean isServiced(String string) throws Exception {
        Object[] objectArray = new String[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        Boolean bl = (Boolean)this.mBeanServer.invoke(this.oname, "isServiced", objectArray, stringArray);
        return bl;
    }

    protected void addServiced(String string) throws Exception {
        Object[] objectArray = new String[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "addServiced", objectArray, stringArray);
    }

    protected void removeServiced(String string) throws Exception {
        Object[] objectArray = new String[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "removeServiced", objectArray, stringArray);
    }

    protected void uploadWar(PrintWriter printWriter, HttpServletRequest httpServletRequest, File file, StringManager stringManager) throws IOException {
        if (file.exists() && !file.delete()) {
            String string = stringManager.getString("managerServlet.deleteFail", new Object[]{file});
            throw new IOException(string);
        }
        try (ServletInputStream servletInputStream = httpServletRequest.getInputStream();
             FileOutputStream fileOutputStream = new FileOutputStream(file);){
            IOTools.flow((InputStream)servletInputStream, fileOutputStream);
        }
        catch (IOException iOException) {
            if (file.exists() && !file.delete()) {
                printWriter.println(stringManager.getString("managerServlet.deleteFail", new Object[]{file}));
            }
            throw iOException;
        }
    }

    protected static boolean validateContextName(ContextName contextName, PrintWriter printWriter, StringManager stringManager) {
        if (contextName != null && (contextName.getPath().startsWith("/") || contextName.getPath().equals(""))) {
            return true;
        }
        String string = null;
        if (contextName != null) {
            string = Escape.htmlElementContent((String)contextName.getPath());
        }
        printWriter.println(stringManager.getString("managerServlet.invalidPath", new Object[]{string}));
        return false;
    }

    protected Map<String, List<String>> getConnectorCiphers(StringManager stringManager) {
        Connector[] connectorArray;
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (Connector connector : connectorArray = this.getConnectors()) {
            Object object;
            if (Boolean.TRUE.equals(connector.getProperty("SSLEnabled"))) {
                object = connector.getProtocolHandler().findSslHostConfigs();
                for (SSLHostConfig sSLHostConfig : object) {
                    String string = connector.toString() + "-" + sSLHostConfig.getHostName();
                    hashMap.put(string, new ArrayList<String>(new LinkedHashSet<String>(Arrays.asList(sSLHostConfig.getEnabledCiphers()))));
                }
                continue;
            }
            object = new ArrayList(1);
            ((ArrayList)object).add(stringManager.getString("managerServlet.notSslConnector"));
            hashMap.put(connector.toString(), (List<String>)object);
        }
        return hashMap;
    }

    protected Map<String, List<String>> getConnectorCerts(StringManager stringManager) {
        Connector[] connectorArray;
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (Connector connector : connectorArray = this.getConnectors()) {
            Object object;
            if (Boolean.TRUE.equals(connector.getProperty("SSLEnabled"))) {
                object = connector.getProtocolHandler().findSslHostConfigs();
                for (SSLHostConfig sSLHostConfig : object) {
                    Collection<String> collection;
                    if (sSLHostConfig.getOpenSslContext() == 0L) {
                        collection = sSLHostConfig.getCertificates();
                        for (SSLHostConfigCertificate sSLHostConfigCertificate : collection) {
                            X509Certificate[] x509CertificateArray;
                            String string = connector.toString() + "-" + sSLHostConfig.getHostName() + "-" + sSLHostConfigCertificate.getType();
                            ArrayList<String> arrayList = new ArrayList<String>();
                            SSLContext sSLContext = sSLHostConfigCertificate.getSslContext();
                            String string2 = sSLHostConfigCertificate.getCertificateKeyAlias();
                            if (string2 == null) {
                                string2 = "tomcat";
                            }
                            if ((x509CertificateArray = sSLContext.getCertificateChain(string2)) == null) {
                                arrayList.add(stringManager.getString("managerServlet.certsNotAvailable"));
                            } else {
                                for (X509Certificate x509Certificate : x509CertificateArray) {
                                    arrayList.add(x509Certificate.toString());
                                }
                            }
                            hashMap.put(string, arrayList);
                        }
                        continue;
                    }
                    collection = new ArrayList();
                    collection.add(stringManager.getString("managerServlet.certsNotAvailable"));
                    String string = connector.toString() + "-" + sSLHostConfig.getHostName();
                    hashMap.put(string, (List<String>)collection);
                }
                continue;
            }
            object = new ArrayList(1);
            object.add(stringManager.getString("managerServlet.notSslConnector"));
            hashMap.put(connector.toString(), (List<String>)object);
        }
        return hashMap;
    }

    protected Map<String, List<String>> getConnectorTrustedCerts(StringManager stringManager) {
        Connector[] connectorArray;
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (Connector connector : connectorArray = this.getConnectors()) {
            Object object;
            if (Boolean.TRUE.equals(connector.getProperty("SSLEnabled"))) {
                object = connector.getProtocolHandler().findSslHostConfigs();
                for (SSLHostConfig sSLHostConfig : object) {
                    String string = connector.toString() + "-" + sSLHostConfig.getHostName();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (sSLHostConfig.getOpenSslContext() == 0L) {
                        SSLContext sSLContext = ((SSLHostConfigCertificate)sSLHostConfig.getCertificates().iterator().next()).getSslContext();
                        X509Certificate[] x509CertificateArray = sSLContext.getAcceptedIssuers();
                        if (x509CertificateArray == null) {
                            arrayList.add(stringManager.getString("managerServlet.certsNotAvailable"));
                        } else if (x509CertificateArray.length == 0) {
                            arrayList.add(stringManager.getString("managerServlet.trustedCertsNotConfigured"));
                        } else {
                            for (X509Certificate x509Certificate : x509CertificateArray) {
                                arrayList.add(x509Certificate.toString());
                            }
                        }
                    } else {
                        arrayList.add(stringManager.getString("managerServlet.certsNotAvailable"));
                    }
                    hashMap.put(string, arrayList);
                }
                continue;
            }
            object = new ArrayList(1);
            object.add(stringManager.getString("managerServlet.notSslConnector"));
            hashMap.put(connector.toString(), (List<String>)object);
        }
        return hashMap;
    }

    private Connector[] getConnectors() {
        Engine engine = (Engine)this.host.getParent();
        Service service = engine.getService();
        return service.findConnectors();
    }
}

