/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;

final class CheckSuper
implements HotSwapCompilerPass,
NodeTraversal.Callback {
    static final DiagnosticType MISSING_CALL_TO_SUPER = DiagnosticType.error("JSC_MISSING_CALL_TO_SUPER", "constructor is missing a call to super()");
    static final DiagnosticType THIS_BEFORE_SUPER = DiagnosticType.error("JSC_THIS_BEFORE_SUPER", "cannot access this before calling super()");
    static final DiagnosticType SUPER_ACCESS_BEFORE_SUPER_CONSTRUCTOR = DiagnosticType.error("JSC_SUPER_ACCESS_BEFORE_SUPER_CONSTRUCTOR", "cannot access super properties before calling super()");
    static final DiagnosticType INVALID_SUPER_CALL = DiagnosticType.error("JSC_INVALID_SUPER_CALL", "super() not allowed except in the constructor of a subclass");
    static final DiagnosticType SUPER_CALL_IN_ARROW = DiagnosticType.error("JSC_SUPER_CALL_IN_ARROW", "closure-compiler does not allow calls to `super()` in arrow functions");
    static final DiagnosticType INVALID_SUPER_USAGE = DiagnosticType.error("JSC_INVALID_SUPER_USAGE", "''super'' may only be used in a call or property access");
    static final DiagnosticType INVALID_SUPER_ACCESS = DiagnosticType.error("JSC_INVALID_SUPER_ACCESS", "''super'' may only be accessed within a method");
    static final DiagnosticType INVALID_SUPER_CALL_WITH_SUGGESTION = DiagnosticType.error("JSC_INVALID_SUPER_CALL_WITH_SUGGESTION", "super() not allowed here. Did you mean super.{0}?");
    private final AbstractCompiler compiler;
    private final Deque<Context> contextStack = new ArrayDeque<Context>();

    public CheckSuper(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        Context currentContext;
        Context newContext;
        if (this.contextStack.isEmpty()) {
            Preconditions.checkState(n.isRoot() || n.isScript(), n);
            this.contextStack.push(new SuperNotAllowedContext(n));
        }
        if (n.isFunction() && (newContext = this.getContextForFunctionNode(currentContext = this.contextStack.peek(), n)) != currentContext) {
            this.contextStack.push(newContext);
        }
        return true;
    }

    private Context getContextForFunctionNode(Context currentContext, Node fn) {
        if (NodeUtil.isMethodDeclaration(fn)) {
            if (NodeUtil.isEs6Constructor(fn)) {
                return new ConstructorContext(fn);
            }
            return new MethodContext(fn);
        }
        return fn.isArrowFunction() ? currentContext.getContextForArrowFunctionNode(fn) : new SuperNotAllowedContext(fn);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        Context currentContext = Preconditions.checkNotNull(this.contextStack.peek());
        if (n.isSuper()) {
            if (this.isSuperConstructorCall(n)) {
                currentContext.visitSuperConstructorCall(t, n);
            } else if (this.isSuperPropertyAccess(n)) {
                currentContext.visitSuperPropertyAccess(t, n);
            } else {
                t.report(n, INVALID_SUPER_USAGE, new String[0]);
            }
        } else if (n.isThis()) {
            currentContext.visitThis(t, n);
        } else if (n.isReturn()) {
            currentContext.visitReturn(t, n);
        }
        if (n == currentContext.getContextNode()) {
            currentContext.visitContextNode(t);
            this.contextStack.pop();
        }
    }

    private boolean isSuperConstructorCall(Node superNode) {
        Preconditions.checkState(superNode.isSuper(), superNode);
        Node parent = superNode.getParent();
        return parent.isCall() && superNode.isFirstChildOf(parent);
    }

    private boolean isSuperPropertyAccess(Node superNode) {
        Preconditions.checkState(superNode.isSuper(), superNode);
        Node parent = superNode.getParent();
        return NodeUtil.isNormalGet(parent) && superNode.isFirstChildOf(parent);
    }

    private static class ConstructorArrowContext
    extends Context {
        private final ConstructorContext constructorContext;

        ConstructorArrowContext(ConstructorContext constructorContext, Node arrowFn) {
            super(arrowFn);
            this.constructorContext = Preconditions.checkNotNull(constructorContext);
        }

        @Override
        Context getContextForArrowFunctionNode(Node arrowFn) {
            return this;
        }

        @Override
        void visitSuperConstructorCall(NodeTraversal t, Node superNode) {
            t.report(superNode, SUPER_CALL_IN_ARROW, new String[0]);
            this.constructorContext.visitSuperConstructorCall(t, superNode);
        }

        @Override
        void visitSuperPropertyAccess(NodeTraversal t, Node superNode) {
            this.constructorContext.visitSuperPropertyAccess(t, superNode);
        }
    }

    private static class ConstructorContext
    extends Context {
        final boolean hasParentClass;
        Node firstSuperCall = null;
        boolean returnsAValue = false;
        Node thisAccessedBeforeSuper = null;
        Node superPropertyAccessedBeforeSuperCall = null;

        ConstructorContext(Node contextNode) {
            super(contextNode);
            Preconditions.checkArgument(NodeUtil.isEs6Constructor(contextNode), contextNode);
            Node classNode = NodeUtil.getEnclosingClass(contextNode);
            this.hasParentClass = !classNode.getSecondChild().isEmpty();
        }

        @Override
        Context getContextForArrowFunctionNode(Node arrowFn) {
            return new ConstructorArrowContext(this, arrowFn);
        }

        @Override
        void visitSuperConstructorCall(NodeTraversal t, Node superNode) {
            if (this.firstSuperCall == null) {
                this.firstSuperCall = superNode;
            }
        }

        @Override
        void visitSuperPropertyAccess(NodeTraversal t, Node superNode) {
            if (this.firstSuperCall == null) {
                this.superPropertyAccessedBeforeSuperCall = superNode;
            }
        }

        @Override
        void visitThis(NodeTraversal t, Node thisNode) {
            if (this.firstSuperCall == null) {
                this.thisAccessedBeforeSuper = thisNode;
            }
        }

        @Override
        void visitReturn(NodeTraversal t, Node returnNode) {
            if (returnNode.hasChildren()) {
                this.returnsAValue = true;
            }
        }

        @Override
        void visitContextNode(NodeTraversal t) {
            if (!this.hasParentClass) {
                if (this.firstSuperCall != null) {
                    t.report(this.firstSuperCall, INVALID_SUPER_CALL, new String[0]);
                }
            } else {
                if (this.firstSuperCall == null && !this.returnsAValue) {
                    t.report(this.getContextNode().getParent(), MISSING_CALL_TO_SUPER, new String[0]);
                }
                if (this.thisAccessedBeforeSuper != null) {
                    t.report(this.thisAccessedBeforeSuper, THIS_BEFORE_SUPER, new String[0]);
                }
                if (this.superPropertyAccessedBeforeSuperCall != null) {
                    t.report(this.superPropertyAccessedBeforeSuperCall, SUPER_ACCESS_BEFORE_SUPER_CONSTRUCTOR, new String[0]);
                }
            }
        }
    }

    private static class MethodContext
    extends Context {
        private final boolean isClassMethod;

        MethodContext(Node functionNode) {
            super(functionNode);
            Preconditions.checkArgument(functionNode.isFunction() && NodeUtil.isMethodDeclaration(functionNode), functionNode);
            Node objLitOrClassMembers = Preconditions.checkNotNull(functionNode.getGrandparent());
            if (objLitOrClassMembers.isObjectLit()) {
                this.isClassMethod = false;
            } else {
                Preconditions.checkState(objLitOrClassMembers.isClassMembers(), objLitOrClassMembers);
                this.isClassMethod = true;
            }
        }

        @Override
        Context getContextForArrowFunctionNode(Node arrowFn) {
            return this;
        }

        @Override
        void visitSuperPropertyAccess(NodeTraversal t, Node superNode) {
        }

        @Override
        void visitSuperConstructorCall(NodeTraversal t, Node superNode) {
            if (this.isClassMethod) {
                String propName = this.getPropertyName();
                if (propName != null) {
                    t.report(superNode, INVALID_SUPER_CALL_WITH_SUGGESTION, propName);
                } else {
                    t.report(superNode, INVALID_SUPER_CALL, new String[0]);
                }
            } else {
                t.report(superNode, INVALID_SUPER_CALL, new String[0]);
            }
        }

        @Nullable
        String getPropertyName() {
            Node parent = Preconditions.checkNotNull(this.getContextNode().getParent());
            if (parent.isMemberFunctionDef() || parent.isGetterDef() || parent.isSetterDef()) {
                return parent.getString();
            }
            return null;
        }
    }

    private static class SuperNotAllowedContext
    extends Context {
        SuperNotAllowedContext(Node contextNode) {
            super(contextNode);
        }

        @Override
        Context getContextForArrowFunctionNode(Node arrowFn) {
            return this;
        }

        @Override
        void visitSuperConstructorCall(NodeTraversal t, Node superNode) {
            t.report(superNode, INVALID_SUPER_CALL, new String[0]);
        }

        @Override
        void visitSuperPropertyAccess(NodeTraversal t, Node superNode) {
            t.report(superNode, INVALID_SUPER_ACCESS, new String[0]);
        }
    }

    private static abstract class Context {
        private final Node contextNode;

        Context(Node contextNode) {
            this.contextNode = Preconditions.checkNotNull(contextNode);
        }

        Node getContextNode() {
            return this.contextNode;
        }

        abstract Context getContextForArrowFunctionNode(Node var1);

        abstract void visitSuperConstructorCall(NodeTraversal var1, Node var2);

        abstract void visitSuperPropertyAccess(NodeTraversal var1, Node var2);

        void visitThis(NodeTraversal t, Node thisNode) {
        }

        void visitReturn(NodeTraversal t, Node returnNode) {
        }

        void visitContextNode(NodeTraversal t) {
        }
    }
}

