/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class DevirtualizeMethods
implements OptimizeCalls.CallGraphCompilerPass {
    private final AbstractCompiler compiler;
    private OptimizeCalls.ReferenceMap refMap;

    DevirtualizeMethods(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root, OptimizeCalls.ReferenceMap refMap) {
        Preconditions.checkState(this.refMap == null, "`process` should only be called once.");
        this.refMap = refMap;
        for (Map.Entry<String, ArrayList<Node>> referenceGroup : refMap.getPropReferences()) {
            this.processReferenceList(referenceGroup.getKey(), (List<Node>)referenceGroup.getValue());
        }
    }

    private void processReferenceList(String name, List<Node> sites) {
        ImmutableListMultimap<Node, Node> functionsBySite = OptimizeCalls.ReferenceMap.getFunctionNodes(sites);
        if (functionsBySite.isEmpty()) {
            return;
        }
        Node canonicalDefinitionSite = (Node)Iterables.get(functionsBySite.keySet(), 0);
        ImmutableList callSites = sites.stream().filter(s -> !functionsBySite.containsKey(s)).collect(ImmutableList.toImmutableList());
        if (callSites.isEmpty()) {
            return;
        }
        if (!functionsBySite.keySet().stream().allMatch(s -> this.isEligibleDefinitionSite(name, (Node)s))) {
            return;
        }
        if (!functionsBySite.values().stream().allMatch(this::isEligibleDefinitionFunction)) {
            return;
        }
        if (!callSites.stream().allMatch(c -> this.isEligibleCallSite((Node)c, canonicalDefinitionSite))) {
            return;
        }
        if (!this.allDefinitionsEquivalent(functionsBySite.values())) {
            return;
        }
        String devirtualizedName = DevirtualizeMethods.rewrittenMethodNameOf(name);
        for (Node callSite : callSites) {
            this.rewriteCall(callSite, devirtualizedName);
        }
        this.rewriteDefinition(canonicalDefinitionSite, devirtualizedName);
    }

    private boolean isPrototypeOrStaticMethodDefinition(Node node) {
        Node parent = node.getParent();
        Node grandparent = node.getGrandparent();
        if (parent == null || grandparent == null) {
            return false;
        }
        switch (node.getToken()) {
            case MEMBER_FUNCTION_DEF: {
                return !NodeUtil.isEs6ConstructorMemberFunctionDef(node);
            }
            case GETPROP: {
                if (!(node.isFirstChildOf(parent) && NodeUtil.isExprAssign(grandparent) && parent.getLastChild().isFunction())) {
                    return false;
                }
                if (NodeUtil.isPrototypeProperty(node)) {
                    return true;
                }
                return this.isDefinitelyCtorOrInterface(node.getFirstChild());
            }
            case STRING_KEY: {
                Preconditions.checkArgument(parent.isObjectLit(), parent);
                return parent.isSecondChildOf(grandparent) && NodeUtil.isPrototypeAssignment(grandparent.getFirstChild()) && node.getFirstChild().isFunction();
            }
        }
        return false;
    }

    private boolean isDefinitelyCtorOrInterface(Node receiver) {
        String qname = receiver.getQualifiedName();
        if (qname == null) {
            return false;
        }
        Var var = (Var)this.refMap.getGlobalScope().getVar(qname);
        if (var == null) {
            return false;
        }
        if (var.isClass()) {
            return true;
        }
        JSDocInfo jsdoc = var.getJSDocInfo();
        if (jsdoc == null) {
            return false;
        }
        return jsdoc.isConstructorOrInterface() || jsdoc.usesImplicitMatch();
    }

    private boolean isEligibleDefinitionSite(String name, Node definitionSite) {
        switch (definitionSite.getToken()) {
            case MEMBER_FUNCTION_DEF: 
            case GETPROP: 
            case STRING_KEY: {
                break;
            }
            default: {
                throw new IllegalArgumentException(definitionSite.toString());
            }
        }
        CodingConvention codingConvention = this.compiler.getCodingConvention();
        if (codingConvention.isExported(name)) {
            return false;
        }
        return this.isPrototypeOrStaticMethodDefinition(definitionSite);
    }

    private boolean isEligibleDefinitionFunction(Node definitionFunction) {
        Preconditions.checkArgument(definitionFunction.isFunction(), definitionFunction);
        if (definitionFunction.isArrowFunction()) {
            return false;
        }
        for (Node ancestor = definitionFunction.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            if (DevirtualizeMethods.isScopingOrBranchingConstruct(ancestor)) {
                return false;
            }
            if (!ancestor.isClass() || !DevirtualizeMethods.localNameIsDeclaredByClass(ancestor)) continue;
            return false;
        }
        if (NodeUtil.has(definitionFunction, Node::isSuper, Predicates.alwaysTrue())) {
            return false;
        }
        return !NodeUtil.doesFunctionReferenceOwnArgumentsObject(definitionFunction);
    }

    private boolean isEligibleCallSite(Node access, Node definitionSite) {
        JSModule callModule;
        Node invocation = access.getParent();
        if (!NodeUtil.isInvocationTarget(access) || !invocation.isCall()) {
            return false;
        }
        JSModuleGraph moduleGraph = this.compiler.getModuleGraph();
        JSModule definitionModule = this.moduleForNode(definitionSite);
        if (definitionModule != (callModule = this.moduleForNode(access))) {
            if (callModule == null) {
                return false;
            }
            if (!moduleGraph.dependsOn(callModule, definitionModule)) {
                return false;
            }
        }
        return true;
    }

    private boolean allDefinitionsEquivalent(Collection<Node> definitions) {
        if (definitions.isEmpty()) {
            return true;
        }
        Node definition = Iterables.get(definitions, 0);
        Preconditions.checkArgument(definition.isFunction(), definition);
        return definitions.stream().allMatch(d -> this.compiler.areNodesEqualForInlining((Node)d, definition));
    }

    private void rewriteCall(Node getprop, String newMethodName) {
        Preconditions.checkArgument(getprop.isGetProp(), getprop);
        Node call = getprop.getParent();
        Preconditions.checkArgument(call.isCall(), call);
        Node receiver = getprop.getFirstChild();
        getprop.removeChild(receiver);
        call.replaceChild(getprop, receiver);
        call.addChildToFront(IR.name(newMethodName).srcref(getprop));
        if (receiver.isSuper()) {
            receiver.setToken(Token.THIS);
        }
        call.putBooleanProp(Node.FREE_CALL, true);
        this.compiler.reportChangeToEnclosingScope(call);
    }

    private void rewriteDefinition(Node definitionSite, String newMethodName) {
        Node subtreeToRemove;
        Node nameSource;
        Node function;
        switch (definitionSite.getToken()) {
            case GETPROP: {
                function = definitionSite.getParent().getLastChild();
                nameSource = definitionSite.getLastChild();
                subtreeToRemove = NodeUtil.getEnclosingStatement(definitionSite);
                break;
            }
            case MEMBER_FUNCTION_DEF: 
            case STRING_KEY: {
                function = definitionSite.getLastChild();
                nameSource = definitionSite;
                subtreeToRemove = definitionSite;
                break;
            }
            default: {
                throw new IllegalArgumentException(definitionSite.toString());
            }
        }
        Node statement = NodeUtil.getEnclosingStatement(definitionSite);
        Node newNameNode = IR.name(newMethodName).useSourceInfoIfMissingFrom(nameSource);
        Node newVarNode = IR.var(newNameNode).useSourceInfoIfMissingFrom(nameSource);
        statement.getParent().addChildBefore(newVarNode, statement);
        function.detach();
        newNameNode.addChildToFront(function);
        String selfName = newMethodName + "$self";
        Node paramList = function.getSecondChild();
        paramList.addChildToFront(IR.name(selfName).useSourceInfoIfMissingFrom(function));
        this.compiler.reportChangeToEnclosingScope(paramList);
        this.replaceReferencesToThis(function.getSecondChild(), selfName);
        this.replaceReferencesToThis(function.getLastChild(), selfName);
        this.fixFunctionType(function);
        NodeUtil.deleteNode(subtreeToRemove, this.compiler);
        this.compiler.reportChangeToEnclosingScope(newVarNode);
    }

    private void fixFunctionType(Node functionNode) {
        JSType t = functionNode.getJSType();
        if (t == null) {
            return;
        }
        FunctionType ft = t.toMaybeFunctionType();
        if (ft != null) {
            functionNode.setJSType(this.convertMethodToFunction(ft));
        }
    }

    private JSType convertMethodToFunction(FunctionType method) {
        ArrayList<JSType> paramTypes = new ArrayList<JSType>();
        paramTypes.add(method.getTypeOfThis());
        for (FunctionType.Parameter param : method.getParameters()) {
            paramTypes.add(param.getJSType());
        }
        ObjectType unknown = this.compiler.getTypeRegistry().getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
        return this.compiler.getTypeRegistry().createFunctionTypeWithInstanceType(unknown, method.getReturnType(), paramTypes);
    }

    private void replaceReferencesToThis(Node node, String name) {
        if (node.isFunction() && !node.isArrowFunction()) {
            return;
        }
        for (Node child : node.children()) {
            if (child.isThis()) {
                Node newName = IR.name(name).useSourceInfoFrom(child).setJSType(child.getJSType());
                node.replaceChild(child, newName);
                this.compiler.reportChangeToEnclosingScope(newName);
                continue;
            }
            this.replaceReferencesToThis(child, name);
        }
    }

    @Nullable
    private JSModule moduleForNode(Node node) {
        Node script = NodeUtil.getEnclosingScript(node);
        CompilerInput input = this.compiler.getInput(script.getInputId());
        return input.getModule();
    }

    private static String rewrittenMethodNameOf(String originalMethodName) {
        return "JSCompiler_StaticMethods_" + originalMethodName;
    }

    private static boolean isScopingOrBranchingConstruct(Node node) {
        return NodeUtil.isControlStructure(node) || node.isAnd() || node.isOr() || node.isFunction() || node.isBlock();
    }

    private static boolean localNameIsDeclaredByClass(Node clazz) {
        Preconditions.checkArgument(clazz.isClass(), clazz);
        if (clazz.getFirstChild().isEmpty()) {
            return false;
        }
        return !NodeUtil.isStatement(clazz);
    }
}

