/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.AutoValue_ModuleIdentifier;
import com.google.javascript.jscomp.deps.ModuleNames;
import java.io.Serializable;

@Immutable
@AutoValue
public abstract class ModuleIdentifier
implements Serializable {
    public abstract String getName();

    public abstract String getClosureNamespace();

    public abstract String getModuleName();

    public final String toString() {
        if (this.getClosureNamespace().equals(this.getModuleName())) {
            return this.getClosureNamespace();
        }
        return this.getModuleName() + ":" + this.getClosureNamespace();
    }

    public static ModuleIdentifier forClosure(String name) {
        String normalizedName = name;
        if (normalizedName.startsWith("goog:")) {
            normalizedName = normalizedName.substring("goog:".length());
        }
        String namespace = normalizedName;
        String moduleName = normalizedName;
        int splitPoint = normalizedName.indexOf(58);
        if (splitPoint != -1) {
            moduleName = normalizedName.substring(0, splitPoint);
            namespace = normalizedName.substring(Math.min(splitPoint + 1, normalizedName.length() - 1));
        }
        return new AutoValue_ModuleIdentifier(normalizedName, namespace, moduleName);
    }

    public static ModuleIdentifier forFile(String filepath) {
        String normalizedName = ModuleNames.fileToModuleName(filepath);
        return new AutoValue_ModuleIdentifier(filepath, normalizedName, normalizedName);
    }

    public static ModuleIdentifier forFlagValue(String flagValue) {
        if (flagValue.startsWith("goog:")) {
            return ModuleIdentifier.forClosure(flagValue);
        }
        return ModuleIdentifier.forFile(flagValue);
    }
}

