/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroupWarningsGuard;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.FileAwareWarningsGuard;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.WarningsGuard;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.Map;

class SuppressDocWarningsGuard
extends FileAwareWarningsGuard {
    private static final long serialVersionUID = 1L;
    private final Map<String, DiagnosticGroupWarningsGuard> suppressors = new HashMap<String, DiagnosticGroupWarningsGuard>();

    SuppressDocWarningsGuard(AbstractCompiler compiler, Map<String, DiagnosticGroup> suppressibleGroups) {
        super(compiler);
        for (Map.Entry<String, DiagnosticGroup> entry : suppressibleGroups.entrySet()) {
            this.suppressors.put(entry.getKey(), new DiagnosticGroupWarningsGuard(entry.getValue(), CheckLevel.OFF));
        }
        this.suppressors.put("missingRequire", new DiagnosticGroupWarningsGuard(new DiagnosticGroup(DiagnosticGroups.STRICT_MISSING_REQUIRE, DiagnosticGroups.STRICTER_MISSING_REQUIRE, DiagnosticGroups.STRICTER_MISSING_REQUIRE_IN_PROVIDES_FILE, DiagnosticGroups.STRICTER_MISSING_REQUIRE_TYPE_IN_PROVIDES_FILE), CheckLevel.OFF));
        this.suppressors.put("missingProperties", new DiagnosticGroupWarningsGuard(new DiagnosticGroup(DiagnosticGroups.MISSING_PROPERTIES, DiagnosticGroups.STRICT_MISSING_PROPERTIES), CheckLevel.OFF));
        this.suppressors.put("checkTypes", new DiagnosticGroupWarningsGuard(new DiagnosticGroup(DiagnosticGroups.CHECK_TYPES, DiagnosticGroups.STRICT_CHECK_TYPES), CheckLevel.OFF));
    }

    @Override
    public CheckLevel level(JSError error) {
        JSDocInfo info;
        Node node = error.getNode();
        if (node == null) {
            node = this.getScriptNodeForError(error);
        }
        if (node == null) {
            return null;
        }
        CheckLevel level = this.getCheckLevelFromAncestors(error, node);
        if (level != null) {
            return level;
        }
        Node scriptNode = this.getScriptNodeForError(error);
        if (scriptNode != null && (info = scriptNode.getJSDocInfo()) != null) {
            return this.getCheckLevelFromInfo(error, info);
        }
        return null;
    }

    private CheckLevel getCheckLevelFromAncestors(JSError error, Node node) {
        for (Node current = node; current != null; current = current.getParent()) {
            CheckLevel level;
            JSDocInfo info = null;
            if (current.isFunction() || current.isClass()) {
                info = NodeUtil.getBestJSDocInfo(current);
            } else if (current.isScript()) {
                info = current.getJSDocInfo();
            } else if (NodeUtil.isNameDeclaration(current) || NodeUtil.isAssignmentOp(current) && current.getParent().isExprResult() || current.isGetProp() && current.getParent().isExprResult() || NodeUtil.mayBeObjectLitKey(current) || current.isComputedProp()) {
                info = NodeUtil.getBestJSDocInfo(current);
            }
            if (info == null || (level = this.getCheckLevelFromInfo(error, info)) == null) continue;
            return level;
        }
        return null;
    }

    private CheckLevel getCheckLevelFromInfo(JSError error, JSDocInfo info) {
        for (String suppressor : info.getSuppressions()) {
            CheckLevel newLevel;
            WarningsGuard guard = this.suppressors.get(suppressor);
            if (guard == null || (newLevel = guard.level(error)) == null) continue;
            return newLevel;
        }
        return null;
    }

    @Override
    public int getPriority() {
        return WarningsGuard.Priority.SUPPRESS_DOC.value;
    }
}

