/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.modules;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.modules.Binding;
import com.google.javascript.jscomp.modules.ClosureRequireProcessor;
import com.google.javascript.jscomp.modules.Export;
import com.google.javascript.jscomp.modules.ExportTrace;
import com.google.javascript.jscomp.modules.Import;
import com.google.javascript.jscomp.modules.Module;
import com.google.javascript.jscomp.modules.ModuleMapCreator;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.jscomp.modules.ModuleRequestResolver;
import com.google.javascript.jscomp.modules.ResolveExportResult;
import com.google.javascript.jscomp.modules.UnresolvedModule;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class ClosureModuleProcessor
implements ModuleMapCreator.ModuleProcessor {
    private final AbstractCompiler compiler;

    private static boolean mayBeAccidentalDefaultExport(String importName, Map<String, Binding> exports) {
        Node defaultExport = exports.get("*exports*").originatingExport().exportNode();
        Preconditions.checkState(defaultExport.matchesName("exports") && defaultExport.getParent().isAssign(), defaultExport);
        Node exportedValue = defaultExport.getNext();
        if (!exportedValue.isObjectLit()) {
            return false;
        }
        for (Node key : exportedValue.children()) {
            if (!key.isStringKey() || !key.getString().equals(importName)) continue;
            return true;
        }
        return false;
    }

    public ClosureModuleProcessor(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public UnresolvedModule process(ModuleMetadataMap.ModuleMetadata metadata, ModuleLoader.ModulePath path, Node script) {
        Preconditions.checkArgument(script.isScript() || script.isCall(), "Unexpected module root %s", (Object)script);
        Preconditions.checkArgument(script.isCall() || path != null, "Non goog.loadModules must have a path");
        ModuleProcessingCallback moduleProcessingCallback = new ModuleProcessingCallback(metadata);
        NodeTraversal.traverse(this.compiler, script, moduleProcessingCallback);
        return new UnresolvedGoogModule(metadata, script.getSourceFileName(), path, ImmutableMap.copyOf(moduleProcessingCallback.namespace), ImmutableMap.copyOf(moduleProcessingCallback.requiresByLocalName), this.compiler);
    }

    private static boolean isNamedExportsLiteral(Node objLit) {
        if (!objLit.isObjectLit() || !objLit.hasChildren()) {
            return false;
        }
        for (Node key : objLit.children()) {
            if (!key.isStringKey() || key.isQuotedString()) {
                return false;
            }
            if (key.getFirstChild().isName()) continue;
            return false;
        }
        return true;
    }

    private static class ModuleProcessingCallback
    extends NodeTraversal.AbstractPreOrderCallback {
        private final ModuleMetadataMap.ModuleMetadata metadata;
        private final String closureNamespace;
        private final Map<String, Binding> namespace;
        private final Map<String, ClosureRequireProcessor.Require> requiresByLocalName;
        private boolean seenExportsAssignment;

        ModuleProcessingCallback(ModuleMetadataMap.ModuleMetadata metadata) {
            this.metadata = metadata;
            this.namespace = new LinkedHashMap<String, Binding>();
            this.requiresByLocalName = new LinkedHashMap<String, ClosureRequireProcessor.Require>();
            this.closureNamespace = Iterables.getOnlyElement(metadata.googNamespaces());
            this.seenExportsAssignment = false;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case MODULE_BODY: 
                case SCRIPT: 
                case CALL: 
                case BLOCK: {
                    return true;
                }
                case FUNCTION: {
                    return parent.isCall() && parent == this.metadata.rootNode();
                }
                case EXPR_RESULT: {
                    Node expr = n.getFirstChild();
                    if (expr.isAssign()) {
                        this.maybeInitializeExports(expr);
                    } else if (expr.isGetProp()) {
                        this.maybeInitializeExportsStub(expr);
                    }
                    return false;
                }
                case CONST: 
                case VAR: 
                case LET: {
                    this.maybeInitializeRequire(n);
                    return false;
                }
            }
            return false;
        }

        private void maybeInitializeExports(Node assignment) {
            Node lhs = assignment.getFirstChild();
            Node rhs = assignment.getSecondChild();
            if (lhs.isName() && lhs.getString().equals("exports")) {
                if (ClosureModuleProcessor.isNamedExportsLiteral(rhs)) {
                    this.initializeNamedExportsLiteral(rhs);
                } else {
                    this.seenExportsAssignment = true;
                }
                this.markExportsAssignmentInNamespace(lhs);
            } else if (lhs.isGetProp() && lhs.getFirstChild().isName() && lhs.getFirstChild().getString().equals("exports")) {
                String exportedId = lhs.getSecondChild().getString();
                this.addPropertyExport(exportedId, lhs);
            }
        }

        private void maybeInitializeExportsStub(Node qname) {
            Node owner = qname.getFirstChild();
            if (owner.isName() && owner.getString().equals("exports")) {
                Node prop = qname.getSecondChild();
                String exportedId = prop.getString();
                this.addPropertyExport(exportedId, qname);
            }
        }

        private void markExportsAssignmentInNamespace(Node exportsNode) {
            this.namespace.put("*exports*", Binding.from(Export.builder().exportName("*exports*").exportNode(exportsNode).moduleMetadata(this.metadata).closureNamespace(this.closureNamespace).modulePath(this.metadata.path()).build(), exportsNode));
        }

        private void initializeNamedExportsLiteral(Node objectLit) {
            for (Node key : objectLit.children()) {
                this.addPropertyExport(key.getString(), key);
            }
        }

        private void addPropertyExport(String exportedId, Node propNode) {
            if (this.seenExportsAssignment) {
                return;
            }
            if (this.namespace.containsKey(exportedId)) {
                return;
            }
            this.namespace.put(exportedId, Binding.from(Export.builder().exportName(exportedId).exportNode(propNode).moduleMetadata(this.metadata).closureNamespace(this.closureNamespace).modulePath(this.metadata.path()).build(), propNode));
        }

        private void maybeInitializeRequire(Node nameDeclaration) {
            for (ClosureRequireProcessor.Require require : ClosureRequireProcessor.getAllRequires(nameDeclaration)) {
                this.requiresByLocalName.putIfAbsent(require.localName(), require);
            }
        }
    }

    private static class UnresolvedGoogModule
    extends UnresolvedModule {
        private final ModuleMetadataMap.ModuleMetadata metadata;
        private final String srcFileName;
        @Nullable
        private final ModuleLoader.ModulePath path;
        private final ImmutableMap<String, Binding> namespace;
        private final ImmutableMap<String, ClosureRequireProcessor.Require> requiresByLocalName;
        private final AbstractCompiler compiler;
        private Module resolved = null;

        UnresolvedGoogModule(ModuleMetadataMap.ModuleMetadata metadata, String srcFileName, ModuleLoader.ModulePath path, ImmutableMap<String, Binding> namespace, ImmutableMap<String, ClosureRequireProcessor.Require> requires, AbstractCompiler compiler) {
            this.metadata = metadata;
            this.srcFileName = srcFileName;
            this.path = path;
            this.namespace = namespace;
            this.requiresByLocalName = requires;
            this.compiler = compiler;
        }

        @Override
        @Nullable
        public ResolveExportResult resolveExport(ModuleRequestResolver moduleRequestResolver, String exportName) {
            if (this.namespace.containsKey(exportName)) {
                return ResolveExportResult.of(this.namespace.get(exportName));
            }
            return ResolveExportResult.NOT_FOUND;
        }

        @Override
        @Nullable
        public ResolveExportResult resolveExport(ModuleRequestResolver moduleRequestResolver, @Nullable String moduleSpecifier, String exportName, Set<ExportTrace> resolveSet, Set<UnresolvedModule> exportStarSet) {
            return this.resolveExport(moduleRequestResolver, exportName);
        }

        @Override
        public Module resolve(ModuleRequestResolver moduleRequestResolver, @Nullable String moduleSpecifier) {
            if (this.resolved == null) {
                LinkedHashMap<String, Binding> boundNames = new LinkedHashMap<String, Binding>(this.getAllResolvedImports(moduleRequestResolver));
                this.resolved = Module.builder().path(this.path).metadata(this.metadata).namespace(this.namespace).boundNames(ImmutableMap.copyOf(boundNames)).localNameToLocalExport(ImmutableMap.of()).closureNamespace(Iterables.getOnlyElement(this.metadata.googNamespaces())).unresolvedModule(this).build();
            }
            return this.resolved;
        }

        Map<String, Binding> getAllResolvedImports(ModuleRequestResolver moduleRequestResolver) {
            HashMap<String, Binding> imports = new HashMap<String, Binding>();
            for (String name : this.requiresByLocalName.keySet()) {
                ResolveExportResult b = this.resolveImport(moduleRequestResolver, name);
                if (!b.resolved()) continue;
                imports.put(name, b.getBinding());
            }
            return imports;
        }

        ResolveExportResult resolveImport(ModuleRequestResolver moduleRequestResolver, String name) {
            ClosureRequireProcessor.Require require = this.requiresByLocalName.get(name);
            Import importRecord = require.importRecord();
            UnresolvedModule requested = moduleRequestResolver.resolve(importRecord);
            if (requested == null) {
                return ResolveExportResult.ERROR;
            }
            if (importRecord.importName().equals("*exports*")) {
                return ResolveExportResult.of(Binding.from(requested.metadata(), importRecord.nameNode(), importRecord.moduleRequest(), require.createdBy()));
            }
            ResolveExportResult result = requested.resolveExport(moduleRequestResolver, importRecord.moduleRequest(), importRecord.importName(), new HashSet<ExportTrace>(), new HashSet<UnresolvedModule>());
            if (!result.found() && !result.hadError()) {
                this.reportInvalidDestructuringRequire(requested, importRecord);
                return ResolveExportResult.ERROR;
            }
            Node forSourceInfo = importRecord.nameNode() == null ? importRecord.importNode() : importRecord.nameNode();
            return result.copy(forSourceInfo, require.createdBy());
        }

        @Override
        ModuleMetadataMap.ModuleMetadata metadata() {
            return this.metadata;
        }

        @Override
        public ImmutableSet<String> getExportedNames(ModuleRequestResolver moduleRequestResolver) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableSet<String> getExportedNames(ModuleRequestResolver moduleRequestResolver, Set<UnresolvedModule> visited) {
            throw new UnsupportedOperationException();
        }

        @Override
        void reset() {
            this.resolved = null;
        }

        private void reportInvalidDestructuringRequire(UnresolvedModule requested, Import importRecord) {
            ImmutableMap<String, Binding> exports;
            String additionalInfo = "";
            if (requested instanceof UnresolvedGoogModule && (exports = ((UnresolvedGoogModule)requested).namespace).containsKey("*exports*")) {
                additionalInfo = Strings.lenientFormat("\nThe goog.module \"%s\" cannot be destructured as it contains a default export, not named exports. See %s.", importRecord.moduleRequest(), "https://github.com/google/closure-library/wiki/goog.module%3A-an-ES6-module-like-alternative-to-goog.provide#destructuring-imports");
                if (ClosureModuleProcessor.mayBeAccidentalDefaultExport(importRecord.importName(), exports)) {
                    additionalInfo = additionalInfo + Strings.lenientFormat("\nEither use a non-destructuring require or rewrite the goog.module \"%s\" to support destructuring requires. For example, consider replacing\n  exports = {%s: <value>[, ...]};\nwith individual named export assignments like\n  exports.%s = <value>;\n", importRecord.moduleRequest(), importRecord.importName(), importRecord.importName());
                }
            }
            this.compiler.report(JSError.make(this.srcFileName, importRecord.importNode().getLineno(), importRecord.importNode().getCharno(), ModuleMapCreator.DOES_NOT_HAVE_EXPORT_WITH_DETAILS, importRecord.importName(), additionalInfo));
        }
    }
}

