/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeClass;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.PrototypeObjectType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.TypeStringBuilder;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class EnumType
extends PrototypeObjectType {
    private static final long serialVersionUID = 1L;
    private static final JSTypeClass TYPE_CLASS = JSTypeClass.ENUM;
    private EnumElementType elementsType;
    private final Set<String> elements = new HashSet<String>();
    private final Node source;

    EnumType(JSTypeRegistry registry, String name, Node source, JSType elementsType) {
        super((PrototypeObjectType.Builder<?>)PrototypeObjectType.builder(registry).setName("enum{" + name + "}"));
        this.elementsType = new EnumElementType(registry, elementsType, name, this);
        this.source = source;
        registry.getResolver().resolveIfClosed(this, TYPE_CLASS);
    }

    @Override
    JSTypeClass getTypeClass() {
        return TYPE_CLASS;
    }

    @Override
    public EnumType toMaybeEnumType() {
        return this;
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE);
    }

    public Set<String> getElements() {
        return Collections.unmodifiableSet(this.elements);
    }

    public boolean defineElement(String name, Node definingNode) {
        this.elements.add(name);
        return this.defineDeclaredProperty(name, this.elementsType, definingNode);
    }

    public EnumElementType getElementsType() {
        return this.elementsType;
    }

    @Override
    public JSType getEnumeratedTypeOfEnumObject() {
        return this.elementsType.getPrimitiveType();
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        TernaryValue result = super.testForEquality(that);
        if (result != null) {
            return result;
        }
        return this.equals(that) ? TernaryValue.TRUE : TernaryValue.FALSE;
    }

    @Override
    void appendTo(TypeStringBuilder sb) {
        sb.append(sb.isForAnnotations() ? "!Object" : this.getReferenceName());
    }

    @Override
    public String getDisplayName() {
        return this.elementsType.getDisplayName();
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseObjectType(this);
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return visitor.caseObjectType(this, that);
    }

    @Override
    public FunctionType getConstructor() {
        return null;
    }

    @Override
    public boolean matchesNumberContext() {
        return false;
    }

    @Override
    public boolean matchesStringContext() {
        return true;
    }

    @Override
    public boolean matchesObjectContext() {
        return true;
    }

    public final Node getSource() {
        return this.source;
    }

    @Override
    JSType resolveInternal(ErrorReporter reporter) {
        this.elementsType = (EnumElementType)this.elementsType.resolve(reporter);
        return super.resolveInternal(reporter);
    }
}

