/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import freemind.controller.MapModuleManager;
import freemind.controller.MenuItemSelectedListener;
import freemind.controller.StructuredMenuHolder;
import freemind.controller.actions.generated.instance.LogFileViewerConfigurationStorage;
import freemind.controller.actions.generated.instance.WindowConfigurationStorage;
import freemind.extensions.HookRegistration;
import freemind.main.LogFileLogHandler;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.Mode;
import freemind.modes.ModeController;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.xml.ActionHandler;
import freemind.modes.mindmapmode.actions.xml.PrintActionHandler;
import freemind.modes.mindmapmode.hooks.MindMapHookAdapter;
import freemind.view.MapModule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LogFileViewer
extends MindMapHookAdapter
implements MapModuleManager.MapModuleChangeObserver,
LogFileLogHandler.LogReceiver {
    private static final String WINDOW_PREFERENCE_STORAGE_PROPERTY = LogFileViewer.class.getName();
    private MindMapController mMyMindMapController;
    private JDialog mLogFileViewer;
    private CloseAction mCloseAction;
    private JTextArea mTextArea;
    protected static Logger logger = null;
    private JMenuBar mMenuBar;
    private UpdateTextAreaThread mUpdateTextAreaThread;
    private SimpleFormatter mSimpleFormatter;

    public Registration getRegistration() {
        return (Registration)this.getPluginBaseClass();
    }

    @Override
    public void startupMapHook() {
        super.startupMapHook();
        if (logger == null) {
            logger = Resources.getInstance().getLogger(this.getClass().getName());
        }
        this.mMyMindMapController = super.getMindMapController();
        this.mSimpleFormatter = new SimpleFormatter();
        String pathname = this.getMindMapController().getFrame().getFreemindDirectory() + File.separator + "log" + ".0";
        String logFileContents = Tools.getFile(new File(pathname));
        this.getMindMapController().getController().getMapModuleManager().addListener(this);
        this.mLogFileViewer = new JDialog((Frame)this.getController().getFrame().getJFrame(), false);
        this.mLogFileViewer.setTitle(this.getResourceString("LogFileViewer_title") + pathname);
        this.mLogFileViewer.setDefaultCloseOperation(0);
        this.mLogFileViewer.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                LogFileViewer.this.disposeDialog();
            }
        });
        this.mCloseAction = new CloseAction();
        Tools.addEscapeActionToDialog(this.mLogFileViewer, new CloseAction());
        StructuredMenuHolder menuHolder = new StructuredMenuHolder();
        this.mMenuBar = new JMenuBar();
        JMenu mainItem = new JMenu(this.getResourceString("MapControllerPopupDialog.Actions"));
        menuHolder.addMenu(mainItem, "main/actions/.");
        PrintOperationAction printOperationAction = new PrintOperationAction();
        this.addAccelerator(menuHolder.addAction(printOperationAction, "main/actions/printOperationAction"), "keystroke_accessories/plugins/LogFileViewer_printOperationAction");
        JMenu loggerItem = new JMenu(this.getResourceString("MapControllerPopupDialog.LogLevels"));
        menuHolder.addMenu(loggerItem, "main/loglevel/.");
        Level[] levels = new Level[]{Level.FINEST, Level.FINER, Level.FINE, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};
        for (int i = 0; i < levels.length; ++i) {
            Level level = levels[i];
            menuHolder.addAction(new SetLogLevelAction(level), "main/loglevel/setLogLevel_" + level.getName());
        }
        menuHolder.updateMenus(this.mMenuBar, "main/");
        this.mLogFileViewer.setJMenuBar(this.mMenuBar);
        this.mLogFileViewer.setSize(400, 400);
        this.mLogFileViewer.setLayout(new BorderLayout());
        this.mTextArea = new JTextArea(logFileContents);
        this.mTextArea.setEditable(false);
        this.mTextArea.getCaret().setVisible(true);
        this.mTextArea.setCaretPosition(logFileContents.length());
        this.mLogFileViewer.add((Component)new JScrollPane(this.mTextArea), "Center");
        LogFileViewerConfigurationStorage storage = (LogFileViewerConfigurationStorage)this.getMindMapController().decorateDialog(this.mLogFileViewer, WINDOW_PREFERENCE_STORAGE_PROPERTY);
        if (storage != null) {
            // empty if block
        }
        this.mLogFileViewer.setVisible(true);
        this.mUpdateTextAreaThread = new UpdateTextAreaThread();
        this.mUpdateTextAreaThread.start();
        LogFileLogHandler baseHandler = this.getBaseHandler();
        if (baseHandler != null) {
            baseHandler.setLogReceiver(this);
        }
    }

    protected Logger getBaseLogger() {
        return logger.getParent();
    }

    protected LogFileLogHandler getBaseHandler() {
        for (int i = 0; i < logger.getHandlers().length; ++i) {
            Handler handler = logger.getHandlers()[i];
            if (!(handler instanceof LogFileLogHandler)) continue;
            LogFileLogHandler logHandler = (LogFileLogHandler)handler;
            return logHandler;
        }
        return null;
    }

    @Override
    public MindMapController getMindMapController() {
        return this.mMyMindMapController;
    }

    public void disposeDialog() {
        this.mUpdateTextAreaThread.commitSuicide();
        this.mUpdateTextAreaThread = null;
        LogFileLogHandler baseHandler = this.getBaseHandler();
        if (baseHandler != null) {
            baseHandler.setLogReceiver(null);
        }
        LogFileViewerConfigurationStorage storage = new LogFileViewerConfigurationStorage();
        this.getMindMapController().storeDialogPositions(this.mLogFileViewer, (WindowConfigurationStorage)storage, WINDOW_PREFERENCE_STORAGE_PROPERTY);
        this.getMindMapController().getController().getMapModuleManager().removeListener(this);
        this.mLogFileViewer.setVisible(false);
        this.mLogFileViewer.dispose();
    }

    @Override
    public boolean isMapModuleChangeAllowed(MapModule pOldMapModule, Mode pOldMode, MapModule pNewMapModule, Mode pNewMode) {
        return true;
    }

    @Override
    public void beforeMapModuleChange(MapModule pOldMapModule, Mode pOldMode, MapModule pNewMapModule, Mode pNewMode) {
    }

    @Override
    public void afterMapClose(MapModule pOldMapModule, Mode pOldMode) {
        this.disposeDialog();
    }

    @Override
    public void afterMapModuleChange(MapModule pOldMapModule, Mode pOldMode, MapModule pNewMapModule, Mode pNewMode) {
        this.disposeDialog();
    }

    @Override
    public void numberOfOpenMapInformation(int pNumber, int pIndex) {
    }

    public CloseAction getCloseAction() {
        return this.mCloseAction;
    }

    @Override
    public void receiveLog(LogRecord record) {
        String msg = this.mSimpleFormatter.format(record);
        this.mUpdateTextAreaThread.addToInbox(msg);
    }

    private class UpdateTextAreaThread
    extends Thread {
        Vector mInbox = new Vector();
        private boolean mCommitSuicide = false;
        private boolean mSuicided = false;

        private UpdateTextAreaThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.mCommitSuicide) {
                final Vector queue = new Vector();
                Vector vector = this.mInbox;
                synchronized (vector) {
                    if (!this.mInbox.isEmpty()) {
                        queue.addAll(this.mInbox);
                        this.mInbox.clear();
                    }
                }
                if (!queue.isEmpty()) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                StringBuffer buffer = new StringBuffer();
                                for (String msg : queue) {
                                    buffer.append(msg);
                                }
                                String msg = buffer.toString();
                                int length = LogFileViewer.this.mTextArea.getDocument().getLength();
                                boolean atEnd = LogFileViewer.this.mTextArea.getCaretPosition() == length;
                                LogFileViewer.this.mTextArea.getDocument().insertString(length, msg, null);
                                if (atEnd) {
                                    LogFileViewer.this.mTextArea.setCaretPosition(LogFileViewer.this.mTextArea.getDocument().getLength());
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
                this.sleepALittle();
            }
            this.mSuicided = true;
        }

        public void commitSuicide() {
            this.mCommitSuicide = true;
            int timeout = 100;
            while (timeout-- > 0 && !this.mSuicided) {
                this.sleepALittle();
            }
        }

        protected void sleepALittle() {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Resources.getInstance().logException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addToInbox(String msg) {
            Vector vector = this.mInbox;
            synchronized (vector) {
                this.mInbox.add(msg);
            }
        }
    }

    private final class SetLogLevelAction
    extends AbstractAction
    implements MenuItemSelectedListener {
        private final Level mLevel;

        public SetLogLevelAction(Level pLevel) {
            super(LogFileViewer.this.getResourceString("LogFileViewer.SetLogLevelAction_" + pLevel.getName()));
            this.mLevel = pLevel;
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            LogFileViewer.this.getBaseHandler().setLevel(this.mLevel);
            List loggerList = LogFileViewer.this.getMindMapController().getFrame().getLoggerList();
            for (Logger otherLogger : loggerList) {
                otherLogger.setLevel(this.mLevel);
            }
        }

        @Override
        public boolean isSelected(JMenuItem pCheckItem, Action pAction) {
            return LogFileViewer.this.getBaseHandler().getLevel().equals(this.mLevel);
        }
    }

    private final class PrintOperationAction
    extends AbstractAction
    implements MenuItemSelectedListener {
        public PrintOperationAction() {
            super(LogFileViewer.this.getResourceString("LogFileViewer.PrintOperationAction"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            LogFileViewer.this.getRegistration().togglePrintAction();
        }

        @Override
        public boolean isSelected(JMenuItem pCheckItem, Action pAction) {
            return LogFileViewer.this.getRegistration().isPrintActionActive();
        }
    }

    private final class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(LogFileViewer.this.getResourceString("LogFileViewer_close"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            LogFileViewer.this.disposeDialog();
        }
    }

    public static class Registration
    implements HookRegistration {
        private static HashMap mPrintActionHandler = new HashMap();
        private final MindMapController modeController;

        public Registration(ModeController controller, MindMap map) {
            this.modeController = (MindMapController)controller;
        }

        @Override
        public void register() {
        }

        @Override
        public void deRegister() {
        }

        public void togglePrintAction() {
            if (!mPrintActionHandler.containsKey(this.modeController)) {
                PrintActionHandler printActionHandler = new PrintActionHandler(this.modeController);
                this.modeController.getActionFactory().registerHandler(printActionHandler);
                mPrintActionHandler.put(this.modeController, printActionHandler);
            } else {
                this.modeController.getActionFactory().deregisterHandler((ActionHandler)mPrintActionHandler.get(this.modeController));
            }
        }

        public boolean isPrintActionActive() {
            return mPrintActionHandler.containsKey(this.modeController);
        }
    }
}

