/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import javajs.util.Lst;
import org.jmol.adapter.readers.more.ForceFieldReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.util.Logger;

public class MdTopReader
extends ForceFieldReader {
    private int nAtoms = 0;
    private int ac = 0;
    private String[] atomTypes;
    String[] group3s;

    @Override
    protected void initializeReader() throws Exception {
        this.setIsPDB();
        this.setUserAtomTypes();
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("%FLAG ") != 0) {
            return true;
        }
        this.line = this.line.substring(6).trim();
        if (this.line.equals("POINTERS")) {
            this.getPointers();
        } else if (this.line.equals("ATOM_NAME")) {
            this.getAtomNames();
        } else if (this.line.equals("CHARGE")) {
            this.getCharges();
        } else if (this.line.equals("RESIDUE_LABEL")) {
            this.getResidueLabels();
        } else if (this.line.equals("RESIDUE_POINTER")) {
            this.getResiduePointers();
        } else if (this.line.equals("AMBER_ATOM_TYPE")) {
            this.getAtomTypes();
        } else if (this.line.equals("MASS")) {
            this.getMasses();
        }
        return false;
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        int i;
        this.finalizeReaderASCR();
        Atom[] atoms = this.asc.atoms;
        for (int i2 = 0; i2 < this.ac; ++i2) {
            Atom atom = atoms[i2];
            atom.isHetero = this.vwr.getJBR().isHetero(atom.group3);
            String atomType = this.atomTypes[i2];
            if (this.getElementSymbol(atom, atomType)) continue;
            atom.elementSymbol = MdTopReader.deducePdbElementSymbol(atom.isHetero, atom.atomName, atom.group3);
        }
        Atom[] atoms2 = null;
        if (this.filter == null) {
            this.nAtoms = this.ac;
        } else {
            atoms2 = new Atom[atoms.length];
            this.nAtoms = 0;
            for (int i3 = 0; i3 < this.ac; ++i3) {
                if (!this.filterAtom(atoms[i3], i3)) continue;
                atoms2[this.nAtoms++] = atoms[i3];
            }
        }
        int j = 0;
        int k = 0;
        for (i = 0; i < this.ac; ++i) {
            if (this.filter != null && !this.bsFilter.get(i)) continue;
            if (k % 100 == 0) {
                ++j;
            }
            this.setAtomCoordXYZ(atoms[i], i % 100 * 2, j * 2, 0.0f);
        }
        if (atoms2 != null) {
            this.discardPreviousAtoms();
            for (i = 0; i < this.nAtoms; ++i) {
                this.asc.addAtom(atoms2[i]);
            }
        }
        Logger.info("Total number of atoms used=" + this.nAtoms);
        this.setModelPDB(true);
        this.htParams.put("defaultType", "mdcrd");
    }

    private String[] getDataBlock() throws Exception {
        Lst<String> vdata = new Lst<String>();
        this.discardLinesUntilContains("FORMAT");
        int n = (Integer)MdTopReader.getFortranFormatLengths(this.line.substring(this.line.indexOf("("))).get(0);
        int i = 0;
        int len = 0;
        while (true) {
            if (i >= len) {
                if (this.rd() == null) break;
                i = 0;
                len = this.line.length();
                if (len == 0 || this.line.indexOf("FLAG") >= 0) break;
            }
            vdata.addLast(this.line.substring(i, i + n).trim());
            i += n;
        }
        return vdata.toArray(new String[vdata.size()]);
    }

    private void getPointers() throws Exception {
        boolean isPeriodic;
        String[] tokens = this.getDataBlock();
        this.ac = this.parseIntStr(tokens[0]);
        boolean bl = isPeriodic = tokens[27].charAt(0) != '0';
        if (isPeriodic) {
            Logger.info("Periodic type: " + tokens[27]);
            this.htParams.put("isPeriodic", Boolean.TRUE);
        }
        Logger.info("Total number of atoms read=" + this.ac);
        this.htParams.put("templateAtomCount", this.ac);
        for (int i = 0; i < this.ac; ++i) {
            this.asc.addAtom(new Atom());
        }
    }

    private void getAtomTypes() throws Exception {
        this.atomTypes = this.getDataBlock();
    }

    private void getCharges() throws Exception {
        String[] data = this.getDataBlock();
        if (data.length != this.ac) {
            return;
        }
        Atom[] atoms = this.asc.atoms;
        int i = this.ac;
        while (--i >= 0) {
            atoms[i].partialCharge = this.parseFloatStr(data[i]);
        }
    }

    private void getResiduePointers() throws Exception {
        String[] resPtrs = this.getDataBlock();
        Logger.info("Total number of residues=" + resPtrs.length);
        int pt1 = this.ac;
        Atom[] atoms = this.asc.atoms;
        int i = resPtrs.length;
        while (--i >= 0) {
            int pt2;
            int ptr = pt2 = this.parseIntStr(resPtrs[i]) - 1;
            while (ptr < pt1) {
                if (this.group3s != null) {
                    atoms[ptr].group3 = this.group3s[i];
                }
                atoms[ptr++].sequenceNumber = i + 1;
            }
            pt1 = pt2;
        }
    }

    private void getResidueLabels() throws Exception {
        this.group3s = this.getDataBlock();
    }

    private void getAtomNames() throws Exception {
        String[] names = this.getDataBlock();
        Atom[] atoms = this.asc.atoms;
        for (int i = 0; i < this.ac; ++i) {
            atoms[i].atomName = names[i];
        }
    }

    private void getMasses() throws Exception {
    }
}

