/*
 * Decompiled with CFR 0.152.
 */
package org.junit.contrib.java.lang.system.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RestoreSpecificSystemProperties {
    private final List<String> properties = new ArrayList<String>();
    private final List<String> originalValues = new ArrayList<String>();

    public void add(String property) {
        this.properties.add(property);
        this.originalValues.add(System.getProperty(property));
    }

    public void restore() {
        Iterator<String> itOriginalValues = this.originalValues.iterator();
        for (String property : this.properties) {
            this.restore(property, itOriginalValues.next());
        }
    }

    private void restore(String property, String originalValue) {
        if (originalValue == null) {
            System.clearProperty(property);
        } else {
            System.setProperty(property, originalValue);
        }
    }
}

