/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuildersKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0014\u0010\t\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001aD\u0010\f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u00020\r*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0001H\u0000\u001a\f\u0010\u0016\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\f\u0010\u0017\u001a\u00020\u0002*\u00020\u0002H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"canHaveSideEffects", "", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getCanHaveSideEffects", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)Z", "constLongValue", "", "getConstLongValue", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)Ljava/lang/Long;", "castIfNecessary", "targetClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "createTemporaryVariableIfNecessary", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "expression", "nameHint", "", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isMutable", "decrement", "negate", "ir.backend.common"})
public final class UtilsKt {
    @NotNull
    public static final IrExpression negate(@NotNull IrExpression $this$negate) {
        IrExpression irExpression;
        Number value2;
        Intrinsics.checkNotNullParameter($this$negate, "$this$negate");
        IrExpression irExpression2 = $this$negate;
        if (!(irExpression2 instanceof IrConst)) {
            irExpression2 = null;
        }
        IrConst irConst = (IrConst)irExpression2;
        Object object = irConst != null ? irConst.getValue() : null;
        if (!(object instanceof Number)) {
            object = null;
        }
        if ((value2 = (Number)object) instanceof Integer) {
            irExpression = new IrConstImpl<Integer>($this$negate.getStartOffset(), $this$negate.getEndOffset(), $this$negate.getType(), IrConstKind.Int.INSTANCE, -value2.intValue());
        } else if (value2 instanceof Long) {
            irExpression = new IrConstImpl<Long>($this$negate.getStartOffset(), $this$negate.getEndOffset(), $this$negate.getType(), IrConstKind.Long.INSTANCE, -value2.longValue());
        } else {
            if (IrTypePredicatesKt.isNothing($this$negate.getType())) {
                return $this$negate;
            }
            IrClass irClass2 = IrTypesKt.getClass($this$negate.getType());
            Intrinsics.checkNotNull(irClass2);
            Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(irClass2);
            boolean $i$f$single = false;
            IrSimpleFunction single$iv = null;
            int found$iv = 0;
            Iterator<IrSimpleFunction> iterator2 = $this$single$iv.iterator();
            while (iterator2.hasNext()) {
                IrSimpleFunction element$iv;
                IrSimpleFunction it = element$iv = iterator2.next();
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getName(), OperatorNameConventions.UNARY_MINUS) && it.getValueParameters().isEmpty())) continue;
                if (found$iv != 0) {
                    throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = 1;
            }
            if (found$iv == 0) {
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            IrSimpleFunction unaryMinusFun = single$iv;
            IrCallImpl irCallImpl = null;
            IrStatementOrigin irStatementOrigin = null;
            int n = 0;
            found$iv = 0;
            irCallImpl = new IrCallImpl($this$negate.getStartOffset(), $this$negate.getEndOffset(), $this$negate.getType(), (IrSimpleFunctionSymbol)unaryMinusFun.getSymbol(), n, found$iv, irStatementOrigin, (IrClassSymbol)((Object)irCallImpl), 192, null);
            boolean bl = false;
            n = 0;
            IrCallImpl $this$apply = irCallImpl;
            boolean bl2 = false;
            $this$apply.setDispatchReceiver($this$negate);
            irExpression = irCallImpl;
        }
        return irExpression;
    }

    @NotNull
    public static final IrExpression decrement(@NotNull IrExpression $this$decrement) {
        IrExpression irExpression;
        Object thisValue;
        Intrinsics.checkNotNullParameter($this$decrement, "$this$decrement");
        IrExpression irExpression2 = $this$decrement;
        if (!(irExpression2 instanceof IrConst)) {
            irExpression2 = null;
        }
        IrConst irConst = (IrConst)irExpression2;
        Object object = thisValue = irConst != null ? irConst.getValue() : null;
        if (thisValue instanceof Integer) {
            irExpression = new IrConstImpl<Integer>($this$decrement.getStartOffset(), $this$decrement.getEndOffset(), $this$decrement.getType(), IrConstKind.Int.INSTANCE, ((Number)thisValue).intValue() - 1);
        } else if (thisValue instanceof Long) {
            irExpression = new IrConstImpl<Long>($this$decrement.getStartOffset(), $this$decrement.getEndOffset(), $this$decrement.getType(), IrConstKind.Long.INSTANCE, ((Number)thisValue).longValue() - 1L);
        } else if (thisValue instanceof Character) {
            irExpression = new IrConstImpl<Character>($this$decrement.getStartOffset(), $this$decrement.getEndOffset(), $this$decrement.getType(), IrConstKind.Char.INSTANCE, Character.valueOf((char)(((Character)thisValue).charValue() - '\u0001')));
        } else {
            IrClass irClass2 = IrTypesKt.getClass($this$decrement.getType());
            Intrinsics.checkNotNull(irClass2);
            Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(irClass2);
            boolean $i$f$single = false;
            IrSimpleFunction single$iv = null;
            int found$iv = 0;
            Iterator<IrSimpleFunction> iterator2 = $this$single$iv.iterator();
            while (iterator2.hasNext()) {
                IrSimpleFunction element$iv;
                IrSimpleFunction it = element$iv = iterator2.next();
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getName(), OperatorNameConventions.DEC) && it.getValueParameters().isEmpty())) continue;
                if (found$iv != 0) {
                    throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = 1;
            }
            if (found$iv == 0) {
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            IrSimpleFunction decFun = single$iv;
            IrCallImpl irCallImpl = null;
            IrStatementOrigin irStatementOrigin = null;
            int n = 0;
            found$iv = 0;
            irCallImpl = new IrCallImpl($this$decrement.getStartOffset(), $this$decrement.getEndOffset(), $this$decrement.getType(), (IrSimpleFunctionSymbol)decFun.getSymbol(), n, found$iv, irStatementOrigin, (IrClassSymbol)((Object)irCallImpl), 192, null);
            boolean bl = false;
            n = 0;
            IrCallImpl $this$apply = irCallImpl;
            boolean bl2 = false;
            $this$apply.setDispatchReceiver($this$decrement);
            irExpression = irCallImpl;
        }
        return irExpression;
    }

    public static final boolean getCanHaveSideEffects(@NotNull IrExpression $this$canHaveSideEffects) {
        Intrinsics.checkNotNullParameter($this$canHaveSideEffects, "$this$canHaveSideEffects");
        return !($this$canHaveSideEffects instanceof IrConst) && !($this$canHaveSideEffects instanceof IrGetValue);
    }

    @Nullable
    public static final Long getConstLongValue(@NotNull IrExpression $this$constLongValue) {
        Object value2;
        Intrinsics.checkNotNullParameter($this$constLongValue, "$this$constLongValue");
        return $this$constLongValue instanceof IrConst ? ((value2 = ((IrConst)$this$constLongValue).getValue()) instanceof Number ? Long.valueOf(((Number)value2).longValue()) : (value2 instanceof Character ? Long.valueOf(((Character)value2).charValue()) : null)) : null;
    }

    @NotNull
    public static final Pair<IrVariable, IrExpression> createTemporaryVariableIfNecessary(@NotNull DeclarationIrBuilder $this$createTemporaryVariableIfNecessary, @NotNull IrExpression expression2, @Nullable String nameHint, @Nullable IrType irType, boolean isMutable) {
        Pair<IrVariable, IrGetValueImpl> pair;
        Intrinsics.checkNotNullParameter($this$createTemporaryVariableIfNecessary, "$this$createTemporaryVariableIfNecessary");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (UtilsKt.getCanHaveSideEffects(expression2)) {
            boolean bl = isMutable;
            IrDeclarationOrigin irDeclarationOrigin = null;
            IrType irType2 = irType;
            IrVariable irVariable2 = IrBuildersKt.createTmpVariable$default($this$createTemporaryVariableIfNecessary.getScope(), expression2, nameHint, bl, irDeclarationOrigin, irType2, 8, null);
            boolean bl2 = false;
            boolean bl3 = false;
            IrVariable it = irVariable2;
            boolean bl4 = false;
            pair = new Pair<IrVariable, IrGetValueImpl>(it, ExpressionHelpersKt.irGet($this$createTemporaryVariableIfNecessary, it));
        } else {
            pair = new Pair<IrVariable, IrGetValueImpl>((IrVariable)null, (IrGetValueImpl)expression2);
        }
        return pair;
    }

    public static /* synthetic */ Pair createTemporaryVariableIfNecessary$default(DeclarationIrBuilder declarationIrBuilder, IrExpression irExpression, String string2, IrType irType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            irType = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return UtilsKt.createTemporaryVariableIfNecessary(declarationIrBuilder, irExpression, string2, irType, bl);
    }

    @NotNull
    public static final IrExpression castIfNecessary(@NotNull IrExpression $this$castIfNecessary, @NotNull IrClass targetClass) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter($this$castIfNecessary, "$this$castIfNecessary");
        Intrinsics.checkNotNullParameter(targetClass, "targetClass");
        if (Intrinsics.areEqual($this$castIfNecessary.getType(), IrUtilsKt.getDefaultType(targetClass)) || IrTypePredicatesKt.isNothing($this$castIfNecessary.getType())) {
            irExpression = $this$castIfNecessary;
        } else {
            Name name = Name.identifier("to" + targetClass.getName().asString());
            Intrinsics.checkNotNullExpressionValue(name, "Name.identifier(\"to${tar\u2026tClass.name.asString()}\")");
            Name numberCastFunctionName = name;
            IrClass irClass2 = IrTypesKt.getClass($this$castIfNecessary.getType());
            Intrinsics.checkNotNull(irClass2);
            Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(irClass2);
            boolean $i$f$single = false;
            IrSimpleFunction single$iv = null;
            boolean found$iv = false;
            Iterator<IrSimpleFunction> iterator2 = $this$single$iv.iterator();
            while (iterator2.hasNext()) {
                IrSimpleFunction element$iv;
                IrSimpleFunction it = element$iv = iterator2.next();
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getName(), numberCastFunctionName) && it.getDispatchReceiverParameter() != null && it.getExtensionReceiverParameter() == null && it.getValueParameters().isEmpty())) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            IrSimpleFunction castFun = single$iv;
            IrCallImpl irCallImpl = new IrCallImpl($this$castIfNecessary.getStartOffset(), $this$castIfNecessary.getEndOffset(), castFun.getReturnType(), (IrSimpleFunctionSymbol)castFun.getSymbol(), 0, 0, null, null, 192, null);
            boolean bl = false;
            boolean bl2 = false;
            IrCallImpl $this$apply = irCallImpl;
            boolean bl3 = false;
            $this$apply.setDispatchReceiver($this$castIfNecessary);
            irExpression = irCallImpl;
        }
        return irExpression;
    }
}

