/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.context.UsageTrackerKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\fH\u0002J\b\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\"2\u0006\u0010 \u001a\u00020\fH\u0002J\u0010\u0010$\u001a\u00020\"2\u0006\u0010 \u001a\u00020\fH\u0002J\u000e\u0010%\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\fJ\f\u0010&\u001a\u00020\r*\u00020\fH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\r0\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0012R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\r0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/js/translate/context/UsageTracker;", "", "parent", "containingDescriptor", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lorg/jetbrains/kotlin/js/translate/context/UsageTracker;Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "captured", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Lkotlin/collections/LinkedHashMap;", "capturedDescriptorToJsName", "", "getCapturedDescriptorToJsName", "()Ljava/util/Map;", "capturedDescriptors", "", "getCapturedDescriptors", "()Ljava/util/Set;", "capturedTypes", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "getCapturedTypes", "capturedTypesImpl", "", "getContainingDescriptor", "()Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "captureIfNeed", "", "descriptor", "isInLocalDeclaration", "", "isReceiverAncestor", "isSingletonReceiver", "used", "getJsNameForCapturedDescriptor", "js.translator"})
public final class UsageTracker {
    private final LinkedHashMap<DeclarationDescriptor, JsName> captured;
    private final Map<TypeParameterDescriptor, JsName> capturedTypesImpl;
    private final UsageTracker parent;
    private final MemberDescriptor containingDescriptor;
    private final BindingContext bindingContext;

    @NotNull
    public final Map<DeclarationDescriptor, JsName> getCapturedDescriptorToJsName() {
        return this.captured;
    }

    @NotNull
    public final Set<DeclarationDescriptor> getCapturedDescriptors() {
        Set<DeclarationDescriptor> set = this.captured.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "captured.keys");
        return set;
    }

    @NotNull
    public final Map<TypeParameterDescriptor, JsName> getCapturedTypes() {
        return this.capturedTypesImpl;
    }

    public final void used(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (UsageTrackerKt.isCaptured(this, descriptor2)) {
            return;
        }
        if (descriptor2 instanceof FakeCallableDescriptorForObject) {
            return;
        }
        if (descriptor2 instanceof FunctionDescriptor && Intrinsics.areEqual(((FunctionDescriptor)descriptor2).getVisibility(), DescriptorVisibilities.LOCAL)) {
            this.captureIfNeed(descriptor2);
        } else if (descriptor2 instanceof VariableDescriptor && !(descriptor2 instanceof PropertyDescriptor)) {
            this.captureIfNeed(descriptor2);
        } else if (descriptor2 instanceof ReceiverParameterDescriptor) {
            this.captureIfNeed(descriptor2);
        } else if (descriptor2 instanceof TypeParameterDescriptor && ((TypeParameterDescriptor)descriptor2).isReified()) {
            this.captureIfNeed(descriptor2);
        }
    }

    private final void captureIfNeed(DeclarationDescriptor descriptor2) {
        if (descriptor2 == null || UsageTrackerKt.isCaptured(this, descriptor2) || !this.isInLocalDeclaration() || DescriptorUtils.isAncestor(this.containingDescriptor, descriptor2, true) || this.isReceiverAncestor(descriptor2) || this.isSingletonReceiver(descriptor2)) {
            return;
        }
        if (DescriptorUtilsKt.isCoroutineLambda(descriptor2) && Intrinsics.areEqual(descriptor2, this.containingDescriptor)) {
            return;
        }
        UsageTracker usageTracker = this.parent;
        if (usageTracker != null) {
            usageTracker.captureIfNeed(descriptor2);
        }
        ((Map)this.captured).put(descriptor2, this.getJsNameForCapturedDescriptor(descriptor2));
        if (descriptor2 instanceof TypeParameterDescriptor) {
            DeclarationDescriptor declarationDescriptor = ((TypeParameterDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "descriptor.containingDeclaration");
            if (Intrinsics.areEqual(declarationDescriptor.getOriginal(), this.containingDescriptor.getOriginal()) ^ true) {
                StringBuilder stringBuilder2 = new StringBuilder().append("typeClosure$");
                String string2 = ((TypeParameterDescriptor)descriptor2).getName().asString();
                Intrinsics.checkNotNullExpressionValue(string2, "descriptor.name.asString()");
                String name = stringBuilder2.append(NameSuggestion.Companion.sanitizeName(string2)).toString();
                JsName jsName = JsScope.declareTemporaryName(name);
                Intrinsics.checkNotNullExpressionValue(jsName, "JsScope.declareTemporaryName(name)");
                this.capturedTypesImpl.put((TypeParameterDescriptor)descriptor2, jsName);
            }
        }
    }

    private final boolean isInLocalDeclaration() {
        MemberDescriptor memberDescriptor;
        MemberDescriptor container = this.containingDescriptor;
        if (container instanceof ConstructorDescriptor) {
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)container).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(classifierDescriptorWithTypeParameters, "container.containingDeclaration");
            memberDescriptor = classifierDescriptorWithTypeParameters;
        } else {
            memberDescriptor = container;
        }
        return DescriptorUtils.isDescriptorWithLocalVisibility(memberDescriptor);
    }

    private final boolean isReceiverAncestor(DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof ReceiverParameterDescriptor)) {
            return false;
        }
        if (!(this.containingDescriptor instanceof ClassDescriptor) && !(this.containingDescriptor instanceof ConstructorDescriptor)) {
            return false;
        }
        ClassDescriptor classDescriptor2 = DescriptorUtils.getParentOfType(this.containingDescriptor, ClassDescriptor.class, false);
        if (classDescriptor2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue(classDescriptor2, "getParentOfType(containi\u2026a, false) ?: return false");
        ClassDescriptor containingClass = classDescriptor2;
        DeclarationDescriptor declarationDescriptor = ((ReceiverParameterDescriptor)descriptor2).getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor3 = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor3 == null) {
            return false;
        }
        ClassDescriptor currentClass = classDescriptor3;
        Iterator<ClassDescriptor> iterator2 = SequencesKt.generateSequence(containingClass, (Function1)isReceiverAncestor.1.INSTANCE).iterator();
        while (iterator2.hasNext()) {
            ClassDescriptor outerDeclaration = iterator2.next();
            if (!Intrinsics.areEqual(outerDeclaration, currentClass)) continue;
            return true;
        }
        return false;
    }

    private final boolean isSingletonReceiver(DeclarationDescriptor descriptor2) {
        ClassDescriptor containingClass;
        if (!(descriptor2 instanceof ReceiverParameterDescriptor)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = ((ReceiverParameterDescriptor)descriptor2).getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "descriptor.containingDeclaration");
        DeclarationDescriptor container = declarationDescriptor;
        if (!DescriptorUtils.isObject(container)) {
            return false;
        }
        return this.containingDescriptor instanceof ClassDescriptor || !Intrinsics.areEqual(containingClass = DescriptorUtils.getParentOfType(this.containingDescriptor, ClassDescriptor.class, false), container);
    }

    private final JsName getJsNameForCapturedDescriptor(DeclarationDescriptor $this$getJsNameForCapturedDescriptor) {
        String string2;
        Object object = $this$getJsNameForCapturedDescriptor;
        if (object instanceof ReceiverParameterDescriptor) {
            string2 = UsageTrackerKt.access$getNameForCapturedReceiver((ReceiverParameterDescriptor)$this$getJsNameForCapturedDescriptor);
        } else if (object instanceof TypeParameterDescriptor) {
            String string3 = Namer.isInstanceSuggestedName((TypeParameterDescriptor)$this$getJsNameForCapturedDescriptor);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "Namer.isInstanceSuggestedName(this)");
        } else {
            SuggestedName suggestedName = new NameSuggestion().suggest($this$getJsNameForCapturedDescriptor, this.bindingContext);
            Intrinsics.checkNotNull(suggestedName);
            String mangled = NameSuggestion.Companion.sanitizeName(CollectionsKt.last(suggestedName.getNames()));
            string2 = "closure$" + mangled;
        }
        String suggestedName = string2;
        JsName jsName = JsScope.declareTemporaryName(suggestedName);
        Intrinsics.checkNotNullExpressionValue(jsName, "JsScope.declareTemporaryName(suggestedName)");
        object = jsName;
        boolean bl = false;
        boolean bl2 = false;
        Object $this$apply = object;
        boolean bl3 = false;
        MetadataProperties.setDescriptor((JsName)$this$apply, $this$getJsNameForCapturedDescriptor);
        return object;
    }

    @NotNull
    public final MemberDescriptor getContainingDescriptor() {
        return this.containingDescriptor;
    }

    @NotNull
    public final BindingContext getBindingContext() {
        return this.bindingContext;
    }

    public UsageTracker(@Nullable UsageTracker parent2, @NotNull MemberDescriptor containingDescriptor, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter(containingDescriptor, "containingDescriptor");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        this.parent = parent2;
        this.containingDescriptor = containingDescriptor;
        this.bindingContext = bindingContext;
        boolean bl = false;
        this.captured = new LinkedHashMap();
        bl = false;
        this.capturedTypesImpl = new LinkedHashMap();
    }
}

