//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.4
//
// <auto-generated>
//
// Generated from file `SSLInfo.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Glacier2_SSLInfo_h__
#define __Glacier2_SSLInfo_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/BuiltinSequences.h>
#include <IceUtil/UndefSysMacros.h>
#include <Glacier2/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 4
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef GLACIER2_API
#   if defined(ICE_STATIC_LIBS)
#       define GLACIER2_API /**/
#   elif defined(GLACIER2_API_EXPORTS)
#       define GLACIER2_API ICE_DECLSPEC_EXPORT
#   else
#       define GLACIER2_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace Glacier2
{

/**
 * Information taken from an SSL connection used for permissions
 * verification.
 * @see PermissionsVerifier
 * \headerfile Glacier2/Glacier2.h
 */
struct SSLInfo
{
    /**
     * The remote host.
     */
    ::std::string remoteHost;
    /**
     * The remote port.
     */
    int remotePort;
    /**
     * The router's host.
     */
    ::std::string localHost;
    /**
     * The router's port.
     */
    int localPort;
    /**
     * The negotiated cipher suite.
     */
    ::std::string cipher;
    /**
     * The certificate chain.
     */
    ::Ice::StringSeq certs;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&, const int&, const ::std::string&, const int&, const ::std::string&, const ::Ice::StringSeq&> ice_tuple() const
    {
        return std::tie(remoteHost, remotePort, localHost, localPort, cipher, certs);
    }
};

using Ice::operator<;
using Ice::operator<=;
using Ice::operator>;
using Ice::operator>=;
using Ice::operator==;
using Ice::operator!=;

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits<::Glacier2::SSLInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 12;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::Glacier2::SSLInfo, S>
{
    static void read(S* istr, ::Glacier2::SSLInfo& v)
    {
        istr->readAll(v.remoteHost, v.remotePort, v.localHost, v.localPort, v.cipher, v.certs);
    }
};

}
/// \endcond

#else // C++98 mapping

namespace Glacier2
{

/**
 * Information taken from an SSL connection used for permissions
 * verification.
 * @see PermissionsVerifier
 * \headerfile Glacier2/Glacier2.h
 */
struct SSLInfo
{
    /**
     * The remote host.
     */
    ::std::string remoteHost;
    /**
     * The remote port.
     */
    ::Ice::Int remotePort;
    /**
     * The router's host.
     */
    ::std::string localHost;
    /**
     * The router's port.
     */
    ::Ice::Int localPort;
    /**
     * The negotiated cipher suite.
     */
    ::std::string cipher;
    /**
     * The certificate chain.
     */
    ::Ice::StringSeq certs;
};

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits< ::Glacier2::SSLInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 12;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::Glacier2::SSLInfo, S>
{
    static void write(S* ostr, const ::Glacier2::SSLInfo& v)
    {
        ostr->write(v.remoteHost);
        ostr->write(v.remotePort);
        ostr->write(v.localHost);
        ostr->write(v.localPort);
        ostr->write(v.cipher);
        ostr->write(v.certs);
    }
};

template<typename S>
struct StreamReader< ::Glacier2::SSLInfo, S>
{
    static void read(S* istr, ::Glacier2::SSLInfo& v)
    {
        istr->read(v.remoteHost);
        istr->read(v.remotePort);
        istr->read(v.localHost);
        istr->read(v.localPort);
        istr->read(v.cipher);
        istr->read(v.certs);
    }
};

}
/// \endcond

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
