"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const chalk = require("chalk");
/**
 * Prints to the console with colors and a format.
 * @category Logging
 */
class RichConsoleLogger {
    constructor() {
        this.chalkDebug = chalk.cyan;
        this.chalkInfo = chalk.green;
        this.chalkWarning = chalk.yellow;
        this.chalkError = chalk.bold.red;
        this.chalkTimestamp = chalk.grey;
        this.chalkModule = chalk.grey;
    }
    getTimestamp() {
        const now = new Date(Date.now()).toUTCString();
        return this.chalkTimestamp(now);
    }
    debug(module, ...messageOrObject) {
        console.debug(this.getTimestamp(), this.chalkDebug("[DEBUG]"), this.chalkModule(`[${module}]`), ...messageOrObject);
    }
    error(module, ...messageOrObject) {
        console.error(this.getTimestamp(), this.chalkError("[ERROR]"), this.chalkModule(`[${module}]`), ...messageOrObject);
    }
    info(module, ...messageOrObject) {
        console.log(this.getTimestamp(), this.chalkInfo("[INFO]"), this.chalkModule(`[${module}]`), ...messageOrObject);
    }
    warn(module, ...messageOrObject) {
        console.warn(this.getTimestamp(), this.chalkWarning("[WARN]"), this.chalkModule(`[${module}]`), ...messageOrObject);
    }
}
exports.RichConsoleLogger = RichConsoleLogger;
