/*
 * Decompiled with CFR 0.152.
 */
package org.jibble.simpleftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.StringTokenizer;

public class SimpleFTP {
    private Socket socket = null;
    private BufferedReader reader = null;
    private BufferedWriter writer = null;
    private static boolean DEBUG = false;

    public synchronized void connect(String string) throws IOException {
        this.connect(string, 21);
    }

    public synchronized void connect(String string, int n) throws IOException {
        this.connect(string, n, "anonymous", "anonymous");
    }

    public synchronized void connect(String string, int n, String string2, String string3) throws IOException {
        if (this.socket != null) {
            throw new IOException("SimpleFTP is already connected. Disconnect first.");
        }
        this.socket = new Socket(string, n);
        this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
        string = this.readLine();
        if (!string.startsWith("220 ") && !string.startsWith("220-")) {
            throw new IOException("SimpleFTP received an unknown response when connecting to the FTP server: " + string);
        }
        this.sendLine("USER " + string2);
        string = this.readLine();
        while (string.startsWith("220 ") || string.startsWith("220-")) {
            string = this.readLine();
        }
        if (!string.startsWith("331 ")) {
            throw new IOException("SimpleFTP received an unknown response after sending the user: " + string);
        }
        this.sendLine("PASS " + string3);
        string = this.readLine();
        if (!string.startsWith("230 ")) {
            throw new IOException("SimpleFTP was unable to log in with the supplied password: " + string);
        }
    }

    public synchronized void disconnect() throws IOException {
        try {
            this.sendLine("QUIT");
            return;
        }
        finally {
            this.socket = null;
        }
    }

    public synchronized String pwd() throws IOException {
        int n;
        int n2;
        this.sendLine("PWD");
        String string = null;
        String string2 = this.readLine();
        if (string2.startsWith("257 ") && (n2 = string2.indexOf(34, (n = string2.indexOf(34)) + 1)) > 0) {
            string = string2.substring(n + 1, n2);
        }
        return string;
    }

    public synchronized boolean cwd(String string) throws IOException {
        this.sendLine("CWD " + string);
        return this.readLine().startsWith("250 ");
    }

    public synchronized boolean retr(OutputStream outputStream, String object) throws IOException {
        int n;
        outputStream = new BufferedOutputStream(outputStream);
        this.sendLine("PASV");
        String string = this.readLine();
        if (!string.startsWith("227 ")) {
            throw new IOException("SimpleFTP could not request passive mode: " + string);
        }
        Object object2 = null;
        int n2 = -1;
        int n3 = string.indexOf(40);
        int n4 = string.indexOf(41, n3 + 1);
        if (n4 > 0) {
            object2 = string.substring(n3 + 1, n4);
            StringTokenizer stringTokenizer = new StringTokenizer((String)object2, ",");
            try {
                object2 = stringTokenizer.nextToken() + "." + stringTokenizer.nextToken() + "." + stringTokenizer.nextToken() + "." + stringTokenizer.nextToken();
                n2 = (Integer.parseInt(stringTokenizer.nextToken()) << 8) + Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                throw new IOException("SimpleFTP received bad data link information: " + string);
            }
        }
        this.sendLine("RETR " + (String)object);
        object2 = new Socket((String)object2, n2);
        string = this.readLine();
        if (!string.startsWith("150 ")) {
            throw new IOException("SimpleFTP was not allowed to retrieve the file: " + string);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(((Socket)object2).getInputStream());
        object = new byte[4096];
        while ((n = bufferedInputStream.read((byte[])object)) != -1) {
            ((BufferedOutputStream)outputStream).write((byte[])object, 0, n);
        }
        ((BufferedOutputStream)outputStream).flush();
        ((FilterOutputStream)outputStream).close();
        bufferedInputStream.close();
        return this.readLine().startsWith("226 ");
    }

    public synchronized boolean stor(File file) throws IOException {
        if (file.isDirectory()) {
            throw new IOException("SimpleFTP cannot upload a directory.");
        }
        String string = file.getName();
        return this.stor(new FileInputStream(file), string);
    }

    public synchronized boolean stor(InputStream inputStream, String object) throws IOException {
        int n;
        inputStream = new BufferedInputStream(inputStream);
        this.sendLine("PASV");
        String string = this.readLine();
        if (!string.startsWith("227 ")) {
            throw new IOException("SimpleFTP could not request passive mode: " + string);
        }
        Object object2 = null;
        int n2 = -1;
        int n3 = string.indexOf(40);
        int n4 = string.indexOf(41, n3 + 1);
        if (n4 > 0) {
            object2 = string.substring(n3 + 1, n4);
            StringTokenizer stringTokenizer = new StringTokenizer((String)object2, ",");
            try {
                object2 = stringTokenizer.nextToken() + "." + stringTokenizer.nextToken() + "." + stringTokenizer.nextToken() + "." + stringTokenizer.nextToken();
                n2 = (Integer.parseInt(stringTokenizer.nextToken()) << 8) + Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                throw new IOException("SimpleFTP received bad data link information: " + string);
            }
        }
        this.sendLine("STOR " + (String)object);
        object2 = new Socket((String)object2, n2);
        string = this.readLine();
        if (!string.startsWith("150 ")) {
            throw new IOException("SimpleFTP was not allowed to send the file: " + string);
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(((Socket)object2).getOutputStream());
        object = new byte[4096];
        while ((n = ((FilterInputStream)inputStream).read((byte[])object)) != -1) {
            bufferedOutputStream.write((byte[])object, 0, n);
        }
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        ((BufferedInputStream)inputStream).close();
        return this.readLine().startsWith("226 ");
    }

    public synchronized boolean bin() throws IOException {
        this.sendLine("TYPE I");
        return this.readLine().startsWith("200 ");
    }

    public synchronized boolean ascii() throws IOException {
        this.sendLine("TYPE A");
        return this.readLine().startsWith("200 ");
    }

    private void sendLine(String string) throws IOException {
        if (this.socket == null) {
            throw new IOException("SimpleFTP is not connected.");
        }
        try {
            this.writer.write(string + "\r\n");
            this.writer.flush();
            if (DEBUG) {
                System.out.println("> " + string);
            }
            return;
        }
        catch (IOException iOException) {
            this.socket = null;
            throw iOException;
        }
    }

    private String readLine() throws IOException {
        String string = this.reader.readLine();
        if (DEBUG) {
            System.out.println("< " + string);
        }
        return string;
    }
}

