/*
 * Copyright (C) 2015 Richard Hughes <richard@hughsie.com>
 *
 * SPDX-License-Identifier: LGPL-2.1+
 */

#pragma once

/**
 * SECTION:fwupd-version
 * @short_description: Obtains the version for the installed fwupd
 *
 * These compile time macros allow the user to enable parts of client code
 * depending on the version of libfwupd installed.
 */

#if !defined (__FWUPD_H_INSIDE__) && !defined (FWUPD_COMPILATION)
#error "Only <fwupd.h> can be included directly."
#endif

/**
 * FWUPD_MAJOR_VERSION:
 *
 * The compile-time major version
 */
#ifndef FWUPD_MAJOR_VERSION
#define FWUPD_MAJOR_VERSION				(1)
#endif

/**
 * FWUPD_MINOR_VERSION:
 *
 * The compile-time minor version
 */
#ifndef FWUPD_MINOR_VERSION
#define FWUPD_MINOR_VERSION				(5)
#endif

/**
 * FWUPD_MICRO_VERSION:
 *
 * The compile-time micro version
 */
#ifndef FWUPD_MICRO_VERSION
#define FWUPD_MICRO_VERSION				(4)
#endif

/**
 * FWUPD_CHECK_VERSION:
 * @major: Major version number
 * @minor: Minor version number
 * @micro: Micro version number
 *
 * Check whether a fwupd version equal to or greater than
 * major.minor.micro.
 */
#define FWUPD_CHECK_VERSION(major,minor,micro)    \
    (FWUPD_MAJOR_VERSION > (major) || \
     (FWUPD_MAJOR_VERSION == (major) && FWUPD_MINOR_VERSION > (minor)) || \
     (FWUPD_MAJOR_VERSION == (major) && FWUPD_MINOR_VERSION == (minor) && \
      FWUPD_MICRO_VERSION >= (micro)))
