/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.spartan;

import javajs.util.PT;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

public abstract class SpartanInputReader
extends BasisFunctionReader {
    protected int modelAtomCount;
    protected String bondData = "";
    protected String constraints = "";

    protected String readInputRecords() throws Exception {
        String[] tokens;
        int ac0 = this.asc.ac;
        String modelName = this.readInputHeader();
        while (this.rd() != null && ((tokens = this.getTokens()).length != 2 || this.parseIntStr(tokens[0]) == Integer.MIN_VALUE || this.parseIntStr(tokens[1]) < 0)) {
        }
        if (this.line == null) {
            return null;
        }
        this.readInputAtoms();
        this.discardLinesUntilContains("ATOMLABELS");
        if (this.line != null) {
            this.readAtomNames();
        }
        if (this.modelAtomCount > 1) {
            this.discardLinesUntilContains("HESSIAN");
            if (this.line != null) {
                this.readBonds(ac0);
            }
            if (this.line != null && this.line.indexOf("BEGINCONSTRAINTS") >= 0) {
                this.readConstraints();
            }
        }
        return modelName;
    }

    private void readConstraints() throws Exception {
        this.constraints = "";
        while (this.rd() != null && this.line.indexOf("END") < 0) {
            this.constraints = this.constraints + (this.constraints == "" ? "" : "\n") + this.line;
        }
        this.rd();
        if (this.constraints.length() == 0) {
            return;
        }
        this.asc.setCurrentModelInfo("constraints", this.constraints);
        this.asc.setAtomSetModelProperty(".PATH", "EnergyProfile");
        this.asc.setAtomSetModelProperty("Constraint", this.constraints);
    }

    void readTransform() throws Exception {
        this.rd();
        String[] tokens = PT.getTokens(this.rd() + " " + this.rd());
        this.setTransform(this.parseFloatStr(tokens[0]), this.parseFloatStr(tokens[1]), this.parseFloatStr(tokens[2]), this.parseFloatStr(tokens[4]), this.parseFloatStr(tokens[5]), this.parseFloatStr(tokens[6]), this.parseFloatStr(tokens[8]), this.parseFloatStr(tokens[9]), this.parseFloatStr(tokens[10]));
    }

    private String readInputHeader() throws Exception {
        while (this.rd() != null && !this.line.startsWith(" ")) {
        }
        this.rd();
        return this.line.substring(0, (this.line + ";").indexOf(";")).trim();
    }

    private void readInputAtoms() throws Exception {
        this.modelAtomCount = 0;
        while (this.rd() != null && !this.line.startsWith("ENDCART")) {
            String[] tokens = this.getTokens();
            this.addAtomXYZSymName(tokens, 1, SpartanInputReader.getElementSymbol(this.parseIntStr(tokens[0])), null);
            ++this.modelAtomCount;
        }
        if (this.debugging) {
            Logger.debug(this.asc.ac + " atoms read");
        }
    }

    private void readAtomNames() throws Exception {
        int atom0 = this.asc.ac - this.modelAtomCount;
        for (int i = 0; i < this.modelAtomCount; ++i) {
            String name;
            this.line = this.rd().trim();
            this.asc.atoms[atom0 + i].atomName = name = this.line.substring(1, this.line.length() - 1);
        }
    }

    private void readBonds(int ac0) throws Exception {
        int nAtoms = this.modelAtomCount;
        this.bondData = "";
        while (this.rd() != null && !this.line.startsWith("ENDHESS")) {
            String[] tokens = this.getTokens();
            this.bondData = this.bondData + this.line + " ";
            if (nAtoms == 0) {
                int sourceIndex = this.parseIntStr(tokens[0]) - 1 + ac0;
                int targetIndex = this.parseIntStr(tokens[1]) - 1 + ac0;
                int bondOrder = this.parseIntStr(tokens[2]);
                if (bondOrder <= 0) continue;
                this.asc.addBond(new Bond(sourceIndex, targetIndex, bondOrder < 4 ? bondOrder : (bondOrder == 5 ? 515 : 1)));
                continue;
            }
            nAtoms -= tokens.length;
        }
        this.rd();
        if (this.debugging) {
            Logger.debug(this.asc.bondCount + " bonds read");
        }
    }
}

