/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import javajs.util.BS;
import javajs.util.T3;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;

class IsoIntersectReader
extends AtomDataReader {
    private static final int TYPE_FUNCTION = 0;
    private static final int TYPE_SUM = 1;
    private static final int TYPE_DIFF = 2;
    private static final int TYPE_MAX = 3;
    private static final int TYPE_DIFF_PAIR = 4;
    private final BS myBsA = new BS();
    private final BS myBsB = new BS();
    private BS[][] bsAtomMinMax = new BS[2][];
    private Object[] func;
    private int funcType = 0;
    private float[] thisPlaneB;
    private final float[] values = new float[2];

    IsoIntersectReader() {
    }

    @Override
    void init(SurfaceGenerator sg) {
        this.initADR(sg);
    }

    @Override
    protected boolean readVolumeParameters(boolean isMapData) {
        this.setup(isMapData);
        if (isMapData) {
            return false;
        }
        this.initializeVolumetricData();
        this.volumeData.setUnitVectors();
        this.thisPlaneB = new float[this.volumeData.getYzCount()];
        this.voxelSource = new int[this.volumeData.nPoints];
        this.vl0 = this.volumeData.volumetricVectorLengths[0];
        this.vl1 = this.volumeData.volumetricVectorLengths[1];
        this.vl2 = this.volumeData.volumetricVectorLengths[2];
        this.bsAtomMinMax[0] = new BS[this.nPointsX];
        this.getAtomMinMax(this.myBsA, this.bsAtomMinMax[0]);
        this.bsAtomMinMax[1] = new BS[this.nPointsX];
        this.getAtomMinMax(this.myBsB, this.bsAtomMinMax[1]);
        return true;
    }

    @Override
    protected void setup(boolean isMapData) {
        this.setup2();
        this.params.fullyLit = true;
        this.point = this.params.point;
        if (this.params.func instanceof String) {
            this.funcType = this.params.func.equals("a-b") ? 2 : (this.params.func.equals("a+b") ? 1 : 3);
        } else if (this.params.func == null || this.sg.atomDataServer == null) {
            this.funcType = 2;
        } else {
            this.func = (Object[])this.params.func;
        }
        if (this.contactPair == null) {
            BS bsA = this.params.intersection[0];
            BS bsB = this.params.intersection[1];
            BS bsSelected = new BS();
            bsSelected.or(bsA);
            bsSelected.or(bsB);
            this.doUseIterator = true;
            this.getAtoms(bsSelected, this.doAddHydrogens, true, true, false, false, false, Float.NaN, null);
            int i = bsA.nextSetBit(0);
            while (i >= 0) {
                this.myBsA.set(this.myIndex[i]);
                i = bsA.nextSetBit(i + 1);
            }
            i = bsB.nextSetBit(0);
            while (i >= 0) {
                this.myBsB.set(this.myIndex[i]);
                i = bsB.nextSetBit(i + 1);
            }
            this.setHeader("VDW intersection surface", this.params.calculationType);
            this.setRanges(this.params.solvent_ptsPerAngstrom, this.params.solvent_gridMax, 0.0f);
            this.margin = 5.0f;
        } else {
            this.setVolumeData();
        }
        this.isXLowToHigh = true;
        this.isProgressive = true;
    }

    @Override
    public float[] getPlane(int x) {
        if (this.yzCount == 0) {
            this.initPlanes();
        }
        this.thisX = x;
        this.thisPlane = this.yzPlanes[x % 2];
        if (this.contactPair == null) {
            this.thisAtomSet = this.bsAtomMinMax[0][x];
            this.resetPlane(Float.MAX_VALUE);
            this.markSphereVoxels(0.0f, this.params.distance);
            this.thisPlane = this.thisPlaneB;
            this.thisAtomSet = this.bsAtomMinMax[1][x];
            this.resetPlane(Float.MAX_VALUE);
            this.markSphereVoxels(0.0f, this.params.distance);
        } else {
            this.markPlaneVoxels(this.contactPair.myAtoms[0], this.contactPair.radii[0]);
            this.thisPlane = this.thisPlaneB;
            this.markPlaneVoxels(this.contactPair.myAtoms[1], this.contactPair.radii[1]);
        }
        this.thisPlane = this.yzPlanes[x % 2];
        if (!this.setVoxels()) {
            this.resetPlane(0.0f);
        }
        if (this.contactPair == null) {
            this.unsetVoxelData();
        }
        return this.thisPlane;
    }

    private boolean setVoxels() {
        for (int i = 0; i < this.yzCount; ++i) {
            float va = this.thisPlane[i];
            float vb = this.thisPlaneB[i];
            float v = this.getValueAB(va, vb);
            if (Float.isNaN(v)) {
                return false;
            }
            this.thisPlane[i] = v;
        }
        return true;
    }

    private float getValueAB(float va, float vb) {
        if (va == Float.MAX_VALUE || vb == Float.MAX_VALUE || Float.isNaN(va) || Float.isNaN(vb)) {
            return Float.MAX_VALUE;
        }
        switch (this.funcType) {
            case 1: {
                return va + vb;
            }
            case 2: 
            case 4: {
                return va - vb;
            }
            case 3: {
                return va > vb ? va : vb;
            }
        }
        this.values[0] = va;
        this.values[1] = vb;
        return this.sg.atomDataServer.evalFunctionFloat(this.func[0], this.func[1], this.values);
    }

    @Override
    public float getValueAtPoint(T3 pt, boolean getSource) {
        return this.getValueAB(this.getValueAtPoint2(pt, this.myBsA), this.getValueAtPoint2(pt, this.myBsB));
    }

    private float getValueAtPoint2(T3 pt, BS bs) {
        float value = Float.MAX_VALUE;
        int iAtom = bs.nextSetBit(0);
        while (iAtom >= 0) {
            float r = pt.distance(this.atomXyzTruncated[iAtom]) - this.atomRadius[iAtom];
            if (r < value) {
                value = r;
            }
            iAtom = bs.nextSetBit(iAtom + 1);
        }
        return value == Float.MAX_VALUE ? Float.NaN : value;
    }
}

