/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.janocchio;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openscience.jmol.app.janocchio.NoeTable;

public class NoeParameterSelectionPanel
extends JPanel {
    NoeTable noeTable;
    JTextField cutoffField;
    JLabel cutoffLabel;
    JTextField freqField;
    JLabel freqLabel;
    JComboBox<String> noesyComboBox;
    JLabel noesyLabel;
    JComboBox<String> refSingleComboBox;
    JLabel refSingleLabel;
    JTextField rhoStarField;
    JLabel rhoStarLabel;
    JButton setAllButton;
    JTextField tMixField;
    JLabel tMixLabel;
    JTextField tauField;
    JLabel tauLabel;
    JLabel titleLabel;

    public NoeParameterSelectionPanel(NoeTable noeTable) {
        this.noeTable = noeTable;
        this.initComponents();
        this.freqField.setText(String.valueOf(noeTable.getNMRfreq()));
        this.tauField.setText(String.valueOf(noeTable.getCorrelationTime()));
        this.tMixField.setText(String.valueOf(noeTable.getMixingTime()));
        this.cutoffField.setText(String.valueOf(noeTable.getCutoff()));
        this.rhoStarField.setText(String.valueOf(noeTable.getRhoStar()));
        this.freqField.setHorizontalAlignment(4);
        this.tauField.setHorizontalAlignment(4);
        this.tMixField.setHorizontalAlignment(4);
        this.cutoffField.setHorizontalAlignment(4);
        this.rhoStarField.setHorizontalAlignment(4);
    }

    void initComponents() {
        this.freqLabel = new JLabel();
        this.freqField = new JTextField();
        this.tMixLabel = new JLabel();
        this.tMixField = new JTextField();
        this.tauLabel = new JLabel();
        this.tauField = new JTextField();
        this.cutoffLabel = new JLabel();
        this.cutoffField = new JTextField();
        this.rhoStarLabel = new JLabel();
        this.rhoStarField = new JTextField();
        this.setAllButton = new JButton();
        this.titleLabel = new JLabel();
        this.noesyLabel = new JLabel();
        this.noesyComboBox = new JComboBox();
        this.refSingleLabel = new JLabel();
        this.refSingleComboBox = new JComboBox();
        this.freqLabel.setText("Spectrometer Frequency/MHz");
        this.freqField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NoeParameterSelectionPanel.this.freqFieldActionPerformed(evt);
            }
        });
        this.tMixLabel.setText("Mixing Time/s");
        this.tMixField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NoeParameterSelectionPanel.this.tMixFieldActionPerformed(evt);
            }
        });
        this.tauLabel.setText("Correlation Time/ps");
        this.tauField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NoeParameterSelectionPanel.this.tauFieldActionPerformed(evt);
            }
        });
        this.cutoffLabel.setText("Spin-pair cutoff/A");
        this.cutoffField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NoeParameterSelectionPanel.this.cutoffFieldActionPerformed(evt);
            }
        });
        this.rhoStarLabel.setText("Constant relaxation term/s-1");
        this.rhoStarField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NoeParameterSelectionPanel.this.rhoStarFieldActionPerformed(evt);
            }
        });
        this.setAllButton.setText("Set All");
        this.setAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NoeParameterSelectionPanel.this.setAllButtonActionPerformed(evt);
            }
        });
        this.titleLabel.setText("Parameters for NOE Calculation");
        this.noesyLabel.setText("NOESY or ROESY");
        this.noesyComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"NOESY", "ROESY"}));
        this.noesyComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NoeParameterSelectionPanel.this.noesyComboBoxActionPerformed(evt);
            }
        });
        this.refSingleLabel.setText("Normalisation");
        this.refSingleComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Single", "Diag"}));
        this.refSingleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NoeParameterSelectionPanel.this.refSingleComboBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.setAllButton)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(35, 35, 35).addComponent(this.titleLabel)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cutoffLabel).addComponent(this.freqLabel).addComponent(this.tMixLabel).addComponent(this.tauLabel)).addGap(18, 18, 18)).addGroup(layout.createSequentialGroup().addComponent(this.noesyLabel, -1, 195, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.tauField, GroupLayout.Alignment.LEADING).addComponent(this.tMixField, GroupLayout.Alignment.LEADING).addComponent(this.freqField, -1, 61, Short.MAX_VALUE).addComponent(this.cutoffField).addComponent(this.rhoStarField, GroupLayout.Alignment.LEADING)).addComponent(this.noesyComboBox, -2, -1, -2))).addGroup(layout.createSequentialGroup().addComponent(this.rhoStarLabel, -1, 276, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.refSingleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 119, Short.MAX_VALUE).addComponent(this.refSingleComboBox, -2, 69, -2)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.titleLabel, -2, 24, -2).addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.freqLabel).addComponent(this.freqField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tMixLabel).addComponent(this.tMixField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tauLabel, -2, 23, -2).addComponent(this.tauField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cutoffField, -2, -1, -2).addComponent(this.cutoffLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rhoStarLabel).addComponent(this.rhoStarField, -2, 19, -2)).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.noesyComboBox, -2, -1, -2).addComponent(this.noesyLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.refSingleComboBox, -2, -1, -2).addComponent(this.refSingleLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 66, Short.MAX_VALUE).addComponent(this.setAllButton).addContainerGap()));
    }

    void refSingleComboBoxActionPerformed(ActionEvent evt) {
        String sel = (String)this.refSingleComboBox.getSelectedItem();
        if (sel.equals("Single")) {
            this.noeTable.setlrefSingle(true);
        } else {
            this.noeTable.setlrefSingle(false);
        }
    }

    void noesyComboBoxActionPerformed(ActionEvent evt) {
        String sel = (String)this.noesyComboBox.getSelectedItem();
        if (sel.equals("NOESY")) {
            this.noeTable.setNoesy(true);
        } else {
            this.noeTable.setNoesy(false);
        }
    }

    void setAllButtonActionPerformed(ActionEvent evt) {
        this.rhoStarFieldActionPerformed(evt);
        this.cutoffFieldActionPerformed(evt);
        this.tauFieldActionPerformed(evt);
        this.tMixFieldActionPerformed(evt);
        this.freqFieldActionPerformed(evt);
        this.noesyComboBoxActionPerformed(evt);
        this.refSingleComboBoxActionPerformed(evt);
    }

    void rhoStarFieldActionPerformed(ActionEvent evt) {
        String text = this.rhoStarField.getText();
        this.noeTable.setRhoStar(Double.parseDouble(text));
        this.rhoStarField.setText(String.valueOf(this.noeTable.getRhoStar()));
    }

    void cutoffFieldActionPerformed(ActionEvent evt) {
        String text = this.cutoffField.getText();
        this.noeTable.setCutoff(Double.parseDouble(text));
        this.cutoffField.setText(String.valueOf(this.noeTable.getCutoff()));
    }

    void tauFieldActionPerformed(ActionEvent evt) {
        String text = this.tauField.getText();
        this.noeTable.setCorrelationTime(Double.parseDouble(text));
        this.tauField.setText(String.valueOf(this.noeTable.getCorrelationTime()));
    }

    void tMixFieldActionPerformed(ActionEvent evt) {
        String text = this.tMixField.getText();
        this.noeTable.setMixingTime(Double.parseDouble(text));
        this.tMixField.setText(String.valueOf(this.noeTable.getMixingTime()));
    }

    void freqFieldActionPerformed(ActionEvent evt) {
        String text = this.freqField.getText();
        this.noeTable.setNMRfreq(Double.parseDouble(text));
        this.freqField.setText(String.valueOf(this.noeTable.getNMRfreq()));
    }

    public JTextField getRhoStarField() {
        return this.rhoStarField;
    }

    public JTextField getCutoffField() {
        return this.cutoffField;
    }

    public JTextField getTauField() {
        return this.tauField;
    }

    public JTextField gettMixField() {
        return this.tMixField;
    }

    public JTextField getFreqField() {
        return this.freqField;
    }
}

