/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Point;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.Pair;

final class ImproveWayAccuracyHelper {
    private ImproveWayAccuracyHelper() {
    }

    public static Way findWay(MapView mv, Point p) {
        Optional<Way> candidate;
        if (mv == null || p == null) {
            return null;
        }
        Node node = mv.getNearestNode(p, OsmPrimitive::isSelectable);
        if (node != null && (candidate = node.referrers(Way.class).findFirst()).isPresent()) {
            return candidate.get();
        }
        return MainApplication.getMap().mapView.getNearestWay(p, OsmPrimitive::isSelectable);
    }

    public static Node findCandidateNode(MapView mv, Way w, Point p) {
        if (mv == null || w == null || p == null) {
            return null;
        }
        EastNorth pEN = mv.getEastNorth(p.x, p.y);
        Double bestDistance = Double.MAX_VALUE;
        List<Pair<Node, Node>> wpps = w.getNodePairs(false);
        Node result = null;
        block0: for (Node n : w.getNodes()) {
            Double currentDistance;
            EastNorth nEN = n.getEastNorth();
            if (nEN == null || !((currentDistance = Double.valueOf(pEN.distance(nEN))) < bestDistance)) continue;
            for (Pair<Node, Node> wpp : wpps) {
                if (((Node)wpp.a).equals(n) || ((Node)wpp.b).equals(n) || Geometry.getSegmentSegmentIntersection(((Node)wpp.a).getEastNorth(), ((Node)wpp.b).getEastNorth(), pEN, nEN) == null) continue;
                continue block0;
            }
            result = n;
            bestDistance = currentDistance;
        }
        return result;
    }

    public static WaySegment findCandidateSegment(MapView mv, Way w, Point p) {
        if (mv == null || w == null || p == null) {
            return null;
        }
        EastNorth pEN = mv.getEastNorth(p.x, p.y);
        Double bestDistance = Double.MAX_VALUE;
        Double bestAngle = 0.0;
        int candidate = -1;
        List<Pair<Node, Node>> wpps = w.getNodePairs(true);
        int i = -1;
        for (Pair<Node, Node> wpp : wpps) {
            ++i;
            EastNorth a = ((Node)wpp.a).getEastNorth();
            EastNorth b = ((Node)wpp.b).getEastNorth();
            EastNorth altitudeIntersection = Geometry.closestPointToSegment(a, b, pEN);
            Double currentDistance = pEN.distance(altitudeIntersection);
            Double currentAngle = !altitudeIntersection.equals(a) && !altitudeIntersection.equals(b) ? Double.valueOf(Double.MAX_VALUE) : Double.valueOf(Math.abs(Geometry.getCornerAngle(a, pEN, b)));
            if (!(currentDistance < bestDistance) && (!(currentAngle > bestAngle) || !(currentDistance < bestDistance * 1.0001))) continue;
            candidate = i;
            bestAngle = currentAngle;
            bestDistance = currentDistance;
        }
        return candidate != -1 ? new WaySegment(w, candidate) : null;
    }
}

