/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.UniqueIdGenerator;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;

public class RelationData
extends PrimitiveData
implements IRelation<RelationMemberData> {
    private static final long serialVersionUID = 1163664954890478565L;
    private static final UniqueIdGenerator idGenerator = Relation.idGenerator;
    private List<RelationMemberData> members = new ArrayList<RelationMemberData>();

    public RelationData() {
        this(idGenerator.generateUniqueId());
    }

    public RelationData(long id) {
        super(id);
    }

    public RelationData(RelationData data) {
        super(data);
        this.members.addAll(data.members);
    }

    @Override
    public List<RelationMemberData> getMembers() {
        return this.members;
    }

    @Override
    public void setMembers(List<RelationMemberData> memberData) {
        this.members = new ArrayList<RelationMemberData>(memberData);
    }

    @Override
    public int getMembersCount() {
        return this.members.size();
    }

    @Override
    public RelationMemberData getMember(int index) {
        return this.members.get(index);
    }

    @Override
    public long getMemberId(int idx) {
        return this.getMember(idx).getMemberId();
    }

    @Override
    public String getRole(int idx) {
        return this.getMember(idx).getRole();
    }

    @Override
    public OsmPrimitiveType getMemberType(int idx) {
        return this.getMember(idx).getMemberType();
    }

    @Override
    public RelationData makeCopy() {
        return new RelationData(this);
    }

    @Override
    public String toString() {
        return super.toString() + " REL " + this.members;
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.RELATION;
    }

    @Override
    public void accept(PrimitiveVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public BBox getBBox() {
        throw new UnsupportedOperationException();
    }

    @Override
    public UniqueIdGenerator getIdGenerator() {
        return idGenerator;
    }
}

