/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class UrlBasedQueryPanel
extends JPanel {
    private final JosmTextField tfUrl = new JosmTextField();
    private final JLabel lblValid = new JLabel();

    public UrlBasedQueryPanel() {
        this.build();
    }

    protected JPanel buildURLPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.weightx = 0.0;
        gc.fill = 2;
        gc.insets = new Insets(0, 0, 0, 5);
        pnl.add((Component)new JLabel(I18n.tr("URL: ", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        gc.fill = 2;
        pnl.add((Component)this.tfUrl, gc);
        this.tfUrl.getDocument().addDocumentListener(new ChangetQueryUrlValidator());
        this.tfUrl.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                UrlBasedQueryPanel.this.tfUrl.selectAll();
            }
        });
        gc.gridx = 2;
        gc.weightx = 0.0;
        gc.fill = 2;
        pnl.add((Component)this.lblValid, gc);
        this.lblValid.setPreferredSize(new Dimension(20, 20));
        return pnl;
    }

    protected static List<String> getExamples() {
        return Arrays.asList(Config.getUrls().getOSMWebsite() + "/history?open=true", OsmApi.getOsmApi().getBaseUrl() + "/changesets?open=true");
    }

    protected JPanel buildHelpPanel() {
        String apiUrl = OsmApi.getOsmApi().getBaseUrl();
        HtmlPanel pnl = new HtmlPanel();
        pnl.setText("<html><body>" + I18n.tr("Please enter or paste an URL to retrieve changesets from the OSM API.", new Object[0]) + "<p><strong>" + I18n.tr("Examples", new Object[0]) + "</strong></p><ul>" + UrlBasedQueryPanel.getExamples().stream().map(s -> "<li><a href=\"" + s + "\">" + s + "</a></li>").collect(Collectors.joining("")) + "</ul>" + I18n.tr("Note that changeset queries are currently always submitted to ''{0}'', regardless of the host, port and path of the URL entered below.", apiUrl) + "</body></html>");
        pnl.getEditorPane().addHyperlinkListener(e -> {
            if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                this.tfUrl.setText(e.getDescription());
                this.tfUrl.requestFocusInWindow();
            }
        });
        return pnl;
    }

    protected final void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gc = new GridBagConstraints();
        gc.weightx = 1.0;
        gc.fill = 2;
        gc.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.buildHelpPanel(), gc);
        gc.gridy = 1;
        gc.weightx = 1.0;
        gc.fill = 2;
        this.add((Component)this.buildURLPanel(), gc);
        gc.gridy = 2;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        this.add((Component)new JPanel(), gc);
    }

    protected static boolean isValidChangesetQueryUrl(String text) {
        return UrlBasedQueryPanel.buildChangesetQuery(text) != null;
    }

    protected static ChangesetQuery buildChangesetQuery(String text) {
        URL url = null;
        try {
            url = new URL(text);
        }
        catch (MalformedURLException e) {
            return null;
        }
        String path = url.getPath();
        if (path == null || !path.endsWith("/changesets") && !path.endsWith("/history")) {
            return null;
        }
        try {
            return ChangesetQuery.buildFromUrlQuery(url.getQuery());
        }
        catch (ChangesetQuery.ChangesetQueryUrlException e) {
            Logging.warn(e);
            return null;
        }
    }

    public ChangesetQuery buildChangesetQuery() {
        String value = this.tfUrl.getText().trim();
        return UrlBasedQueryPanel.buildChangesetQuery(value);
    }

    public void startUserInput() {
        this.tfUrl.requestFocusInWindow();
    }

    class ChangetQueryUrlValidator
    implements DocumentListener {
        ChangetQueryUrlValidator() {
        }

        protected String getCurrentFeedback() {
            String fb = (String)UrlBasedQueryPanel.this.lblValid.getClientProperty("valid");
            return fb == null ? "none" : fb;
        }

        protected void feedbackValid() {
            if ("valid".equals(this.getCurrentFeedback())) {
                return;
            }
            UrlBasedQueryPanel.this.lblValid.setIcon(ImageProvider.get("misc", "green_check"));
            UrlBasedQueryPanel.this.lblValid.setToolTipText(null);
            UrlBasedQueryPanel.this.lblValid.putClientProperty("valid", "valid");
        }

        protected void feedbackInvalid() {
            if ("invalid".equals(this.getCurrentFeedback())) {
                return;
            }
            UrlBasedQueryPanel.this.lblValid.setIcon(ImageProvider.get("warning-small"));
            UrlBasedQueryPanel.this.lblValid.setToolTipText(I18n.tr("This changeset query URL is invalid", new Object[0]));
            UrlBasedQueryPanel.this.lblValid.putClientProperty("valid", "invalid");
        }

        protected void feedbackNone() {
            UrlBasedQueryPanel.this.lblValid.setIcon(null);
            UrlBasedQueryPanel.this.lblValid.putClientProperty("valid", "none");
        }

        protected void validate() {
            String value = UrlBasedQueryPanel.this.tfUrl.getText();
            if (value.trim().isEmpty()) {
                this.feedbackNone();
                return;
            }
            if (UrlBasedQueryPanel.isValidChangesetQueryUrl(value = value.trim())) {
                this.feedbackValid();
            } else {
                this.feedbackInvalid();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.validate();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.validate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.validate();
        }
    }
}

