/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsContext;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.CipherSuite;
import org.bouncycastle.tls.ClientHello;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.HandshakeMessageInput;
import org.bouncycastle.tls.HandshakeMessageOutput;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.ServerHello;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientContextImpl;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TlsClientProtocol
extends TlsProtocol {
    protected TlsClient tlsClient = null;
    TlsClientContextImpl tlsClientContext = null;
    protected Hashtable clientAgreements = null;
    protected TlsKeyExchange keyExchange = null;
    protected TlsAuthentication authentication = null;
    protected CertificateStatus certificateStatus = null;
    protected CertificateRequest certificateRequest = null;

    public TlsClientProtocol() {
    }

    public TlsClientProtocol(InputStream inputStream, OutputStream outputStream) {
        super(inputStream, outputStream);
    }

    public void connect(TlsClient tlsClient) throws IOException {
        if (tlsClient == null) {
            throw new IllegalArgumentException("'tlsClient' cannot be null");
        }
        if (this.tlsClient != null) {
            throw new IllegalStateException("'connect' can only be called once");
        }
        this.tlsClient = tlsClient;
        this.tlsClientContext = new TlsClientContextImpl(tlsClient.getCrypto());
        this.tlsClient.init(this.tlsClientContext);
        this.recordStream.init(this.tlsClientContext);
        tlsClient.notifyCloseHandle(this);
        this.beginHandshake(false);
        if (this.blocking) {
            this.blockForHandshake();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beginHandshake(boolean bl) throws IOException {
        SessionParameters sessionParameters;
        super.beginHandshake(bl);
        TlsSession tlsSession = this.tlsClient.getSessionToResume();
        if (tlsSession != null && tlsSession.isResumable() && (sessionParameters = tlsSession.exportSessionParameters()) != null && (sessionParameters.isExtendedMasterSecret() || !this.tlsClient.requiresExtendedMasterSecret() && this.tlsClient.allowLegacyResumption())) {
            TlsSecret tlsSecret;
            TlsSecret tlsSecret2 = tlsSecret = sessionParameters.getMasterSecret();
            synchronized (tlsSecret2) {
                if (tlsSecret.isAlive()) {
                    this.tlsSession = tlsSession;
                    this.sessionParameters = sessionParameters;
                    this.sessionMasterSecret = this.tlsClientContext.getCrypto().adoptSecret(tlsSecret);
                }
            }
        }
        this.sendClientHelloMessage();
        this.connection_state = 1;
    }

    protected void cleanupHandshake() {
        super.cleanupHandshake();
        this.keyExchange = null;
        this.authentication = null;
        this.certificateStatus = null;
        this.certificateRequest = null;
    }

    protected TlsContext getContext() {
        return this.tlsClientContext;
    }

    AbstractTlsContext getContextAdmin() {
        return this.tlsClientContext;
    }

    protected TlsPeer getPeer() {
        return this.tlsClient;
    }

    protected void handle13HandshakeMessage(short s, HandshakeMessageInput handshakeMessageInput) throws IOException {
        if (!this.isTLSv13ConnectionState()) {
            throw new TlsFatalAlert(80);
        }
        if (this.resumedSession) {
            throw new TlsFatalAlert(80);
        }
        block0 : switch (s) {
            case 11: {
                switch (this.connection_state) {
                    case 5: {
                        this.skip13CertificateRequest();
                    }
                    case 11: {
                        this.receive13ServerCertificate(handshakeMessageInput);
                        this.connection_state = (short)7;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 13: {
                switch (this.connection_state) {
                    case 21: {
                        throw new TlsFatalAlert(10);
                    }
                    case 5: {
                        this.receive13CertificateRequest(handshakeMessageInput);
                        this.connection_state = (short)11;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 15: {
                switch (this.connection_state) {
                    case 7: {
                        this.receive13ServerCertificateVerify(handshakeMessageInput);
                        handshakeMessageInput.updateHash(this.handshakeHash);
                        this.connection_state = (short)9;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 8: {
                switch (this.connection_state) {
                    case 4: {
                        this.receive13EncryptedExtensions(handshakeMessageInput);
                        this.connection_state = (short)5;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 5: {
                        this.skip13CertificateRequest();
                    }
                    case 11: {
                        this.skip13ServerCertificate();
                    }
                    case 9: {
                        this.receive13ServerFinished(handshakeMessageInput);
                        handshakeMessageInput.updateHash(this.handshakeHash);
                        this.connection_state = (short)20;
                        this.connection_state = (short)18;
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 24: {
                switch (this.connection_state) {
                    case 21: {
                        this.receive13ServerKeyUpdate(handshakeMessageInput);
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 4: {
                switch (this.connection_state) {
                    case 21: {
                        this.receive13NewSessionTicket(handshakeMessageInput);
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 2: {
                switch (this.connection_state) {
                    case 1: {
                        throw new TlsFatalAlert(80);
                    }
                    case 3: {
                        ServerHello serverHello = ServerHello.parse(handshakeMessageInput);
                        if (serverHello.isHelloRetryRequest()) {
                            throw new TlsFatalAlert(10);
                        }
                        this.process13ServerHello(serverHello, true);
                        handshakeMessageInput.updateHash(this.handshakeHash);
                        this.connection_state = (short)4;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void handleHandshakeMessage(short s, HandshakeMessageInput handshakeMessageInput) throws IOException {
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        if (this.connection_state > 1 && TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
            this.handle13HandshakeMessage(s, handshakeMessageInput);
            return;
        }
        if (!this.isLegacyConnectionState()) {
            throw new TlsFatalAlert(80);
        }
        if (this.resumedSession) {
            if (s != 20 || this.connection_state != 4) {
                throw new TlsFatalAlert(10);
            }
            this.processFinishedMessage(handshakeMessageInput);
            handshakeMessageInput.updateHash(this.handshakeHash);
            this.connection_state = (short)20;
            this.sendChangeCipherSpecMessage();
            this.sendFinishedMessage();
            this.connection_state = (short)18;
            this.completeHandshake();
            return;
        }
        block0 : switch (s) {
            case 11: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(null);
                    }
                    case 6: {
                        TlsUtils.receiveServerCertificate(this.tlsClientContext, handshakeMessageInput);
                        this.authentication = this.tlsClient.getAuthentication();
                        if (null != this.authentication) break;
                        throw new TlsFatalAlert(80);
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)7;
                break;
            }
            case 22: {
                switch (this.connection_state) {
                    case 7: {
                        if (!this.allowCertificateStatus) {
                            throw new TlsFatalAlert(10);
                        }
                        this.certificateStatus = CertificateStatus.parse(handshakeMessageInput);
                        TlsClientProtocol.assertEmpty(handshakeMessageInput);
                        this.connection_state = (short)8;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 18: {
                        if (this.expectSessionTicket) {
                            throw new TlsFatalAlert(10);
                        }
                    }
                    case 19: {
                        this.processFinishedMessage(handshakeMessageInput);
                        this.connection_state = (short)20;
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 2: {
                switch (this.connection_state) {
                    case 1: {
                        ServerHello serverHello = ServerHello.parse(handshakeMessageInput);
                        if (serverHello.isHelloRetryRequest()) {
                            this.process13HelloRetryRequest(serverHello);
                            this.handshakeHash.notifyPRFDetermined();
                            TlsUtils.adjustTranscriptForRetry(this.handshakeHash);
                            handshakeMessageInput.updateHash(this.handshakeHash);
                            this.connection_state = (short)2;
                            this.send13ClientHelloRetryMessage();
                            this.connection_state = (short)3;
                            break block0;
                        }
                        this.processServerHelloMessage(serverHello);
                        this.handshakeHash.notifyPRFDetermined();
                        handshakeMessageInput.updateHash(this.handshakeHash);
                        this.connection_state = (short)4;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 23: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(TlsClientProtocol.readSupplementalDataMessage(handshakeMessageInput));
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 14: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(null);
                    }
                    case 6: {
                        this.authentication = null;
                    }
                    case 7: 
                    case 8: {
                        this.handleServerCertificate();
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 10: 
                    case 11: {
                        TlsClientProtocol.assertEmpty(handshakeMessageInput);
                        this.connection_state = (short)12;
                        Vector vector = this.tlsClient.getClientSupplementalData();
                        if (vector != null) {
                            this.sendSupplementalDataMessage(vector);
                        }
                        this.connection_state = (short)14;
                        TlsCredentialedSigner tlsCredentialedSigner = null;
                        TlsStreamSigner tlsStreamSigner = null;
                        if (this.certificateRequest == null) {
                            this.keyExchange.skipClientCredentials();
                        } else {
                            Certificate certificate = null;
                            TlsCredentials tlsCredentials = TlsUtils.establishClientCredentials(this.authentication, this.certificateRequest);
                            if (null == tlsCredentials) {
                                this.keyExchange.skipClientCredentials();
                            } else {
                                this.keyExchange.processClientCredentials(tlsCredentials);
                                certificate = tlsCredentials.getCertificate();
                                if (tlsCredentials instanceof TlsCredentialedSigner) {
                                    tlsCredentialedSigner = (TlsCredentialedSigner)tlsCredentials;
                                    tlsStreamSigner = tlsCredentialedSigner.getStreamSigner();
                                }
                            }
                            this.sendCertificateMessage(certificate, null);
                        }
                        this.connection_state = (short)15;
                        boolean bl = tlsStreamSigner != null;
                        TlsUtils.sealHandshakeHash(this.tlsClientContext, this.handshakeHash, bl);
                        this.sendClientKeyExchangeMessage();
                        this.connection_state = (short)16;
                        boolean bl2 = TlsUtils.isSSL(this.tlsClientContext);
                        if (bl2) {
                            TlsClientProtocol.establishMasterSecret(this.tlsClientContext, this.keyExchange);
                        }
                        this.tlsClientContext.getSecurityParametersHandshake().sessionHash = TlsUtils.getCurrentPRFHash(this.handshakeHash);
                        if (!bl2) {
                            TlsClientProtocol.establishMasterSecret(this.tlsClientContext, this.keyExchange);
                        }
                        this.recordStream.setPendingConnectionState(TlsUtils.initCipher(this.tlsClientContext));
                        if (tlsCredentialedSigner != null) {
                            DigitallySigned digitallySigned = TlsUtils.generateCertificateVerify(this.tlsClientContext, tlsCredentialedSigner, tlsStreamSigner, this.handshakeHash);
                            this.sendCertificateVerifyMessage(digitallySigned);
                            this.connection_state = (short)17;
                        }
                        this.handshakeHash = this.handshakeHash.stopTracking();
                        this.sendChangeCipherSpecMessage();
                        this.sendFinishedMessage();
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)18;
                break;
            }
            case 12: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(null);
                    }
                    case 6: {
                        this.authentication = null;
                    }
                    case 7: 
                    case 8: {
                        this.handleServerCertificate();
                        this.keyExchange.processServerKeyExchange(handshakeMessageInput);
                        TlsClientProtocol.assertEmpty(handshakeMessageInput);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)10;
                break;
            }
            case 13: {
                switch (this.connection_state) {
                    case 7: 
                    case 8: {
                        this.handleServerCertificate();
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 10: {
                        if (this.authentication == null) {
                            throw new TlsFatalAlert(40);
                        }
                        this.certificateRequest = CertificateRequest.parse(this.tlsClientContext, handshakeMessageInput);
                        TlsClientProtocol.assertEmpty(handshakeMessageInput);
                        this.certificateRequest = TlsUtils.validateCertificateRequest(this.certificateRequest, this.keyExchange);
                        TlsUtils.establishServerSigAlgs(securityParameters, this.certificateRequest);
                        TlsUtils.trackHashAlgorithms(this.handshakeHash, securityParameters.getServerSigAlgs());
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)11;
                break;
            }
            case 4: {
                switch (this.connection_state) {
                    case 18: {
                        if (!this.expectSessionTicket) {
                            throw new TlsFatalAlert(10);
                        }
                        this.invalidateSession();
                        this.receiveNewSessionTicketMessage(handshakeMessageInput);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)19;
                break;
            }
            case 0: {
                TlsClientProtocol.assertEmpty(handshakeMessageInput);
                if (this.connection_state != 21) break;
                this.handleRenegotiation();
                break;
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void handleServerCertificate() throws IOException {
        TlsUtils.processServerCertificate(this.tlsClientContext, this.tlsClient, this.certificateStatus, this.keyExchange, this.authentication, this.clientExtensions, this.serverExtensions);
    }

    protected void handleSupplementalData(Vector vector) throws IOException {
        this.tlsClient.processServerSupplementalData(vector);
        this.connection_state = (short)6;
        this.keyExchange = TlsUtils.initKeyExchangeClient(this.tlsClientContext, this.tlsClient);
    }

    protected void process13HelloRetryRequest(ServerHello serverHello) throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected void process13ServerHello(ServerHello serverHello, boolean bl) throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected void processServerHelloMessage(ServerHello serverHello) throws IOException {
        Object object;
        Object object2;
        Object object3;
        this.serverExtensions = serverHello.getExtensions();
        ProtocolVersion protocolVersion = serverHello.getVersion();
        ProtocolVersion protocolVersion2 = TlsExtensionsUtils.getSupportedVersionsExtensionServer(this.serverExtensions);
        if (null != protocolVersion2) {
            if (!ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(protocolVersion2)) {
                throw new TlsFatalAlert(47);
            }
            protocolVersion = protocolVersion2;
        }
        if (!ProtocolVersion.isSupportedTLSVersion(protocolVersion)) {
            throw new TlsFatalAlert(47);
        }
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        if (securityParameters.isRenegotiating()) {
            if (!protocolVersion.equals(this.tlsClientContext.getServerVersion())) {
                throw new TlsFatalAlert(47);
            }
        } else {
            if (!ProtocolVersion.contains(this.tlsClientContext.getClientSupportedVersions(), protocolVersion)) {
                throw new TlsFatalAlert(47);
            }
            object3 = protocolVersion.isLaterVersionOf(ProtocolVersion.TLSv12) ? ProtocolVersion.TLSv12 : protocolVersion;
            this.recordStream.setWriteVersion((ProtocolVersion)object3);
            securityParameters.negotiatedVersion = protocolVersion;
        }
        TlsUtils.negotiatedVersion(this.tlsClientContext);
        this.tlsClient.notifyServerVersion(protocolVersion);
        securityParameters.serverRandom = serverHello.getRandom();
        if (!this.tlsClientContext.getClientVersion().equals(protocolVersion)) {
            TlsUtils.checkDowngradeMarker(protocolVersion, securityParameters.getServerRandom());
        }
        object3 = serverHello.getSessionID();
        if (ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(protocolVersion)) {
            object2 = TlsUtils.getSessionID(this.tlsSession);
            if (!Arrays.areEqual((byte[])object2, (byte[])object3)) {
                throw new TlsFatalAlert(47);
            }
            object3 = TlsUtils.EMPTY_BYTES;
        }
        securityParameters.sessionID = (byte[])object3;
        this.tlsClient.notifySessionID((byte[])object3);
        this.resumedSession = ((Object)object3).length > 0 && this.tlsSession != null && Arrays.areEqual((byte[])object3, (byte[])this.tlsSession.getSessionID());
        int n = serverHello.getCipherSuite();
        if (!Arrays.contains((int[])this.offeredCipherSuites, (int)n) || n == 0 || CipherSuite.isSCSV(n) || !TlsUtils.isValidCipherSuiteForVersion(n, this.tlsClientContext.getServerVersion())) {
            throw new TlsFatalAlert(47);
        }
        securityParameters.cipherSuite = n;
        TlsUtils.negotiatedCipherSuite(this.tlsClientContext);
        this.tlsClient.notifySelectedCipherSuite(n);
        if (this.serverExtensions != null) {
            Enumeration enumeration = this.serverExtensions.keys();
            while (enumeration.hasMoreElements()) {
                object2 = (Integer)enumeration.nextElement();
                if (object2.equals(EXT_RenegotiationInfo)) continue;
                if (null == TlsUtils.getExtensionData(this.clientExtensions, (Integer)object2)) {
                    throw new TlsFatalAlert(110);
                }
                if (!this.resumedSession) continue;
            }
        }
        byte[] byArray = TlsUtils.getExtensionData(this.serverExtensions, EXT_RenegotiationInfo);
        if (securityParameters.isRenegotiating()) {
            if (!securityParameters.isSecureRenegotiation()) {
                throw new TlsFatalAlert(80);
            }
            if (byArray == null) {
                throw new TlsFatalAlert(40);
            }
            object2 = this.tlsClientContext.getSecurityParametersConnection();
            object = TlsUtils.concat(object2.getLocalVerifyData(), object2.getPeerVerifyData());
            if (!Arrays.constantTimeAreEqual((byte[])byArray, (byte[])TlsClientProtocol.createRenegotiationInfo(object))) {
                throw new TlsFatalAlert(40);
            }
        } else if (byArray == null) {
            securityParameters.secureRenegotiation = false;
        } else {
            securityParameters.secureRenegotiation = true;
            if (!Arrays.constantTimeAreEqual((byte[])byArray, (byte[])TlsClientProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        this.tlsClient.notifySecureRenegotiation(securityParameters.isSecureRenegotiation());
        boolean bl = TlsExtensionsUtils.hasExtendedMasterSecretExtension(this.serverExtensions);
        if (bl ? protocolVersion.isSSL() || !this.resumedSession && !this.tlsClient.shouldUseExtendedMasterSecret() : this.tlsClient.requiresExtendedMasterSecret() || this.resumedSession && !this.tlsClient.allowLegacyResumption()) {
            throw new TlsFatalAlert(40);
        }
        securityParameters.extendedMasterSecret = bl;
        securityParameters.applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer(this.serverExtensions);
        securityParameters.applicationProtocolSet = true;
        Hashtable hashtable = this.clientExtensions;
        object = this.serverExtensions;
        if (this.resumedSession) {
            if (securityParameters.getCipherSuite() != this.sessionParameters.getCipherSuite() || 0 != this.sessionParameters.getCompressionAlgorithm() || !protocolVersion.equals(this.sessionParameters.getNegotiatedVersion())) {
                throw new TlsFatalAlert(47);
            }
            hashtable = null;
            object = this.sessionParameters.readServerExtensions();
        }
        if (object != null && !object.isEmpty()) {
            boolean bl2 = TlsExtensionsUtils.hasEncryptThenMACExtension((Hashtable)object);
            if (bl2 && !TlsUtils.isBlockCipherSuite(securityParameters.getCipherSuite())) {
                throw new TlsFatalAlert(47);
            }
            securityParameters.encryptThenMAC = bl2;
            securityParameters.maxFragmentLength = this.processMaxFragmentLengthExtension(hashtable, (Hashtable)object, (short)47);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension((Hashtable)object);
            this.allowCertificateStatus = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData((Hashtable)object, TlsExtensionsUtils.EXT_status_request, (short)47);
            boolean bl3 = this.expectSessionTicket = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData((Hashtable)object, TlsProtocol.EXT_SessionTicket, (short)47);
        }
        if (hashtable != null) {
            this.tlsClient.processServerExtensions((Hashtable)object);
        }
        securityParameters.prfAlgorithm = TlsClientProtocol.getPRFAlgorithm(this.tlsClientContext, securityParameters.getCipherSuite());
        securityParameters.verifyDataLength = securityParameters.getNegotiatedVersion().isSSL() ? 36 : 12;
        this.applyMaxFragmentLengthExtension();
        if (this.resumedSession) {
            securityParameters.masterSecret = this.sessionMasterSecret;
            this.recordStream.setPendingConnectionState(TlsUtils.initCipher(this.tlsClientContext));
        } else {
            this.invalidateSession();
            this.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
            this.sessionParameters = null;
            this.sessionMasterSecret = null;
        }
    }

    protected void receive13CertificateRequest(ByteArrayInputStream byteArrayInputStream) throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected void receive13EncryptedExtensions(ByteArrayInputStream byteArrayInputStream) throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected void receive13NewSessionTicket(ByteArrayInputStream byteArrayInputStream) throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected void receive13ServerCertificate(ByteArrayInputStream byteArrayInputStream) throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected void receive13ServerCertificateVerify(ByteArrayInputStream byteArrayInputStream) throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected void receive13ServerFinished(ByteArrayInputStream byteArrayInputStream) throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected void receive13ServerKeyUpdate(ByteArrayInputStream byteArrayInputStream) throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected void receiveNewSessionTicketMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(byteArrayInputStream);
        TlsClientProtocol.assertEmpty(byteArrayInputStream);
        this.tlsClient.notifyNewSessionTicket(newSessionTicket);
    }

    protected void send13ClientHelloRetryMessage() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected void sendCertificateVerifyMessage(DigitallySigned digitallySigned) throws IOException {
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(15);
        digitallySigned.encode(handshakeMessageOutput);
        handshakeMessageOutput.send(this);
    }

    protected void sendClientHelloMessage() throws IOException {
        Object object;
        ProtocolVersion protocolVersion;
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        if (securityParameters.isRenegotiating()) {
            protocolVersion = this.tlsClientContext.getClientVersion();
        } else {
            this.tlsClientContext.setClientSupportedVersions(this.tlsClient.getProtocolVersions());
            if (ProtocolVersion.contains(this.tlsClientContext.getClientSupportedVersions(), ProtocolVersion.SSLv3)) {
                this.recordStream.setWriteVersion(ProtocolVersion.SSLv3);
            } else {
                this.recordStream.setWriteVersion(ProtocolVersion.TLSv10);
            }
            protocolVersion = ProtocolVersion.getLatestTLS(this.tlsClientContext.getClientSupportedVersions());
            if (!ProtocolVersion.isSupportedTLSVersion(protocolVersion)) {
                throw new TlsFatalAlert(80);
            }
            this.tlsClientContext.setClientVersion(protocolVersion);
        }
        byte[] byArray = TlsUtils.getSessionID(this.tlsSession);
        boolean bl = this.tlsClient.isFallback();
        this.offeredCipherSuites = this.tlsClient.getCipherSuites();
        if (!(byArray.length <= 0 || this.sessionParameters == null || Arrays.contains((int[])this.offeredCipherSuites, (int)this.sessionParameters.getCipherSuite()) && 0 == this.sessionParameters.getCompressionAlgorithm())) {
            byArray = TlsUtils.EMPTY_BYTES;
        }
        this.clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.tlsClient.getClientExtensions());
        ProtocolVersion protocolVersion2 = protocolVersion;
        if (protocolVersion.isLaterVersionOf(ProtocolVersion.TLSv12)) {
            protocolVersion2 = ProtocolVersion.TLSv12;
            TlsExtensionsUtils.addSupportedVersionsExtensionClient(this.clientExtensions, this.tlsClientContext.getClientSupportedVersions());
        }
        this.tlsClientContext.setRSAPreMasterSecretVersion(protocolVersion2);
        securityParameters.clientServerNames = TlsExtensionsUtils.getServerNameExtensionClient(this.clientExtensions);
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion)) {
            TlsUtils.establishClientSigAlgs(securityParameters, this.clientExtensions);
        }
        securityParameters.clientSupportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(this.clientExtensions);
        this.clientAgreements = TlsUtils.addEarlyKeySharesToClientHello(this.tlsClientContext, this.tlsClient, this.clientExtensions);
        if (!protocolVersion.isSSL() && this.tlsClient.shouldUseExtendedMasterSecret()) {
            TlsExtensionsUtils.addExtendedMasterSecretExtension(this.clientExtensions);
        } else if (this.tlsClient.requiresExtendedMasterSecret()) {
            throw new TlsFatalAlert(80);
        }
        securityParameters.clientRandom = TlsClientProtocol.createRandomBlock(this.tlsClient.shouldUseGMTUnixTime(), this.tlsClientContext);
        if (securityParameters.isRenegotiating()) {
            if (!securityParameters.isSecureRenegotiation()) {
                throw new TlsFatalAlert(80);
            }
            object = this.tlsClientContext.getSecurityParametersConnection();
            this.clientExtensions.put(EXT_RenegotiationInfo, TlsClientProtocol.createRenegotiationInfo(((SecurityParameters)object).getLocalVerifyData()));
        } else {
            boolean bl2;
            boolean bl3 = null == TlsUtils.getExtensionData(this.clientExtensions, EXT_RenegotiationInfo);
            boolean bl4 = bl2 = !Arrays.contains((int[])this.offeredCipherSuites, (int)255);
            if (bl3 && bl2) {
                this.offeredCipherSuites = Arrays.append((int[])this.offeredCipherSuites, (int)255);
            }
        }
        if (bl && !Arrays.contains((int[])this.offeredCipherSuites, (int)22016)) {
            this.offeredCipherSuites = Arrays.append((int[])this.offeredCipherSuites, (int)22016);
        }
        object = new ClientHello(protocolVersion2, securityParameters.getClientRandom(), byArray, null, this.offeredCipherSuites, this.clientExtensions);
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(1);
        ((ClientHello)object).encode(this.tlsClientContext, handshakeMessageOutput);
        handshakeMessageOutput.send(this);
    }

    protected void sendClientKeyExchangeMessage() throws IOException {
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(16);
        this.keyExchange.generateClientKeyExchange(handshakeMessageOutput);
        handshakeMessageOutput.send(this);
    }

    protected void skip13CertificateRequest() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected void skip13ServerCertificate() throws IOException {
        throw new TlsFatalAlert(80);
    }
}

