/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.field.StrictDateTimeField;

public final class StrictChronology
extends AssembledChronology {
    private static final long serialVersionUID = 6633006628097111960L;
    private transient Chronology iWithUTC;

    public static StrictChronology getInstance(Chronology chronology) {
        if (chronology == null) {
            throw new IllegalArgumentException("Must supply a chronology");
        }
        return new StrictChronology(chronology);
    }

    private StrictChronology(Chronology chronology) {
        super(chronology, null);
    }

    public Chronology withUTC() {
        if (this.iWithUTC == null) {
            this.iWithUTC = this.getZone() == DateTimeZone.UTC ? this : StrictChronology.getInstance(this.getBase().withUTC());
        }
        return this.iWithUTC;
    }

    public Chronology withZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == DateTimeZone.UTC) {
            return this.withUTC();
        }
        if (dateTimeZone == this.getZone()) {
            return this;
        }
        return StrictChronology.getInstance(this.getBase().withZone(dateTimeZone));
    }

    protected void assemble(AssembledChronology.Fields fields2) {
        fields2.year = StrictChronology.convertField(fields2.year);
        fields2.yearOfEra = StrictChronology.convertField(fields2.yearOfEra);
        fields2.yearOfCentury = StrictChronology.convertField(fields2.yearOfCentury);
        fields2.centuryOfEra = StrictChronology.convertField(fields2.centuryOfEra);
        fields2.era = StrictChronology.convertField(fields2.era);
        fields2.dayOfWeek = StrictChronology.convertField(fields2.dayOfWeek);
        fields2.dayOfMonth = StrictChronology.convertField(fields2.dayOfMonth);
        fields2.dayOfYear = StrictChronology.convertField(fields2.dayOfYear);
        fields2.monthOfYear = StrictChronology.convertField(fields2.monthOfYear);
        fields2.weekOfWeekyear = StrictChronology.convertField(fields2.weekOfWeekyear);
        fields2.weekyear = StrictChronology.convertField(fields2.weekyear);
        fields2.weekyearOfCentury = StrictChronology.convertField(fields2.weekyearOfCentury);
        fields2.millisOfSecond = StrictChronology.convertField(fields2.millisOfSecond);
        fields2.millisOfDay = StrictChronology.convertField(fields2.millisOfDay);
        fields2.secondOfMinute = StrictChronology.convertField(fields2.secondOfMinute);
        fields2.secondOfDay = StrictChronology.convertField(fields2.secondOfDay);
        fields2.minuteOfHour = StrictChronology.convertField(fields2.minuteOfHour);
        fields2.minuteOfDay = StrictChronology.convertField(fields2.minuteOfDay);
        fields2.hourOfDay = StrictChronology.convertField(fields2.hourOfDay);
        fields2.hourOfHalfday = StrictChronology.convertField(fields2.hourOfHalfday);
        fields2.clockhourOfDay = StrictChronology.convertField(fields2.clockhourOfDay);
        fields2.clockhourOfHalfday = StrictChronology.convertField(fields2.clockhourOfHalfday);
        fields2.halfdayOfDay = StrictChronology.convertField(fields2.halfdayOfDay);
    }

    private static final DateTimeField convertField(DateTimeField dateTimeField) {
        return StrictDateTimeField.getInstance(dateTimeField);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StrictChronology)) {
            return false;
        }
        StrictChronology strictChronology = (StrictChronology)object;
        return this.getBase().equals(strictChronology.getBase());
    }

    public int hashCode() {
        return 352831696 + this.getBase().hashCode() * 7;
    }

    public String toString() {
        return "StrictChronology[" + this.getBase().toString() + ']';
    }
}

