/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.dataflow.analyses;

import org.jruby.ir.Operation;
import org.jruby.ir.dataflow.analyses.UnboxableOp;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Float;

final class ArithOp
extends UnboxableOp {
    private final Operation fixnumOp;
    private final Operation floatOp;

    public ArithOp(String name2, Operation fixnumOp, Operation floatOp) {
        super(name2);
        this.fixnumOp = fixnumOp;
        this.floatOp = floatOp;
    }

    @Override
    public boolean acceptsArgTypes(Class receiverType, Class argType) {
        return receiverType == Float.class || receiverType == Fixnum.class && (argType == Float.class || argType == Fixnum.class);
    }

    @Override
    public Class getUnboxedType(Class receiverType, Class argType) {
        return receiverType == Float.class || argType == Float.class ? Float.class : Fixnum.class;
    }

    @Override
    public final Class getUnboxedResultType(Class operandType) {
        return operandType == Float.class || operandType == Fixnum.class ? operandType : null;
    }

    @Override
    public final Operation getUnboxedOp(Class operandType) {
        return operandType == Fixnum.class ? this.fixnumOp : (operandType == Float.class ? this.floatOp : null);
    }
}

