/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.lexer.StrptimeLexer;
import org.jruby.util.StrptimeFormat;
import org.jruby.util.StrptimeToken;

public class StrptimeParser {
    private static final String[] DAY_NAMES = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] MONTH_NAMES = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] MERID_NAMES = new String[]{"am", "pm", "a.m.", "p.m."};

    private void addToPattern(List<StrptimeToken> compiledPattern, String str) {
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char c = str.charAt(i2);
            if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
                compiledPattern.add(StrptimeToken.format(c));
                continue;
            }
            compiledPattern.add(StrptimeToken.str(Character.toString(c)));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<StrptimeToken> compilePattern(String pattern) {
        LinkedList<StrptimeToken> compiledPattern = new LinkedList<StrptimeToken>();
        StringReader reader = new StringReader(pattern);
        StrptimeLexer lexer = new StrptimeLexer(reader);
        try {
            char c;
            StrptimeToken token;
            block15: while ((token = lexer.yylex()) != null) {
                if (token.getFormat() != StrptimeFormat.FORMAT_SPECIAL) {
                    compiledPattern.add(token);
                    continue;
                }
                c = ((Character)token.getData()).charValue();
                switch (c) {
                    case 'c': {
                        this.addToPattern(compiledPattern, "a b e H:M:S Y");
                        continue block15;
                    }
                    case 'D': 
                    case 'x': {
                        this.addToPattern(compiledPattern, "m/d/y");
                        continue block15;
                    }
                    case 'F': {
                        this.addToPattern(compiledPattern, "Y-m-d");
                        continue block15;
                    }
                    case 'n': {
                        compiledPattern.add(StrptimeToken.str("\n"));
                        continue block15;
                    }
                    case 'R': {
                        this.addToPattern(compiledPattern, "H:M");
                        continue block15;
                    }
                    case 'r': {
                        this.addToPattern(compiledPattern, "I:M:S p");
                        continue block15;
                    }
                    case 'T': 
                    case 'X': {
                        this.addToPattern(compiledPattern, "H:M:S");
                        continue block15;
                    }
                    case 't': {
                        compiledPattern.add(StrptimeToken.str("\t"));
                        continue block15;
                    }
                    case 'v': {
                        this.addToPattern(compiledPattern, "e-b-Y");
                        continue block15;
                    }
                    case 'Z': {
                        compiledPattern.add(StrptimeToken.zoneOffsetColons(1));
                        continue block15;
                    }
                    case '+': {
                        this.addToPattern(compiledPattern, "a b e H:M:S ");
                        compiledPattern.add(StrptimeToken.zoneOffsetColons(1));
                        this.addToPattern(compiledPattern, " Y");
                        continue block15;
                    }
                }
            }
            return compiledPattern;
            throw new Error("Unknown special char: " + c);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return compiledPattern;
    }

    public FormatBag parse(List<StrptimeToken> compiledPattern, String text) {
        FormatBag bag = new StringParser(text).parse(compiledPattern);
        if (bag == null) {
            return null;
        }
        if (FormatBag.has(bag.cent)) {
            if (FormatBag.has(bag.cWYear)) {
                bag.cWYear = bag.cWYear + bag.cent * 100L;
            }
            if (FormatBag.has(bag.year)) {
                bag.year = bag.year + bag.cent * 100L;
            }
            bag.cent = Long.MIN_VALUE;
        }
        if (FormatBag.has(bag.merid)) {
            if (FormatBag.has(bag.hour)) {
                bag.hour = bag.hour % 12;
                bag.hour = bag.hour + bag.merid;
            }
            bag.merid = Integer.MIN_VALUE;
        }
        return bag;
    }

    private static class StringParser {
        private static final Pattern ZONE_PARSE_REGEX = Pattern.compile("\\A((?:gmt|utc?)?[-+]\\d+(?:[,.:]\\d+(?::\\d+)?)?|(?-i:[[\\p{Alpha}].\\s]+)(?:standard|daylight)\\s+time\\b|(?-i:[[\\p{Alpha}]]+)(?:\\s+dst)?\\b)", 2);
        private final String text;
        private final FormatBag bag;
        private int pos;
        private boolean fail;
        private static final EnumSet<StrptimeFormat> NUMBER_PATTERNS = EnumSet.copyOf(Arrays.asList(StrptimeFormat.FORMAT_CENTURY, StrptimeFormat.FORMAT_DAY, StrptimeFormat.FORMAT_DAY_S, StrptimeFormat.FORMAT_WEEKYEAR, StrptimeFormat.FORMAT_WEEKYEAR_SHORT, StrptimeFormat.FORMAT_HOUR, StrptimeFormat.FORMAT_HOUR_M, StrptimeFormat.FORMAT_DAY_YEAR, StrptimeFormat.FORMAT_HOUR_BLANK, StrptimeFormat.FORMAT_MILLISEC, StrptimeFormat.FORMAT_HOUR_S, StrptimeFormat.FORMAT_MINUTES, StrptimeFormat.FORMAT_MONTH, StrptimeFormat.FORMAT_NANOSEC, StrptimeFormat.FORMAT_SECONDS, StrptimeFormat.FORMAT_EPOCH, StrptimeFormat.FORMAT_WEEK_YEAR_S, StrptimeFormat.FORMAT_DAY_WEEK2, StrptimeFormat.FORMAT_WEEK_WEEKYEAR, StrptimeFormat.FORMAT_WEEK_YEAR_M, StrptimeFormat.FORMAT_DAY_WEEK, StrptimeFormat.FORMAT_YEAR_LONG, StrptimeFormat.FORMAT_YEAR_SHORT));

        private StringParser(String text) {
            this.text = text;
            this.bag = new FormatBag();
            this.pos = 0;
            this.fail = false;
        }

        private FormatBag parse(List<StrptimeToken> compiledPattern) {
            block27: for (int tokenIndex = 0; tokenIndex < compiledPattern.size(); ++tokenIndex) {
                StrptimeToken token = compiledPattern.get(tokenIndex);
                switch (token.getFormat()) {
                    case FORMAT_STRING: {
                        String str = token.getData().toString();
                        for (int i2 = 0; i2 < str.length(); ++i2) {
                            char c = str.charAt(i2);
                            if (StringParser.isSpace(c)) {
                                while (!StringParser.isEndOfText(this.text, this.pos) && StringParser.isSpace(this.text.charAt(this.pos))) {
                                    ++this.pos;
                                }
                                continue;
                            }
                            if (StringParser.isEndOfText(this.text, this.pos) || c != this.text.charAt(this.pos)) {
                                this.fail = true;
                            }
                            ++this.pos;
                        }
                        continue block27;
                    }
                    case FORMAT_WEEK_LONG: 
                    case FORMAT_WEEK_SHORT: {
                        int dayIndex = this.findIndexInPatterns(DAY_NAMES);
                        if (dayIndex >= 0) {
                            this.bag.wDay = dayIndex % 7;
                            this.pos += DAY_NAMES[dayIndex].length();
                            continue block27;
                        }
                        this.fail = true;
                        continue block27;
                    }
                    case FORMAT_MONTH_LONG: 
                    case FORMAT_MONTH_SHORT: {
                        int monIndex = this.findIndexInPatterns(MONTH_NAMES);
                        if (monIndex >= 0) {
                            this.bag.mon = monIndex % 12 + 1;
                            this.pos += MONTH_NAMES[monIndex].length();
                            continue block27;
                        }
                        this.fail = true;
                        continue block27;
                    }
                    case FORMAT_CENTURY: {
                        if (StringParser.isNumberPattern(compiledPattern, tokenIndex)) {
                            this.bag.cent = this.readDigits(2);
                            continue block27;
                        }
                        this.bag.cent = this.readDigitsMaxLong();
                        continue block27;
                    }
                    case FORMAT_DAY: 
                    case FORMAT_DAY_S: {
                        long day;
                        if (StringParser.isBlank(this.text, this.pos)) {
                            ++this.pos;
                            day = this.readDigits(1);
                        } else {
                            day = this.readDigits(2);
                        }
                        if (!StringParser.validRange(day, 1, 31)) {
                            this.fail = true;
                        }
                        this.bag.mDay = (int)day;
                        continue block27;
                    }
                    case FORMAT_WEEKYEAR: {
                        if (StringParser.isNumberPattern(compiledPattern, tokenIndex)) {
                            this.bag.cWYear = this.readDigits(4);
                            continue block27;
                        }
                        this.bag.cWYear = this.readDigitsMaxLong();
                        continue block27;
                    }
                    case FORMAT_WEEKYEAR_SHORT: {
                        long v = this.readDigits(2);
                        if (!StringParser.validRange(v, 0, 99)) {
                            this.fail = true;
                        }
                        this.bag.cWYear = v;
                        if (FormatBag.has(this.bag.cent)) continue block27;
                        this.bag.cent = v >= 69L ? 19L : 20L;
                        continue block27;
                    }
                    case FORMAT_HOUR: 
                    case FORMAT_HOUR_BLANK: {
                        long hour2;
                        if (StringParser.isBlank(this.text, this.pos)) {
                            ++this.pos;
                            hour2 = this.readDigits(1);
                        } else {
                            hour2 = this.readDigits(2);
                        }
                        if (!StringParser.validRange(hour2, 0, 24)) {
                            this.fail = true;
                        }
                        this.bag.hour = (int)hour2;
                        continue block27;
                    }
                    case FORMAT_HOUR_M: 
                    case FORMAT_HOUR_S: {
                        long hour3;
                        if (StringParser.isBlank(this.text, this.pos)) {
                            ++this.pos;
                            hour3 = this.readDigits(1);
                        } else {
                            hour3 = this.readDigits(2);
                        }
                        if (!StringParser.validRange(hour3, 1, 12)) {
                            this.fail = true;
                        }
                        this.bag.hour = (int)hour3;
                        continue block27;
                    }
                    case FORMAT_DAY_YEAR: {
                        long day = this.readDigits(3);
                        if (!StringParser.validRange(day, 1, 365)) {
                            this.fail = true;
                        }
                        this.bag.yDay = (int)day;
                        continue block27;
                    }
                    case FORMAT_MILLISEC: 
                    case FORMAT_NANOSEC: {
                        boolean negative = false;
                        if (StringParser.isSign(this.text, this.pos)) {
                            negative = this.text.charAt(this.pos) == '-';
                        }
                        int initPos = ++this.pos;
                        Number v = StringParser.isNumberPattern(compiledPattern, tokenIndex) ? (token.getFormat() == StrptimeFormat.FORMAT_MILLISEC ? BigInteger.valueOf(this.readDigits(3)) : BigInteger.valueOf(this.readDigits(9))) : this.readDigitsMax();
                        this.bag.secFraction = !negative ? (Number)v : (Number)StringParser.negateInteger(v);
                        this.bag.secFractionSize = this.pos - initPos;
                        continue block27;
                    }
                    case FORMAT_MINUTES: {
                        long min2 = this.readDigits(2);
                        if (!StringParser.validRange(min2, 0, 59)) {
                            this.fail = true;
                        }
                        this.bag.min = (int)min2;
                        continue block27;
                    }
                    case FORMAT_MONTH: {
                        long mon2 = this.readDigits(2);
                        if (!StringParser.validRange(mon2, 1, 12)) {
                            this.fail = true;
                        }
                        this.bag.mon = (int)mon2;
                        continue block27;
                    }
                    case FORMAT_MERIDIAN: 
                    case FORMAT_MERIDIAN_LOWER_CASE: {
                        int meridIndex = this.findIndexInPatterns(MERID_NAMES);
                        if (meridIndex >= 0) {
                            this.bag.merid = meridIndex % 2 == 0 ? 0 : 12;
                            this.pos += MERID_NAMES[meridIndex].length();
                            continue block27;
                        }
                        this.fail = true;
                        continue block27;
                    }
                    case FORMAT_MICROSEC_EPOCH: {
                        boolean negative = false;
                        if (StringParser.isMinus(this.text, this.pos)) {
                            negative = true;
                            ++this.pos;
                        }
                        Number sec2 = this.readDigitsMax();
                        this.bag.seconds = !negative ? (Number)sec2 : (Number)StringParser.negateInteger(sec2);
                        this.bag.secondsSize = 3;
                        continue block27;
                    }
                    case FORMAT_SECONDS: {
                        long sec3 = this.readDigits(2);
                        if (!StringParser.validRange(sec3, 0, 60)) {
                            this.fail = true;
                        }
                        this.bag.sec = (int)sec3;
                        continue block27;
                    }
                    case FORMAT_EPOCH: {
                        boolean negative = false;
                        if (StringParser.isMinus(this.text, this.pos)) {
                            negative = true;
                            ++this.pos;
                        }
                        Number sec4 = this.readDigitsMax();
                        this.bag.seconds = !negative ? (Number)sec4 : (Number)StringParser.negateInteger(sec4);
                        continue block27;
                    }
                    case FORMAT_WEEK_YEAR_S: 
                    case FORMAT_WEEK_YEAR_M: {
                        long week = this.readDigits(2);
                        if (!StringParser.validRange(week, 0, 53)) {
                            this.fail = true;
                        }
                        if (token.getFormat() == StrptimeFormat.FORMAT_WEEK_YEAR_S) {
                            this.bag.wNum0 = (int)week;
                            continue block27;
                        }
                        this.bag.wNum1 = (int)week;
                        continue block27;
                    }
                    case FORMAT_DAY_WEEK2: {
                        long day = this.readDigits(1);
                        if (!StringParser.validRange(day, 1, 7)) {
                            this.fail = true;
                        }
                        this.bag.cWDay = (int)day;
                        continue block27;
                    }
                    case FORMAT_WEEK_WEEKYEAR: {
                        long week = this.readDigits(2);
                        if (!StringParser.validRange(week, 1, 53)) {
                            this.fail = true;
                        }
                        this.bag.cWeek = (int)week;
                        continue block27;
                    }
                    case FORMAT_DAY_WEEK: {
                        long day = this.readDigits(1);
                        if (!StringParser.validRange(day, 0, 6)) {
                            this.fail = true;
                        }
                        this.bag.wDay = (int)day;
                        continue block27;
                    }
                    case FORMAT_YEAR_LONG: {
                        boolean negative = false;
                        if (StringParser.isSign(this.text, this.pos)) {
                            negative = this.text.charAt(this.pos) == '-';
                            ++this.pos;
                        }
                        long year2 = StringParser.isNumberPattern(compiledPattern, tokenIndex) ? this.readDigits(4) : this.readDigitsMaxLong();
                        this.bag.year = !negative ? year2 : -1L * year2;
                        continue block27;
                    }
                    case FORMAT_YEAR_SHORT: {
                        long year3 = this.readDigits(2);
                        if (!StringParser.validRange(year3, 0, 99)) {
                            this.fail = true;
                        }
                        this.bag.year = year3;
                        if (FormatBag.has(this.bag.cent)) continue block27;
                        this.bag.cent = year3 >= 69L ? 19L : 20L;
                        continue block27;
                    }
                    case FORMAT_ZONE_ID: 
                    case FORMAT_COLON_ZONE_OFF: {
                        if (StringParser.isEndOfText(this.text, this.pos)) {
                            this.fail = true;
                            continue block27;
                        }
                        Matcher m = ZONE_PARSE_REGEX.matcher(this.text.substring(this.pos));
                        if (m.find()) {
                            String zone2 = this.text.substring(this.pos, this.pos + m.end());
                            this.bag.zone = zone2;
                            this.pos += zone2.length();
                            continue block27;
                        }
                        this.fail = true;
                        continue block27;
                    }
                    case FORMAT_SPECIAL: {
                        throw new Error("FORMAT_SPECIAL is a special token only for the lexer.");
                    }
                }
            }
            if (this.fail) {
                return null;
            }
            if (this.text.length() > this.pos) {
                this.bag.leftover = this.text.substring(this.pos, this.text.length());
            }
            return this.bag;
        }

        private long readDigits(int len) {
            char c;
            long v = 0L;
            int initPos = this.pos;
            for (int i2 = 0; i2 < len && !StringParser.isEndOfText(this.text, this.pos) && StringParser.isDigit(c = this.text.charAt(this.pos)); ++i2) {
                v = v * 10L + (long)StringParser.toInt(c);
                ++this.pos;
            }
            if (this.pos == initPos) {
                this.fail = true;
            }
            return v;
        }

        private Number readDigitsMax() {
            char c;
            long v = 0L;
            Number vBig = null;
            int initPos = this.pos;
            while (!StringParser.isEndOfText(this.text, this.pos) && StringParser.isDigit(c = this.text.charAt(this.pos))) {
                block5: {
                    if (vBig == null) {
                        try {
                            long tmp = Math.multiplyExact(v, 10L);
                            v = tmp = Math.addExact(tmp, (long)StringParser.toInt(c));
                            break block5;
                        }
                        catch (ArithmeticException overflow) {
                            vBig = BigInteger.valueOf(v);
                            continue;
                        }
                    }
                    vBig = ((BigInteger)vBig).multiply(BigInteger.TEN);
                    vBig = ((BigInteger)vBig).add(BigInteger.valueOf(StringParser.toInt(c)));
                }
                ++this.pos;
            }
            if (this.pos == initPos) {
                this.fail = true;
            }
            return vBig == null ? Long.valueOf(v) : vBig;
        }

        private long readDigitsMaxLong() {
            char c;
            long v = 0L;
            int initPos = this.pos;
            while (!StringParser.isEndOfText(this.text, this.pos) && StringParser.isDigit(c = this.text.charAt(this.pos))) {
                v = v * 10L + (long)StringParser.toInt(c);
                ++this.pos;
            }
            if (this.pos == initPos) {
                this.fail = true;
            }
            return v;
        }

        private int findIndexInPatterns(String[] patterns) {
            if (StringParser.isEndOfText(this.text, this.pos)) {
                return -1;
            }
            for (int i2 = 0; i2 < patterns.length; ++i2) {
                String pattern = patterns[i2];
                int len = pattern.length();
                if (StringParser.isEndOfText(this.text, this.pos + len - 1) || !pattern.equalsIgnoreCase(this.text.substring(this.pos, this.pos + len))) continue;
                return i2;
            }
            return -1;
        }

        private static boolean isNumberPattern(List<StrptimeToken> compiledPattern, int i2) {
            if (compiledPattern.size() <= i2 + 1) {
                return false;
            }
            StrptimeToken nextToken = compiledPattern.get(i2 + 1);
            StrptimeFormat f = nextToken.getFormat();
            if (f == StrptimeFormat.FORMAT_STRING && StringParser.isDigit(((String)nextToken.getData()).charAt(0))) {
                return true;
            }
            return NUMBER_PATTERNS.contains((Object)f);
        }

        private static boolean validRange(long v, int lower, int upper) {
            return (long)lower <= v && v <= (long)upper;
        }

        private static boolean isSpace(char c) {
            return c == ' ' || c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r';
        }

        private static boolean isDigit(char c) {
            return '0' <= c && c <= '9';
        }

        private static boolean isEndOfText(String text, int pos2) {
            return pos2 >= text.length();
        }

        private static boolean isSign(String text, int pos2) {
            return !StringParser.isEndOfText(text, pos2) && (text.charAt(pos2) == '+' || text.charAt(pos2) == '-');
        }

        private static boolean isMinus(String text, int pos2) {
            return !StringParser.isEndOfText(text, pos2) && text.charAt(pos2) == '-';
        }

        private static boolean isBlank(String text, int pos2) {
            return !StringParser.isEndOfText(text, pos2) && text.charAt(pos2) == ' ';
        }

        private static int toInt(char c) {
            return c - 48;
        }

        private static Number negateInteger(Number i2) {
            if (i2 instanceof BigInteger) {
                return ((BigInteger)i2).negate();
            }
            return -i2.longValue();
        }
    }

    public static class FormatBag {
        private int mDay = Integer.MIN_VALUE;
        private int wDay = Integer.MIN_VALUE;
        private int cWDay = Integer.MIN_VALUE;
        private int yDay = Integer.MIN_VALUE;
        private int cWeek = Integer.MIN_VALUE;
        private long cWYear = Long.MIN_VALUE;
        private int min = Integer.MIN_VALUE;
        private int mon = Integer.MIN_VALUE;
        private int hour = Integer.MIN_VALUE;
        private long year = Long.MIN_VALUE;
        private int sec = Integer.MIN_VALUE;
        private int wNum0 = Integer.MIN_VALUE;
        private int wNum1 = Integer.MIN_VALUE;
        private String zone = null;
        private Number secFraction = null;
        private int secFractionSize = Integer.MIN_VALUE;
        private Number seconds = null;
        private int secondsSize = Integer.MIN_VALUE;
        private int merid = Integer.MIN_VALUE;
        private long cent = Long.MIN_VALUE;
        private String leftover = null;

        public int getMDay() {
            return this.mDay;
        }

        public int getWDay() {
            return this.wDay;
        }

        public int getCWDay() {
            return this.cWDay;
        }

        public int getYDay() {
            return this.yDay;
        }

        public int getCWeek() {
            return this.cWeek;
        }

        public long getCWYear() {
            return this.cWYear;
        }

        public int getMin() {
            return this.min;
        }

        public int getMon() {
            return this.mon;
        }

        public int getHour() {
            return this.hour;
        }

        public long getYear() {
            return this.year;
        }

        public int getSec() {
            return this.sec;
        }

        public int getWNum0() {
            return this.wNum0;
        }

        public int getWNum1() {
            return this.wNum1;
        }

        public String getZone() {
            return this.zone;
        }

        public Number getSecFraction() {
            return this.secFraction;
        }

        public int getSecFractionSize() {
            return this.secFractionSize;
        }

        public Number getSeconds() {
            return this.seconds;
        }

        public int getSecondsSize() {
            return this.secondsSize;
        }

        public int getMerid() {
            return this.merid;
        }

        public long getCent() {
            return this.cent;
        }

        public String getLeftover() {
            return this.leftover;
        }

        public static boolean has(int v) {
            return v != Integer.MIN_VALUE;
        }

        public static boolean has(long v) {
            return v != Long.MIN_VALUE;
        }

        public static boolean has(Number v) {
            return v != null;
        }
    }
}

