/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentWeakHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    private static final long serialVersionUID = 7249069246763182397L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final int segmentMask;
    final int segmentShift;
    final Segment<K, V>[] segments;
    transient Set<K> keySet;
    transient Set<Map.Entry<K, V>> entrySet;
    transient Collection<V> values;

    private static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    final Segment<K, V> segmentFor(int hash2) {
        return this.segments[hash2 >>> this.segmentShift & this.segmentMask];
    }

    public ConcurrentWeakHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        int cap;
        int c;
        int ssize;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (concurrencyLevel > 65536) {
            concurrencyLevel = 65536;
        }
        int sshift = 0;
        for (ssize = 1; ssize < concurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = Segment.newArray(ssize);
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c;
        }
        for (cap = 1; cap < c; cap <<= 1) {
        }
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2] = new Segment(cap, loadFactor);
        }
    }

    public ConcurrentWeakHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 16);
    }

    public ConcurrentWeakHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f, 16);
    }

    public ConcurrentWeakHashMap() {
        this(16, 0.75f, 16);
    }

    public ConcurrentWeakHashMap(Map<? extends K, ? extends V> m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 16), 0.75f, 16);
        this.putAll(m);
    }

    @Override
    public boolean isEmpty() {
        int i2;
        Segment<K, V>[] segments = this.segments;
        int[] mc = new int[segments.length];
        int mcsum = 0;
        for (i2 = 0; i2 < segments.length; ++i2) {
            if (segments[i2].count != 0) {
                return false;
            }
            mc[i2] = segments[i2].modCount;
            mcsum += mc[i2];
        }
        if (mcsum != 0) {
            for (i2 = 0; i2 < segments.length; ++i2) {
                if (segments[i2].count == 0 && mc[i2] == segments[i2].modCount) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int size() {
        Segment<K, V>[] segments = this.segments;
        long sum2 = 0L;
        long check2 = 0L;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            int i2;
            check2 = 0L;
            sum2 = 0L;
            int mcsum = 0;
            for (i2 = 0; i2 < segments.length; ++i2) {
                sum2 += (long)segments[i2].count;
                mc[i2] = segments[i2].modCount;
                mcsum += mc[i2];
            }
            if (mcsum != 0) {
                for (i2 = 0; i2 < segments.length; ++i2) {
                    check2 += (long)segments[i2].count;
                    if (mc[i2] == segments[i2].modCount) continue;
                    check2 = -1L;
                    break;
                }
            }
            if (check2 == sum2) break;
        }
        if (check2 != sum2) {
            int i3;
            sum2 = 0L;
            for (i3 = 0; i3 < segments.length; ++i3) {
                segments[i3].lock();
            }
            for (i3 = 0; i3 < segments.length; ++i3) {
                sum2 += (long)segments[i3].count;
            }
            for (i3 = 0; i3 < segments.length; ++i3) {
                segments[i3].unlock();
            }
        }
        if (sum2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum2;
    }

    @Override
    public V get(Object key2) {
        int hash2 = ConcurrentWeakHashMap.hash(key2.hashCode());
        return this.segmentFor(hash2).get(key2, hash2);
    }

    @Override
    public boolean containsKey(Object key2) {
        int hash2 = ConcurrentWeakHashMap.hash(key2.hashCode());
        return this.segmentFor(hash2).containsKey(key2, hash2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value2) {
        int i2;
        if (value2 == null) {
            throw new NullPointerException();
        }
        Segment<K, V>[] segments = this.segments;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            boolean sum2 = false;
            int mcsum = 0;
            for (int i3 = 0; i3 < segments.length; ++i3) {
                int c = segments[i3].count;
                mc[i3] = segments[i3].modCount;
                mcsum += mc[i3];
                if (!segments[i3].containsValue(value2)) continue;
                return true;
            }
            boolean cleanSweep = true;
            if (mcsum != 0) {
                for (int i4 = 0; i4 < segments.length; ++i4) {
                    int c = segments[i4].count;
                    if (mc[i4] == segments[i4].modCount) continue;
                    cleanSweep = false;
                    break;
                }
            }
            if (!cleanSweep) continue;
            return false;
        }
        for (int i5 = 0; i5 < segments.length; ++i5) {
            segments[i5].lock();
        }
        boolean found = false;
        try {
            for (i2 = 0; i2 < segments.length; ++i2) {
                if (!segments[i2].containsValue(value2)) continue;
                found = true;
                break;
            }
        }
        finally {
            for (i2 = 0; i2 < segments.length; ++i2) {
                segments[i2].unlock();
            }
        }
        return found;
    }

    public boolean contains(Object value2) {
        return this.containsValue(value2);
    }

    @Override
    public V put(K key2, V value2) {
        if (value2 == null) {
            throw new NullPointerException();
        }
        int hash2 = ConcurrentWeakHashMap.hash(key2.hashCode());
        return this.segmentFor(hash2).put(key2, hash2, value2, false);
    }

    @Override
    public V putIfAbsent(K key2, V value2) {
        if (value2 == null) {
            throw new NullPointerException();
        }
        int hash2 = ConcurrentWeakHashMap.hash(key2.hashCode());
        return this.segmentFor(hash2).put(key2, hash2, value2, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key2) {
        int hash2 = ConcurrentWeakHashMap.hash(key2.hashCode());
        return this.segmentFor(hash2).remove(key2, hash2, null, false);
    }

    @Override
    public boolean remove(Object key2, Object value2) {
        int hash2 = ConcurrentWeakHashMap.hash(key2.hashCode());
        if (value2 == null) {
            return false;
        }
        return this.segmentFor(hash2).remove(key2, hash2, value2, false) != null;
    }

    @Override
    public boolean replace(K key2, V oldValue, V newValue) {
        if (oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        int hash2 = ConcurrentWeakHashMap.hash(key2.hashCode());
        return this.segmentFor(hash2).replace(key2, hash2, oldValue, newValue);
    }

    @Override
    public V replace(K key2, V value2) {
        if (value2 == null) {
            throw new NullPointerException();
        }
        int hash2 = ConcurrentWeakHashMap.hash(key2.hashCode());
        return this.segmentFor(hash2).replace(key2, hash2, value2);
    }

    @Override
    public void clear() {
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2].clear();
        }
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    public Enumeration<K> keys() {
        return new KeyIterator();
    }

    public Enumeration<V> elements() {
        return new ValueIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        for (int k = 0; k < this.segments.length; ++k) {
            Segment<K, V> seg = this.segments[k];
            seg.lock();
            try {
                HashEntry<K, V>[] tab = seg.table;
                for (int i2 = 0; i2 < tab.length; ++i2) {
                    HashEntry e = tab[i2];
                    while (e != null) {
                        Object key2 = e.keyRef.get();
                        if (key2 != null) {
                            s2.writeObject(key2);
                            s2.writeObject(e.value);
                        }
                        e = e.next;
                    }
                }
                continue;
            }
            finally {
                seg.unlock();
            }
        }
        s2.writeObject(null);
        s2.writeObject(null);
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2].setTable(new HashEntry[1]);
        }
        while (true) {
            Object key2 = s2.readObject();
            Object value2 = s2.readObject();
            if (key2 == null) break;
            this.put(key2, value2);
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object v = ConcurrentWeakHashMap.this.get(e.getKey());
            return v != null && v.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ConcurrentWeakHashMap.this.remove(e.getKey(), e.getValue());
        }

        @Override
        public int size() {
            return ConcurrentWeakHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentWeakHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            ConcurrentWeakHashMap.this.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return ConcurrentWeakHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentWeakHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentWeakHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            ConcurrentWeakHashMap.this.clear();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return ConcurrentWeakHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentWeakHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentWeakHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return ConcurrentWeakHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            ConcurrentWeakHashMap.this.clear();
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            HashEntry e = super.nextEntry();
            return new WriteThroughEntry(e.keyRef.get(), e.value);
        }
    }

    final class WriteThroughEntry
    extends SimpleEntry<K, V> {
        private static final long serialVersionUID = -7900634345345313646L;

        WriteThroughEntry(K k, V v) {
            super(k, v);
        }

        @Override
        public V setValue(V value2) {
            if (value2 == null) {
                throw new NullPointerException();
            }
            Object v = super.setValue(value2);
            ConcurrentWeakHashMap.this.put(this.getKey(), value2);
            return v;
        }
    }

    static class SimpleEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = -8499721149061103585L;
        private final K key;
        private V value;

        public SimpleEntry(K key2, V value2) {
            this.key = key2;
            this.value = value2;
        }

        public SimpleEntry(Map.Entry<? extends K, ? extends V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value2) {
            V oldValue = this.value;
            this.value = value2;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return SimpleEntry.eq(this.key, e.getKey()) && SimpleEntry.eq(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator<V>,
    Enumeration<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return super.nextEntry().value;
        }

        @Override
        public V nextElement() {
            return super.nextEntry().value;
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator<K>,
    Enumeration<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            return super.nextEntry().keyRef.get();
        }

        @Override
        public K nextElement() {
            return super.nextEntry().keyRef.get();
        }
    }

    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        HashEntry<K, V>[] currentTable;
        HashEntry<K, V> nextEntry;
        HashEntry<K, V> lastReturned;
        K currentKey;

        HashIterator() {
            this.nextSegmentIndex = ConcurrentWeakHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment seg = ConcurrentWeakHashMap.this.segments[this.nextSegmentIndex--];
                if (seg.count == 0) continue;
                this.currentTable = seg.table;
                for (int j = this.currentTable.length - 1; j >= 0; --j) {
                    this.nextEntry = this.currentTable[j];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = j - 1;
                    return;
                }
            }
        }

        public boolean hasNext() {
            while (this.nextEntry != null) {
                if (this.nextEntry.keyRef.get() != null) {
                    return true;
                }
                this.advance();
            }
            return false;
        }

        HashEntry<K, V> nextEntry() {
            do {
                if (this.nextEntry == null) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.nextEntry;
                this.currentKey = this.lastReturned.keyRef.get();
                this.advance();
            } while (this.currentKey == null);
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentWeakHashMap.this.remove(this.currentKey);
            this.lastReturned = null;
        }
    }

    static final class Segment<K, V>
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        volatile transient int count;
        transient int modCount;
        transient int threshold;
        volatile transient HashEntry<K, V>[] table;
        final float loadFactor;
        volatile transient ReferenceQueue<K> refQueue;

        Segment(int initialCapacity, float lf) {
            this.loadFactor = lf;
            this.setTable(HashEntry.newArray(initialCapacity));
        }

        static final <K, V> Segment<K, V>[] newArray(int i2) {
            return new Segment[i2];
        }

        void setTable(HashEntry<K, V>[] newTable) {
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            this.table = newTable;
            this.refQueue = new ReferenceQueue();
        }

        HashEntry<K, V> getFirst(int hash2) {
            HashEntry<K, V>[] tab = this.table;
            return tab[hash2 & tab.length - 1];
        }

        V readValueUnderLock(HashEntry<K, V> e) {
            this.lock();
            try {
                this.removeStale();
                Object v = e.value;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        V get(Object key2, int hash2) {
            if (this.count != 0) {
                HashEntry<K, V> e = this.getFirst(hash2);
                while (e != null) {
                    if (e.hash == hash2 && key2.equals(e.keyRef.get())) {
                        Object v = e.value;
                        if (v != null) {
                            return v;
                        }
                        return this.readValueUnderLock(e);
                    }
                    e = e.next;
                }
            }
            return null;
        }

        boolean containsKey(Object key2, int hash2) {
            if (this.count != 0) {
                HashEntry<K, V> e = this.getFirst(hash2);
                while (e != null) {
                    if (e.hash == hash2 && key2.equals(e.keyRef.get())) {
                        return true;
                    }
                    e = e.next;
                }
            }
            return false;
        }

        boolean containsValue(Object value2) {
            if (this.count != 0) {
                for (HashEntry<K, V> e : this.table) {
                    while (e != null) {
                        Object v = e.value;
                        if (v == null) {
                            v = this.readValueUnderLock(e);
                        }
                        if (value2.equals(v)) {
                            return true;
                        }
                        e = e.next;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(K key2, int hash2, V oldValue, V newValue) {
            this.lock();
            try {
                this.removeStale();
                HashEntry<K, V> e = this.getFirst(hash2);
                while (!(e == null || e.hash == hash2 && key2.equals(e.keyRef.get()))) {
                    e = e.next;
                }
                boolean replaced = false;
                if (e != null && oldValue.equals(e.value)) {
                    replaced = true;
                    e.value = newValue;
                }
                boolean bl = replaced;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(K key2, int hash2, V newValue) {
            this.lock();
            try {
                this.removeStale();
                HashEntry<K, V> e = this.getFirst(hash2);
                while (!(e == null || e.hash == hash2 && key2.equals(e.keyRef.get()))) {
                    e = e.next;
                }
                V oldValue = null;
                if (e != null) {
                    oldValue = e.value;
                    e.value = newValue;
                }
                V v = oldValue;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(K key2, int hash2, V value2, boolean onlyIfAbsent) {
            this.lock();
            try {
                V oldValue;
                HashEntry<K, V> first2;
                int reduced;
                this.removeStale();
                int c = this.count;
                if (c++ > this.threshold && (reduced = this.rehash()) > 0) {
                    this.count = (c -= reduced) - 1;
                }
                HashEntry<K, V>[] tab = this.table;
                int index2 = hash2 & tab.length - 1;
                HashEntry<K, V> e = first2 = tab[index2];
                while (!(e == null || e.hash == hash2 && key2.equals(e.keyRef.get()))) {
                    e = e.next;
                }
                if (e != null) {
                    oldValue = e.value;
                    if (!onlyIfAbsent) {
                        e.value = value2;
                    }
                } else {
                    oldValue = null;
                    ++this.modCount;
                    tab[index2] = new HashEntry<K, V>(key2, hash2, first2, value2, this.refQueue);
                    this.count = c;
                }
                V v = oldValue;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        int rehash() {
            HashEntry<K, V>[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return 0;
            }
            HashEntry<K, V>[] newTable = HashEntry.newArray(oldCapacity << 1);
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            int sizeMask = newTable.length - 1;
            int reduce = 0;
            for (int i2 = 0; i2 < oldCapacity; ++i2) {
                HashEntry<K, V> e = oldTable[i2];
                if (e == null) continue;
                HashEntry next2 = e.next;
                int idx = e.hash & sizeMask;
                if (next2 == null) {
                    newTable[idx] = e;
                    continue;
                }
                HashEntry<K, V> lastRun = e;
                int lastIdx = idx;
                HashEntry last2 = next2;
                while (last2 != null) {
                    int k = last2.hash & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last2;
                    }
                    last2 = last2.next;
                }
                newTable[lastIdx] = lastRun;
                HashEntry<K, V> p2 = e;
                while (p2 != lastRun) {
                    Object key2 = p2.keyRef.get();
                    if (key2 == null) {
                        ++reduce;
                    } else {
                        int k = p2.hash & sizeMask;
                        HashEntry n = newTable[k];
                        newTable[k] = new HashEntry(key2, p2.hash, n, p2.value, this.refQueue);
                    }
                    p2 = p2.next;
                }
            }
            this.table = newTable;
            return reduce;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(Object key2, int hash2, Object value2, boolean weakRemove) {
            this.lock();
            try {
                HashEntry<K, V> first2;
                if (!weakRemove) {
                    this.removeStale();
                }
                int c = this.count - 1;
                HashEntry<K, V>[] tab = this.table;
                int index2 = hash2 & tab.length - 1;
                HashEntry<K, V> e = first2 = tab[index2];
                while (!(e == null || weakRemove && key2 == e.keyRef || e.hash == hash2 && key2.equals(e.keyRef.get()))) {
                    e = e.next;
                }
                V oldValue = null;
                if (e != null) {
                    Object v = e.value;
                    if (value2 == null || value2.equals(v)) {
                        oldValue = v;
                        ++this.modCount;
                        HashEntry newFirst = e.next;
                        HashEntry<K, V> p2 = first2;
                        while (p2 != e) {
                            Object pKey = p2.keyRef.get();
                            if (pKey == null) {
                                --c;
                            } else {
                                newFirst = new HashEntry(pKey, p2.hash, newFirst, p2.value, this.refQueue);
                            }
                            p2 = p2.next;
                        }
                        tab[index2] = newFirst;
                        this.count = c;
                    }
                }
                V v = oldValue;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        void removeStale() {
            WeakKeyReference ref;
            while ((ref = (WeakKeyReference)this.refQueue.poll()) != null) {
                this.remove(ref, ref.hash, null, true);
            }
        }

        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    HashEntry<K, V>[] tab = this.table;
                    for (int i2 = 0; i2 < tab.length; ++i2) {
                        tab[i2] = null;
                    }
                    ++this.modCount;
                    this.refQueue = new ReferenceQueue();
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }
    }

    static final class HashEntry<K, V> {
        final WeakReference<K> keyRef;
        final int hash;
        volatile V value;
        final HashEntry<K, V> next;

        HashEntry(K key2, int hash2, HashEntry<K, V> next2, V value2, ReferenceQueue<K> refQueue) {
            this.keyRef = new WeakKeyReference<K>(key2, hash2, refQueue);
            this.hash = hash2;
            this.next = next2;
            this.value = value2;
        }

        static final <K, V> HashEntry<K, V>[] newArray(int i2) {
            return new HashEntry[i2];
        }
    }

    static final class WeakKeyReference<K>
    extends WeakReference<K> {
        final int hash;

        WeakKeyReference(K key2, int hash2, ReferenceQueue<K> refQueue) {
            super(key2, refQueue);
            this.hash = hash2;
        }
    }
}

