/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.crypto.tls;

import java.io.IOException;
import org.python.bouncycastle.crypto.tls.AbstractTlsClient;
import org.python.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import org.python.bouncycastle.crypto.tls.DefaultTlsDHVerifier;
import org.python.bouncycastle.crypto.tls.TlsCipherFactory;
import org.python.bouncycastle.crypto.tls.TlsDHEKeyExchange;
import org.python.bouncycastle.crypto.tls.TlsDHKeyExchange;
import org.python.bouncycastle.crypto.tls.TlsDHVerifier;
import org.python.bouncycastle.crypto.tls.TlsECDHEKeyExchange;
import org.python.bouncycastle.crypto.tls.TlsECDHKeyExchange;
import org.python.bouncycastle.crypto.tls.TlsFatalAlert;
import org.python.bouncycastle.crypto.tls.TlsKeyExchange;
import org.python.bouncycastle.crypto.tls.TlsRSAKeyExchange;
import org.python.bouncycastle.crypto.tls.TlsUtils;

public abstract class DefaultTlsClient
extends AbstractTlsClient {
    protected TlsDHVerifier dhVerifier;

    public DefaultTlsClient() {
        this(new DefaultTlsCipherFactory());
    }

    public DefaultTlsClient(TlsCipherFactory tlsCipherFactory) {
        this(tlsCipherFactory, new DefaultTlsDHVerifier());
    }

    public DefaultTlsClient(TlsCipherFactory tlsCipherFactory, TlsDHVerifier tlsDHVerifier) {
        super(tlsCipherFactory);
        this.dhVerifier = tlsDHVerifier;
    }

    public int[] getCipherSuites() {
        return new int[]{49195, 49187, 49161, 49199, 49191, 49171, 156, 60, 47};
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        int n = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n) {
            case 7: 
            case 9: 
            case 11: {
                return this.createDHKeyExchange(n);
            }
            case 3: 
            case 5: {
                return this.createDHEKeyExchange(n);
            }
            case 16: 
            case 18: 
            case 20: {
                return this.createECDHKeyExchange(n);
            }
            case 17: 
            case 19: {
                return this.createECDHEKeyExchange(n);
            }
            case 1: {
                return this.createRSAKeyExchange();
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createDHKeyExchange(int n) {
        return new TlsDHKeyExchange(n, this.supportedSignatureAlgorithms, this.dhVerifier, null);
    }

    protected TlsKeyExchange createDHEKeyExchange(int n) {
        return new TlsDHEKeyExchange(n, this.supportedSignatureAlgorithms, this.dhVerifier, null);
    }

    protected TlsKeyExchange createECDHKeyExchange(int n) {
        return new TlsECDHKeyExchange(n, this.supportedSignatureAlgorithms, this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }

    protected TlsKeyExchange createECDHEKeyExchange(int n) {
        return new TlsECDHEKeyExchange(n, this.supportedSignatureAlgorithms, this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }

    protected TlsKeyExchange createRSAKeyExchange() {
        return new TlsRSAKeyExchange(this.supportedSignatureAlgorithms);
    }
}

