"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const experimental_utils_1 = require("@typescript-eslint/experimental-utils");
const util = __importStar(require("../util"));
exports.default = util.createRule({
    name: 'ban-ts-ignore',
    meta: {
        type: 'problem',
        docs: {
            description: 'Bans “// @ts-ignore” comments from being used',
            category: 'Best Practices',
            recommended: 'error',
        },
        schema: [],
        messages: {
            tsIgnoreComment: 'Do not use "// @ts-ignore" comments because they suppress compilation errors.',
        },
        deprecated: true,
        replacedBy: ['ban-ts-comment'],
    },
    defaultOptions: [],
    create(context) {
        const tsIgnoreRegExp = /^\/*\s*@ts-ignore/;
        const sourceCode = context.getSourceCode();
        return {
            Program() {
                const comments = sourceCode.getAllComments();
                comments.forEach(comment => {
                    if (comment.type !== experimental_utils_1.AST_TOKEN_TYPES.Line) {
                        return;
                    }
                    if (tsIgnoreRegExp.test(comment.value)) {
                        context.report({
                            node: comment,
                            messageId: 'tsIgnoreComment',
                        });
                    }
                });
            },
        };
    },
});
//# sourceMappingURL=ban-ts-ignore.js.map