/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus;

import java.util.ArrayList;
import java.util.List;
import net.osmand.GeoidAltitudeCorrection;
import net.osmand.Location;
import net.osmand.ResultMatcher;
import net.osmand.binary.GeocodingUtilities;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.QuadPoint;
import net.osmand.plus.CurrentPositionHelper;
import net.osmand.plus.OsmandSettings;
import net.osmand.plus.TargetPointsHelper;
import net.osmand.router.RouteSegmentResult;
import net.osmand.util.MapUtils;
import net.sourceforge.offroad.OsmWindow;

public class OsmAndLocationProvider {
    public static final int REQUEST_LOCATION_PERMISSION = 100;
    private static final String SIMULATED_PROVIDER = "OsmAnd";
    private static final int INTERVAL_TO_CLEAR_SET_LOCATION = 30000;
    private static final int LOST_LOCATION_MSG_ID = 5001;
    private static final int START_SIMULATE_LOCATION_MSG_ID = 5002;
    private static final int RUN_SIMULATE_LOCATION_MSG_ID = 5003;
    private static final long LOST_LOCATION_CHECK_DELAY = 18000L;
    private static final long START_LOCATION_SIMULATION_DELAY = 2000L;
    private static final float ACCURACY_FOR_GPX_AND_ROUTING = 50.0f;
    private static final int GPS_TIMEOUT_REQUEST = 0;
    private static final int GPS_DIST_REQUEST = 0;
    private static final int NOT_SWITCH_TO_NETWORK_WHEN_GPS_LOST_MS = 12000;
    private long lastTimeGPSLocationFixed = 0L;
    private boolean gpsSignalLost;
    private SimulationProvider simulatePosition = null;
    private boolean sensorRegistered = false;
    private float[] mGravs = new float[3];
    private float[] mGeoMags = new float[3];
    private float previousCorrectionValue = 360.0f;
    private static final boolean USE_KALMAN_FILTER = true;
    private static final float KALMAN_COEFFICIENT = 0.04f;
    float avgValSin = 0.0f;
    float avgValCos = 0.0f;
    float lastValSin = 0.0f;
    float lastValCos = 0.0f;
    private float[] previousCompassValuesA = new float[50];
    private float[] previousCompassValuesB = new float[50];
    private int previousCompassIndA = 0;
    private int previousCompassIndB = 0;
    private boolean inUpdateValue = false;
    private Float heading = null;
    private int currentScreenOrientation;
    private OsmWindow app;
    private OsmandSettings settings;
    private CurrentPositionHelper currentPositionHelper;
    private Location location = null;
    private GPSInfo gpsInfo = new GPSInfo();
    private List<OsmAndLocationListener> locationListeners = new ArrayList<OsmAndLocationListener>();
    private List<OsmAndCompassListener> compassListeners = new ArrayList<OsmAndCompassListener>();
    private float[] mRotationM = new float[9];
    private OsmandSettings.OsmandPreference<Boolean> USE_MAGNETIC_FIELD_SENSOR_COMPASS;
    private OsmandSettings.OsmandPreference<Boolean> USE_FILTER_FOR_COMPASS;
    private static final long AGPS_TO_REDOWNLOAD = 57600000L;

    public OsmAndLocationProvider(OsmWindow app) {
        this.app = app;
        this.settings = app.getSettings();
        this.USE_MAGNETIC_FIELD_SENSOR_COMPASS = this.settings.USE_MAGNETIC_FIELD_SENSOR_COMPASS;
        this.USE_FILTER_FOR_COMPASS = this.settings.USE_KALMAN_FILTER_FOR_COMPASS;
        this.currentPositionHelper = new CurrentPositionHelper(app);
    }

    public void resumeAllUpdates() {
    }

    public void redownloadAGPS() {
    }

    public GPSInfo getGPSInfo() {
        return this.gpsInfo;
    }

    public void updateScreenOrientation(int orientation) {
        this.currentScreenOrientation = orientation;
    }

    public void addLocationListener(OsmAndLocationListener listener) {
        if (!this.locationListeners.contains(listener)) {
            this.locationListeners.add(listener);
        }
    }

    public void removeLocationListener(OsmAndLocationListener listener) {
        this.locationListeners.remove(listener);
    }

    public void addCompassListener(OsmAndCompassListener listener) {
        if (!this.compassListeners.contains(listener)) {
            this.compassListeners.add(listener);
        }
    }

    public void removeCompassListener(OsmAndCompassListener listener) {
        this.compassListeners.remove(listener);
    }

    public Location getFirstTimeRunDefaultLocation() {
        return null;
    }

    public void registerOrUnregisterCompassListener(boolean register) {
    }

    private void updateSpeedEmulator(Location location) {
        if (location != null && location.distanceTo(location) > 3.0f) {
            float d = location.distanceTo(location);
            long time = location.getTime() - location.getTime();
            float speed = time == 0L ? 0.0f : d * 1000.0f / (float)time;
            if (speed > 100.0f) {
                speed = 100.0f;
            }
            location.setSpeed(speed);
        }
    }

    public static boolean isPointAccurateForRouting(Location loc) {
        return loc != null && (!loc.hasAccuracy() || loc.getAccuracy() < 75.0f);
    }

    private boolean isRunningOnEmulator() {
        return false;
    }

    public Float getHeading() {
        return this.heading;
    }

    private float getAngle(float sinA, float cosA) {
        return MapUtils.unifyRotationTo360((float)(Math.atan2(sinA, cosA) * 180.0 / Math.PI));
    }

    private void updateLocation(Location loc) {
        for (OsmAndLocationListener l : this.locationListeners) {
            l.updateLocation(loc);
        }
    }

    public static Location convertLocation(Location l, OsmWindow app) {
        if (l == null) {
            return null;
        }
        Location r = new Location(l.getProvider());
        r.setLatitude(l.getLatitude());
        r.setLongitude(l.getLongitude());
        r.setTime(l.getTime());
        if (l.hasAccuracy()) {
            r.setAccuracy(l.getAccuracy());
        }
        if (l.hasSpeed()) {
            r.setSpeed(l.getSpeed());
        }
        if (l.hasAltitude()) {
            r.setAltitude(l.getAltitude());
        }
        if (l.hasBearing()) {
            r.setBearing(l.getBearing());
        }
        if (l.hasAltitude() && app != null) {
            double alt = l.getAltitude();
            GeoidAltitudeCorrection geo = app.getResourceManager().getGeoidAltitudeCorrection();
            if (geo != null) {
                r.setAltitude(alt -= (double)geo.getGeoidHeight(l.getLatitude(), l.getLongitude()));
            }
        }
        return r;
    }

    public RouteDataObject getLastKnownRouteSegment() {
        return this.currentPositionHelper.getLastKnownRouteSegment(this.getLastKnownLocation());
    }

    public boolean getRouteSegment(Location loc, ResultMatcher<RouteDataObject> result) {
        return this.currentPositionHelper.getRouteSegment(loc, result);
    }

    public boolean getGeocodingResult(Location loc, ResultMatcher<GeocodingUtilities.GeocodingResult> result) {
        return this.currentPositionHelper.getGeocodingResult(loc, result);
    }

    public Location getLastKnownLocation() {
        return this.location;
    }

    public void showNavigationInfo(TargetPointsHelper.TargetPoint pointToNavigate, OsmWindow uiActivity) {
    }

    public static boolean isNotSimulatedLocation(Location l) {
        if (l != null) {
            return !SIMULATED_PROVIDER.equals(l.getProvider());
        }
        return true;
    }

    public boolean checkGPSEnabled(OsmWindow context) {
        return false;
    }

    public static boolean isLocationPermissionAvailable(OsmWindow context) {
        return false;
    }

    public static class GPSInfo {
        public int foundSatellites = 0;
        public int usedSatellites = 0;
        public boolean fixed = false;
    }

    public class SimulationProvider {
        private int currentRoad;
        private int currentSegment;
        private QuadPoint currentPoint;
        private Location startLocation;
        private List<RouteSegmentResult> roads;

        public void startSimulation(List<RouteSegmentResult> roads, Location currentLocation) {
            this.roads = roads;
            this.startLocation = new Location(currentLocation);
            long ms = System.currentTimeMillis();
            if (ms - this.startLocation.getTime() > 5000L || ms < this.startLocation.getTime()) {
                this.startLocation.setTime(ms);
            }
            this.currentRoad = -1;
            int px = MapUtils.get31TileNumberX(currentLocation.getLongitude());
            int py = MapUtils.get31TileNumberY(currentLocation.getLatitude());
            double dist = 1000.0;
            for (int i = 0; i < roads.size(); ++i) {
                RouteSegmentResult road = roads.get(i);
                boolean plus = road.getStartPointIndex() < road.getEndPointIndex();
                for (int j = road.getStartPointIndex() + 1; j <= road.getEndPointIndex(); j += plus ? 1 : -1) {
                    RouteDataObject obj = road.getObject();
                    QuadPoint proj = MapUtils.getProjectionPoint31(px, py, obj.getPoint31XTile(j - 1), obj.getPoint31YTile(j - 1), obj.getPoint31XTile(j), obj.getPoint31YTile(j));
                    double dd = MapUtils.squareRootDist31((int)proj.x, (int)proj.y, px, py);
                    if (!(dd < dist)) continue;
                    dist = dd;
                    this.currentRoad = i;
                    this.currentSegment = j;
                    this.currentPoint = proj;
                }
            }
        }

        private float proceedMeters(float meters, Location l) {
            for (int i = this.currentRoad; i < this.roads.size(); ++i) {
                int j;
                RouteSegmentResult road = this.roads.get(i);
                boolean firstRoad = i == this.currentRoad;
                boolean plus = road.getStartPointIndex() < road.getEndPointIndex();
                int n = j = firstRoad ? this.currentSegment : road.getStartPointIndex() + 1;
                while (j <= road.getEndPointIndex()) {
                    double dd;
                    boolean first;
                    RouteDataObject obj = road.getObject();
                    int st31x = obj.getPoint31XTile(j - 1);
                    int st31y = obj.getPoint31YTile(j - 1);
                    int end31x = obj.getPoint31XTile(j);
                    int end31y = obj.getPoint31YTile(j);
                    boolean last = i == this.roads.size() - 1 && j == road.getEndPointIndex();
                    boolean bl = first = firstRoad && j == this.currentSegment;
                    if (first) {
                        st31x = (int)this.currentPoint.x;
                        st31y = (int)this.currentPoint.y;
                    }
                    if (!((double)meters > (dd = MapUtils.measuredDist31(st31x, st31y, end31x, end31y))) || last) {
                        int prx = (int)((double)st31x + (double)(end31x - st31x) * ((double)meters / dd));
                        int pry = (int)((double)st31y + (double)(end31y - st31y) * ((double)meters / dd));
                        l.setLongitude(MapUtils.get31LongitudeX(prx));
                        l.setLatitude(MapUtils.get31LatitudeY(pry));
                        return (float)Math.max((double)meters - dd, 0.0);
                    }
                    meters = (float)((double)meters - dd);
                    j += plus ? 1 : -1;
                }
            }
            return -1.0f;
        }

        public Location getSimulatedLocation() {
            if (!this.isSimulatedDataAvailable()) {
                return null;
            }
            Location loc = new Location(OsmAndLocationProvider.SIMULATED_PROVIDER);
            loc.setSpeed(this.startLocation.getSpeed());
            loc.setAltitude(this.startLocation.getAltitude());
            loc.setTime(System.currentTimeMillis());
            float meters = this.startLocation.getSpeed() * (float)((System.currentTimeMillis() - this.startLocation.getTime()) / 1000L);
            float proc = this.proceedMeters(meters, loc);
            if (proc < 0.0f || proc >= 100.0f) {
                return null;
            }
            return loc;
        }

        public boolean isSimulatedDataAvailable() {
            return this.startLocation != null && this.startLocation.getSpeed() > 0.0f && this.currentRoad >= 0;
        }
    }

    public static interface OsmAndCompassListener {
        public void updateCompassValue(float var1);
    }

    public static interface OsmAndLocationListener {
        public void updateLocation(Location var1);
    }
}

