/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ColumnFilter;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.SQLServerException;

class IntColumnIdentityFilter
extends ColumnFilter {
    IntColumnIdentityFilter() {
    }

    private static String zeroOneToYesNo(int i) {
        return 0 == i ? "NO" : "YES";
    }

    @Override
    final Object apply(Object value, JDBCType asJDBCType) throws SQLServerException {
        if (value == null) {
            return value;
        }
        switch (asJDBCType) {
            case INTEGER: 
            case SMALLINT: {
                assert (value instanceof Number);
                return IntColumnIdentityFilter.zeroOneToYesNo(((Number)value).intValue());
            }
            case CHAR: 
            case VARCHAR: 
            case LONGVARCHAR: {
                assert (value instanceof String);
                return IntColumnIdentityFilter.zeroOneToYesNo(Integer.parseInt((String)value));
            }
        }
        DataTypes.throwConversionError("char", asJDBCType.toString());
        return value;
    }
}

