/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean;

import java.util.ArrayList;
import java.util.List;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.DataCodingFactory;
import org.jsmpp.bean.DataCodingFactory00xx;
import org.jsmpp.bean.DataCodingFactory1100;
import org.jsmpp.bean.DataCodingFactory1101;
import org.jsmpp.bean.DataCodingFactory1110;
import org.jsmpp.bean.DataCodingFactory1111;
import org.jsmpp.bean.GeneralDataCoding;
import org.jsmpp.bean.RawDataCoding;

public final class DataCodings {
    public static final byte MASK_CONTAIN_MESSAGE_CLASS = 16;
    private static final List<DataCodingFactory> factories = new ArrayList<DataCodingFactory>();
    public static final DataCoding ZERO;

    private DataCodings() {
        throw new InstantiationError("This class must not be instantiated");
    }

    public static DataCoding newInstance(byte dataCoding) {
        for (DataCodingFactory factory : factories) {
            if (!factory.isRecognized(dataCoding)) continue;
            return factory.newInstance(dataCoding);
        }
        return new RawDataCoding(dataCoding);
    }

    public static boolean containsMessageClass(byte dataCoding) {
        return (dataCoding & 0x10) == 16;
    }

    static {
        factories.add(new DataCodingFactory00xx());
        factories.add(new DataCodingFactory1100());
        factories.add(new DataCodingFactory1101());
        factories.add(new DataCodingFactory1110());
        factories.add(new DataCodingFactory1111());
        ZERO = new GeneralDataCoding();
    }
}

