/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.geom.AffineTransform;
import java.io.Serializable;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.SvgCharSizeHack;
import net.sourceforge.plantuml.TikzFontDistortion;
import net.sourceforge.plantuml.graphic.StringBounder;

public final class FileFormatOption
implements Serializable {
    private final FileFormat fileFormat;
    private final AffineTransform affineTransform;
    private boolean withMetadata;
    private final boolean useRedForError;
    private final String svgLinkTarget;
    private final String hoverColor;
    private final TikzFontDistortion tikzFontDistortion;
    private final double scale;
    private final String preserveAspectRatio;
    private final String watermark;
    private boolean debugsvek = false;

    public double getScaleCoef() {
        return this.scale;
    }

    public FileFormatOption(FileFormat fileFormat) {
        this(fileFormat, null, true, false, "_top", false, null, TikzFontDistortion.getDefault(), 1.0, "none", null);
    }

    public FileFormatOption(FileFormat fileFormat, boolean withMetadata) {
        this(fileFormat, null, withMetadata, false, "_top", false, null, TikzFontDistortion.getDefault(), 1.0, "none", null);
    }

    private FileFormatOption(FileFormat fileFormat, AffineTransform at, boolean withMetadata, boolean useRedForError, String svgLinkTarget, boolean debugsvek, String hoverColor, TikzFontDistortion tikzFontDistortion, double scale, String preserveAspectRatio, String watermark) {
        this.hoverColor = hoverColor;
        this.watermark = watermark;
        this.fileFormat = fileFormat;
        this.affineTransform = at;
        this.withMetadata = withMetadata;
        this.useRedForError = useRedForError;
        this.svgLinkTarget = svgLinkTarget;
        this.debugsvek = debugsvek;
        this.tikzFontDistortion = tikzFontDistortion;
        this.scale = scale;
        this.preserveAspectRatio = preserveAspectRatio;
        if (tikzFontDistortion == null) {
            throw new IllegalArgumentException();
        }
    }

    public StringBounder getDefaultStringBounder(SvgCharSizeHack charSizeHack) {
        return this.fileFormat.getDefaultStringBounder(this.tikzFontDistortion, charSizeHack);
    }

    public String getSvgLinkTarget() {
        return this.svgLinkTarget;
    }

    public final boolean isWithMetadata() {
        return this.withMetadata;
    }

    public final String getPreserveAspectRatio() {
        return this.preserveAspectRatio;
    }

    public FileFormatOption withUseRedForError() {
        return new FileFormatOption(this.fileFormat, this.affineTransform, this.withMetadata, true, this.svgLinkTarget, this.debugsvek, this.hoverColor, this.tikzFontDistortion, this.scale, this.preserveAspectRatio, this.watermark);
    }

    public FileFormatOption withTikzFontDistortion(TikzFontDistortion tikzFontDistortion) {
        return new FileFormatOption(this.fileFormat, this.affineTransform, this.withMetadata, true, this.svgLinkTarget, this.debugsvek, this.hoverColor, tikzFontDistortion, this.scale, this.preserveAspectRatio, this.watermark);
    }

    public FileFormatOption withSvgLinkTarget(String svgLinkTarget) {
        return new FileFormatOption(this.fileFormat, this.affineTransform, this.withMetadata, this.useRedForError, svgLinkTarget, this.debugsvek, this.hoverColor, this.tikzFontDistortion, this.scale, this.preserveAspectRatio, this.watermark);
    }

    public FileFormatOption withPreserveAspectRatio(String preserveAspectRatio) {
        return new FileFormatOption(this.fileFormat, this.affineTransform, this.withMetadata, this.useRedForError, this.svgLinkTarget, this.debugsvek, this.hoverColor, this.tikzFontDistortion, this.scale, preserveAspectRatio, this.watermark);
    }

    public FileFormatOption withHoverColor(String hoverColor) {
        return new FileFormatOption(this.fileFormat, this.affineTransform, this.withMetadata, this.useRedForError, this.svgLinkTarget, this.debugsvek, hoverColor, this.tikzFontDistortion, this.scale, this.preserveAspectRatio, this.watermark);
    }

    public FileFormatOption withScale(double scale) {
        return new FileFormatOption(this.fileFormat, this.affineTransform, this.withMetadata, this.useRedForError, this.svgLinkTarget, this.debugsvek, this.hoverColor, this.tikzFontDistortion, scale, this.preserveAspectRatio, this.watermark);
    }

    public FileFormatOption withWartermark(String watermark) {
        return new FileFormatOption(this.fileFormat, this.affineTransform, this.withMetadata, this.useRedForError, this.svgLinkTarget, this.debugsvek, this.hoverColor, this.tikzFontDistortion, this.scale, this.preserveAspectRatio, watermark);
    }

    public String toString() {
        return this.fileFormat.toString() + " " + this.affineTransform;
    }

    public final FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public AffineTransform getAffineTransform() {
        return this.affineTransform;
    }

    public final boolean isUseRedForError() {
        return this.useRedForError;
    }

    public void setDebugSvek(boolean debugsvek) {
        this.debugsvek = debugsvek;
    }

    public boolean isDebugSvek() {
        return this.debugsvek;
    }

    public final String getHoverColor() {
        return this.hoverColor;
    }

    public void hideMetadata() {
        this.withMetadata = false;
    }

    public final TikzFontDistortion getTikzFontDistortion() {
        return this.tikzFontDistortion;
    }

    public final String getWatermark() {
        return this.watermark;
    }
}

