/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.util.EnumMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.Value;
import net.sourceforge.plantuml.style.ValueColor;
import net.sourceforge.plantuml.style.ValueNull;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorNone;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class Style {
    private final Map<PName, Value> map;
    private final StyleSignature signature;

    public Style(StyleSignature signature, Map<PName, Value> map) {
        this.map = map;
        this.signature = signature;
    }

    public String toString() {
        return this.signature + " " + this.map;
    }

    public Value value(PName name) {
        Value result = this.map.get((Object)name);
        if (result == null) {
            return ValueNull.NULL;
        }
        return result;
    }

    public Style mergeWith(Style other) {
        if (other == null) {
            return this;
        }
        EnumMap<PName, Value> both = new EnumMap<PName, Value>(this.map);
        for (Map.Entry<PName, Value> ent : other.map.entrySet()) {
            Value previous = this.map.get((Object)ent.getKey());
            if (previous != null && ent.getValue().getPriority() <= previous.getPriority()) continue;
            both.put((PName)((Enum)ent.getKey()), ent.getValue());
        }
        return new Style(this.signature.mergeWith(other.getSignature()), both);
    }

    public Style eventuallyOverride(PName param, HColor color) {
        if (color == null) {
            return this;
        }
        EnumMap<PName, Value> result = new EnumMap<PName, Value>(this.map);
        Value old = result.get((Object)param);
        result.put(param, new ValueColor(color, old.getPriority()));
        return new Style(this.signature, result);
    }

    public Style eventuallyOverride(Colors colors) {
        Style result = this;
        if (colors != null) {
            HColor line;
            HColor back = colors.getColor(ColorType.BACK);
            if (back != null) {
                result = result.eventuallyOverride(PName.BackGroundColor, back);
            }
            if ((line = colors.getColor(ColorType.LINE)) != null) {
                result = result.eventuallyOverride(PName.LineColor, line);
            }
        }
        return result;
    }

    public Style eventuallyOverride(SymbolContext symbolContext) {
        HColor back;
        Style result = this;
        if (symbolContext != null && (back = symbolContext.getBackColor()) != null) {
            result = result.eventuallyOverride(PName.BackGroundColor, back);
        }
        return result;
    }

    public StyleSignature getSignature() {
        return this.signature;
    }

    public UFont getUFont() {
        String family = this.value(PName.FontName).asString();
        int fontStyle = this.value(PName.FontStyle).asFontStyle();
        int size = this.value(PName.FontSize).asInt();
        return new UFont(family, fontStyle, size);
    }

    public FontConfiguration getFontConfiguration(HColorSet set) {
        UFont font = this.getUFont();
        HColor color = this.value(PName.FontColor).asColor(set);
        HColor hyperlinkColor = this.value(PName.HyperLinkColor).asColor(set);
        return new FontConfiguration(font, color, hyperlinkColor, true);
    }

    public SymbolContext getSymbolContext(HColorSet set) {
        HColor backColor = this.value(PName.BackGroundColor).asColor(set);
        HColor foreColor = this.value(PName.LineColor).asColor(set);
        double deltaShadowing = this.value(PName.Shadowing).asDouble();
        return new SymbolContext(backColor, foreColor).withStroke(this.getStroke()).withDeltaShadow(deltaShadowing);
    }

    public UStroke getStroke() {
        double thickness = this.value(PName.LineThickness).asDouble();
        String dash = this.value(PName.LineStyle).asString();
        if (dash.length() == 0) {
            return new UStroke(thickness);
        }
        try {
            double dashVisible;
            StringTokenizer st = new StringTokenizer(dash, "-;,");
            double dashSpace = dashVisible = Double.parseDouble(st.nextToken().trim());
            if (st.hasMoreTokens()) {
                dashSpace = Double.parseDouble(st.nextToken().trim());
            }
            return new UStroke(dashVisible, dashSpace, thickness);
        }
        catch (Exception e) {
            return new UStroke(thickness);
        }
    }

    public LineBreakStrategy wrapWidth() {
        String value = this.value(PName.MaximumWidth).asString();
        return new LineBreakStrategy(value);
    }

    public ClockwiseTopRightBottomLeft getPadding() {
        String padding = this.value(PName.Padding).asString();
        return ClockwiseTopRightBottomLeft.read(padding);
    }

    public ClockwiseTopRightBottomLeft getMargin() {
        String margin = this.value(PName.Margin).asString();
        return ClockwiseTopRightBottomLeft.read(margin);
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.value(PName.HorizontalAlignment).asHorizontalAlignment();
    }

    private TextBlock createTextBlockInternal(Display display, HColorSet set, ISkinSimple spriteContainer, HorizontalAlignment alignment) {
        FontConfiguration fc = this.getFontConfiguration(set);
        return display.create(fc, alignment, spriteContainer);
    }

    public TextBlock createTextBlockBordered(Display note, HColorSet set, ISkinSimple spriteContainer) {
        HorizontalAlignment alignment = this.getHorizontalAlignment();
        TextBlock textBlock = this.createTextBlockInternal(note, set, spriteContainer, alignment);
        HColor legendBackgroundColor = this.value(PName.BackGroundColor).asColor(set);
        HColor legendColor = this.value(PName.LineColor).asColor(set);
        UStroke stroke = this.getStroke();
        int cornersize = this.value(PName.RoundCorner).asInt();
        ClockwiseTopRightBottomLeft margin = this.getMargin();
        ClockwiseTopRightBottomLeft padding = this.getPadding();
        TextBlock result = TextBlockUtils.bordered(textBlock, stroke, legendColor, legendBackgroundColor, cornersize, padding);
        return TextBlockUtils.withMargin(result, margin);
    }

    public UGraphic applyStrokeAndLineColor(UGraphic ug, HColorSet colorSet) {
        HColor color = this.value(PName.LineColor).asColor(colorSet);
        ug = color == null ? ug.apply(new HColorNone()) : ug.apply(color);
        ug = ug.apply(this.getStroke());
        return ug;
    }
}

