# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
Standard module, see official documentation at
https://www.opencascade.com/doc/occt-7.4.0/refman/html/package_standard.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _Standard
else:
    import _Standard

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Standard.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _Standard.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _Standard.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _Standard.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _Standard.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _Standard.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _Standard.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _Standard.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _Standard.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _Standard.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _Standard.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _Standard.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _Standard.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _Standard.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _Standard.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _Standard.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _Standard.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _Standard:
_Standard.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _Standard.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated


from enum import IntEnum
from OCC.Core.Exception import *

Standard_HandlerVoid = _Standard.Standard_HandlerVoid
Standard_HandlerJumped = _Standard.Standard_HandlerJumped
Standard_HandlerProcessed = _Standard.Standard_HandlerProcessed


class Standard_HandlerStatus(IntEnum):
	Standard_HandlerVoid = 0
	Standard_HandlerJumped = 1
	Standard_HandlerProcessed = 2
Standard_HandlerVoid = Standard_HandlerStatus.Standard_HandlerVoid
Standard_HandlerJumped = Standard_HandlerStatus.Standard_HandlerJumped
Standard_HandlerProcessed = Standard_HandlerStatus.Standard_HandlerProcessed


def Handle_Standard_Transient_Create() -> "opencascade::handle< Standard_Transient >":
    return _Standard.Handle_Standard_Transient_Create()

def Handle_Standard_Transient_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Standard_Transient >":
    return _Standard.Handle_Standard_Transient_DownCast(t)

def Handle_Standard_Transient_IsNull(t: "opencascade::handle< Standard_Transient > const &") -> "bool":
    return _Standard.Handle_Standard_Transient_IsNull(t)

def Handle_Standard_Failure_Create() -> "opencascade::handle< Standard_Failure >":
    return _Standard.Handle_Standard_Failure_Create()

def Handle_Standard_Failure_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Standard_Failure >":
    return _Standard.Handle_Standard_Failure_DownCast(t)

def Handle_Standard_Failure_IsNull(t: "opencascade::handle< Standard_Failure > const &") -> "bool":
    return _Standard.Handle_Standard_Failure_IsNull(t)

def Handle_Standard_OutOfMemory_Create() -> "opencascade::handle< Standard_OutOfMemory >":
    return _Standard.Handle_Standard_OutOfMemory_Create()

def Handle_Standard_OutOfMemory_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Standard_OutOfMemory >":
    return _Standard.Handle_Standard_OutOfMemory_DownCast(t)

def Handle_Standard_OutOfMemory_IsNull(t: "opencascade::handle< Standard_OutOfMemory > const &") -> "bool":
    return _Standard.Handle_Standard_OutOfMemory_IsNull(t)

def Handle_Standard_Persistent_Create() -> "opencascade::handle< Standard_Persistent >":
    return _Standard.Handle_Standard_Persistent_Create()

def Handle_Standard_Persistent_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Standard_Persistent >":
    return _Standard.Handle_Standard_Persistent_DownCast(t)

def Handle_Standard_Persistent_IsNull(t: "opencascade::handle< Standard_Persistent > const &") -> "bool":
    return _Standard.Handle_Standard_Persistent_IsNull(t)

def Handle_Standard_Type_Create() -> "opencascade::handle< Standard_Type >":
    return _Standard.Handle_Standard_Type_Create()

def Handle_Standard_Type_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Standard_Type >":
    return _Standard.Handle_Standard_Type_DownCast(t)

def Handle_Standard_Type_IsNull(t: "opencascade::handle< Standard_Type > const &") -> "bool":
    return _Standard.Handle_Standard_Type_IsNull(t)
class standard(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Allocate(*args) -> "Standard_Address":
        r"""
        Allocates memory blocks asize - bytes to allocate.

        Parameters
        ----------
        aSize: Standard_Size

        Returns
        -------
        Standard_Address

        """
        return _Standard.standard_Allocate(*args)

    @staticmethod
    def AllocateAligned(*args) -> "Standard_Address":
        r"""
        Allocates aligned memory blocks. should be used with cpu instructions which require specific alignment. for example: sse requires 16 bytes, avx requires 32 bytes. @param thesize bytes to allocate @param thealign alignment in bytes.

        Parameters
        ----------
        theSize: Standard_Size
        theAlign: Standard_Size

        Returns
        -------
        Standard_Address

        """
        return _Standard.standard_AllocateAligned(*args)

    @staticmethod
    def Purge(*args) -> "Standard_Integer":
        r"""
        Deallocates the storage retained on the free list and clears the list. returns non-zero if some memory has been actually freed.

        Returns
        -------
        int

        """
        return _Standard.standard_Purge(*args)

    @staticmethod
    def Reallocate(*args) -> "Standard_Address":
        r"""
        Reallocates memory blocks astorage - previously allocated memory block anewsize - new size in bytes.

        Parameters
        ----------
        aStorage: Standard_Address
        aNewSize: Standard_Size

        Returns
        -------
        Standard_Address

        """
        return _Standard.standard_Reallocate(*args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def Free(self):
    	pass

    @methodnotwrapped
    def FreeAligned(self):
    	pass


    def __init__(self):
        _Standard.standard_swiginit(self, _Standard.new_standard())
    __swig_destroy__ = _Standard.delete_standard

# Register standard in _Standard:
_Standard.standard_swigregister(standard)

def standard_Allocate(*args) -> "Standard_Address":
    r"""
    Allocates memory blocks asize - bytes to allocate.

    Parameters
    ----------
    aSize: Standard_Size

    Returns
    -------
    Standard_Address

    """
    return _Standard.standard_Allocate(*args)

def standard_AllocateAligned(*args) -> "Standard_Address":
    r"""
    Allocates aligned memory blocks. should be used with cpu instructions which require specific alignment. for example: sse requires 16 bytes, avx requires 32 bytes. @param thesize bytes to allocate @param thealign alignment in bytes.

    Parameters
    ----------
    theSize: Standard_Size
    theAlign: Standard_Size

    Returns
    -------
    Standard_Address

    """
    return _Standard.standard_AllocateAligned(*args)

def standard_Purge(*args) -> "Standard_Integer":
    r"""
    Deallocates the storage retained on the free list and clears the list. returns non-zero if some memory has been actually freed.

    Returns
    -------
    int

    """
    return _Standard.standard_Purge(*args)

def standard_Reallocate(*args) -> "Standard_Address":
    r"""
    Reallocates memory blocks astorage - previously allocated memory block anewsize - new size in bytes.

    Parameters
    ----------
    aStorage: Standard_Address
    aNewSize: Standard_Size

    Returns
    -------
    Standard_Address

    """
    return _Standard.standard_Reallocate(*args)

class Standard_ArrayStreamBuffer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Main constructor. passed pointer is stored as is (memory is not copied nor released with destructor). @param thebegin pointer to the beggining of pre-allocated buffer @param thesize length of pre-allocated buffer.

        Parameters
        ----------
        theBegin: char *
        theSize: size_t

        Returns
        -------
        None

        """
        _Standard.Standard_ArrayStreamBuffer_swiginit(self, _Standard.new_Standard_ArrayStreamBuffer(*args))

    def Init(self, *args) -> "void":
        r"""
        (re)-initialize the stream. passed pointer is stored as is (memory is not copied nor released with destructor). @param thebegin pointer to the beggining of pre-allocated buffer @param thesize length of pre-allocated buffer.

        Parameters
        ----------
        theBegin: char *
        theSize: size_t

        Returns
        -------
        None

        """
        return _Standard.Standard_ArrayStreamBuffer_Init(self, *args)

    def xsgetn(self, *args) -> "std::streamsize":
        r"""
        Read a bunch of bytes at once.

        Parameters
        ----------
        thePtr: char *
        theCount: std::streamsize

        Returns
        -------
        std::streamsize

        """
        return _Standard.Standard_ArrayStreamBuffer_xsgetn(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Standard.delete_Standard_ArrayStreamBuffer

# Register Standard_ArrayStreamBuffer in _Standard:
_Standard.Standard_ArrayStreamBuffer_swigregister(Standard_ArrayStreamBuffer)

class Standard_Condition(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Default constructor. @param theisset initial flag state.

        Parameters
        ----------
        theIsSet: bool

        Returns
        -------
        None

        """
        _Standard.Standard_Condition_swiginit(self, _Standard.new_Standard_Condition(*args))

    def Check(self, *args) -> "bool":
        r"""
        Do not wait for signal - just test it state. returns true if get event.

        Returns
        -------
        bool

        """
        return _Standard.Standard_Condition_Check(self, *args)

    def CheckReset(self, *args) -> "bool":
        r"""
        Method perform two steps at-once - reset the event object and returns true if it was in signaling state. returns true if event object was in signaling state.

        Returns
        -------
        bool

        """
        return _Standard.Standard_Condition_CheckReset(self, *args)

    def Reset(self, *args) -> "void":
        r"""
        Reset event (unset signaling state).

        Returns
        -------
        None

        """
        return _Standard.Standard_Condition_Reset(self, *args)

    def Set(self, *args) -> "void":
        r"""
        Set event into signaling state.

        Returns
        -------
        None

        """
        return _Standard.Standard_Condition_Set(self, *args)

    def Wait(self, *args) -> "bool":
        r"""
        Wait for event (infinity).

        Returns
        -------
        None
        Wait for signal requested time. @param thetimemilliseconds wait limit in milliseconds returns true if get event.

        Parameters
        ----------
        theTimeMilliseconds: int

        Returns
        -------
        bool

        """
        return _Standard.Standard_Condition_Wait(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def getHandle(self):
    	pass

    __swig_destroy__ = _Standard.delete_Standard_Condition

# Register Standard_Condition in _Standard:
_Standard.Standard_Condition_swigregister(Standard_Condition)

class Standard_ErrorHandler(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Create a errorhandler (to be used with try{}catch(){}). it uses the 'setjmp' and 'longjmp' routines.

        Returns
        -------
        None

        """
        _Standard.Standard_ErrorHandler_swiginit(self, _Standard.new_Standard_ErrorHandler(*args))

    def Catches(self, *args) -> "Standard_Boolean":
        r"""
        Returns 'true' if the caught exception has the same type or inherits from 'atype'.

        Parameters
        ----------
        aType: Standard_Type

        Returns
        -------
        bool

        """
        return _Standard.Standard_ErrorHandler_Catches(self, *args)

    def Destroy(self, *args) -> "void":
        r"""
        Unlinks and checks if there is a raised exception.

        Returns
        -------
        None

        """
        return _Standard.Standard_ErrorHandler_Destroy(self, *args)

    def Error(self, *args) -> "opencascade::handle< Standard_Failure >":
        r"""
        Returns the current error.

        Returns
        -------
        opencascade::handle<Standard_Failure>

        """
        return _Standard.Standard_ErrorHandler_Error(self, *args)

    @staticmethod
    def IsInTryBlock(*args) -> "Standard_Boolean":
        r"""
        Test if the code is currently running in a try block.

        Returns
        -------
        bool

        """
        return _Standard.Standard_ErrorHandler_IsInTryBlock(*args)

    @staticmethod
    def LastCaughtError(*args) -> "opencascade::handle< Standard_Failure >":
        r"""
        Returns the caught exception.

        Returns
        -------
        opencascade::handle<Standard_Failure>

        """
        return _Standard.Standard_ErrorHandler_LastCaughtError(*args)

    def Unlink(self, *args) -> "void":
        r"""
        Removes handler from the handlers list.

        Returns
        -------
        None

        """
        return _Standard.Standard_ErrorHandler_Unlink(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def Label(self):
    	pass

    __swig_destroy__ = _Standard.delete_Standard_ErrorHandler

# Register Standard_ErrorHandler in _Standard:
_Standard.Standard_ErrorHandler_swigregister(Standard_ErrorHandler)

def Standard_ErrorHandler_IsInTryBlock(*args) -> "Standard_Boolean":
    r"""
    Test if the code is currently running in a try block.

    Returns
    -------
    bool

    """
    return _Standard.Standard_ErrorHandler_IsInTryBlock(*args)

def Standard_ErrorHandler_LastCaughtError(*args) -> "opencascade::handle< Standard_Failure >":
    r"""
    Returns the caught exception.

    Returns
    -------
    opencascade::handle<Standard_Failure>

    """
    return _Standard.Standard_ErrorHandler_LastCaughtError(*args)

class Standard_GUID(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None
        Build a guid from an ascii string with the following format: length : 36 char '00000000-0000-0000-0000-000000000000'.

        Parameters
        ----------
        aGuid: char *

        Returns
        -------
        None
        Build a guid from an unicode string with the following format: //! '00000000-0000-0000-0000-000000000000'.

        Parameters
        ----------
        aGuid: Standard_ExtString

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        a32b: int
        a16b1: Standard_ExtCharacter
        a16b2: Standard_ExtCharacter
        a16b3: Standard_ExtCharacter
        a8b1: Standard_Byte
        a8b2: Standard_Byte
        a8b3: Standard_Byte
        a8b4: Standard_Byte
        a8b5: Standard_Byte
        a8b6: Standard_Byte

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        aGuid: Standard_UUID

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        aGuid: Standard_GUID

        Returns
        -------
        None

        """
        _Standard.Standard_GUID_swiginit(self, _Standard.new_Standard_GUID(*args))

    def Assign(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        uid: Standard_GUID

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        uid: Standard_UUID

        Returns
        -------
        None

        """
        return _Standard.Standard_GUID_Assign(self, *args)

    @staticmethod
    def CheckGUIDFormat(*args) -> "Standard_Boolean":
        r"""
        Check the format of a guid string. it checks the size, the position of the '-' and the correct size of fields.

        Parameters
        ----------
        aGuid: char *

        Returns
        -------
        bool

        """
        return _Standard.Standard_GUID_CheckGUIDFormat(*args)

    def Hash(self, *args) -> "Standard_Integer":
        r"""
        Hash function for guid.

        Parameters
        ----------
        Upper: int

        Returns
        -------
        int

        """
        return _Standard.Standard_GUID_Hash(self, *args)

    @staticmethod
    def HashCode(*args) -> "Standard_Integer":
        r"""
        Computes a hash code for the given guid of the standard_integer type, in the range [1, theupperbound] @param theguid the guid which hash code is to be computed @param theupperbound the upper bound of the range a computing hash code must be within returns a computed hash code, in the range [1, theupperbound].

        Parameters
        ----------
        theGUID: Standard_GUID
        theUpperBound: int

        Returns
        -------
        int

        """
        return _Standard.Standard_GUID_HashCode(*args)

    @staticmethod
    def IsEqual(*args) -> "Standard_Boolean":
        r"""
        Returns true when the two guid are the same.

        Parameters
        ----------
        string1: Standard_GUID
        string2: Standard_GUID

        Returns
        -------
        bool

        """
        return _Standard.Standard_GUID_IsEqual(*args)

    def IsNotSame(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Parameters
        ----------
        uid: Standard_GUID

        Returns
        -------
        bool

        """
        return _Standard.Standard_GUID_IsNotSame(self, *args)

    def IsSame(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Parameters
        ----------
        uid: Standard_GUID

        Returns
        -------
        bool

        """
        return _Standard.Standard_GUID_IsSame(self, *args)

    def ShallowDumpToString(self) -> "std::string":
        r"""ShallowDumpToString(Standard_GUID self) -> std::string"""
        return _Standard.Standard_GUID_ShallowDumpToString(self)

    def ToCString(self, *args) -> "void":
        r"""
        Translate the guid into ascii string the astrguid is allocated by user. the guid have the following format: //! '00000000-0000-0000-0000-000000000000'.

        Parameters
        ----------
        aStrGuid: Standard_PCharacter

        Returns
        -------
        None

        """
        return _Standard.Standard_GUID_ToCString(self, *args)

    def ToExtString(self, *args) -> "void":
        r"""
        Translate the guid into unicode string the astrguid is allocated by user. the guid have the following format: //! '00000000-0000-0000-0000-000000000000'.

        Parameters
        ----------
        aStrGuid: Standard_PExtCharacter

        Returns
        -------
        None

        """
        return _Standard.Standard_GUID_ToExtString(self, *args)

    def ToUUID(self, *args) -> "Standard_UUID":
        r"""
        No available documentation.

        Returns
        -------
        Standard_UUID

        """
        return _Standard.Standard_GUID_ToUUID(self, *args)

    def __ne_wrapper__(self, other: "Standard_GUID") -> "bool":
        r"""__ne_wrapper__(Standard_GUID self, Standard_GUID other) -> bool"""
        return _Standard.Standard_GUID___ne_wrapper__(self, other)

    def __ne__(self, right):
        try:
            return self.__ne_wrapper__(right)
        except:
            return True


    def __eq_wrapper__(self, other: "Standard_GUID") -> "bool":
        r"""__eq_wrapper__(Standard_GUID self, Standard_GUID other) -> bool"""
        return _Standard.Standard_GUID___eq_wrapper__(self, other)

    def __eq__(self, right):
        try:
            return self.__eq_wrapper__(right)
        except:
            return False


    __repr__ = _dumps_object

    __swig_destroy__ = _Standard.delete_Standard_GUID

# Register Standard_GUID in _Standard:
_Standard.Standard_GUID_swigregister(Standard_GUID)

def Standard_GUID_CheckGUIDFormat(*args) -> "Standard_Boolean":
    r"""
    Check the format of a guid string. it checks the size, the position of the '-' and the correct size of fields.

    Parameters
    ----------
    aGuid: char *

    Returns
    -------
    bool

    """
    return _Standard.Standard_GUID_CheckGUIDFormat(*args)

def Standard_GUID_HashCode(*args) -> "Standard_Integer":
    r"""
    Computes a hash code for the given guid of the standard_integer type, in the range [1, theupperbound] @param theguid the guid which hash code is to be computed @param theupperbound the upper bound of the range a computing hash code must be within returns a computed hash code, in the range [1, theupperbound].

    Parameters
    ----------
    theGUID: Standard_GUID
    theUpperBound: int

    Returns
    -------
    int

    """
    return _Standard.Standard_GUID_HashCode(*args)

def Standard_GUID_IsEqual(*args) -> "Standard_Boolean":
    r"""
    Returns true when the two guid are the same.

    Parameters
    ----------
    string1: Standard_GUID
    string2: Standard_GUID

    Returns
    -------
    bool

    """
    return _Standard.Standard_GUID_IsEqual(*args)

class Standard_MMgrRoot(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Allocate(self, *args) -> "Standard_Address":
        r"""
        Allocate specified number of bytes. the actually allocated space should be rounded up to double word size (4 bytes), as this is expected by implementation of some classes in occ (e.g. tcollection_asciistring).

        Parameters
        ----------
        theSize: Standard_Size

        Returns
        -------
        Standard_Address

        """
        return _Standard.Standard_MMgrRoot_Allocate(self, *args)

    def Free(self, *args) -> "void":
        r"""
        Frees previously allocated memory at specified address.

        Parameters
        ----------
        thePtr: Standard_Address

        Returns
        -------
        None

        """
        return _Standard.Standard_MMgrRoot_Free(self, *args)

    def Purge(self, *args) -> "Standard_Integer":
        r"""
        Purge internally cached unused memory blocks (if any) by releasing them to the operating system. must return non-zero if some memory has been actually released, or zero otherwise. if option isdestroyed is true, this means that memory manager is not expected to be used any more; note however that in general case it is still possible to have calls to that instance of memory manager after this (e.g. to free memory of static objects in occ). thus this option should command the memory manager to release any cached memory to the system and not cache any more, but still remain operable... //! default implementation does nothing and returns 0.

        Parameters
        ----------
        isDestroyed: bool,optional
        	default value is Standard_False

        Returns
        -------
        int

        """
        return _Standard.Standard_MMgrRoot_Purge(self, *args)

    def Reallocate(self, *args) -> "Standard_Address":
        r"""
        Reallocate previously allocated memory to contain at least thesize bytes. in case of success, new pointer is returned.

        Parameters
        ----------
        thePtr: Standard_Address
        theSize: Standard_Size

        Returns
        -------
        Standard_Address

        """
        return _Standard.Standard_MMgrRoot_Reallocate(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Standard.delete_Standard_MMgrRoot

# Register Standard_MMgrRoot in _Standard:
_Standard.Standard_MMgrRoot_swigregister(Standard_MMgrRoot)

class Standard_Transient(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Empty constructor.

        Returns
        -------
        None
        Copy constructor -- does nothing.

        Parameters
        ----------
        &: Standard_Transient

        Returns
        -------
        None

        """
        _Standard.Standard_Transient_swiginit(self, _Standard.new_Standard_Transient(*args))

    def DecrementRefCounter(self, *args) -> "Standard_Integer":
        r"""
        Decrements the reference counter of this object; returns the decremented value.

        Returns
        -------
        int

        """
        return _Standard.Standard_Transient_DecrementRefCounter(self, *args)

    def Delete(self, *args) -> "void":
        r"""
        Memory deallocator for transient classes.

        Returns
        -------
        None

        """
        return _Standard.Standard_Transient_Delete(self, *args)

    def DynamicType(self, *args) -> "opencascade::handle< Standard_Type > const &":
        r"""
        Returns a type descriptor about this object.

        Returns
        -------
        opencascade::handle<Standard_Type>

        """
        return _Standard.Standard_Transient_DynamicType(self, *args)

    def GetRefCount(self, *args) -> "Standard_Integer":
        r"""
        Get the reference counter of this object.

        Returns
        -------
        int

        """
        return _Standard.Standard_Transient_GetRefCount(self, *args)

    def IncrementRefCounter(self, *args) -> "void":
        r"""
        Increments the reference counter of this object.

        Returns
        -------
        None

        """
        return _Standard.Standard_Transient_IncrementRefCounter(self, *args)

    def IsInstance(self, *args) -> "Standard_Boolean":
        r"""
        Returns a true value if this is an instance of type.

        Parameters
        ----------
        theType: Standard_Type

        Returns
        -------
        bool
        Returns a true value if this is an instance of typename.

        Parameters
        ----------
        theTypeName: char *

        Returns
        -------
        bool

        """
        return _Standard.Standard_Transient_IsInstance(self, *args)

    def IsKind(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if this is an instance of type or an instance of any class that inherits from type. note that multiple inheritance is not supported by occt rtti mechanism.

        Parameters
        ----------
        theType: Standard_Type

        Returns
        -------
        bool
        Returns true if this is an instance of typename or an instance of any class that inherits from typename. note that multiple inheritance is not supported by occt rtti mechanism.

        Parameters
        ----------
        theTypeName: char *

        Returns
        -------
        bool

        """
        return _Standard.Standard_Transient_IsKind(self, *args)

    def This(self, *args) -> "Standard_Transient *":
        r"""
        Returns non-const pointer to this object (like const_cast). for protection against creating handle to objects allocated in stack or call from constructor, it will raise exception standard_programerror if reference counter is zero.

        Returns
        -------
        Standard_Transient *

        """
        return _Standard.Standard_Transient_This(self, *args)

    @staticmethod
    def get_type_descriptor(*args) -> "opencascade::handle< Standard_Type > const &":
        r"""
        Returns type descriptor of standard_transient class.

        Returns
        -------
        opencascade::handle<Standard_Type>

        """
        return _Standard.Standard_Transient_get_type_descriptor(*args)

    @staticmethod
    def get_type_name(*args) -> "char const *":
        r"""
        No available documentation.

        Returns
        -------
        char *

        """
        return _Standard.Standard_Transient_get_type_name(*args)


    @staticmethod
    def DownCast(t):
      return Handle_Standard_Transient_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Standard.delete_Standard_Transient

# Register Standard_Transient in _Standard:
_Standard.Standard_Transient_swigregister(Standard_Transient)

def Standard_Transient_get_type_descriptor(*args) -> "opencascade::handle< Standard_Type > const &":
    r"""
    Returns type descriptor of standard_transient class.

    Returns
    -------
    opencascade::handle<Standard_Type>

    """
    return _Standard.Standard_Transient_get_type_descriptor(*args)

def Standard_Transient_get_type_name(*args) -> "char const *":
    r"""
    No available documentation.

    Returns
    -------
    char *

    """
    return _Standard.Standard_Transient_get_type_name(*args)

class Standard_Failure(Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a status object of type 'failure'.

        Returns
        -------
        None
        Copy constructor.

        Parameters
        ----------
        f: Standard_Failure

        Returns
        -------
        None
        Creates a status object of type 'failure'.

        Parameters
        ----------
        aString: char *

        Returns
        -------
        None

        """
        _Standard.Standard_Failure_swiginit(self, _Standard.new_Standard_Failure(*args))

    @staticmethod
    def Caught(*args) -> "opencascade::handle< Standard_Failure >":
        r"""
        Returns the last caught exception. needed when exceptions are emulated by c longjumps, in other cases is also provided for compatibility.

        Returns
        -------
        opencascade::handle<Standard_Failure>

        """
        return _Standard.Standard_Failure_Caught(*args)

    def GetMessageString(self, *args) -> "char const *":
        r"""
        Returns error message.

        Returns
        -------
        char *

        """
        return _Standard.Standard_Failure_GetMessageString(self, *args)

    def Jump(self, *args) -> "void":
        r"""
        Used to throw cascade exception from c signal handler. on platforms that do not allow throwing c++ exceptions from this handler (e.g. linux), uses longjump to get to the current active signal handler, and only then is converted to c++ exception.

        Returns
        -------
        None

        """
        return _Standard.Standard_Failure_Jump(self, *args)

    @staticmethod
    def NewInstance(*args) -> "opencascade::handle< Standard_Failure >":
        r"""
        Used to construct an instance of the exception object as a handle. shall be used to protect against possible construction of exception object in c stack -- that is dangerous since some of methods require that object was allocated dynamically.

        Parameters
        ----------
        aMessage: char *

        Returns
        -------
        opencascade::handle<Standard_Failure>

        """
        return _Standard.Standard_Failure_NewInstance(*args)

    def PrintToString(self) -> "std::string":
        r"""PrintToString(Standard_Failure self) -> std::string"""
        return _Standard.Standard_Failure_PrintToString(self)

    @staticmethod
    def Raise(*args) -> "void":
        r"""
        Raises an exception of type 'failure' and associates an error message to it. the message can be printed in an exception handler.

        Parameters
        ----------
        aMessage: char *,optional
        	default value is 

        Returns
        -------
        None
        Raises an exception of type 'failure' and associates an error message to it. the message can be constructed at run-time.

        Parameters
        ----------
        aReason: Standard_SStream

        Returns
        -------
        None

        """
        return _Standard.Standard_Failure_Raise(*args)

    def Reraise(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        aMessage: char *

        Returns
        -------
        None
        Reraises a caught exception and changes its error message.

        Parameters
        ----------
        aReason: Standard_SStream

        Returns
        -------
        None

        """
        return _Standard.Standard_Failure_Reraise(self, *args)

    def SetMessageString(self, *args) -> "void":
        r"""
        Sets error message.

        Parameters
        ----------
        aMessage: char *

        Returns
        -------
        None

        """
        return _Standard.Standard_Failure_SetMessageString(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Standard_Failure_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Standard.delete_Standard_Failure

# Register Standard_Failure in _Standard:
_Standard.Standard_Failure_swigregister(Standard_Failure)

def Standard_Failure_Caught(*args) -> "opencascade::handle< Standard_Failure >":
    r"""
    Returns the last caught exception. needed when exceptions are emulated by c longjumps, in other cases is also provided for compatibility.

    Returns
    -------
    opencascade::handle<Standard_Failure>

    """
    return _Standard.Standard_Failure_Caught(*args)

def Standard_Failure_NewInstance(*args) -> "opencascade::handle< Standard_Failure >":
    r"""
    Used to construct an instance of the exception object as a handle. shall be used to protect against possible construction of exception object in c stack -- that is dangerous since some of methods require that object was allocated dynamically.

    Parameters
    ----------
    aMessage: char *

    Returns
    -------
    opencascade::handle<Standard_Failure>

    """
    return _Standard.Standard_Failure_NewInstance(*args)

def Standard_Failure_Raise(*args) -> "void":
    r"""
    Raises an exception of type 'failure' and associates an error message to it. the message can be printed in an exception handler.

    Parameters
    ----------
    aMessage: char *,optional
    	default value is 

    Returns
    -------
    None
    Raises an exception of type 'failure' and associates an error message to it. the message can be constructed at run-time.

    Parameters
    ----------
    aReason: Standard_SStream

    Returns
    -------
    None

    """
    return _Standard.Standard_Failure_Raise(*args)

class Standard_MMgrOpt(Standard_MMgrRoot):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor. if aclear is true, the allocated emmory will be nullified. for description of other parameters, see description of the class above.

        Parameters
        ----------
        aClear: bool,optional
        	default value is Standard_True
        aMMap: bool,optional
        	default value is Standard_True
        aCellSize: Standard_Size,optional
        	default value is 200
        aNbPages: int,optional
        	default value is 10000
        aThreshold: Standard_Size,optional
        	default value is 40000

        Returns
        -------
        None

        """
        _Standard.Standard_MMgrOpt_swiginit(self, _Standard.new_Standard_MMgrOpt(*args))

    __repr__ = _dumps_object

    @methodnotwrapped
    def SetCallBackFunction(self):
    	pass

    __swig_destroy__ = _Standard.delete_Standard_MMgrOpt

# Register Standard_MMgrOpt in _Standard:
_Standard.Standard_MMgrOpt_swigregister(Standard_MMgrOpt)

class Standard_MMgrRaw(Standard_MMgrRoot):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor; if aclear is true, the memory will be nullified upon allocation.

        Parameters
        ----------
        aClear: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        _Standard.Standard_MMgrRaw_swiginit(self, _Standard.new_Standard_MMgrRaw(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _Standard.delete_Standard_MMgrRaw

# Register Standard_MMgrRaw in _Standard:
_Standard.Standard_MMgrRaw_swigregister(Standard_MMgrRaw)

class Standard_MMgrTBBalloc(Standard_MMgrRoot):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor; if aclear is true, the memory will be nullified upon allocation.

        Parameters
        ----------
        aClear: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        _Standard.Standard_MMgrTBBalloc_swiginit(self, _Standard.new_Standard_MMgrTBBalloc(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _Standard.delete_Standard_MMgrTBBalloc

# Register Standard_MMgrTBBalloc in _Standard:
_Standard.Standard_MMgrTBBalloc_swigregister(Standard_MMgrTBBalloc)

class Standard_OutOfMemory(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor is kept public for backward compatibility.

        Parameters
        ----------
        theMessage: char *,optional
        	default value is 0

        Returns
        -------
        None

        """
        _Standard.Standard_OutOfMemory_swiginit(self, _Standard.new_Standard_OutOfMemory(*args))

    def GetMessageString(self, *args) -> "char const *":
        r"""
        Returns error message.

        Returns
        -------
        char *

        """
        return _Standard.Standard_OutOfMemory_GetMessageString(self, *args)

    @staticmethod
    def NewInstance(*args) -> "opencascade::handle< Standard_OutOfMemory >":
        r"""
        Returns global instance of exception.

        Parameters
        ----------
        theMessage: char *,optional
        	default value is 

        Returns
        -------
        opencascade::handle<Standard_OutOfMemory>

        """
        return _Standard.Standard_OutOfMemory_NewInstance(*args)

    @staticmethod
    def Raise(*args) -> "void":
        r"""
        Raises exception with specified message string.

        Parameters
        ----------
        theMessage: char *,optional
        	default value is 

        Returns
        -------
        None
        Raises exception with specified message string.

        Parameters
        ----------
        theMessage: Standard_SStream

        Returns
        -------
        None

        """
        return _Standard.Standard_OutOfMemory_Raise(*args)

    def SetMessageString(self, *args) -> "void":
        r"""
        Sets error message.

        Parameters
        ----------
        aMessage: char *

        Returns
        -------
        None

        """
        return _Standard.Standard_OutOfMemory_SetMessageString(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Standard_OutOfMemory_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Standard.delete_Standard_OutOfMemory

# Register Standard_OutOfMemory in _Standard:
_Standard.Standard_OutOfMemory_swigregister(Standard_OutOfMemory)

def Standard_OutOfMemory_NewInstance(*args) -> "opencascade::handle< Standard_OutOfMemory >":
    r"""
    Returns global instance of exception.

    Parameters
    ----------
    theMessage: char *,optional
    	default value is 

    Returns
    -------
    opencascade::handle<Standard_OutOfMemory>

    """
    return _Standard.Standard_OutOfMemory_NewInstance(*args)

def Standard_OutOfMemory_Raise(*args) -> "void":
    r"""
    Raises exception with specified message string.

    Parameters
    ----------
    theMessage: char *,optional
    	default value is 

    Returns
    -------
    None
    Raises exception with specified message string.

    Parameters
    ----------
    theMessage: Standard_SStream

    Returns
    -------
    None

    """
    return _Standard.Standard_OutOfMemory_Raise(*args)

class Standard_Persistent(Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        _Standard.Standard_Persistent_swiginit(self, _Standard.new_Standard_Persistent(*args))

    def GetTypeNum(self) -> "Standard_Integer":
        r"""GetTypeNum(Standard_Persistent self) -> Standard_Integer"""
        return _Standard.Standard_Persistent_GetTypeNum(self)

    def SetTypeNum(self, value: "Standard_Integer") -> "void":
        r"""SetTypeNum(Standard_Persistent self, Standard_Integer value)"""
        return _Standard.Standard_Persistent_SetTypeNum(self, value)


    @staticmethod
    def DownCast(t):
      return Handle_Standard_Persistent_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Standard.delete_Standard_Persistent

# Register Standard_Persistent in _Standard:
_Standard.Standard_Persistent_swigregister(Standard_Persistent)

class Standard_Type(Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Name(self, *args) -> "char const *":
        r"""
        Returns the given name of the class type (get_type_name).

        Returns
        -------
        char *

        """
        return _Standard.Standard_Type_Name(self, *args)

    def Parent(self, *args) -> "opencascade::handle< Standard_Type > const &":
        r"""
        Returns descriptor of the base class in the hierarchy.

        Returns
        -------
        opencascade::handle<Standard_Type>

        """
        return _Standard.Standard_Type_Parent(self, *args)

    def PrintToString(self) -> "std::string":
        r"""PrintToString(Standard_Type self) -> std::string"""
        return _Standard.Standard_Type_PrintToString(self)

    @staticmethod
    def Register(*args) -> "Standard_Type *":
        r"""
        Register a type; returns either new or existing descriptor. //! @param thesystemname name of the class as returned by typeid(class).name() @param thename name of the class to be stored in name field @param thesize size of the class instance @param theparent base class in the transient hierarchy //! note that this function is intended for use by opencascade::type_instance only. .

        Parameters
        ----------
        theSystemName: char *
        theName: char *
        theSize: Standard_Size
        theParent: Standard_Type

        Returns
        -------
        Standard_Type *

        """
        return _Standard.Standard_Type_Register(*args)

    def Size(self, *args) -> "Standard_Size":
        r"""
        Returns the size of the class instance in bytes.

        Returns
        -------
        Standard_Size

        """
        return _Standard.Standard_Type_Size(self, *args)

    def SubType(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if this type is the same as theother, or inherits from theother. note that multiple inheritance is not supported.

        Parameters
        ----------
        theOther: Standard_Type

        Returns
        -------
        bool
        Returns true if this type is the same as theother, or inherits from theother. note that multiple inheritance is not supported.

        Parameters
        ----------
        theOther: char *

        Returns
        -------
        bool

        """
        return _Standard.Standard_Type_SubType(self, *args)

    def SystemName(self, *args) -> "char const *":
        r"""
        Returns the system type name of the class (typeinfo.name).

        Returns
        -------
        char *

        """
        return _Standard.Standard_Type_SystemName(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Standard_Type_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Standard.delete_Standard_Type

# Register Standard_Type in _Standard:
_Standard.Standard_Type_swigregister(Standard_Type)

def Standard_Type_Register(*args) -> "Standard_Type *":
    r"""
    Register a type; returns either new or existing descriptor. //! @param thesystemname name of the class as returned by typeid(class).name() @param thename name of the class to be stored in name field @param thesize size of the class instance @param theparent base class in the transient hierarchy //! note that this function is intended for use by opencascade::type_instance only. .

    Parameters
    ----------
    theSystemName: char *
    theName: char *
    theSize: Standard_Size
    theParent: Standard_Type

    Returns
    -------
    Standard_Type *

    """
    return _Standard.Standard_Type_Register(*args)


@classnotwrapped
class Standard_AncestorIterator:
	pass

@classnotwrapped
class Standard_Static_Assert:
	pass

@classnotwrapped
class Standard_CLocaleSentry:
	pass

@classnotwrapped
class Standard_Mutex:
	pass

@classnotwrapped
class Standard_ReadLineBuffer:
	pass

@classnotwrapped
class Standard_ProgramError:
	pass

@classnotwrapped
class Standard_ReadBuffer:
	pass






