/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;

public abstract class AbstractPolygon
extends EMFTag {
    private Rectangle bounds;
    private int numberOfPoints;
    private Point[] points;

    protected AbstractPolygon(int id, int version) {
        super(id, version);
    }

    protected AbstractPolygon(int id, int version, Rectangle bounds, int numberOfPoints, Point[] points) {
        super(id, version);
        this.bounds = bounds;
        this.numberOfPoints = numberOfPoints;
        this.points = points;
    }

    @Override
    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.writeRECTL(this.bounds);
        emf.writeDWORD(this.numberOfPoints);
        emf.writePOINTL(this.numberOfPoints, this.points);
    }

    @Override
    public String toString() {
        String result = super.toString() + "\n  bounds: " + this.bounds + "\n  #points: " + this.numberOfPoints;
        if (this.points != null) {
            result = result + "\n  points: ";
            for (int i = 0; i < this.points.length; ++i) {
                result = result + "[" + this.points[i].x + "," + this.points[i].y + "]";
                if (i >= this.points.length - 1) continue;
                result = result + ", ";
            }
        }
        return result;
    }

    protected Rectangle getBounds() {
        return this.bounds;
    }

    protected int getNumberOfPoints() {
        return this.numberOfPoints;
    }

    protected Point[] getPoints() {
        return this.points;
    }
}

