/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.Session;
import org.hsqldb.SetFunction;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.Iterator;
import org.hsqldb.map.ValuePool;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;
import org.hsqldb.types.TypedComparator;

public class SetFunctionValueAggregate
implements SetFunction {
    private HashSet distinctValues;
    private final boolean isDistinct;
    private final Session session;
    private final int setType;
    private final int typeCode;
    private final Type type;
    private final Type returnType;
    private final TypedComparator comparator;
    private long count;
    private boolean hasNull;
    private boolean every = true;
    private boolean some = false;
    private long hiLong;
    private long loLong;
    private long fraction;
    private double currentDouble;
    private BigDecimal currentBigDecimal;
    private Object currentValue;
    static final BigInteger multiplier = BigInteger.valueOf(0x100000000L);
    private double sk;
    private double vk;
    private long n;
    private boolean initialized;
    private boolean sample;

    SetFunctionValueAggregate(Session session, int n, Type type, Type type2, boolean bl) {
        this.session = session;
        this.setType = n;
        this.type = type;
        this.returnType = type2;
        this.isDistinct = bl;
        if (bl) {
            this.distinctValues = new HashSet();
            if (type.isRowType() || type.isArrayType() || type.isCharacterType()) {
                this.comparator = new TypedComparator(session);
                this.comparator.setType(type, null);
                this.distinctValues.setComparator(this.comparator);
            } else {
                this.comparator = null;
            }
        } else {
            this.comparator = null;
        }
        switch (n) {
            case 82: 
            case 84: {
                this.sample = true;
            }
        }
        this.typeCode = type == null ? 0 : (type.isIntervalYearMonthType() ? 102 : (type.isIntervalDaySecondType() ? 106 : type.typeCode));
    }

    @Override
    public void reset() {
    }

    @Override
    public void add(Object object, Object object2) {
    }

    @Override
    public void add(Object object) {
        if (object == null) {
            this.hasNull = true;
            return;
        }
        if (this.isDistinct && !this.distinctValues.add(object)) {
            return;
        }
        ++this.count;
        switch (this.setType) {
            case 74: {
                return;
            }
            case 75: 
            case 78: {
                switch (this.typeCode) {
                    case -6: 
                    case 4: 
                    case 5: {
                        this.loLong += (long)((Number)object).intValue();
                        return;
                    }
                    case 106: {
                        if (object instanceof IntervalSecondData) {
                            this.addLong(((IntervalSecondData)object).getSeconds());
                            this.fraction += (long)((IntervalSecondData)object).getNanos();
                            if (this.fraction > 1000000000L) {
                                this.addLong(this.fraction / 1000000000L);
                                this.fraction %= 1000000000L;
                            }
                        }
                        return;
                    }
                    case 102: {
                        if (object instanceof IntervalMonthData) {
                            this.addLong(((IntervalMonthData)object).units);
                        }
                        return;
                    }
                    case 91: 
                    case 93: 
                    case 95: {
                        this.addLong(((TimestampData)object).getSeconds());
                        this.fraction += (long)((TimestampData)object).getNanos();
                        if (this.fraction > 1000000000L) {
                            this.addLong(this.fraction / 1000000000L);
                            this.fraction %= 1000000000L;
                        }
                        this.currentDouble = ((TimestampData)object).getZone();
                        return;
                    }
                    case 92: 
                    case 94: {
                        this.addLong(((TimeData)object).getSeconds());
                        this.fraction += (long)((TimeData)object).getNanos();
                        if (this.fraction > 1000000000L) {
                            this.addLong(this.fraction / 1000000000L);
                            this.fraction %= 1000000000L;
                        }
                        this.currentDouble = ((TimeData)object).getZone();
                        return;
                    }
                    case 25: {
                        this.addLong(((Number)object).longValue());
                        return;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        this.currentDouble += ((Number)object).doubleValue();
                        return;
                    }
                    case 2: 
                    case 3: {
                        this.currentBigDecimal = this.currentBigDecimal == null ? (BigDecimal)object : this.currentBigDecimal.add((BigDecimal)object);
                        return;
                    }
                }
                throw Error.error(5563);
            }
            case 76: {
                if (this.currentValue == null) {
                    this.currentValue = object;
                    return;
                }
                if (this.type.compare(this.session, this.currentValue, object) > 0) {
                    this.currentValue = object;
                }
                return;
            }
            case 77: {
                if (this.currentValue == null) {
                    this.currentValue = object;
                    return;
                }
                if (this.type.compare(this.session, this.currentValue, object) < 0) {
                    this.currentValue = object;
                }
                return;
            }
            case 79: {
                if (!(object instanceof Boolean)) {
                    throw Error.error(5563);
                }
                this.every = this.every && (Boolean)object != false;
                return;
            }
            case 80: {
                if (!(object instanceof Boolean)) {
                    throw Error.error(5563);
                }
                this.some = this.some || (Boolean)object != false;
                return;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                this.addDataPoint((Number)object);
                return;
            }
            case 98: {
                this.currentValue = object;
                return;
            }
        }
        throw Error.runtimeError(201, "SetFunction");
    }

    @Override
    public void addGroup(SetFunction setFunction) {
        SetFunctionValueAggregate setFunctionValueAggregate = (SetFunctionValueAggregate)setFunction;
        if (this.isDistinct) {
            HashSet hashSet = setFunctionValueAggregate.distinctValues;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.add(e);
            }
            return;
        }
        switch (this.setType) {
            case 74: {
                this.count += setFunctionValueAggregate.count;
                return;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                this.count += setFunctionValueAggregate.count;
                this.addDataGroup(setFunctionValueAggregate);
                return;
            }
            case 75: 
            case 78: {
                this.count += setFunctionValueAggregate.count;
                switch (this.typeCode) {
                    case -6: 
                    case 4: 
                    case 5: {
                        this.loLong += setFunctionValueAggregate.loLong;
                        return;
                    }
                    case 91: 
                    case 93: 
                    case 95: 
                    case 102: 
                    case 106: {
                        this.addLongGroup(setFunctionValueAggregate);
                        this.fraction += setFunctionValueAggregate.fraction;
                        if (this.fraction > 1000000000L) {
                            this.addLong(this.fraction / 1000000000L);
                            this.fraction %= 1000000000L;
                        }
                        this.currentDouble = setFunctionValueAggregate.currentDouble;
                        return;
                    }
                    case 25: {
                        this.addLongGroup(setFunctionValueAggregate);
                        return;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        this.currentDouble += setFunctionValueAggregate.currentDouble;
                        return;
                    }
                    case 2: 
                    case 3: {
                        this.currentBigDecimal = this.currentBigDecimal == null ? setFunctionValueAggregate.currentBigDecimal : this.currentBigDecimal.add(setFunctionValueAggregate.currentBigDecimal);
                        return;
                    }
                }
                throw Error.error(5563);
            }
        }
        this.add(setFunction.getValue());
    }

    @Override
    public Object getValue() {
        if (this.hasNull) {
            this.session.addWarning(Error.error(1003));
        }
        if (this.setType == 74) {
            if (this.count > 1L && this.isDistinct && (this.type.isRowType() || this.type.isArrayType() || this.type.isCharacterType())) {
                Object[] objectArray = this.distinctValues.toArray();
                ArraySort.sort(objectArray, objectArray.length, this.comparator);
                this.count = ArraySort.deDuplicate(objectArray, objectArray.length, this.comparator);
            }
            return ValuePool.getLong(this.count);
        }
        if (this.count == 0L) {
            return null;
        }
        switch (this.setType) {
            case 78: {
                switch (this.typeCode) {
                    case -6: 
                    case 4: 
                    case 5: {
                        if (this.returnType.scale != 0) {
                            return this.returnType.divide(this.session, this.loLong, this.count);
                        }
                        return this.loLong / this.count;
                    }
                    case 25: {
                        long l = this.getLongSum().divide(BigInteger.valueOf(this.count)).longValue();
                        return l;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return this.currentDouble / (double)this.count;
                    }
                    case 2: 
                    case 3: {
                        if (this.returnType.scale == this.type.scale) {
                            return this.currentBigDecimal.divide(new BigDecimal(this.count), RoundingMode.DOWN);
                        }
                        return this.returnType.divide(this.session, this.currentBigDecimal, this.count);
                    }
                    case 102: 
                    case 106: {
                        BigInteger[] bigIntegerArray = this.getLongSum().divideAndRemainder(BigInteger.valueOf(this.count));
                        if (NumberType.compareToLongLimits(bigIntegerArray[0]) != 0) {
                            throw Error.error(3435);
                        }
                        if (this.type.isIntervalDaySecondType()) {
                            long l = (this.fraction + bigIntegerArray[1].longValue() * 1000000000L) / this.count;
                            l = DTIType.normaliseFraction((int)l, this.type.scale);
                            return new IntervalSecondData(bigIntegerArray[0].longValue(), l, (IntervalType)this.type, true);
                        }
                        return IntervalMonthData.newIntervalMonth(bigIntegerArray[0].longValue(), (IntervalType)this.type);
                    }
                    case 91: 
                    case 93: 
                    case 95: {
                        BigInteger[] bigIntegerArray = this.getLongSum().divideAndRemainder(BigInteger.valueOf(this.count));
                        if (NumberType.compareToLongLimits(bigIntegerArray[0]) != 0) {
                            throw Error.error(3435);
                        }
                        long l = bigIntegerArray[0].longValue();
                        long l2 = (this.fraction + bigIntegerArray[1].longValue() * 1000000000L) / this.count;
                        l2 = DTIType.normaliseFraction((int)l2, this.type.scale);
                        if (this.setType == 91) {
                            l = HsqlDateTime.getNormalisedDate(l);
                            l2 = 0L;
                        }
                        return new TimestampData(l, (int)l2, 0);
                    }
                    case 92: 
                    case 94: {
                        BigInteger[] bigIntegerArray = this.getLongSum().divideAndRemainder(BigInteger.valueOf(this.count));
                        if (NumberType.compareToLongLimits(bigIntegerArray[0]) != 0) {
                            throw Error.error(3435);
                        }
                        long l = bigIntegerArray[0].longValue();
                        long l3 = (this.fraction + bigIntegerArray[1].longValue() * 1000000000L) / this.count;
                        l3 = DTIType.normaliseFraction((int)l3, 0);
                        if (this.setType == 91) {
                            l = HsqlDateTime.getNormalisedDate(l);
                            l3 = 0L;
                        }
                        return new TimeData((int)l, (int)l3, 0);
                    }
                }
                throw Error.runtimeError(201, "SetFunction");
            }
            case 75: {
                switch (this.typeCode) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return this.loLong;
                    }
                    case 25: {
                        return new BigDecimal(this.getLongSum());
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return this.currentDouble;
                    }
                    case 2: 
                    case 3: {
                        return this.currentBigDecimal;
                    }
                    case 102: 
                    case 106: {
                        BigInteger bigInteger = this.getLongSum();
                        if (NumberType.compareToLongLimits(bigInteger) != 0) {
                            throw Error.error(3435);
                        }
                        if (this.type.isIntervalDaySecondType()) {
                            return new IntervalSecondData(bigInteger.longValue(), this.fraction, (IntervalType)this.type, true);
                        }
                        return IntervalMonthData.newIntervalMonth(bigInteger.longValue(), (IntervalType)this.type);
                    }
                }
                throw Error.runtimeError(201, "SetFunction");
            }
            case 76: 
            case 77: {
                return this.currentValue;
            }
            case 79: {
                return this.every ? Boolean.TRUE : Boolean.FALSE;
            }
            case 80: {
                return this.some ? Boolean.TRUE : Boolean.FALSE;
            }
            case 81: 
            case 82: {
                return this.getStdDev();
            }
            case 83: 
            case 84: {
                return this.getVariance();
            }
            case 98: {
                return this.currentValue;
            }
        }
        throw Error.runtimeError(201, "SetFunction");
    }

    private void addLong(long l) {
        if (l != 0L) {
            if (l > 0L) {
                this.hiLong += l >> 32;
                this.loLong += l & 0xFFFFFFFFL;
            } else if (l == Long.MIN_VALUE) {
                this.hiLong -= 0x80000000L;
            } else {
                long l2 = (l ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
                this.hiLong -= l2 >> 32;
                this.loLong -= l2 & 0xFFFFFFFFL;
            }
        }
    }

    private void addLongGroup(SetFunctionValueAggregate setFunctionValueAggregate) {
        this.addLong(setFunctionValueAggregate.loLong);
        this.hiLong += setFunctionValueAggregate.hiLong;
    }

    private BigInteger getLongSum() {
        BigInteger bigInteger = BigInteger.valueOf(this.loLong);
        BigInteger bigInteger2 = BigInteger.valueOf(this.hiLong);
        BigInteger bigInteger3 = bigInteger2.multiply(multiplier).add(bigInteger);
        return bigInteger3;
    }

    private void addDataPoint(Number number) {
        if (number == null) {
            return;
        }
        double d = number.doubleValue();
        if (!this.initialized) {
            this.n = 1L;
            this.sk = d;
            this.vk = 0.0;
            this.initialized = true;
            return;
        }
        ++this.n;
        long l = this.n - 1L;
        double d2 = this.sk - d * (double)l;
        this.vk += d2 * d2 / (double)this.n / (double)l;
        this.sk += d;
    }

    private void addDataGroup(SetFunctionValueAggregate setFunctionValueAggregate) {
        if (setFunctionValueAggregate == null || setFunctionValueAggregate.count == 0L) {
            return;
        }
        if (!this.initialized) {
            this.n = setFunctionValueAggregate.n;
            this.sk = setFunctionValueAggregate.sk;
            this.vk = setFunctionValueAggregate.vk;
            this.initialized = true;
            return;
        }
        double d = (this.sk + setFunctionValueAggregate.sk) / (double)(this.n + setFunctionValueAggregate.n);
        this.vk = this.vk + setFunctionValueAggregate.vk + (double)this.n * (this.sk / (double)this.n - d) * (this.sk / (double)this.n - d) + (double)setFunctionValueAggregate.n * (setFunctionValueAggregate.sk / (double)setFunctionValueAggregate.n - d) * (setFunctionValueAggregate.sk / (double)setFunctionValueAggregate.n - d);
        this.sk += setFunctionValueAggregate.sk;
        this.n += setFunctionValueAggregate.n;
    }

    private Double getVariance() {
        if (!this.initialized) {
            return null;
        }
        return this.sample ? (this.n == 1L ? null : Double.valueOf(this.vk / (double)(this.n - 1L))) : Double.valueOf(this.vk / (double)this.n);
    }

    private Double getStdDev() {
        if (!this.initialized) {
            return null;
        }
        return this.sample ? (this.n == 1L ? null : Double.valueOf(Math.sqrt(this.vk / (double)(this.n - 1L)))) : Double.valueOf(Math.sqrt(this.vk / (double)this.n));
    }
}

