/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.LinkedHashSet;
import java.util.Set;

final class GatherExternProperties
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final Set<String> externProperties;
    private final AbstractCompiler compiler;

    GatherExternProperties(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.externProperties = compiler.getExternProperties() == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(compiler.getExternProperties());
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, externs, this);
        this.compiler.setExternProperties(ImmutableSet.copyOf(this.externProperties));
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case GETPROP: {
                Node dest = n.getSecondChild();
                if (!dest.isString()) break;
                this.externProperties.add(dest.getString());
                break;
            }
            case STRING_KEY: {
                if (!parent.isObjectLit()) break;
                this.externProperties.add(n.getString());
                break;
            }
            case MEMBER_FUNCTION_DEF: {
                this.externProperties.add(n.getString());
                break;
            }
        }
        JSDocInfo jsDocInfo = n.getJSDocInfo();
        if (jsDocInfo != null) {
            this.gatherPropertiesFromJSDocInfo(jsDocInfo);
        }
    }

    private void gatherPropertiesFromJSDocInfo(JSDocInfo jsDocInfo) {
        for (Node jsTypeExpressionNode : jsDocInfo.getTypeNodes()) {
            this.gatherPropertiesFromJsTypeExpressionNode(jsTypeExpressionNode);
        }
    }

    private void gatherPropertiesFromJsTypeExpressionNode(Node jsTypeExpressionNode) {
        switch (jsTypeExpressionNode.getToken()) {
            case LB: {
                this.gatherPropertiesFromJsDocRecordType(jsTypeExpressionNode);
                break;
            }
            default: {
                for (Node child = jsTypeExpressionNode.getFirstChild(); child != null; child = child.getNext()) {
                    this.gatherPropertiesFromJsTypeExpressionNode(child);
                }
            }
        }
    }

    private void gatherPropertiesFromJsDocRecordType(Node jsDocRecordNode) {
        Preconditions.checkState(jsDocRecordNode.getToken() == Token.LB, jsDocRecordNode);
        for (Node fieldNode = jsDocRecordNode.getFirstChild(); fieldNode != null; fieldNode = fieldNode.getNext()) {
            Node fieldTypeNode;
            Node fieldNameNode;
            if (fieldNode.getToken() == Token.COLON) {
                fieldNameNode = fieldNode.getFirstChild();
                fieldTypeNode = fieldNameNode.getNext();
            } else {
                fieldNameNode = fieldNode;
                fieldTypeNode = null;
            }
            Preconditions.checkState(fieldNameNode.isStringKey(), fieldNameNode);
            String fieldName = fieldNameNode.getString();
            if (fieldName.startsWith("'") || fieldName.startsWith("\"")) {
                fieldName = fieldName.substring(1, fieldName.length() - 1);
            }
            this.externProperties.add(fieldName);
            if (fieldTypeNode == null) continue;
            this.gatherPropertiesFromJsTypeExpressionNode(fieldTypeNode);
        }
    }
}

