/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.TextArea;

abstract class Anchor {
    private final DisplayManager displayManager;
    private final TextArea textArea;
    private int physicalLine;
    private int scrollLine;
    private boolean callChanged;
    private boolean callReset;
    int preContentInsertedScrollLines;
    int preContentRemovedScrollLines;

    protected Anchor(DisplayManager displayManager, TextArea textArea) {
        this.displayManager = displayManager;
        this.textArea = textArea;
    }

    abstract void reset();

    abstract void changed();

    public String toString() {
        return this.getClass().getName() + "[" + this.getPhysicalLine() + "," + this.getScrollLine() + "]";
    }

    void movePhysicalLine(int n) {
        if (n == 0) {
            return;
        }
        this.setPhysicalLine(this.getPhysicalLine() + n);
    }

    void moveScrollLine(int n) {
        if (n == 0) {
            return;
        }
        this.setScrollLine(this.getScrollLine() + n);
    }

    abstract void preContentInserted(int var1, int var2);

    abstract void contentInserted(int var1, int var2);

    abstract void preContentRemoved(int var1, int var2, int var3);

    abstract void contentRemoved(int var1, int var2, int var3);

    int getPhysicalLine() {
        return this.physicalLine;
    }

    void setPhysicalLine(int n) {
        assert (n >= 0);
        if (this.physicalLine != n) {
            this.setCallChanged(true);
            this.physicalLine = n;
        }
    }

    int getScrollLine() {
        return this.scrollLine;
    }

    void setScrollLine(int n) {
        assert (n >= 0);
        if (this.scrollLine != n) {
            this.setCallChanged(true);
            this.scrollLine = n;
        }
    }

    boolean isCallChanged() {
        return this.callChanged;
    }

    void setCallChanged(boolean bl) {
        this.callChanged = bl;
    }

    boolean isCallReset() {
        return this.callReset;
    }

    void setCallReset(boolean bl) {
        this.callReset = bl;
    }

    DisplayManager getDisplayManager() {
        return this.displayManager;
    }

    TextArea getTextArea() {
        return this.textArea;
    }

    void resetCallState() {
        this.callChanged = false;
        this.callReset = false;
    }
}

