/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.swing;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.gl2.GLUT;
import java.awt.Container;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import org.gephi.ui.utils.UIUtils;
import org.gephi.visualization.swing.GLAbstractListener;

public class GraphCanvas
extends GLAbstractListener {
    private final GLCanvas glCanvas;
    private final GLUT glut = new GLUT();

    public GraphCanvas() {
        this.glCanvas = new GLCanvas((GLCapabilitiesImmutable)this.getCaps());
        super.initDrawable((GLAutoDrawable)this.glCanvas);
        this.graphComponent = this.glCanvas;
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
    }

    @Override
    protected void init(GL2 gl) {
        this.globalScale = this.glCanvas.getCurrentSurfaceScale(new float[2])[0];
        this.engine.startDisplay();
    }

    @Override
    protected void render3DScene(GL2 gl, GLU glu) {
        if (this.vizController.getVizConfig().isShowFPS()) {
            gl.glPushMatrix();
            gl.glLoadIdentity();
            gl.glMatrixMode(5889);
            gl.glPushMatrix();
            gl.glLoadIdentity();
            gl.glGetIntegerv(2978, this.viewport);
            glu.gluOrtho2D(0.0f, (float)this.viewport.get(2), (float)this.viewport.get(3), 0.0f);
            gl.glDepthFunc(519);
            gl.glColor3i(192, 192, 192);
            gl.glRasterPos2f(10.0f, 15.0f);
            String fpsRound = String.valueOf((int)this.fps);
            this.glut.glutBitmapString(6, fpsRound);
            gl.glDepthFunc(513);
            gl.glPopMatrix();
            gl.glMatrixMode(5888);
            gl.glPopMatrix();
        }
    }

    @Override
    protected void reshape3DScene(GL2 gl) {
    }

    @Override
    public void reinitWindow() {
        Container c;
        if (UIUtils.isAquaLookAndFeel() && (c = this.graphComponent.getParent()) != null) {
            c.remove(this.graphComponent);
            c.add(this.graphComponent, "Center");
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.glCanvas.destroy();
    }
}

