/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import processing.app.EditorConsole;

public class ConsoleOutputStream
extends ByteArrayOutputStream {
    private SimpleAttributeSet attributes;
    private final PrintStream printStream;
    private final Timer timer;
    private volatile EditorConsole editorConsole;
    private volatile boolean newLinePrinted;

    public ConsoleOutputStream(SimpleAttributeSet attributes, PrintStream printStream) {
        this.attributes = attributes;
        this.printStream = printStream;
        this.newLinePrinted = false;
        this.timer = new Timer(100, e -> {
            if (this.editorConsole != null && this.newLinePrinted) {
                this.editorConsole.scrollDown();
                this.newLinePrinted = false;
            }
        });
        this.timer.setRepeats(false);
    }

    public void setAttibutes(SimpleAttributeSet attributes) {
        this.attributes = attributes;
    }

    public void setCurrentEditorConsole(EditorConsole console) {
        this.editorConsole = console;
    }

    @Override
    public synchronized void flush() {
        String text = this.toString();
        if (text.length() == 0) {
            return;
        }
        this.printStream.print(text);
        this.printInConsole(text);
        this.reset();
    }

    private void printInConsole(String text) {
        boolean bl = this.newLinePrinted = this.newLinePrinted || text.contains("\n");
        if (this.editorConsole != null) {
            SwingUtilities.invokeLater(() -> {
                try {
                    this.editorConsole.insertString(text, this.attributes);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            });
            if (!this.timer.isRunning()) {
                this.timer.restart();
            }
        }
    }
}

