/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PolyfillUsageFinder;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.jscomp.resources.ResourceLoader;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.LinkedHashSet;

class IsolatePolyfills
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final PolyfillUsageFinder.Polyfills polyfills;
    private final Node jscompPolyfillsObject;
    private static final String POLYFILL_TEMP = "$jscomp$polyfillTmp";
    private final Node jscompLookupMethod = IR.name("$jscomp$lookupPolyfilledValue");
    private boolean usedPolyfillMethodLookup = false;
    private boolean isTempVarInitialized = false;

    IsolatePolyfills(AbstractCompiler compiler) {
        this(compiler, PolyfillUsageFinder.Polyfills.fromTable(ResourceLoader.loadTextResource(IsolatePolyfills.class, "js/polyfills.txt")));
    }

    @VisibleForTesting
    IsolatePolyfills(AbstractCompiler compiler, PolyfillUsageFinder.Polyfills polyfills) {
        this.compiler = compiler;
        this.polyfills = polyfills;
        boolean hasPropertyCollapsingRun = compiler.getOptions().getPropertyCollapseLevel().equals((Object)CompilerOptions.PropertyCollapseLevel.ALL);
        this.jscompPolyfillsObject = hasPropertyCollapsingRun ? IR.name("$jscomp$polyfills") : IsolatePolyfills.createJSCompPolyfillsAccess();
    }

    private static Node createJSCompPolyfillsAccess() {
        Node jscomp = IR.name("$jscomp");
        jscomp.putBooleanProp(Node.IS_CONSTANT_NAME, true);
        return IR.getprop(jscomp, "polyfills", new String[0]);
    }

    @Override
    public void process(Node externs, Node root) {
        ImmutableSet<String> injectedPolyfills = this.findAllInjectedPolyfills();
        ArrayList polyfillUsages = new ArrayList();
        new PolyfillUsageFinder(this.compiler, this.polyfills).traverseIncludingGuarded(root, polyfillUsages::add);
        LinkedHashSet<Node> visitedNodes = new LinkedHashSet<Node>();
        for (PolyfillUsageFinder.PolyfillUsage usage : polyfillUsages) {
            if (visitedNodes.contains(usage.node()) || usage.polyfill().library.isEmpty() || !injectedPolyfills.contains(usage.polyfill().nativeSymbol)) continue;
            this.rewritePolyfill(usage);
            visitedNodes.add(usage.node());
        }
        this.cleanUpJscompLookupPolyfilledValue();
    }

    private ImmutableSet<String> findAllInjectedPolyfills() {
        final ImmutableSet.Builder actualPolyfills = ImmutableSet.builder();
        Node lastInjectedNode = this.compiler.getNodeForCodeInsertion(null);
        NodeTraversal.traverse(this.compiler, lastInjectedNode, new NodeTraversal.AbstractShallowCallback(){

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (IsolatePolyfills.this.isJSCompPolyfillCall(n)) {
                    String polyfilledSymbol = n.getSecondChild().getString();
                    actualPolyfills.add(polyfilledSymbol);
                }
            }
        });
        return actualPolyfills.build();
    }

    private boolean isJSCompPolyfillCall(Node call) {
        if (!call.isCall()) {
            return false;
        }
        String jscompPolyfillName = this.compiler.getOptions().getPropertyCollapseLevel().equals((Object)CompilerOptions.PropertyCollapseLevel.ALL) ? "$jscomp$polyfill" : "$jscomp.polyfill";
        return call.getFirstChild().matchesQualifiedName(jscompPolyfillName);
    }

    private void rewritePolyfill(PolyfillUsageFinder.PolyfillUsage polyfillUsage) {
        boolean isGlobalClass;
        PolyfillUsageFinder.Polyfill polyfill = polyfillUsage.polyfill();
        if (this.compiler.getOptions().getOutputFeatureSet().contains(FeatureSet.valueOf(polyfill.nativeVersion))) {
            return;
        }
        Node polyfillAccess = polyfillUsage.node();
        Node parent = polyfillUsage.node().getParent();
        if (polyfillAccess.getSourceFileName().equals(" [synthetic:util/global] ") || polyfillAccess.getSourceFileName().equals(" [synthetic:util/shouldpolyfill] ")) {
            return;
        }
        if (NodeUtil.isLValue(polyfillAccess) || parent.isAssign() && polyfillAccess.isFirstChildOf(parent)) {
            return;
        }
        String name = polyfillUsage.name();
        boolean bl = isGlobalClass = name.indexOf(46) == -1 && polyfill.kind.equals((Object)PolyfillUsageFinder.Polyfill.Kind.STATIC);
        if (isGlobalClass) {
            polyfillAccess.replaceWith(IR.getelem(this.jscompPolyfillsObject.cloneTree(), IR.string(name)).srcrefTree(polyfillAccess));
        } else if (parent.isCall() && polyfillAccess.isFirstChildOf(parent)) {
            this.rewritePolyfillInCall(polyfillAccess);
        } else {
            Node receiver = polyfillAccess.removeFirstChild();
            Node methodName = polyfillAccess.removeFirstChild();
            polyfillAccess.replaceWith(this.createPolyfillMethodLookup(receiver, methodName).srcrefTree(polyfillAccess));
        }
        this.compiler.reportChangeToEnclosingScope(parent);
    }

    private void rewritePolyfillInCall(Node callee) {
        Node polyfilledMethod;
        Node thisNode;
        Node callNode = callee.getParent();
        Node receiver = callee.removeFirstChild();
        Node methodName = callee.removeFirstChild();
        boolean requiresTemp = this.compiler.getAstAnalyzer().mayEffectMutableState(receiver);
        if (requiresTemp) {
            thisNode = this.createTempName(callee);
            polyfilledMethod = IR.comma(IR.assign(thisNode.cloneTree(), receiver), this.createPolyfillMethodLookup(thisNode.cloneTree(), methodName));
        } else {
            thisNode = receiver;
            polyfilledMethod = this.createPolyfillMethodLookup(receiver.cloneTree(), methodName);
        }
        Node receiverDotCall = IR.getprop(polyfilledMethod, IR.string("call")).srcrefTree(callee);
        callee.replaceWith(receiverDotCall);
        callNode.addChildAfter(thisNode, receiverDotCall);
    }

    private Node createTempName(Node srcref) {
        if (!this.isTempVarInitialized) {
            this.isTempVarInitialized = true;
            Node decl = IR.var(IR.name(POLYFILL_TEMP)).srcrefTree(srcref);
            this.compiler.getNodeForCodeInsertion(null).addChildToFront(decl);
        }
        return IR.name(POLYFILL_TEMP).srcref(srcref);
    }

    private Node createPolyfillMethodLookup(Node receiver, Node methodName) {
        this.usedPolyfillMethodLookup = true;
        Node call = IR.call(this.jscompLookupMethod.cloneTree(), receiver, methodName);
        call.putBooleanProp(Node.FREE_CALL, true);
        return call;
    }

    private void cleanUpJscompLookupPolyfilledValue() {
        Node syntheticExternsRoot = this.compiler.getSynthesizedExternsInputAtEnd().getAstRoot(this.compiler);
        AbstractScope syntheticExternsScope = new SyntacticScopeCreator(this.compiler).createScope(syntheticExternsRoot, (AbstractScope)null);
        Var externVar = Preconditions.checkNotNull((Var)syntheticExternsScope.getVar(this.jscompLookupMethod.getString()), "Failed to find synthetic $jscomp$lookupPolyfilledValue extern");
        NodeUtil.deleteNode(externVar.getParentNode(), this.compiler);
        if (this.usedPolyfillMethodLookup) {
            return;
        }
        AbstractScope syntheticCodeScope = new SyntacticScopeCreator(this.compiler).createScope(this.compiler.getNodeForCodeInsertion(null), (AbstractScope)null);
        Var syntheticVar = (Var)syntheticCodeScope.getVar(this.jscompLookupMethod.getString());
        if (syntheticVar != null) {
            NodeUtil.deleteNode(syntheticVar.getParentNode(), this.compiler);
        }
    }
}

