/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import java.util.TreeMap;

public class LazyParsedDependencyInfo
extends DependencyInfo.Base {
    private final DependencyInfo delegate;
    private JsAst ast;
    private final transient AbstractCompiler compiler;
    private ImmutableMap<String, String> loadFlags;

    public LazyParsedDependencyInfo(DependencyInfo delegate, JsAst ast, AbstractCompiler compiler) {
        this.delegate = Preconditions.checkNotNull(delegate);
        this.ast = Preconditions.checkNotNull(ast);
        this.compiler = Preconditions.checkNotNull(compiler);
    }

    @Override
    public ImmutableMap<String, String> getLoadFlags() {
        if (this.loadFlags == null) {
            String version;
            TreeMap<String, String> loadFlagsBuilder = new TreeMap<String, String>();
            boolean hadSourceInMemory = this.ast.getSourceFile().hasSourceInMemory();
            loadFlagsBuilder.putAll(this.delegate.getLoadFlags());
            FeatureSet features = this.ast.getFeatures(this.compiler);
            if (features.has(FeatureSet.Feature.MODULES)) {
                String previousModule = (String)loadFlagsBuilder.get("module");
                if (previousModule != null && !previousModule.equals("es6")) {
                    this.compiler.report(JSError.make(this.getName(), -1, -1, ModuleLoader.MODULE_CONFLICT, this.getName()));
                }
                loadFlagsBuilder.put("module", "es6");
            }
            if (!(version = features.version()).equals("es3")) {
                loadFlagsBuilder.put("lang", version);
            }
            this.loadFlags = ImmutableMap.copyOf(loadFlagsBuilder);
            if (!hadSourceInMemory) {
                this.ast.getSourceFile().clearCachedSource();
            }
            this.ast = null;
        }
        return this.loadFlags;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public String getPathRelativeToClosureBase() {
        return this.delegate.getPathRelativeToClosureBase();
    }

    @Override
    public ImmutableList<DependencyInfo.Require> getRequires() {
        return this.delegate.getRequires();
    }

    @Override
    public ImmutableList<String> getTypeRequires() {
        return this.delegate.getTypeRequires();
    }

    @Override
    public ImmutableList<String> getProvides() {
        return this.delegate.getProvides();
    }

    @Override
    public boolean getHasExternsAnnotation() {
        return this.delegate.getHasExternsAnnotation();
    }

    @Override
    public boolean getHasNoCompileAnnotation() {
        return this.delegate.getHasNoCompileAnnotation();
    }
}

