/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.common.base.Strings;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.refactoring.Match;
import com.google.javascript.refactoring.NodeMetadata;
import com.google.javascript.refactoring.Scanner;
import com.google.javascript.refactoring.SuggestedFix;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

final class JsFlumeCallback
implements NodeTraversal.Callback {
    private final Scanner scanner;
    @Nullable
    private final Pattern includeFilePattern;
    private final List<Match> matches = new ArrayList<Match>();
    private final List<SuggestedFix> fixes = new ArrayList<SuggestedFix>();

    JsFlumeCallback(Scanner scanner, @Nullable Pattern includeFilePattern) {
        this.scanner = scanner;
        this.includeFilePattern = includeFilePattern;
    }

    List<Match> getMatches() {
        return this.matches;
    }

    List<SuggestedFix> getFixes() {
        return this.fixes;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        if (n.isFromExterns()) {
            return false;
        }
        if (n.isScript()) {
            String filename = n.getSourceFileName();
            if (this.includeFilePattern != null && !Strings.isNullOrEmpty(this.includeFilePattern.pattern()) && !Strings.isNullOrEmpty(filename)) {
                return this.includeFilePattern.matcher(filename).find();
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        NodeMetadata metadata = NodeMetadata.fromTraversal(t);
        if (this.scanner.matches(n, metadata)) {
            Match match = new Match(n, metadata);
            this.fixes.addAll(this.scanner.processMatch(match));
            this.matches.add(match);
        }
    }
}

