/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.javascript.rhino.ClosurePrimitive;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.ArrowType;
import com.google.javascript.rhino.jstype.AutoValue_FunctionType_Parameter;
import com.google.javascript.rhino.jstype.EqualityChecker;
import com.google.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.javascript.rhino.jstype.InstanceObjectType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeClass;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.NoResolvedType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.Property;
import com.google.javascript.rhino.jstype.PrototypeObjectType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TypeStringBuilder;
import com.google.javascript.rhino.jstype.UnknownType;
import com.google.javascript.rhino.jstype.Visitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class FunctionType
extends PrototypeObjectType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final JSTypeClass TYPE_CLASS = JSTypeClass.FUNCTION;
    private ConstructorAmbiguity constructorAmbiguity = ConstructorAmbiguity.UNKNOWN;
    private ArrowType call;
    private Property prototypeSlot;
    private final Kind kind;
    private PropAccess propAccess;
    private JSType typeOfThis;
    private Node source;
    private boolean isStructuralInterface;
    private final boolean isAbstract;
    private ImmutableList<ObjectType> implementedInterfaces = ImmutableList.of();
    private ImmutableList<ObjectType> extendedInterfaces = ImmutableList.of();
    private List<FunctionType> subTypes = null;
    private boolean wasAddedToExtendedConstructorSubtypes = false;
    private final ClosurePrimitive closurePrimitive;
    private final FunctionType canonicalRepresentation;
    private static final String DELEGATE_SUFFIX = ObjectType.createDelegateSuffix("Proxy");

    FunctionType(Builder builder) {
        super(builder);
        this.setPrettyPrint(true);
        Node source = builder.sourceNode;
        Preconditions.checkArgument(source == null || source.isFunction() || source.isClass());
        this.source = source;
        this.kind = builder.kind;
        if (builder.typeOfThis != null) {
            this.typeOfThis = builder.typeOfThis;
        } else if (this instanceof NoResolvedType) {
            this.typeOfThis = this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        } else {
            switch (this.kind) {
                case CONSTRUCTOR: 
                case INTERFACE: {
                    InstanceObjectType.Builder typeOfThisBuilder = InstanceObjectType.builderForCtor(this);
                    Set ctorKeys = builder.constructorOnlyKeys;
                    if (!ctorKeys.isEmpty()) {
                        ((InstanceObjectType.Builder)typeOfThisBuilder.setTemplateTypeMap(this.templateTypeMap.copyWithoutKeys(ctorKeys))).setTemplateParamCount(this.getTemplateParamCount() - ctorKeys.size());
                    }
                    this.typeOfThis = typeOfThisBuilder.build();
                    break;
                }
                case ORDINARY: {
                    this.typeOfThis = this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
                    break;
                }
                case NONE: {
                    this.typeOfThis = this;
                }
            }
        }
        if (this.kind == Kind.CONSTRUCTOR) {
            this.propAccess = PropAccess.ANY;
        }
        this.call = new ArrowType(this.registry, builder.parameters, builder.returnsOwnInstanceType ? this.typeOfThis : builder.returnType, builder.returnTypeIsInferred);
        this.closurePrimitive = builder.primitiveId;
        this.isStructuralInterface = false;
        this.isAbstract = builder.isAbstract;
        FunctionType canonicalRepresentation = builder.canonicalRepresentation;
        Preconditions.checkArgument(canonicalRepresentation == null || this.kind == Kind.CONSTRUCTOR, "Only constructors should have canonical representations");
        this.canonicalRepresentation = canonicalRepresentation;
        if (builder.setPrototypeBasedOn != null) {
            this.setPrototypeBasedOn(builder.setPrototypeBasedOn);
        }
        this.registry.getResolver().resolveIfClosed(this, TYPE_CLASS);
    }

    @Override
    JSTypeClass getTypeClass() {
        return TYPE_CLASS;
    }

    @Override
    public FunctionType getConstructor() {
        return Preconditions.checkNotNull(this.registry.getNativeFunctionType(JSTypeNative.FUNCTION_FUNCTION_TYPE));
    }

    @Override
    public final boolean isInstanceType() {
        return JSType.areIdentical(this, this.registry.getNativeType(JSTypeNative.FUNCTION_TYPE));
    }

    @Override
    public final boolean isConstructor() {
        return this.kind == Kind.CONSTRUCTOR;
    }

    @Override
    public final boolean isInterface() {
        return this.kind == Kind.INTERFACE;
    }

    @Override
    public final boolean isOrdinaryFunction() {
        return this.kind == Kind.ORDINARY;
    }

    final Kind getKind() {
        return this.kind;
    }

    public final boolean makesStructs() {
        if (!this.hasInstanceType()) {
            return false;
        }
        if (this.propAccess == PropAccess.STRUCT) {
            return true;
        }
        if (this.propAccess == PropAccess.ANY_EXPLICIT) {
            return false;
        }
        FunctionType superc = this.getSuperClassConstructor();
        if (superc != null && superc.makesStructs()) {
            this.setStruct();
            return true;
        }
        return false;
    }

    public final boolean makesDicts() {
        if (!this.isConstructor()) {
            return false;
        }
        if (this.propAccess == PropAccess.DICT) {
            return true;
        }
        if (this.propAccess == PropAccess.ANY_EXPLICIT) {
            return false;
        }
        FunctionType superc = this.getSuperClassConstructor();
        if (superc != null && superc.makesDicts()) {
            this.setDict();
            return true;
        }
        return false;
    }

    public final void setStruct() {
        this.propAccess = PropAccess.STRUCT;
    }

    public final void setDict() {
        this.propAccess = PropAccess.DICT;
    }

    public final void setExplicitUnrestricted() {
        this.propAccess = PropAccess.ANY_EXPLICIT;
    }

    @Override
    public FunctionType toMaybeFunctionType() {
        return this;
    }

    @Override
    public final boolean canBeCalled() {
        return true;
    }

    public final boolean hasImplementedInterfaces() {
        FunctionType superCtor;
        if (!this.implementedInterfaces.isEmpty()) {
            return true;
        }
        FunctionType functionType = superCtor = this.isConstructor() ? this.getSuperClassConstructor() : null;
        if (superCtor != null) {
            return superCtor.hasImplementedInterfaces();
        }
        return false;
    }

    public final ImmutableList<Parameter> getParameters() {
        return this.getInternalArrowType().getParameterList();
    }

    public final int getMinArity() {
        int i = 0;
        int min = 0;
        for (Parameter parameter : this.getParameters()) {
            ++i;
            if (parameter.isOptional() || parameter.isVariadic()) continue;
            min = i;
        }
        return min;
    }

    public final int getMaxArity() {
        ImmutableList<Parameter> params = this.getParameters();
        if (params.isEmpty()) {
            return 0;
        }
        Parameter lastParam = Iterables.getLast(params);
        if (!lastParam.isVariadic()) {
            return params.size();
        }
        return Integer.MAX_VALUE;
    }

    public final JSType getReturnType() {
        return this.call.getReturnType();
    }

    public final boolean isReturnTypeInferred() {
        return this.call.returnTypeInferred;
    }

    final ArrowType getInternalArrowType() {
        return this.call;
    }

    @Override
    public final Property getSlot(String name) {
        if ("prototype".equals(name)) {
            this.getPrototype();
            return this.prototypeSlot;
        }
        return super.getSlot(name);
    }

    @Override
    public final Set<String> getOwnPropertyNames() {
        if (this.prototypeSlot == null) {
            return super.getOwnPropertyNames();
        }
        ImmutableSet.Builder names = ImmutableSet.builder();
        names.add("prototype");
        names.addAll(super.getOwnPropertyNames());
        return names.build();
    }

    public final ObjectType getPrototypeProperty() {
        return this.getPrototype();
    }

    public final ObjectType getPrototype() {
        if (this.prototypeSlot == null) {
            String refName = this.getReferenceName();
            if (refName == null) {
                this.setPrototypeNoCheck(this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE), null);
            } else {
                this.setPrototype(((PrototypeObjectType.Builder)((PrototypeObjectType.Builder)((PrototypeObjectType.Builder)PrototypeObjectType.builder(this.registry).setName(this.getReferenceName() + ".prototype")).setImplicitPrototype(this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE))).setNative(this.isNativeObjectType())).build(), null);
            }
        }
        return (ObjectType)this.prototypeSlot.getType();
    }

    public final void setPrototypeBasedOn(ObjectType baseType) {
        this.setPrototypeBasedOn(baseType, null);
    }

    private void setPrototypeBasedOn(ObjectType baseType, Node propertyNode) {
        if (this.source != null && this.source.isClass()) {
            FunctionType superCtor = baseType.getConstructor();
            if (superCtor != null) {
                this.setImplicitPrototype(superCtor);
            }
            this.maybeLoosenTypecheckingDueToForwardReferencedSupertype(baseType);
        }
        if (baseType.hasReferenceName() || this.isNativeObjectType() || baseType.isFunctionPrototypeType()) {
            if (this.prototypeSlot != null && this.hasInstanceType() && baseType.equals(this.getInstanceType())) {
                return;
            }
            baseType = ((PrototypeObjectType.Builder)((PrototypeObjectType.Builder)PrototypeObjectType.builder(this.registry).setName(this.getReferenceName() + ".prototype")).setImplicitPrototype(baseType)).build();
        }
        this.setPrototype(baseType, propertyNode);
    }

    final boolean setPrototype(ObjectType prototype, Node propertyNode) {
        if (prototype == null) {
            return false;
        }
        if (this.isConstructor() && JSType.areIdentical(prototype, this.getInstanceType())) {
            return false;
        }
        return this.setPrototypeNoCheck(prototype, propertyNode);
    }

    private boolean setPrototypeNoCheck(ObjectType prototype, Node propertyNode) {
        ObjectType oldPrototype = this.prototypeSlot == null ? null : (ObjectType)this.prototypeSlot.getType();
        boolean replacedPrototype = oldPrototype != null;
        this.prototypeSlot = new Property("prototype", prototype, true, propertyNode == null ? this.source : propertyNode);
        prototype.setOwnerFunction(this);
        if (oldPrototype != null) {
            oldPrototype.setOwnerFunction(null);
        }
        if (this.isConstructor() || this.isInterface()) {
            FunctionType superClass = this.getSuperClassConstructor();
            if (superClass != null) {
                superClass.addSubType(this);
                this.wasAddedToExtendedConstructorSubtypes = true;
            }
            if (this.isInterface()) {
                for (ObjectType interfaceType : this.getExtendedInterfaces()) {
                    if (interfaceType.getConstructor() == null) continue;
                    interfaceType.getConstructor().addSubType(this);
                }
            }
        }
        if (replacedPrototype) {
            this.clearCachedValues();
        }
        return true;
    }

    public final Iterable<ObjectType> getAllImplementedInterfaces() {
        LinkedHashSet<ObjectType> interfaces = new LinkedHashSet<ObjectType>();
        for (ObjectType type : this.getImplementedInterfaces()) {
            this.addRelatedInterfaces(type, interfaces);
        }
        return interfaces;
    }

    private void addRelatedInterfaces(ObjectType instance, Set<ObjectType> set) {
        FunctionType constructor = instance.getConstructor();
        if (constructor != null) {
            if (!constructor.isInterface()) {
                return;
            }
            if (!set.add(instance)) {
                return;
            }
            for (ObjectType interfaceType : instance.getCtorExtendedInterfaces()) {
                this.addRelatedInterfaces(interfaceType, set);
            }
        }
    }

    public final Collection<ObjectType> getAncestorInterfaces() {
        HashSet<ObjectType> result = new HashSet<ObjectType>();
        if (this.isConstructor()) {
            result.addAll(this.getImplementedInterfaces());
        } else {
            result.addAll(this.getExtendedInterfaces());
        }
        return result;
    }

    public final ImmutableList<ObjectType> getImplementedInterfaces() {
        FunctionType superCtor;
        FunctionType functionType = superCtor = this.isConstructor() ? this.getSuperClassConstructor() : null;
        if (superCtor == null) {
            return this.implementedInterfaces;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.implementedInterfaces);
        while (superCtor != null) {
            builder.addAll(superCtor.implementedInterfaces);
            superCtor = superCtor.getSuperClassConstructor();
        }
        return builder.build();
    }

    public final ImmutableList<ObjectType> getOwnImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    public final void setImplementedInterfaces(List<ObjectType> implementedInterfaces) {
        Preconditions.checkState(this.isConstructor());
        this.implementedInterfaces = ImmutableList.copyOf(implementedInterfaces);
        for (ObjectType type : implementedInterfaces) {
            this.registry.registerTypeImplementingInterface(this, type);
            this.typeOfThis.mergeSupertypeTemplateTypes(type);
        }
    }

    public final ImmutableList<ObjectType> getExtendedInterfaces() {
        return this.extendedInterfaces;
    }

    public final int getExtendedInterfacesCount() {
        return this.extendedInterfaces.size();
    }

    public final void setExtendedInterfaces(List<ObjectType> extendedInterfaces) {
        Preconditions.checkState(this.isInterface());
        this.extendedInterfaces = ImmutableList.copyOf(extendedInterfaces);
        for (ObjectType extendedInterface : extendedInterfaces) {
            this.typeOfThis.mergeSupertypeTemplateTypes(extendedInterface);
        }
    }

    @Override
    public final JSType getPropertyType(String name) {
        if (!this.hasOwnProperty(name)) {
            boolean isCall = "call".equals(name);
            boolean isBind = "bind".equals(name);
            if (isCall || isBind) {
                this.defineDeclaredProperty(name, this.getCallOrBindSignature(isCall), this.source);
            } else if ("apply".equals(name)) {
                FunctionParamBuilder builder = new FunctionParamBuilder(this.registry);
                builder.addOptionalParams(this.registry.createNullableType(this.getTypeOfThis()), this.registry.createNullableType(this.registry.getNativeType(JSTypeNative.OBJECT_TYPE)));
                this.defineDeclaredProperty(name, FunctionType.builder(this.registry).withParameters(builder.build()).withReturnType(this.getReturnType()).withTemplateKeys(this.getTemplateTypeMap().getTemplateKeys()).build(), this.source);
            }
        }
        return super.getPropertyType(name);
    }

    public final FunctionType getBindReturnType(int argsToBind) {
        Builder builder = FunctionType.builder(this.registry).withReturnType(this.getReturnType()).withTemplateKeys(this.getTemplateTypeMap().getTemplateKeys());
        if (argsToBind < 0) {
            return builder.build();
        }
        ImmutableList<Parameter> origParams = this.call.getParameterList();
        ArrayList<Parameter> params = new ArrayList<Parameter>(origParams);
        for (int i = 1; i < argsToBind && !params.isEmpty() && !((Parameter)params.get(0)).isVariadic(); ++i) {
            params.remove(0);
        }
        builder.withParameters(params);
        return builder.build();
    }

    private FunctionType getCallOrBindSignature(boolean isCall) {
        boolean isBind = !isCall;
        Builder builder = FunctionType.builder(this.registry).withReturnType(isCall ? this.getReturnType() : this.getBindReturnType(-1)).withTemplateKeys(this.getTemplateTypeMap().getTemplateKeys());
        ImmutableList<Parameter> origParams = this.getInternalArrowType().getParameterList();
        ArrayList<Parameter> params = new ArrayList<Parameter>(origParams);
        Parameter thisType = Parameter.create(this.registry.createOptionalNullableType(this.getTypeOfThis()), false, false);
        params.add(0, thisType);
        if (isBind) {
            for (int i = 1; i < params.size(); ++i) {
                Parameter current = (Parameter)params.get(i);
                Parameter optionalCopy = Parameter.create(current.getJSType(), true, current.isVariadic());
                params.set(i, optionalCopy);
            }
        } else if (isCall) {
            Parameter firstArg;
            Parameter parameter = firstArg = params.size() > 1 ? (Parameter)params.get(1) : null;
            if (firstArg == null || firstArg.isOptional() || firstArg.isVariadic()) {
                Parameter optionalThisType = Parameter.create(thisType.getJSType(), true, false);
                params.set(0, optionalThisType);
            }
        }
        builder.withParameters(params);
        return builder.build();
    }

    @Override
    boolean defineProperty(String name, JSType type, boolean inferred, Node propertyNode) {
        if ("prototype".equals(name)) {
            ObjectType objType = type.toObjectType();
            if (objType != null) {
                if (this.prototypeSlot != null && objType.equals(this.prototypeSlot.getType())) {
                    return true;
                }
                this.setPrototypeBasedOn(objType, propertyNode);
                return true;
            }
            return false;
        }
        return super.defineProperty(name, type, inferred, propertyNode);
    }

    final FunctionType supAndInfHelper(FunctionType that, boolean leastSuper) {
        JSType functionInstance;
        Preconditions.checkNotNull(that);
        if (this.equals(that)) {
            return this;
        }
        if (this.isOrdinaryFunction() && that.isOrdinaryFunction() && !this.call.hasUnknownParamsOrReturn() && !that.call.hasUnknownParamsOrReturn()) {
            boolean isSubtypeOfThat = this.isSubtype(that);
            boolean isSubtypeOfThis = that.isSubtype(this);
            if (isSubtypeOfThat && !isSubtypeOfThis) {
                return leastSuper ? that : this;
            }
            if (isSubtypeOfThis && !isSubtypeOfThat) {
                return leastSuper ? this : that;
            }
            FunctionType merged = this.tryMergeFunctionPiecewise(that, leastSuper);
            if (merged != null) {
                return merged;
            }
        }
        if ((functionInstance = this.registry.getNativeType(JSTypeNative.FUNCTION_TYPE)).equals(that)) {
            return leastSuper ? that : this;
        }
        if (functionInstance.equals(this)) {
            return leastSuper ? this : that;
        }
        FunctionType greatestFn = this.registry.getNativeFunctionType(JSTypeNative.FUNCTION_TYPE);
        FunctionType leastFn = this.registry.getNativeFunctionType(JSTypeNative.LEAST_FUNCTION_TYPE);
        return leastSuper ? greatestFn : leastFn;
    }

    private FunctionType tryMergeFunctionPiecewise(FunctionType other, boolean leastSuper) {
        JSType maybeNewTypeOfThis;
        ImmutableList<Parameter> newParamsNode = null;
        if (!new EqualityChecker().setEqMethod(EqualityChecker.EqMethod.IDENTITY).checkParameters(this.call, other.call)) {
            return null;
        }
        newParamsNode = this.call.getParameterList();
        JSType newReturnType = leastSuper ? this.call.getReturnType().getLeastSupertype(other.call.getReturnType()) : this.call.getReturnType().getGreatestSubtype(other.call.getReturnType());
        JSType newTypeOfThis = null;
        newTypeOfThis = Objects.equals(this.typeOfThis, other.typeOfThis) ? this.typeOfThis : (maybeNewTypeOfThis = leastSuper ? this.typeOfThis.getLeastSupertype(other.typeOfThis) : this.typeOfThis.getGreatestSubtype(other.typeOfThis));
        boolean newReturnTypeInferred = this.call.returnTypeInferred || other.call.returnTypeInferred;
        return FunctionType.builder(this.registry).withParameters(newParamsNode).withReturnType(newReturnType, newReturnTypeInferred).withTypeOfThis(newTypeOfThis).build();
    }

    @Override
    public final FunctionType getSuperClassConstructor() {
        Preconditions.checkArgument(this.isConstructor() || this.isInterface());
        ObjectType maybeSuperInstanceType = this.getPrototype().getImplicitPrototype();
        if (maybeSuperInstanceType == null) {
            return null;
        }
        return maybeSuperInstanceType.getConstructor();
    }

    @Override
    int recursionUnsafeHashCode() {
        int hc = this.kind.hashCode();
        switch (this.kind) {
            case CONSTRUCTOR: 
            case INTERFACE: {
                return 31 * hc + System.identityHashCode(this);
            }
            case ORDINARY: {
                hc = 31 * hc + this.typeOfThis.hashCode();
                hc = 31 * hc + this.call.hashCode();
                return hc;
            }
        }
        throw new AssertionError();
    }

    public final boolean hasEqualCallType(FunctionType that) {
        return new EqualityChecker().setEqMethod(EqualityChecker.EqMethod.IDENTITY).check(this.call, that.call);
    }

    @Override
    void appendTo(TypeStringBuilder sb) {
        boolean hasKnownTypeOfThis;
        if (!this.isPrettyPrint() || JSType.areIdentical(this, this.registry.getNativeType(JSTypeNative.FUNCTION_TYPE))) {
            sb.append(sb.isForAnnotations() ? "!Function" : "Function");
            return;
        }
        if (this.hasInstanceType() && this.getSource() != null) {
            sb.append("(typeof ").append(this.getInstanceType()).append(")");
            return;
        }
        this.setPrettyPrint(false);
        sb.append("function(");
        int paramNum = this.call.getParameterList().size();
        boolean bl = hasKnownTypeOfThis = !(this.typeOfThis instanceof UnknownType);
        if (hasKnownTypeOfThis) {
            if (this.isConstructor()) {
                sb.append("new:");
            } else {
                sb.append("this:");
            }
            sb.append(this.typeOfThis);
        }
        if (paramNum > 0) {
            if (hasKnownTypeOfThis) {
                sb.append(", ");
            }
            Parameter p = (Parameter)this.call.getParameterList().get(0);
            this.appendArgString(sb, p);
            for (int i = 1; i < paramNum; ++i) {
                p = (Parameter)this.call.getParameterList().get(i);
                sb.append(", ");
                this.appendArgString(sb, p);
            }
        }
        sb.append("): ");
        sb.appendNonNull(this.call.getReturnType());
        this.setPrettyPrint(true);
    }

    private void appendArgString(TypeStringBuilder sb, Parameter p) {
        if (p.isVariadic()) {
            this.appendVarArgsString(sb, p.getJSType());
        } else if (p.isOptional()) {
            this.appendOptionalArgString(sb, p.getJSType());
        } else {
            sb.appendNonNull(p.getJSType());
        }
    }

    private void appendVarArgsString(TypeStringBuilder sb, JSType paramType) {
        sb.append("...").appendNonNull(paramType);
    }

    private void appendOptionalArgString(TypeStringBuilder sb, JSType paramType) {
        if (paramType.isUnionType()) {
            paramType = paramType.toMaybeUnionType().getRestrictedUnion(this.registry.getNativeType(JSTypeNative.VOID_TYPE));
        }
        sb.appendNonNull(paramType).append("=");
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseFunctionType(this);
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return visitor.caseFunctionType(this, that);
    }

    public final ObjectType getInstanceType() {
        Preconditions.checkState(this.hasInstanceType());
        return this.typeOfThis.toObjectType();
    }

    public final boolean hasInstanceType() {
        return this.isConstructor() || this.isInterface();
    }

    @Override
    public final JSType getTypeOfThis() {
        return this.typeOfThis.isEmptyType() ? this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE) : this.typeOfThis;
    }

    public final Node getSource() {
        return this.source;
    }

    public final void setSource(Node source) {
        if (this.prototypeSlot != null && (source == null || this.prototypeSlot.getNode() == null)) {
            this.prototypeSlot = new Property(this.prototypeSlot.getName(), this.prototypeSlot.getType(), this.prototypeSlot.isTypeInferred(), source);
        }
        this.source = source;
    }

    private void addSubType(FunctionType subType) {
        if (this.subTypes == null) {
            this.subTypes = new ArrayList<FunctionType>();
        }
        this.subTypes.add(subType);
    }

    final void addSubClassAfterResolution(FunctionType subClass) {
        Preconditions.checkArgument(JSType.areIdentical(this, subClass.getSuperClassConstructor()));
        if (!subClass.wasAddedToExtendedConstructorSubtypes) {
            this.addSubType(subClass);
        }
    }

    @Override
    public final void clearCachedValues() {
        super.clearCachedValues();
        if (this.subTypes != null) {
            for (FunctionType subType : this.subTypes) {
                subType.clearCachedValues();
            }
        }
        if (!this.isNativeObjectType()) {
            if (this.hasInstanceType()) {
                this.getInstanceType().clearCachedValues();
            }
            if (this.prototypeSlot != null) {
                ((ObjectType)this.prototypeSlot.getType()).clearCachedValues();
            }
        }
    }

    public final Iterable<FunctionType> getDirectSubTypes() {
        return Iterables.concat(this.subTypes != null ? this.subTypes : ImmutableList.of(), this.registry.getDirectImplementors(this));
    }

    @Override
    public final boolean hasCachedValues() {
        return this.prototypeSlot != null || super.hasCachedValues();
    }

    @Override
    JSType resolveInternal(ErrorReporter reporter) {
        ImmutableList<ObjectType> resolvedExtended;
        ImmutableList<ObjectType> resolvedImplemented;
        JSType maybeTypeOfThis;
        this.call = (ArrowType)FunctionType.safeResolve(this.call, reporter);
        if (this.prototypeSlot != null) {
            this.prototypeSlot.setType(FunctionType.safeResolve(this.prototypeSlot.getType(), reporter));
        }
        if ((maybeTypeOfThis = FunctionType.safeResolve(this.typeOfThis, reporter)) != null) {
            if (maybeTypeOfThis.isNullType() || maybeTypeOfThis.isVoidType()) {
                this.typeOfThis = maybeTypeOfThis;
            } else if ((maybeTypeOfThis = ObjectType.cast(maybeTypeOfThis.restrictByNotNullOrUndefined())) != null) {
                this.typeOfThis = maybeTypeOfThis;
            }
        }
        if ((resolvedImplemented = this.resolveTypeListHelper(this.implementedInterfaces, reporter)) != null) {
            this.implementedInterfaces = resolvedImplemented;
        }
        if ((resolvedExtended = this.resolveTypeListHelper(this.extendedInterfaces, reporter)) != null) {
            this.extendedInterfaces = resolvedExtended;
        }
        if (this.subTypes != null) {
            for (int i = 0; i < this.subTypes.size(); ++i) {
                FunctionType subType = this.subTypes.get(i);
                this.subTypes.set(i, JSType.toMaybeFunctionType(subType.resolve(reporter)));
            }
        }
        return super.resolveInternal(reporter);
    }

    private ImmutableList<ObjectType> resolveTypeListHelper(ImmutableList<ObjectType> list, ErrorReporter reporter) {
        boolean changed = false;
        ImmutableList.Builder resolvedList = ImmutableList.builder();
        for (ObjectType type : list) {
            JSType rt = type.resolve(reporter);
            if (!rt.isObjectType()) {
                reporter.warning("not an object type: " + rt + " (at " + this.toString() + ")", this.source.getSourceFileName(), this.source.getLineno(), this.source.getCharno());
                continue;
            }
            ObjectType resolved = rt.toObjectType();
            resolvedList.add(resolved);
            changed |= !JSType.areIdentical(resolved, type);
        }
        return changed ? resolvedList.build() : null;
    }

    @Override
    final boolean hasAnyTemplateTypesInternal() {
        return this.getTemplateParamCount() > 0 || this.typeOfThis.hasAnyTemplateTypes() || this.call.hasAnyTemplateTypes();
    }

    public final boolean hasProperties() {
        return !super.getOwnPropertyNames().isEmpty();
    }

    public final void setImplicitMatch(boolean flag) {
        Preconditions.checkState(this.isInterface());
        this.isStructuralInterface = flag;
    }

    @Override
    public final boolean isStructuralInterface() {
        return this.isInterface() && this.isStructuralInterface;
    }

    public final boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public final Map<String, JSType> getPropertyTypeMap() {
        LinkedHashMap<String, JSType> propTypeMap = new LinkedHashMap<String, JSType>();
        FunctionType.updatePropertyTypeMap(this, propTypeMap, new HashSet<FunctionType>());
        return propTypeMap;
    }

    private static void updatePropertyTypeMap(FunctionType type, Map<String, JSType> propTypeMap, HashSet<FunctionType> cache) {
        ImmutableList<ObjectType> iterable;
        if (type == null) {
            return;
        }
        ObjectType prototype = type.getPrototype();
        if (prototype != null) {
            Set<String> propNames = prototype.getOwnPropertyNames();
            for (String name : propNames) {
                if (propTypeMap.containsKey(name)) continue;
                JSType propType = prototype.getPropertyType(name);
                propTypeMap.put(name, propType);
            }
        }
        if ((iterable = type.getExtendedInterfaces()) != null) {
            for (ObjectType interfaceType : iterable) {
                FunctionType superConstructor = interfaceType.getConstructor();
                if (superConstructor == null || cache.contains(superConstructor)) continue;
                cache.add(superConstructor);
                FunctionType.updatePropertyTypeMap(superConstructor, propTypeMap, cache);
                cache.remove(superConstructor);
            }
        }
    }

    public final List<FunctionType> checkExtendsLoop() {
        return this.checkExtendsLoop(new HashSet<FunctionType>(), new ArrayList<FunctionType>());
    }

    private List<FunctionType> checkExtendsLoop(Set<FunctionType> cache, List<FunctionType> path) {
        ImmutableList<ObjectType> iterable = this.getExtendedInterfaces();
        if (iterable != null) {
            for (ObjectType interfaceType : iterable) {
                FunctionType superConstructor = interfaceType.getConstructor();
                if (superConstructor == null) continue;
                if (cache.contains(superConstructor)) {
                    path.add(superConstructor);
                    while (!JSType.areIdentical(path.get(0), superConstructor)) {
                        path.remove(0);
                    }
                    return path;
                }
                cache.add(superConstructor);
                path.add(superConstructor);
                List<FunctionType> result = superConstructor.checkExtendsLoop(cache, path);
                if (result != null) {
                    return result;
                }
                cache.remove(superConstructor);
                path.remove(path.size() - 1);
            }
        }
        return null;
    }

    public final boolean acceptsArguments(List<? extends JSType> argumentTypes) {
        Iterator<? extends JSType> arguments = argumentTypes.iterator();
        Iterator parameters = this.getParameters().iterator();
        Parameter parameter = null;
        JSType argument = null;
        while (arguments.hasNext() && (parameters.hasNext() || parameter != null && parameter.isVariadic())) {
            if (parameters.hasNext()) {
                parameter = (Parameter)parameters.next();
            }
            if ((argument = arguments.next()).isSubtypeOf(parameter.getJSType())) continue;
            return false;
        }
        int numArgs = argumentTypes.size();
        return this.getMinArity() <= numArgs && numArgs <= this.getMaxArity();
    }

    public final FunctionType forgetParameterAndReturnTypes() {
        FunctionType result = FunctionType.builder(this.registry).withName(this.getReferenceName()).withSourceNode(this.source).withTypeOfThis(this.getInstanceType()).withKind(this.kind).withCanonicalRepresentation(this).build();
        result.setPrototypeBasedOn(this.getInstanceType());
        return result;
    }

    public final ImmutableList<TemplateType> getConstructorOnlyTemplateParameters() {
        Preconditions.checkState(this.isConstructor(), this);
        TemplateTypeMap map = this.getTemplateTypeMap();
        int ctorOnlyKeyCount = this.getTemplateParamCount() - this.getInstanceType().getTemplateParamCount();
        return map.getTemplateKeys().subList(map.size() - ctorOnlyKeyCount, map.size());
    }

    public final boolean isAmbiguousConstructor() {
        if (this.constructorAmbiguity == ConstructorAmbiguity.UNKNOWN) {
            this.constructorAmbiguity = this.calculateConstructorAmbiguity();
        }
        return this.constructorAmbiguity == ConstructorAmbiguity.IS_AMBIGUOUS_CONSTRUCTOR;
    }

    private ConstructorAmbiguity calculateConstructorAmbiguity() {
        FunctionType superConstructor;
        ConstructorAmbiguity constructorAmbiguity = this.isUnknownType() ? ConstructorAmbiguity.IS_AMBIGUOUS_CONSTRUCTOR : (this.isNativeObjectType() ? ConstructorAmbiguity.IS_UNAMBIGUOUS_CONSTRUCTOR : ((superConstructor = this.getSuperClassConstructor()) == null ? ConstructorAmbiguity.IS_AMBIGUOUS_CONSTRUCTOR : (superConstructor.isAmbiguousConstructor() ? ConstructorAmbiguity.IS_AMBIGUOUS_CONSTRUCTOR : (this.source != null ? ConstructorAmbiguity.IS_UNAMBIGUOUS_CONSTRUCTOR : (this.isDelegateProxy() ? ConstructorAmbiguity.IS_UNAMBIGUOUS_CONSTRUCTOR : ConstructorAmbiguity.IS_AMBIGUOUS_CONSTRUCTOR)))));
        return constructorAmbiguity;
    }

    private boolean isDelegateProxy() {
        return this.hasReferenceName() && this.getReferenceName().endsWith(DELEGATE_SUFFIX);
    }

    public final ClosurePrimitive getClosurePrimitive() {
        return this.closurePrimitive;
    }

    public static Builder builder(JSTypeRegistry registry) {
        return new Builder(registry);
    }

    public final FunctionType getCanonicalRepresentation() {
        return this.canonicalRepresentation;
    }

    @AutoValue
    public static abstract class Parameter
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public static Parameter create(JSType type, boolean isOptional, boolean isVariadic) {
            return new AutoValue_FunctionType_Parameter(type, isOptional, isVariadic);
        }

        public abstract JSType getJSType();

        public abstract boolean isOptional();

        public abstract boolean isVariadic();
    }

    public static final class Builder
    extends PrototypeObjectType.Builder<Builder> {
        private Node sourceNode = null;
        private List<Parameter> parameters = null;
        private JSType returnType = null;
        private JSType typeOfThis = null;
        private ObjectType setPrototypeBasedOn = null;
        private Set<TemplateType> constructorOnlyKeys = ImmutableSet.of();
        private Kind kind = Kind.ORDINARY;
        private boolean isAbstract;
        private boolean returnTypeIsInferred;
        private boolean returnsOwnInstanceType;
        private ClosurePrimitive primitiveId = null;
        private FunctionType canonicalRepresentation = null;

        private Builder(JSTypeRegistry registry) {
            super(registry);
            this.setImplicitPrototype(Preconditions.checkNotNull(registry.getNativeObjectType(JSTypeNative.FUNCTION_PROTOTYPE)));
        }

        public Builder withName(String name) {
            return (Builder)this.setName(name);
        }

        public Builder withSourceNode(Node sourceNode) {
            this.sourceNode = sourceNode;
            return this;
        }

        public Builder withParameters(List<Parameter> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder withParameters() {
            this.parameters = ImmutableList.of();
            return this;
        }

        public Builder withReturnType(JSType returnType) {
            this.returnType = returnType;
            return this;
        }

        public Builder withReturnType(JSType returnType, boolean inferred) {
            this.returnType = returnType;
            this.returnTypeIsInferred = inferred;
            return this;
        }

        Builder withReturnsOwnInstanceType() {
            this.returnsOwnInstanceType = true;
            return this;
        }

        public Builder withInferredReturnType(JSType returnType) {
            this.returnType = returnType;
            this.returnTypeIsInferred = true;
            return this;
        }

        public Builder withTypeOfThis(JSType typeOfThis) {
            this.typeOfThis = typeOfThis;
            return this;
        }

        public Builder withTemplateKeys(ImmutableList<TemplateType> templateKeys) {
            return (Builder)((Builder)this.setTemplateTypeMap(this.registry.getEmptyTemplateTypeMap().copyWithExtension(templateKeys, ImmutableList.of()))).setTemplateParamCount(templateKeys.size());
        }

        public Builder withTemplateKeys(TemplateType ... templateKeys) {
            return this.withTemplateKeys(ImmutableList.copyOf(templateKeys));
        }

        public Builder withConstructorTemplateKeys(Iterable<TemplateType> constructorOnlyKeys) {
            this.constructorOnlyKeys = ImmutableSet.copyOf(constructorOnlyKeys);
            return this;
        }

        Builder withKind(Kind kind) {
            this.kind = kind;
            return this;
        }

        public Builder forConstructor() {
            this.kind = Kind.CONSTRUCTOR;
            return this;
        }

        public Builder forInterface() {
            this.kind = Kind.INTERFACE;
            this.parameters = ImmutableList.of();
            return this;
        }

        Builder forNativeType() {
            return (Builder)this.setNative(true);
        }

        public Builder withIsAbstract(boolean isAbstract) {
            this.isAbstract = isAbstract;
            return this;
        }

        public Builder withPrototypeBasedOn(ObjectType setPrototypeBasedOn) {
            this.setPrototypeBasedOn = setPrototypeBasedOn;
            return this;
        }

        public Builder withClosurePrimitiveId(ClosurePrimitive id) {
            this.primitiveId = id;
            return this;
        }

        private Builder withCanonicalRepresentation(FunctionType representation) {
            this.canonicalRepresentation = representation;
            return this;
        }

        public Builder copyFromOtherFunction(FunctionType otherType) {
            ((Builder)((Builder)((Builder)this.setName(otherType.getReferenceName())).setNative(otherType.isNativeObjectType())).setTemplateTypeMap(otherType.getTemplateTypeMap())).setTemplateParamCount(otherType.getTemplateParamCount());
            this.sourceNode = otherType.getSource();
            this.parameters = otherType.getParameters();
            this.returnType = otherType.getReturnType();
            this.typeOfThis = otherType.getTypeOfThis();
            this.kind = otherType.getKind();
            this.returnTypeIsInferred = otherType.isReturnTypeInferred();
            this.isAbstract = otherType.isAbstract();
            this.primitiveId = otherType.getClosurePrimitive();
            return this;
        }

        @Override
        public FunctionType build() {
            switch (this.kind) {
                case CONSTRUCTOR: 
                case INTERFACE: {
                    break;
                }
                case NONE: {
                    Preconditions.checkState(this.returnsOwnInstanceType);
                    break;
                }
                case ORDINARY: {
                    Preconditions.checkState(!this.returnsOwnInstanceType);
                }
            }
            if (this.returnsOwnInstanceType) {
                Preconditions.checkState(this.returnType == null);
                Preconditions.checkState(this.typeOfThis == null);
            }
            switch (this.kind) {
                case CONSTRUCTOR: 
                case INTERFACE: {
                    break;
                }
                case ORDINARY: 
                case NONE: {
                    Preconditions.checkState(this.constructorOnlyKeys.isEmpty());
                }
            }
            return new FunctionType(this);
        }

        public FunctionType buildAndResolve() {
            return Preconditions.checkNotNull(this.build().toMaybeFunctionType());
        }
    }

    static enum ConstructorAmbiguity {
        UNKNOWN,
        IS_AMBIGUOUS_CONSTRUCTOR,
        IS_UNAMBIGUOUS_CONSTRUCTOR;

    }

    private static enum PropAccess {
        ANY,
        ANY_EXPLICIT,
        STRUCT,
        DICT;

    }

    static enum Kind {
        ORDINARY,
        CONSTRUCTOR,
        INTERFACE,
        NONE;

    }
}

