/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeClass;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.NamedType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.PrototypeObjectType;
import com.google.javascript.rhino.jstype.TypeStringBuilder;

final class InstanceObjectType
extends PrototypeObjectType {
    private static final long serialVersionUID = 1L;
    private static final JSTypeClass TYPE_CLASS = JSTypeClass.INSTANCE_OBJECT;
    private final FunctionType constructor;

    private InstanceObjectType(Builder builder) {
        super(builder);
        this.constructor = Preconditions.checkNotNull(builder.constructor);
        this.registry.getResolver().resolveIfClosed(this, TYPE_CLASS);
    }

    static Builder builderForCtor(FunctionType ctor) {
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder(ctor.registry).setName(ctor.getReferenceName())).setImplicitPrototype(null)).setNative(ctor.isNativeObjectType())).setAnonymous(ctor.isAnonymous())).setTemplateTypeMap(ctor.getTemplateTypeMap())).setTemplateParamCount(ctor.getTemplateParamCount())).setConstructor(ctor);
    }

    @Override
    JSTypeClass getTypeClass() {
        return TYPE_CLASS;
    }

    @Override
    public String getReferenceName() {
        return this.getConstructor().getReferenceName();
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return this.getConstructor().getPrototype();
    }

    @Override
    public FunctionType getConstructor() {
        return this.constructor;
    }

    @Override
    boolean defineProperty(String name, JSType type, boolean inferred, Node propertyNode) {
        ObjectType proto = this.getImplicitPrototype();
        if (proto != null && proto.hasOwnDeclaredProperty(name)) {
            return false;
        }
        return super.defineProperty(name, type, inferred, propertyNode);
    }

    @Override
    void appendTo(TypeStringBuilder sb) {
        if (!this.constructor.hasReferenceName()) {
            super.appendTo(sb);
            return;
        }
        if (sb.isForAnnotations()) {
            sb.append(this.constructor.getNormalizedReferenceName());
            return;
        }
        String name = this.constructor.getReferenceName();
        if (name.isEmpty()) {
            Node n = this.constructor.getSource();
            sb.append("<anonymous@").append(n != null ? n.getSourceFileName() : "unknown").append(":").append(Integer.toString(n != null ? n.getLineno() : 0)).append(">");
        }
        sb.append(name);
    }

    @Override
    boolean isTheObjectType() {
        return this.getConstructor().isNativeObjectType() && "Object".equals(this.getReferenceName());
    }

    @Override
    public boolean isInstanceType() {
        return true;
    }

    @Override
    public boolean isArrayType() {
        return this.getConstructor().isNativeObjectType() && "Array".equals(this.getReferenceName());
    }

    @Override
    public boolean isBigIntObjectType() {
        return this.getConstructor().isNativeObjectType() && "BigInt".equals(this.getReferenceName());
    }

    @Override
    public boolean isStringObjectType() {
        return this.getConstructor().isNativeObjectType() && "String".equals(this.getReferenceName());
    }

    @Override
    public boolean isSymbolObjectType() {
        return this.getConstructor().isNativeObjectType() && "Symbol".equals(this.getReferenceName());
    }

    @Override
    public boolean isBooleanObjectType() {
        return this.getConstructor().isNativeObjectType() && "Boolean".equals(this.getReferenceName());
    }

    @Override
    public boolean isNumberObjectType() {
        return this.getConstructor().isNativeObjectType() && "Number".equals(this.getReferenceName());
    }

    @Override
    public boolean isDateType() {
        return this.getConstructor().isNativeObjectType() && "Date".equals(this.getReferenceName());
    }

    @Override
    public boolean isRegexpType() {
        return this.getConstructor().isNativeObjectType() && "RegExp".equals(this.getReferenceName());
    }

    @Override
    public boolean isNominalType() {
        return this.hasReferenceName();
    }

    @Override
    int recursionUnsafeHashCode() {
        if (this.hasReferenceName()) {
            return NamedType.nominalHashCode(this);
        }
        return super.hashCode();
    }

    @Override
    public Iterable<ObjectType> getCtorImplementedInterfaces() {
        return this.getConstructor().getImplementedInterfaces();
    }

    @Override
    public Iterable<ObjectType> getCtorExtendedInterfaces() {
        return this.getConstructor().getExtendedInterfaces();
    }

    static final class Builder
    extends PrototypeObjectType.Builder<Builder> {
        private FunctionType constructor;

        Builder(JSTypeRegistry registry) {
            super(registry);
        }

        Builder setConstructor(FunctionType x) {
            this.constructor = x;
            return this;
        }

        @Override
        InstanceObjectType build() {
            return new InstanceObjectType(this);
        }
    }
}

