/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.MessageSource;
import io.micronaut.core.annotation.Internal;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Internal
class DefaultMessageContext
implements MessageSource.MessageContext {
    @Nullable
    private final Locale locale;
    @Nullable
    private final Map<String, Object> variables;

    DefaultMessageContext(@Nullable Locale locale, @Nullable Map<String, Object> variables) {
        this.locale = locale;
        this.variables = variables;
    }

    @Override
    @Nonnull
    public Map<String, Object> getVariables() {
        if (this.variables != null) {
            return Collections.unmodifiableMap(this.variables);
        }
        return Collections.emptyMap();
    }

    @Override
    @Nonnull
    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return Locale.getDefault();
    }
}

