/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.time.DateTimeException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.UncheckedParseException;
import org.openstreetmap.josm.tools.XmlParsingException;
import org.openstreetmap.josm.tools.date.DateUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OsmServerUserInfoReader
extends OsmServerReader {
    public static UserInfo buildFromXML(Document document) throws XmlParsingException {
        try {
            NodeList xmlNodeList;
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            UserInfo userInfo = new UserInfo();
            Node xmlNode = (Node)xpath.compile("/osm/user[1]").evaluate(document, XPathConstants.NODE);
            if (xmlNode == null) {
                throw new XmlParsingException(I18n.tr("XML tag <user> is missing.", new Object[0]));
            }
            String v = OsmServerUserInfoReader.getAttribute(xmlNode, "id");
            if (v == null) {
                throw new XmlParsingException(I18n.tr("Missing attribute ''{0}'' on XML tag ''{1}''.", "id", "user"));
            }
            try {
                userInfo.setId(Integer.parseInt(v));
            }
            catch (NumberFormatException e) {
                throw new XmlParsingException(I18n.tr("Illegal value for attribute ''{0}'' on XML tag ''{1}''. Got {2}.", "id", "user", v), e);
            }
            v = OsmServerUserInfoReader.getAttribute(xmlNode, "display_name");
            userInfo.setDisplayName(v);
            v = OsmServerUserInfoReader.getAttribute(xmlNode, "account_created");
            if (v != null) {
                userInfo.setAccountCreated(DateUtils.fromString(v));
            }
            if ((xmlNode = (Node)xpath.compile("/osm/user[1]/description[1]/text()").evaluate(document, XPathConstants.NODE)) != null) {
                userInfo.setDescription(xmlNode.getNodeValue());
            }
            if ((xmlNode = (Node)xpath.compile("/osm/user[1]/home").evaluate(document, XPathConstants.NODE)) != null) {
                int zoom;
                double lon;
                double lat;
                v = OsmServerUserInfoReader.getAttribute(xmlNode, "lat");
                if (v == null) {
                    throw new XmlParsingException(I18n.tr("Missing attribute ''{0}'' on XML tag ''{1}''.", "lat", "home"));
                }
                try {
                    lat = Double.parseDouble(v);
                }
                catch (NumberFormatException e) {
                    throw new XmlParsingException(I18n.tr("Illegal value for attribute ''{0}'' on XML tag ''{1}''. Got {2}.", "lat", "home", v), e);
                }
                v = OsmServerUserInfoReader.getAttribute(xmlNode, "lon");
                if (v == null) {
                    throw new XmlParsingException(I18n.tr("Missing attribute ''{0}'' on XML tag ''{1}''.", "lon", "home"));
                }
                try {
                    lon = Double.parseDouble(v);
                }
                catch (NumberFormatException e) {
                    throw new XmlParsingException(I18n.tr("Illegal value for attribute ''{0}'' on XML tag ''{1}''. Got {2}.", "lon", "home", v), e);
                }
                v = OsmServerUserInfoReader.getAttribute(xmlNode, "zoom");
                if (v == null) {
                    throw new XmlParsingException(I18n.tr("Missing attribute ''{0}'' on XML tag ''{1}''.", "zoom", "home"));
                }
                try {
                    zoom = Integer.parseInt(v);
                }
                catch (NumberFormatException e) {
                    throw new XmlParsingException(I18n.tr("Illegal value for attribute ''{0}'' on XML tag ''{1}''. Got {2}.", "zoom", "home", v), e);
                }
                userInfo.setHome(new LatLon(lat, lon));
                userInfo.setHomeZoom(zoom);
            }
            if ((xmlNodeList = (NodeList)xpath.compile("/osm/user[1]/languages[1]/lang/text()").evaluate(document, XPathConstants.NODESET)) != null) {
                List<String> languages = IntStream.range(0, xmlNodeList.getLength()).mapToObj(i -> xmlNodeList.item(i).getNodeValue()).collect(Collectors.toList());
                userInfo.setLanguages(languages);
            }
            if ((xmlNode = (Node)xpath.compile("/osm/user[1]/messages/received").evaluate(document, XPathConstants.NODE)) != null) {
                v = OsmServerUserInfoReader.getAttribute(xmlNode, "unread");
                if (v == null) {
                    throw new XmlParsingException(I18n.tr("Missing attribute ''{0}'' on XML tag ''{1}''.", "unread", "received"));
                }
                try {
                    userInfo.setUnreadMessages(Integer.parseInt(v));
                }
                catch (NumberFormatException e) {
                    throw new XmlParsingException(I18n.tr("Illegal value for attribute ''{0}'' on XML tag ''{1}''. Got {2}.", "unread", "received", v), e);
                }
            }
            return userInfo;
        }
        catch (DateTimeException | XPathException | UncheckedParseException e) {
            throw new XmlParsingException(e);
        }
    }

    public OsmServerUserInfoReader() {
        this.setDoAuthenticate(true);
    }

    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public UserInfo fetchUserInfo(ProgressMonitor monitor) throws OsmTransferException {
        return this.fetchUserInfo(monitor, null);
    }

    public UserInfo fetchUserInfo(ProgressMonitor monitor, String reason) throws OsmTransferException {
        return this.fetchData("user/details", I18n.tr("Reading user info ...", new Object[0]), OsmServerUserInfoReader::buildFromXML, monitor, reason);
    }
}

