#ifndef _flextgl_h_
#define _flextgl_h_
/*
    This file is part of Magnum.

    Copyright © 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019,
                2020 Vladimír Vondruš <mosra@centrum.cz>

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included
    in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
    THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
*/

#include <Corrade/Utility/VisibilityMacros.h>

#include "Magnum/configure.h"
#include "Magnum/GL/GL.h"
#include "MagnumExternal/OpenGL/KHR/khrplatform.h"

/* Defensive include guards */

#if defined(__glew_h__) || defined(__GLEW_H__)
#error Attempt to include auto-generated header after including glew.h
#endif
#if defined(__gl_h_) || defined(__GL_H__)
#error Attempt to include auto-generated header after including gl.h
#endif
#if defined(__glext_h_) || defined(__GLEXT_H_)
#error Attempt to include auto-generated header after including glext.h
#endif
#if defined(__gltypes_h_)
#error Attempt to include auto-generated header after including gltypes.h
#endif
#if defined(__gl_ATI_h_)
#error Attempt to include auto-generated header after including glATI.h
#endif

#define __glew_h__
#define __GLEW_H__
#define __gl_h_
#define __GL_H__
#define __gl3_h_
#define __glext_h_
#define __GLEXT_H_
#define __gltypes_h_
#define __gl_ATI_h_

#ifdef __cplusplus
extern "C" {
#endif

#ifndef DOXYGEN_GENERATING_OUTPUT /* So the macro names are preserved in the docs */

void flextGLInit(Magnum::GL::Context& context);

/* Function declaration macros */

#ifndef MAGNUM_BUILD_STATIC
    #ifdef FlextGL_EXPORTS
        #define FLEXTGL_EXPORT CORRADE_VISIBILITY_EXPORT
    #else
        #define FLEXTGL_EXPORT CORRADE_VISIBILITY_IMPORT
    #endif
#else
    #define FLEXTGL_EXPORT CORRADE_VISIBILITY_STATIC
#endif

#if defined(_WIN32) && !defined(APIENTRY) && !defined(__CYGWIN__) && !defined(__SCITECH_SNAP__)
#define WIN32_LEAN_AND_MEAN 1
#ifndef WINAPI
#define WINAPI __stdcall
#endif
#define APIENTRY WINAPI
#endif

#ifndef APIENTRY
#define APIENTRY
#endif

/* GL version defines. Needs to be done to avoid conflicting definitions with
   other GL headers (such as qopengl.h in Qt, which has different definition
   for GLsizei and GLintptr on Windows) */
#define GL_VERSION_1_0 1
#define GL_VERSION_1_1 1
#define GL_VERSION_1_2 1
#define GL_VERSION_1_3 1
#define GL_VERSION_1_4 1
#define GL_VERSION_1_5 1
#define GL_VERSION_2_0 1
#define GL_VERSION_2_1 1
#define GL_VERSION_3_0 1
#define GL_VERSION_3_1 1
#define GL_VERSION_3_2 1
#define GL_VERSION_3_3 1
#define GL_VERSION_4_0 1
#define GL_VERSION_4_1 1
#define GL_VERSION_4_2 1
#define GL_VERSION_4_3 1
#define GL_VERSION_4_4 1
#define GL_VERSION_4_5 1
#define GL_VERSION_4_6 1

/* Data types */

typedef unsigned int GLenum;
typedef unsigned char GLboolean;
typedef unsigned int GLbitfield;
typedef void GLvoid;
typedef khronos_int8_t GLbyte;
typedef khronos_uint8_t GLubyte;
typedef khronos_int16_t GLshort;
typedef khronos_uint16_t GLushort;
typedef int GLint;
typedef unsigned int GLuint;
typedef int GLsizei;
typedef khronos_float_t GLfloat;
typedef double GLdouble;
typedef char GLchar;
typedef khronos_uint16_t GLhalf;
typedef khronos_intptr_t GLintptr;
typedef khronos_ssize_t GLsizeiptr;
typedef khronos_int64_t GLint64;
typedef khronos_uint64_t GLuint64;
typedef khronos_uint64_t GLuint64EXT;
typedef struct __GLsync *GLsync;
typedef void (APIENTRY *GLDEBUGPROC)(GLenum source,GLenum type,GLuint id,GLenum severity,GLsizei length,const GLchar *message,const void *userParam);

/* Enums */

/* GL_VERSION_1_0 */

#define GL_DEPTH_BUFFER_BIT 0x00000100
#define GL_STENCIL_BUFFER_BIT 0x00000400
#define GL_COLOR_BUFFER_BIT 0x00004000
#define GL_FALSE 0
#define GL_TRUE 1
#define GL_POINTS 0x0000
#define GL_LINES 0x0001
#define GL_LINE_LOOP 0x0002
#define GL_LINE_STRIP 0x0003
#define GL_TRIANGLES 0x0004
#define GL_TRIANGLE_STRIP 0x0005
#define GL_TRIANGLE_FAN 0x0006
#define GL_NEVER 0x0200
#define GL_LESS 0x0201
#define GL_EQUAL 0x0202
#define GL_LEQUAL 0x0203
#define GL_GREATER 0x0204
#define GL_NOTEQUAL 0x0205
#define GL_GEQUAL 0x0206
#define GL_ALWAYS 0x0207
#define GL_ZERO 0
#define GL_ONE 1
#define GL_SRC_COLOR 0x0300
#define GL_ONE_MINUS_SRC_COLOR 0x0301
#define GL_SRC_ALPHA 0x0302
#define GL_ONE_MINUS_SRC_ALPHA 0x0303
#define GL_DST_ALPHA 0x0304
#define GL_ONE_MINUS_DST_ALPHA 0x0305
#define GL_DST_COLOR 0x0306
#define GL_ONE_MINUS_DST_COLOR 0x0307
#define GL_SRC_ALPHA_SATURATE 0x0308
#define GL_NONE 0
#define GL_FRONT_LEFT 0x0400
#define GL_FRONT_RIGHT 0x0401
#define GL_BACK_LEFT 0x0402
#define GL_BACK_RIGHT 0x0403
#define GL_FRONT 0x0404
#define GL_BACK 0x0405
#define GL_LEFT 0x0406
#define GL_RIGHT 0x0407
#define GL_FRONT_AND_BACK 0x0408
#define GL_NO_ERROR 0
#define GL_INVALID_ENUM 0x0500
#define GL_INVALID_VALUE 0x0501
#define GL_INVALID_OPERATION 0x0502
#define GL_OUT_OF_MEMORY 0x0505
#define GL_CW 0x0900
#define GL_CCW 0x0901
#define GL_POINT_SIZE 0x0B11
#define GL_POINT_SIZE_RANGE 0x0B12
#define GL_POINT_SIZE_GRANULARITY 0x0B13
#define GL_LINE_SMOOTH 0x0B20
#define GL_LINE_WIDTH 0x0B21
#define GL_LINE_WIDTH_RANGE 0x0B22
#define GL_LINE_WIDTH_GRANULARITY 0x0B23
#define GL_POLYGON_MODE 0x0B40
#define GL_POLYGON_SMOOTH 0x0B41
#define GL_CULL_FACE 0x0B44
#define GL_CULL_FACE_MODE 0x0B45
#define GL_FRONT_FACE 0x0B46
#define GL_DEPTH_RANGE 0x0B70
#define GL_DEPTH_TEST 0x0B71
#define GL_DEPTH_WRITEMASK 0x0B72
#define GL_DEPTH_CLEAR_VALUE 0x0B73
#define GL_DEPTH_FUNC 0x0B74
#define GL_STENCIL_TEST 0x0B90
#define GL_STENCIL_CLEAR_VALUE 0x0B91
#define GL_STENCIL_FUNC 0x0B92
#define GL_STENCIL_VALUE_MASK 0x0B93
#define GL_STENCIL_FAIL 0x0B94
#define GL_STENCIL_PASS_DEPTH_FAIL 0x0B95
#define GL_STENCIL_PASS_DEPTH_PASS 0x0B96
#define GL_STENCIL_REF 0x0B97
#define GL_STENCIL_WRITEMASK 0x0B98
#define GL_VIEWPORT 0x0BA2
#define GL_DITHER 0x0BD0
#define GL_BLEND_DST 0x0BE0
#define GL_BLEND_SRC 0x0BE1
#define GL_BLEND 0x0BE2
#define GL_LOGIC_OP_MODE 0x0BF0
#define GL_DRAW_BUFFER 0x0C01
#define GL_READ_BUFFER 0x0C02
#define GL_SCISSOR_BOX 0x0C10
#define GL_SCISSOR_TEST 0x0C11
#define GL_COLOR_CLEAR_VALUE 0x0C22
#define GL_COLOR_WRITEMASK 0x0C23
#define GL_DOUBLEBUFFER 0x0C32
#define GL_STEREO 0x0C33
#define GL_LINE_SMOOTH_HINT 0x0C52
#define GL_POLYGON_SMOOTH_HINT 0x0C53
#define GL_UNPACK_SWAP_BYTES 0x0CF0
#define GL_UNPACK_LSB_FIRST 0x0CF1
#define GL_UNPACK_ROW_LENGTH 0x0CF2
#define GL_UNPACK_SKIP_ROWS 0x0CF3
#define GL_UNPACK_SKIP_PIXELS 0x0CF4
#define GL_UNPACK_ALIGNMENT 0x0CF5
#define GL_PACK_SWAP_BYTES 0x0D00
#define GL_PACK_LSB_FIRST 0x0D01
#define GL_PACK_ROW_LENGTH 0x0D02
#define GL_PACK_SKIP_ROWS 0x0D03
#define GL_PACK_SKIP_PIXELS 0x0D04
#define GL_PACK_ALIGNMENT 0x0D05
#define GL_MAX_TEXTURE_SIZE 0x0D33
#define GL_MAX_VIEWPORT_DIMS 0x0D3A
#define GL_SUBPIXEL_BITS 0x0D50
#define GL_TEXTURE_1D 0x0DE0
#define GL_TEXTURE_2D 0x0DE1
#define GL_TEXTURE_WIDTH 0x1000
#define GL_TEXTURE_HEIGHT 0x1001
#define GL_TEXTURE_BORDER_COLOR 0x1004
#define GL_DONT_CARE 0x1100
#define GL_FASTEST 0x1101
#define GL_NICEST 0x1102
#define GL_BYTE 0x1400
#define GL_UNSIGNED_BYTE 0x1401
#define GL_SHORT 0x1402
#define GL_UNSIGNED_SHORT 0x1403
#define GL_INT 0x1404
#define GL_UNSIGNED_INT 0x1405
#define GL_FLOAT 0x1406
#define GL_CLEAR 0x1500
#define GL_AND 0x1501
#define GL_AND_REVERSE 0x1502
#define GL_COPY 0x1503
#define GL_AND_INVERTED 0x1504
#define GL_NOOP 0x1505
#define GL_XOR 0x1506
#define GL_OR 0x1507
#define GL_NOR 0x1508
#define GL_EQUIV 0x1509
#define GL_INVERT 0x150A
#define GL_OR_REVERSE 0x150B
#define GL_COPY_INVERTED 0x150C
#define GL_OR_INVERTED 0x150D
#define GL_NAND 0x150E
#define GL_SET 0x150F
#define GL_TEXTURE 0x1702
#define GL_COLOR 0x1800
#define GL_DEPTH 0x1801
#define GL_STENCIL 0x1802
#define GL_STENCIL_INDEX 0x1901
#define GL_DEPTH_COMPONENT 0x1902
#define GL_RED 0x1903
#define GL_GREEN 0x1904
#define GL_BLUE 0x1905
#define GL_ALPHA 0x1906
#define GL_RGB 0x1907
#define GL_RGBA 0x1908
#define GL_POINT 0x1B00
#define GL_LINE 0x1B01
#define GL_FILL 0x1B02
#define GL_KEEP 0x1E00
#define GL_REPLACE 0x1E01
#define GL_INCR 0x1E02
#define GL_DECR 0x1E03
#define GL_VENDOR 0x1F00
#define GL_RENDERER 0x1F01
#define GL_VERSION 0x1F02
#define GL_EXTENSIONS 0x1F03
#define GL_NEAREST 0x2600
#define GL_LINEAR 0x2601
#define GL_NEAREST_MIPMAP_NEAREST 0x2700
#define GL_LINEAR_MIPMAP_NEAREST 0x2701
#define GL_NEAREST_MIPMAP_LINEAR 0x2702
#define GL_LINEAR_MIPMAP_LINEAR 0x2703
#define GL_TEXTURE_MAG_FILTER 0x2800
#define GL_TEXTURE_MIN_FILTER 0x2801
#define GL_TEXTURE_WRAP_S 0x2802
#define GL_TEXTURE_WRAP_T 0x2803
#define GL_REPEAT 0x2901

/* GL_VERSION_1_1 */

#define GL_COLOR_LOGIC_OP 0x0BF2
#define GL_POLYGON_OFFSET_UNITS 0x2A00
#define GL_POLYGON_OFFSET_POINT 0x2A01
#define GL_POLYGON_OFFSET_LINE 0x2A02
#define GL_POLYGON_OFFSET_FILL 0x8037
#define GL_POLYGON_OFFSET_FACTOR 0x8038
#define GL_TEXTURE_BINDING_1D 0x8068
#define GL_TEXTURE_BINDING_2D 0x8069
#define GL_TEXTURE_INTERNAL_FORMAT 0x1003
#define GL_TEXTURE_RED_SIZE 0x805C
#define GL_TEXTURE_GREEN_SIZE 0x805D
#define GL_TEXTURE_BLUE_SIZE 0x805E
#define GL_TEXTURE_ALPHA_SIZE 0x805F
#define GL_DOUBLE 0x140A
#define GL_PROXY_TEXTURE_1D 0x8063
#define GL_PROXY_TEXTURE_2D 0x8064
#define GL_R3_G3_B2 0x2A10
#define GL_RGB4 0x804F
#define GL_RGB5 0x8050
#define GL_RGB8 0x8051
#define GL_RGB10 0x8052
#define GL_RGB12 0x8053
#define GL_RGB16 0x8054
#define GL_RGBA2 0x8055
#define GL_RGBA4 0x8056
#define GL_RGB5_A1 0x8057
#define GL_RGBA8 0x8058
#define GL_RGB10_A2 0x8059
#define GL_RGBA12 0x805A
#define GL_RGBA16 0x805B

/* GL_VERSION_1_2 */

#define GL_UNSIGNED_BYTE_3_3_2 0x8032
#define GL_UNSIGNED_SHORT_4_4_4_4 0x8033
#define GL_UNSIGNED_SHORT_5_5_5_1 0x8034
#define GL_UNSIGNED_INT_8_8_8_8 0x8035
#define GL_UNSIGNED_INT_10_10_10_2 0x8036
#define GL_TEXTURE_BINDING_3D 0x806A
#define GL_PACK_SKIP_IMAGES 0x806B
#define GL_PACK_IMAGE_HEIGHT 0x806C
#define GL_UNPACK_SKIP_IMAGES 0x806D
#define GL_UNPACK_IMAGE_HEIGHT 0x806E
#define GL_TEXTURE_3D 0x806F
#define GL_PROXY_TEXTURE_3D 0x8070
#define GL_TEXTURE_DEPTH 0x8071
#define GL_TEXTURE_WRAP_R 0x8072
#define GL_MAX_3D_TEXTURE_SIZE 0x8073
#define GL_UNSIGNED_BYTE_2_3_3_REV 0x8362
#define GL_UNSIGNED_SHORT_5_6_5 0x8363
#define GL_UNSIGNED_SHORT_5_6_5_REV 0x8364
#define GL_UNSIGNED_SHORT_4_4_4_4_REV 0x8365
#define GL_UNSIGNED_SHORT_1_5_5_5_REV 0x8366
#define GL_UNSIGNED_INT_8_8_8_8_REV 0x8367
#define GL_UNSIGNED_INT_2_10_10_10_REV 0x8368
#define GL_BGR 0x80E0
#define GL_BGRA 0x80E1
#define GL_MAX_ELEMENTS_VERTICES 0x80E8
#define GL_MAX_ELEMENTS_INDICES 0x80E9
#define GL_CLAMP_TO_EDGE 0x812F
#define GL_TEXTURE_MIN_LOD 0x813A
#define GL_TEXTURE_MAX_LOD 0x813B
#define GL_TEXTURE_BASE_LEVEL 0x813C
#define GL_TEXTURE_MAX_LEVEL 0x813D
#define GL_SMOOTH_POINT_SIZE_RANGE 0x0B12
#define GL_SMOOTH_POINT_SIZE_GRANULARITY 0x0B13
#define GL_SMOOTH_LINE_WIDTH_RANGE 0x0B22
#define GL_SMOOTH_LINE_WIDTH_GRANULARITY 0x0B23
#define GL_ALIASED_LINE_WIDTH_RANGE 0x846E

/* GL_VERSION_1_3 */

#define GL_TEXTURE0 0x84C0
#define GL_TEXTURE1 0x84C1
#define GL_TEXTURE2 0x84C2
#define GL_TEXTURE3 0x84C3
#define GL_TEXTURE4 0x84C4
#define GL_TEXTURE5 0x84C5
#define GL_TEXTURE6 0x84C6
#define GL_TEXTURE7 0x84C7
#define GL_TEXTURE8 0x84C8
#define GL_TEXTURE9 0x84C9
#define GL_TEXTURE10 0x84CA
#define GL_TEXTURE11 0x84CB
#define GL_TEXTURE12 0x84CC
#define GL_TEXTURE13 0x84CD
#define GL_TEXTURE14 0x84CE
#define GL_TEXTURE15 0x84CF
#define GL_TEXTURE16 0x84D0
#define GL_TEXTURE17 0x84D1
#define GL_TEXTURE18 0x84D2
#define GL_TEXTURE19 0x84D3
#define GL_TEXTURE20 0x84D4
#define GL_TEXTURE21 0x84D5
#define GL_TEXTURE22 0x84D6
#define GL_TEXTURE23 0x84D7
#define GL_TEXTURE24 0x84D8
#define GL_TEXTURE25 0x84D9
#define GL_TEXTURE26 0x84DA
#define GL_TEXTURE27 0x84DB
#define GL_TEXTURE28 0x84DC
#define GL_TEXTURE29 0x84DD
#define GL_TEXTURE30 0x84DE
#define GL_TEXTURE31 0x84DF
#define GL_ACTIVE_TEXTURE 0x84E0
#define GL_MULTISAMPLE 0x809D
#define GL_SAMPLE_ALPHA_TO_COVERAGE 0x809E
#define GL_SAMPLE_ALPHA_TO_ONE 0x809F
#define GL_SAMPLE_COVERAGE 0x80A0
#define GL_SAMPLE_BUFFERS 0x80A8
#define GL_SAMPLES 0x80A9
#define GL_SAMPLE_COVERAGE_VALUE 0x80AA
#define GL_SAMPLE_COVERAGE_INVERT 0x80AB
#define GL_TEXTURE_CUBE_MAP 0x8513
#define GL_TEXTURE_BINDING_CUBE_MAP 0x8514
#define GL_TEXTURE_CUBE_MAP_POSITIVE_X 0x8515
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_X 0x8516
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Y 0x8517
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Y 0x8518
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Z 0x8519
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Z 0x851A
#define GL_PROXY_TEXTURE_CUBE_MAP 0x851B
#define GL_MAX_CUBE_MAP_TEXTURE_SIZE 0x851C
#define GL_COMPRESSED_RGB 0x84ED
#define GL_COMPRESSED_RGBA 0x84EE
#define GL_TEXTURE_COMPRESSION_HINT 0x84EF
#define GL_TEXTURE_COMPRESSED_IMAGE_SIZE 0x86A0
#define GL_TEXTURE_COMPRESSED 0x86A1
#define GL_NUM_COMPRESSED_TEXTURE_FORMATS 0x86A2
#define GL_COMPRESSED_TEXTURE_FORMATS 0x86A3
#define GL_CLAMP_TO_BORDER 0x812D

/* GL_VERSION_1_4 */

#define GL_BLEND_DST_RGB 0x80C8
#define GL_BLEND_SRC_RGB 0x80C9
#define GL_BLEND_DST_ALPHA 0x80CA
#define GL_BLEND_SRC_ALPHA 0x80CB
#define GL_POINT_FADE_THRESHOLD_SIZE 0x8128
#define GL_DEPTH_COMPONENT16 0x81A5
#define GL_DEPTH_COMPONENT24 0x81A6
#define GL_DEPTH_COMPONENT32 0x81A7
#define GL_MIRRORED_REPEAT 0x8370
#define GL_MAX_TEXTURE_LOD_BIAS 0x84FD
#define GL_TEXTURE_LOD_BIAS 0x8501
#define GL_INCR_WRAP 0x8507
#define GL_DECR_WRAP 0x8508
#define GL_TEXTURE_DEPTH_SIZE 0x884A
#define GL_TEXTURE_COMPARE_MODE 0x884C
#define GL_TEXTURE_COMPARE_FUNC 0x884D
#define GL_BLEND_COLOR 0x8005
#define GL_BLEND_EQUATION 0x8009
#define GL_CONSTANT_COLOR 0x8001
#define GL_ONE_MINUS_CONSTANT_COLOR 0x8002
#define GL_CONSTANT_ALPHA 0x8003
#define GL_ONE_MINUS_CONSTANT_ALPHA 0x8004
#define GL_FUNC_ADD 0x8006
#define GL_FUNC_REVERSE_SUBTRACT 0x800B
#define GL_FUNC_SUBTRACT 0x800A
#define GL_MIN 0x8007
#define GL_MAX 0x8008

/* GL_VERSION_1_5 */

#define GL_BUFFER_SIZE 0x8764
#define GL_BUFFER_USAGE 0x8765
#define GL_QUERY_COUNTER_BITS 0x8864
#define GL_CURRENT_QUERY 0x8865
#define GL_QUERY_RESULT 0x8866
#define GL_QUERY_RESULT_AVAILABLE 0x8867
#define GL_ARRAY_BUFFER 0x8892
#define GL_ELEMENT_ARRAY_BUFFER 0x8893
#define GL_ARRAY_BUFFER_BINDING 0x8894
#define GL_ELEMENT_ARRAY_BUFFER_BINDING 0x8895
#define GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING 0x889F
#define GL_READ_ONLY 0x88B8
#define GL_WRITE_ONLY 0x88B9
#define GL_READ_WRITE 0x88BA
#define GL_BUFFER_ACCESS 0x88BB
#define GL_BUFFER_MAPPED 0x88BC
#define GL_BUFFER_MAP_POINTER 0x88BD
#define GL_STREAM_DRAW 0x88E0
#define GL_STREAM_READ 0x88E1
#define GL_STREAM_COPY 0x88E2
#define GL_STATIC_DRAW 0x88E4
#define GL_STATIC_READ 0x88E5
#define GL_STATIC_COPY 0x88E6
#define GL_DYNAMIC_DRAW 0x88E8
#define GL_DYNAMIC_READ 0x88E9
#define GL_DYNAMIC_COPY 0x88EA
#define GL_SAMPLES_PASSED 0x8914
#define GL_SRC1_ALPHA 0x8589

/* GL_VERSION_2_0 */

#define GL_BLEND_EQUATION_RGB 0x8009
#define GL_VERTEX_ATTRIB_ARRAY_ENABLED 0x8622
#define GL_VERTEX_ATTRIB_ARRAY_SIZE 0x8623
#define GL_VERTEX_ATTRIB_ARRAY_STRIDE 0x8624
#define GL_VERTEX_ATTRIB_ARRAY_TYPE 0x8625
#define GL_CURRENT_VERTEX_ATTRIB 0x8626
#define GL_VERTEX_PROGRAM_POINT_SIZE 0x8642
#define GL_VERTEX_ATTRIB_ARRAY_POINTER 0x8645
#define GL_STENCIL_BACK_FUNC 0x8800
#define GL_STENCIL_BACK_FAIL 0x8801
#define GL_STENCIL_BACK_PASS_DEPTH_FAIL 0x8802
#define GL_STENCIL_BACK_PASS_DEPTH_PASS 0x8803
#define GL_MAX_DRAW_BUFFERS 0x8824
#define GL_DRAW_BUFFER0 0x8825
#define GL_DRAW_BUFFER1 0x8826
#define GL_DRAW_BUFFER2 0x8827
#define GL_DRAW_BUFFER3 0x8828
#define GL_DRAW_BUFFER4 0x8829
#define GL_DRAW_BUFFER5 0x882A
#define GL_DRAW_BUFFER6 0x882B
#define GL_DRAW_BUFFER7 0x882C
#define GL_DRAW_BUFFER8 0x882D
#define GL_DRAW_BUFFER9 0x882E
#define GL_DRAW_BUFFER10 0x882F
#define GL_DRAW_BUFFER11 0x8830
#define GL_DRAW_BUFFER12 0x8831
#define GL_DRAW_BUFFER13 0x8832
#define GL_DRAW_BUFFER14 0x8833
#define GL_DRAW_BUFFER15 0x8834
#define GL_BLEND_EQUATION_ALPHA 0x883D
#define GL_MAX_VERTEX_ATTRIBS 0x8869
#define GL_VERTEX_ATTRIB_ARRAY_NORMALIZED 0x886A
#define GL_MAX_TEXTURE_IMAGE_UNITS 0x8872
#define GL_FRAGMENT_SHADER 0x8B30
#define GL_VERTEX_SHADER 0x8B31
#define GL_MAX_FRAGMENT_UNIFORM_COMPONENTS 0x8B49
#define GL_MAX_VERTEX_UNIFORM_COMPONENTS 0x8B4A
#define GL_MAX_VARYING_FLOATS 0x8B4B
#define GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS 0x8B4C
#define GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS 0x8B4D
#define GL_SHADER_TYPE 0x8B4F
#define GL_FLOAT_VEC2 0x8B50
#define GL_FLOAT_VEC3 0x8B51
#define GL_FLOAT_VEC4 0x8B52
#define GL_INT_VEC2 0x8B53
#define GL_INT_VEC3 0x8B54
#define GL_INT_VEC4 0x8B55
#define GL_BOOL 0x8B56
#define GL_BOOL_VEC2 0x8B57
#define GL_BOOL_VEC3 0x8B58
#define GL_BOOL_VEC4 0x8B59
#define GL_FLOAT_MAT2 0x8B5A
#define GL_FLOAT_MAT3 0x8B5B
#define GL_FLOAT_MAT4 0x8B5C
#define GL_SAMPLER_1D 0x8B5D
#define GL_SAMPLER_2D 0x8B5E
#define GL_SAMPLER_3D 0x8B5F
#define GL_SAMPLER_CUBE 0x8B60
#define GL_SAMPLER_1D_SHADOW 0x8B61
#define GL_SAMPLER_2D_SHADOW 0x8B62
#define GL_DELETE_STATUS 0x8B80
#define GL_COMPILE_STATUS 0x8B81
#define GL_LINK_STATUS 0x8B82
#define GL_VALIDATE_STATUS 0x8B83
#define GL_INFO_LOG_LENGTH 0x8B84
#define GL_ATTACHED_SHADERS 0x8B85
#define GL_ACTIVE_UNIFORMS 0x8B86
#define GL_ACTIVE_UNIFORM_MAX_LENGTH 0x8B87
#define GL_SHADER_SOURCE_LENGTH 0x8B88
#define GL_ACTIVE_ATTRIBUTES 0x8B89
#define GL_ACTIVE_ATTRIBUTE_MAX_LENGTH 0x8B8A
#define GL_FRAGMENT_SHADER_DERIVATIVE_HINT 0x8B8B
#define GL_SHADING_LANGUAGE_VERSION 0x8B8C
#define GL_CURRENT_PROGRAM 0x8B8D
#define GL_POINT_SPRITE_COORD_ORIGIN 0x8CA0
#define GL_LOWER_LEFT 0x8CA1
#define GL_UPPER_LEFT 0x8CA2
#define GL_STENCIL_BACK_REF 0x8CA3
#define GL_STENCIL_BACK_VALUE_MASK 0x8CA4
#define GL_STENCIL_BACK_WRITEMASK 0x8CA5

/* GL_VERSION_2_1 */

#define GL_PIXEL_PACK_BUFFER 0x88EB
#define GL_PIXEL_UNPACK_BUFFER 0x88EC
#define GL_PIXEL_PACK_BUFFER_BINDING 0x88ED
#define GL_PIXEL_UNPACK_BUFFER_BINDING 0x88EF
#define GL_FLOAT_MAT2x3 0x8B65
#define GL_FLOAT_MAT2x4 0x8B66
#define GL_FLOAT_MAT3x2 0x8B67
#define GL_FLOAT_MAT3x4 0x8B68
#define GL_FLOAT_MAT4x2 0x8B69
#define GL_FLOAT_MAT4x3 0x8B6A
#define GL_SRGB 0x8C40
#define GL_SRGB8 0x8C41
#define GL_SRGB_ALPHA 0x8C42
#define GL_SRGB8_ALPHA8 0x8C43
#define GL_COMPRESSED_SRGB 0x8C48
#define GL_COMPRESSED_SRGB_ALPHA 0x8C49

/* GL_VERSION_3_0 */

#define GL_COMPARE_REF_TO_TEXTURE 0x884E
#define GL_CLIP_DISTANCE0 0x3000
#define GL_CLIP_DISTANCE1 0x3001
#define GL_CLIP_DISTANCE2 0x3002
#define GL_CLIP_DISTANCE3 0x3003
#define GL_CLIP_DISTANCE4 0x3004
#define GL_CLIP_DISTANCE5 0x3005
#define GL_CLIP_DISTANCE6 0x3006
#define GL_CLIP_DISTANCE7 0x3007
#define GL_MAX_CLIP_DISTANCES 0x0D32
#define GL_MAJOR_VERSION 0x821B
#define GL_MINOR_VERSION 0x821C
#define GL_NUM_EXTENSIONS 0x821D
#define GL_CONTEXT_FLAGS 0x821E
#define GL_COMPRESSED_RED 0x8225
#define GL_COMPRESSED_RG 0x8226
#define GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT 0x00000001
#define GL_RGBA32F 0x8814
#define GL_RGB32F 0x8815
#define GL_RGBA16F 0x881A
#define GL_RGB16F 0x881B
#define GL_VERTEX_ATTRIB_ARRAY_INTEGER 0x88FD
#define GL_MAX_ARRAY_TEXTURE_LAYERS 0x88FF
#define GL_MIN_PROGRAM_TEXEL_OFFSET 0x8904
#define GL_MAX_PROGRAM_TEXEL_OFFSET 0x8905
#define GL_CLAMP_READ_COLOR 0x891C
#define GL_FIXED_ONLY 0x891D
#define GL_MAX_VARYING_COMPONENTS 0x8B4B
#define GL_TEXTURE_1D_ARRAY 0x8C18
#define GL_PROXY_TEXTURE_1D_ARRAY 0x8C19
#define GL_TEXTURE_2D_ARRAY 0x8C1A
#define GL_PROXY_TEXTURE_2D_ARRAY 0x8C1B
#define GL_TEXTURE_BINDING_1D_ARRAY 0x8C1C
#define GL_TEXTURE_BINDING_2D_ARRAY 0x8C1D
#define GL_R11F_G11F_B10F 0x8C3A
#define GL_UNSIGNED_INT_10F_11F_11F_REV 0x8C3B
#define GL_RGB9_E5 0x8C3D
#define GL_UNSIGNED_INT_5_9_9_9_REV 0x8C3E
#define GL_TEXTURE_SHARED_SIZE 0x8C3F
#define GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH 0x8C76
#define GL_TRANSFORM_FEEDBACK_BUFFER_MODE 0x8C7F
#define GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS 0x8C80
#define GL_TRANSFORM_FEEDBACK_VARYINGS 0x8C83
#define GL_TRANSFORM_FEEDBACK_BUFFER_START 0x8C84
#define GL_TRANSFORM_FEEDBACK_BUFFER_SIZE 0x8C85
#define GL_PRIMITIVES_GENERATED 0x8C87
#define GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN 0x8C88
#define GL_RASTERIZER_DISCARD 0x8C89
#define GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS 0x8C8A
#define GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS 0x8C8B
#define GL_INTERLEAVED_ATTRIBS 0x8C8C
#define GL_SEPARATE_ATTRIBS 0x8C8D
#define GL_TRANSFORM_FEEDBACK_BUFFER 0x8C8E
#define GL_TRANSFORM_FEEDBACK_BUFFER_BINDING 0x8C8F
#define GL_RGBA32UI 0x8D70
#define GL_RGB32UI 0x8D71
#define GL_RGBA16UI 0x8D76
#define GL_RGB16UI 0x8D77
#define GL_RGBA8UI 0x8D7C
#define GL_RGB8UI 0x8D7D
#define GL_RGBA32I 0x8D82
#define GL_RGB32I 0x8D83
#define GL_RGBA16I 0x8D88
#define GL_RGB16I 0x8D89
#define GL_RGBA8I 0x8D8E
#define GL_RGB8I 0x8D8F
#define GL_RED_INTEGER 0x8D94
#define GL_GREEN_INTEGER 0x8D95
#define GL_BLUE_INTEGER 0x8D96
#define GL_RGB_INTEGER 0x8D98
#define GL_RGBA_INTEGER 0x8D99
#define GL_BGR_INTEGER 0x8D9A
#define GL_BGRA_INTEGER 0x8D9B
#define GL_SAMPLER_1D_ARRAY 0x8DC0
#define GL_SAMPLER_2D_ARRAY 0x8DC1
#define GL_SAMPLER_1D_ARRAY_SHADOW 0x8DC3
#define GL_SAMPLER_2D_ARRAY_SHADOW 0x8DC4
#define GL_SAMPLER_CUBE_SHADOW 0x8DC5
#define GL_UNSIGNED_INT_VEC2 0x8DC6
#define GL_UNSIGNED_INT_VEC3 0x8DC7
#define GL_UNSIGNED_INT_VEC4 0x8DC8
#define GL_INT_SAMPLER_1D 0x8DC9
#define GL_INT_SAMPLER_2D 0x8DCA
#define GL_INT_SAMPLER_3D 0x8DCB
#define GL_INT_SAMPLER_CUBE 0x8DCC
#define GL_INT_SAMPLER_1D_ARRAY 0x8DCE
#define GL_INT_SAMPLER_2D_ARRAY 0x8DCF
#define GL_UNSIGNED_INT_SAMPLER_1D 0x8DD1
#define GL_UNSIGNED_INT_SAMPLER_2D 0x8DD2
#define GL_UNSIGNED_INT_SAMPLER_3D 0x8DD3
#define GL_UNSIGNED_INT_SAMPLER_CUBE 0x8DD4
#define GL_UNSIGNED_INT_SAMPLER_1D_ARRAY 0x8DD6
#define GL_UNSIGNED_INT_SAMPLER_2D_ARRAY 0x8DD7
#define GL_QUERY_WAIT 0x8E13
#define GL_QUERY_NO_WAIT 0x8E14
#define GL_QUERY_BY_REGION_WAIT 0x8E15
#define GL_QUERY_BY_REGION_NO_WAIT 0x8E16
#define GL_BUFFER_ACCESS_FLAGS 0x911F
#define GL_BUFFER_MAP_LENGTH 0x9120
#define GL_BUFFER_MAP_OFFSET 0x9121
#define GL_DEPTH_COMPONENT32F 0x8CAC
#define GL_DEPTH32F_STENCIL8 0x8CAD
#define GL_FLOAT_32_UNSIGNED_INT_24_8_REV 0x8DAD
#define GL_INVALID_FRAMEBUFFER_OPERATION 0x0506
#define GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING 0x8210
#define GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE 0x8211
#define GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE 0x8212
#define GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE 0x8213
#define GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE 0x8214
#define GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE 0x8215
#define GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE 0x8216
#define GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE 0x8217
#define GL_FRAMEBUFFER_DEFAULT 0x8218
#define GL_FRAMEBUFFER_UNDEFINED 0x8219
#define GL_DEPTH_STENCIL_ATTACHMENT 0x821A
#define GL_MAX_RENDERBUFFER_SIZE 0x84E8
#define GL_DEPTH_STENCIL 0x84F9
#define GL_UNSIGNED_INT_24_8 0x84FA
#define GL_DEPTH24_STENCIL8 0x88F0
#define GL_TEXTURE_STENCIL_SIZE 0x88F1
#define GL_TEXTURE_RED_TYPE 0x8C10
#define GL_TEXTURE_GREEN_TYPE 0x8C11
#define GL_TEXTURE_BLUE_TYPE 0x8C12
#define GL_TEXTURE_ALPHA_TYPE 0x8C13
#define GL_TEXTURE_DEPTH_TYPE 0x8C16
#define GL_UNSIGNED_NORMALIZED 0x8C17
#define GL_FRAMEBUFFER_BINDING 0x8CA6
#define GL_DRAW_FRAMEBUFFER_BINDING 0x8CA6
#define GL_RENDERBUFFER_BINDING 0x8CA7
#define GL_READ_FRAMEBUFFER 0x8CA8
#define GL_DRAW_FRAMEBUFFER 0x8CA9
#define GL_READ_FRAMEBUFFER_BINDING 0x8CAA
#define GL_RENDERBUFFER_SAMPLES 0x8CAB
#define GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE 0x8CD0
#define GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME 0x8CD1
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL 0x8CD2
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE 0x8CD3
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER 0x8CD4
#define GL_FRAMEBUFFER_COMPLETE 0x8CD5
#define GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT 0x8CD6
#define GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT 0x8CD7
#define GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER 0x8CDB
#define GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER 0x8CDC
#define GL_FRAMEBUFFER_UNSUPPORTED 0x8CDD
#define GL_MAX_COLOR_ATTACHMENTS 0x8CDF
#define GL_COLOR_ATTACHMENT0 0x8CE0
#define GL_COLOR_ATTACHMENT1 0x8CE1
#define GL_COLOR_ATTACHMENT2 0x8CE2
#define GL_COLOR_ATTACHMENT3 0x8CE3
#define GL_COLOR_ATTACHMENT4 0x8CE4
#define GL_COLOR_ATTACHMENT5 0x8CE5
#define GL_COLOR_ATTACHMENT6 0x8CE6
#define GL_COLOR_ATTACHMENT7 0x8CE7
#define GL_COLOR_ATTACHMENT8 0x8CE8
#define GL_COLOR_ATTACHMENT9 0x8CE9
#define GL_COLOR_ATTACHMENT10 0x8CEA
#define GL_COLOR_ATTACHMENT11 0x8CEB
#define GL_COLOR_ATTACHMENT12 0x8CEC
#define GL_COLOR_ATTACHMENT13 0x8CED
#define GL_COLOR_ATTACHMENT14 0x8CEE
#define GL_COLOR_ATTACHMENT15 0x8CEF
#define GL_COLOR_ATTACHMENT16 0x8CF0
#define GL_COLOR_ATTACHMENT17 0x8CF1
#define GL_COLOR_ATTACHMENT18 0x8CF2
#define GL_COLOR_ATTACHMENT19 0x8CF3
#define GL_COLOR_ATTACHMENT20 0x8CF4
#define GL_COLOR_ATTACHMENT21 0x8CF5
#define GL_COLOR_ATTACHMENT22 0x8CF6
#define GL_COLOR_ATTACHMENT23 0x8CF7
#define GL_COLOR_ATTACHMENT24 0x8CF8
#define GL_COLOR_ATTACHMENT25 0x8CF9
#define GL_COLOR_ATTACHMENT26 0x8CFA
#define GL_COLOR_ATTACHMENT27 0x8CFB
#define GL_COLOR_ATTACHMENT28 0x8CFC
#define GL_COLOR_ATTACHMENT29 0x8CFD
#define GL_COLOR_ATTACHMENT30 0x8CFE
#define GL_COLOR_ATTACHMENT31 0x8CFF
#define GL_DEPTH_ATTACHMENT 0x8D00
#define GL_STENCIL_ATTACHMENT 0x8D20
#define GL_FRAMEBUFFER 0x8D40
#define GL_RENDERBUFFER 0x8D41
#define GL_RENDERBUFFER_WIDTH 0x8D42
#define GL_RENDERBUFFER_HEIGHT 0x8D43
#define GL_RENDERBUFFER_INTERNAL_FORMAT 0x8D44
#define GL_STENCIL_INDEX1 0x8D46
#define GL_STENCIL_INDEX4 0x8D47
#define GL_STENCIL_INDEX8 0x8D48
#define GL_STENCIL_INDEX16 0x8D49
#define GL_RENDERBUFFER_RED_SIZE 0x8D50
#define GL_RENDERBUFFER_GREEN_SIZE 0x8D51
#define GL_RENDERBUFFER_BLUE_SIZE 0x8D52
#define GL_RENDERBUFFER_ALPHA_SIZE 0x8D53
#define GL_RENDERBUFFER_DEPTH_SIZE 0x8D54
#define GL_RENDERBUFFER_STENCIL_SIZE 0x8D55
#define GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE 0x8D56
#define GL_MAX_SAMPLES 0x8D57
#define GL_FRAMEBUFFER_SRGB 0x8DB9
#define GL_HALF_FLOAT 0x140B
#define GL_MAP_READ_BIT 0x0001
#define GL_MAP_WRITE_BIT 0x0002
#define GL_MAP_INVALIDATE_RANGE_BIT 0x0004
#define GL_MAP_INVALIDATE_BUFFER_BIT 0x0008
#define GL_MAP_FLUSH_EXPLICIT_BIT 0x0010
#define GL_MAP_UNSYNCHRONIZED_BIT 0x0020
#define GL_COMPRESSED_RED_RGTC1 0x8DBB
#define GL_COMPRESSED_SIGNED_RED_RGTC1 0x8DBC
#define GL_COMPRESSED_RG_RGTC2 0x8DBD
#define GL_COMPRESSED_SIGNED_RG_RGTC2 0x8DBE
#define GL_RG 0x8227
#define GL_RG_INTEGER 0x8228
#define GL_R8 0x8229
#define GL_R16 0x822A
#define GL_RG8 0x822B
#define GL_RG16 0x822C
#define GL_R16F 0x822D
#define GL_R32F 0x822E
#define GL_RG16F 0x822F
#define GL_RG32F 0x8230
#define GL_R8I 0x8231
#define GL_R8UI 0x8232
#define GL_R16I 0x8233
#define GL_R16UI 0x8234
#define GL_R32I 0x8235
#define GL_R32UI 0x8236
#define GL_RG8I 0x8237
#define GL_RG8UI 0x8238
#define GL_RG16I 0x8239
#define GL_RG16UI 0x823A
#define GL_RG32I 0x823B
#define GL_RG32UI 0x823C
#define GL_VERTEX_ARRAY_BINDING 0x85B5

/* GL_VERSION_3_1 */

#define GL_SAMPLER_2D_RECT 0x8B63
#define GL_SAMPLER_2D_RECT_SHADOW 0x8B64
#define GL_SAMPLER_BUFFER 0x8DC2
#define GL_INT_SAMPLER_2D_RECT 0x8DCD
#define GL_INT_SAMPLER_BUFFER 0x8DD0
#define GL_UNSIGNED_INT_SAMPLER_2D_RECT 0x8DD5
#define GL_UNSIGNED_INT_SAMPLER_BUFFER 0x8DD8
#define GL_TEXTURE_BUFFER 0x8C2A
#define GL_MAX_TEXTURE_BUFFER_SIZE 0x8C2B
#define GL_TEXTURE_BINDING_BUFFER 0x8C2C
#define GL_TEXTURE_BUFFER_DATA_STORE_BINDING 0x8C2D
#define GL_TEXTURE_RECTANGLE 0x84F5
#define GL_TEXTURE_BINDING_RECTANGLE 0x84F6
#define GL_PROXY_TEXTURE_RECTANGLE 0x84F7
#define GL_MAX_RECTANGLE_TEXTURE_SIZE 0x84F8
#define GL_R8_SNORM 0x8F94
#define GL_RG8_SNORM 0x8F95
#define GL_RGB8_SNORM 0x8F96
#define GL_RGBA8_SNORM 0x8F97
#define GL_R16_SNORM 0x8F98
#define GL_RG16_SNORM 0x8F99
#define GL_RGB16_SNORM 0x8F9A
#define GL_RGBA16_SNORM 0x8F9B
#define GL_SIGNED_NORMALIZED 0x8F9C
#define GL_PRIMITIVE_RESTART 0x8F9D
#define GL_PRIMITIVE_RESTART_INDEX 0x8F9E
#define GL_COPY_READ_BUFFER 0x8F36
#define GL_COPY_WRITE_BUFFER 0x8F37
#define GL_UNIFORM_BUFFER 0x8A11
#define GL_UNIFORM_BUFFER_BINDING 0x8A28
#define GL_UNIFORM_BUFFER_START 0x8A29
#define GL_UNIFORM_BUFFER_SIZE 0x8A2A
#define GL_MAX_VERTEX_UNIFORM_BLOCKS 0x8A2B
#define GL_MAX_GEOMETRY_UNIFORM_BLOCKS 0x8A2C
#define GL_MAX_FRAGMENT_UNIFORM_BLOCKS 0x8A2D
#define GL_MAX_COMBINED_UNIFORM_BLOCKS 0x8A2E
#define GL_MAX_UNIFORM_BUFFER_BINDINGS 0x8A2F
#define GL_MAX_UNIFORM_BLOCK_SIZE 0x8A30
#define GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS 0x8A31
#define GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS 0x8A32
#define GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS 0x8A33
#define GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT 0x8A34
#define GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH 0x8A35
#define GL_ACTIVE_UNIFORM_BLOCKS 0x8A36
#define GL_UNIFORM_TYPE 0x8A37
#define GL_UNIFORM_SIZE 0x8A38
#define GL_UNIFORM_NAME_LENGTH 0x8A39
#define GL_UNIFORM_BLOCK_INDEX 0x8A3A
#define GL_UNIFORM_OFFSET 0x8A3B
#define GL_UNIFORM_ARRAY_STRIDE 0x8A3C
#define GL_UNIFORM_MATRIX_STRIDE 0x8A3D
#define GL_UNIFORM_IS_ROW_MAJOR 0x8A3E
#define GL_UNIFORM_BLOCK_BINDING 0x8A3F
#define GL_UNIFORM_BLOCK_DATA_SIZE 0x8A40
#define GL_UNIFORM_BLOCK_NAME_LENGTH 0x8A41
#define GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS 0x8A42
#define GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES 0x8A43
#define GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER 0x8A44
#define GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER 0x8A45
#define GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER 0x8A46
#define GL_INVALID_INDEX 0xFFFFFFFFu

/* GL_VERSION_3_2 */

#define GL_CONTEXT_CORE_PROFILE_BIT 0x00000001
#define GL_CONTEXT_COMPATIBILITY_PROFILE_BIT 0x00000002
#define GL_LINES_ADJACENCY 0x000A
#define GL_LINE_STRIP_ADJACENCY 0x000B
#define GL_TRIANGLES_ADJACENCY 0x000C
#define GL_TRIANGLE_STRIP_ADJACENCY 0x000D
#define GL_PROGRAM_POINT_SIZE 0x8642
#define GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS 0x8C29
#define GL_FRAMEBUFFER_ATTACHMENT_LAYERED 0x8DA7
#define GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS 0x8DA8
#define GL_GEOMETRY_SHADER 0x8DD9
#define GL_GEOMETRY_VERTICES_OUT 0x8916
#define GL_GEOMETRY_INPUT_TYPE 0x8917
#define GL_GEOMETRY_OUTPUT_TYPE 0x8918
#define GL_MAX_GEOMETRY_UNIFORM_COMPONENTS 0x8DDF
#define GL_MAX_GEOMETRY_OUTPUT_VERTICES 0x8DE0
#define GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS 0x8DE1
#define GL_MAX_VERTEX_OUTPUT_COMPONENTS 0x9122
#define GL_MAX_GEOMETRY_INPUT_COMPONENTS 0x9123
#define GL_MAX_GEOMETRY_OUTPUT_COMPONENTS 0x9124
#define GL_MAX_FRAGMENT_INPUT_COMPONENTS 0x9125
#define GL_CONTEXT_PROFILE_MASK 0x9126
#define GL_DEPTH_CLAMP 0x864F
#define GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION 0x8E4C
#define GL_FIRST_VERTEX_CONVENTION 0x8E4D
#define GL_LAST_VERTEX_CONVENTION 0x8E4E
#define GL_PROVOKING_VERTEX 0x8E4F
#define GL_TEXTURE_CUBE_MAP_SEAMLESS 0x884F
#define GL_MAX_SERVER_WAIT_TIMEOUT 0x9111
#define GL_OBJECT_TYPE 0x9112
#define GL_SYNC_CONDITION 0x9113
#define GL_SYNC_STATUS 0x9114
#define GL_SYNC_FLAGS 0x9115
#define GL_SYNC_FENCE 0x9116
#define GL_SYNC_GPU_COMMANDS_COMPLETE 0x9117
#define GL_UNSIGNALED 0x9118
#define GL_SIGNALED 0x9119
#define GL_ALREADY_SIGNALED 0x911A
#define GL_TIMEOUT_EXPIRED 0x911B
#define GL_CONDITION_SATISFIED 0x911C
#define GL_WAIT_FAILED 0x911D
#define GL_TIMEOUT_IGNORED 0xFFFFFFFFFFFFFFFFull
#define GL_SYNC_FLUSH_COMMANDS_BIT 0x00000001
#define GL_SAMPLE_POSITION 0x8E50
#define GL_SAMPLE_MASK 0x8E51
#define GL_SAMPLE_MASK_VALUE 0x8E52
#define GL_MAX_SAMPLE_MASK_WORDS 0x8E59
#define GL_TEXTURE_2D_MULTISAMPLE 0x9100
#define GL_PROXY_TEXTURE_2D_MULTISAMPLE 0x9101
#define GL_TEXTURE_2D_MULTISAMPLE_ARRAY 0x9102
#define GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY 0x9103
#define GL_TEXTURE_BINDING_2D_MULTISAMPLE 0x9104
#define GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY 0x9105
#define GL_TEXTURE_SAMPLES 0x9106
#define GL_TEXTURE_FIXED_SAMPLE_LOCATIONS 0x9107
#define GL_SAMPLER_2D_MULTISAMPLE 0x9108
#define GL_INT_SAMPLER_2D_MULTISAMPLE 0x9109
#define GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE 0x910A
#define GL_SAMPLER_2D_MULTISAMPLE_ARRAY 0x910B
#define GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY 0x910C
#define GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY 0x910D
#define GL_MAX_COLOR_TEXTURE_SAMPLES 0x910E
#define GL_MAX_DEPTH_TEXTURE_SAMPLES 0x910F
#define GL_MAX_INTEGER_SAMPLES 0x9110

/* GL_VERSION_3_3 */

#define GL_VERTEX_ATTRIB_ARRAY_DIVISOR 0x88FE
#define GL_SRC1_COLOR 0x88F9
#define GL_ONE_MINUS_SRC1_COLOR 0x88FA
#define GL_ONE_MINUS_SRC1_ALPHA 0x88FB
#define GL_MAX_DUAL_SOURCE_DRAW_BUFFERS 0x88FC
#define GL_ANY_SAMPLES_PASSED 0x8C2F
#define GL_SAMPLER_BINDING 0x8919
#define GL_RGB10_A2UI 0x906F
#define GL_TEXTURE_SWIZZLE_R 0x8E42
#define GL_TEXTURE_SWIZZLE_G 0x8E43
#define GL_TEXTURE_SWIZZLE_B 0x8E44
#define GL_TEXTURE_SWIZZLE_A 0x8E45
#define GL_TEXTURE_SWIZZLE_RGBA 0x8E46
#define GL_TIME_ELAPSED 0x88BF
#define GL_TIMESTAMP 0x8E28
#define GL_INT_2_10_10_10_REV 0x8D9F

/* GL_VERSION_4_0 */

#define GL_SAMPLE_SHADING 0x8C36
#define GL_MIN_SAMPLE_SHADING_VALUE 0x8C37
#define GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET 0x8E5E
#define GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET 0x8E5F
#define GL_TEXTURE_CUBE_MAP_ARRAY 0x9009
#define GL_TEXTURE_BINDING_CUBE_MAP_ARRAY 0x900A
#define GL_PROXY_TEXTURE_CUBE_MAP_ARRAY 0x900B
#define GL_SAMPLER_CUBE_MAP_ARRAY 0x900C
#define GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW 0x900D
#define GL_INT_SAMPLER_CUBE_MAP_ARRAY 0x900E
#define GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY 0x900F
#define GL_DRAW_INDIRECT_BUFFER 0x8F3F
#define GL_DRAW_INDIRECT_BUFFER_BINDING 0x8F43
#define GL_GEOMETRY_SHADER_INVOCATIONS 0x887F
#define GL_MAX_GEOMETRY_SHADER_INVOCATIONS 0x8E5A
#define GL_MIN_FRAGMENT_INTERPOLATION_OFFSET 0x8E5B
#define GL_MAX_FRAGMENT_INTERPOLATION_OFFSET 0x8E5C
#define GL_FRAGMENT_INTERPOLATION_OFFSET_BITS 0x8E5D
#define GL_MAX_VERTEX_STREAMS 0x8E71
#define GL_DOUBLE_VEC2 0x8FFC
#define GL_DOUBLE_VEC3 0x8FFD
#define GL_DOUBLE_VEC4 0x8FFE
#define GL_DOUBLE_MAT2 0x8F46
#define GL_DOUBLE_MAT3 0x8F47
#define GL_DOUBLE_MAT4 0x8F48
#define GL_DOUBLE_MAT2x3 0x8F49
#define GL_DOUBLE_MAT2x4 0x8F4A
#define GL_DOUBLE_MAT3x2 0x8F4B
#define GL_DOUBLE_MAT3x4 0x8F4C
#define GL_DOUBLE_MAT4x2 0x8F4D
#define GL_DOUBLE_MAT4x3 0x8F4E
#define GL_ACTIVE_SUBROUTINES 0x8DE5
#define GL_ACTIVE_SUBROUTINE_UNIFORMS 0x8DE6
#define GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS 0x8E47
#define GL_ACTIVE_SUBROUTINE_MAX_LENGTH 0x8E48
#define GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH 0x8E49
#define GL_MAX_SUBROUTINES 0x8DE7
#define GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS 0x8DE8
#define GL_NUM_COMPATIBLE_SUBROUTINES 0x8E4A
#define GL_COMPATIBLE_SUBROUTINES 0x8E4B
#define GL_PATCHES 0x000E
#define GL_PATCH_VERTICES 0x8E72
#define GL_PATCH_DEFAULT_INNER_LEVEL 0x8E73
#define GL_PATCH_DEFAULT_OUTER_LEVEL 0x8E74
#define GL_TESS_CONTROL_OUTPUT_VERTICES 0x8E75
#define GL_TESS_GEN_MODE 0x8E76
#define GL_TESS_GEN_SPACING 0x8E77
#define GL_TESS_GEN_VERTEX_ORDER 0x8E78
#define GL_TESS_GEN_POINT_MODE 0x8E79
#define GL_ISOLINES 0x8E7A
#define GL_QUADS 0x0007
#define GL_FRACTIONAL_ODD 0x8E7B
#define GL_FRACTIONAL_EVEN 0x8E7C
#define GL_MAX_PATCH_VERTICES 0x8E7D
#define GL_MAX_TESS_GEN_LEVEL 0x8E7E
#define GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS 0x8E7F
#define GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS 0x8E80
#define GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS 0x8E81
#define GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS 0x8E82
#define GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS 0x8E83
#define GL_MAX_TESS_PATCH_COMPONENTS 0x8E84
#define GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS 0x8E85
#define GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS 0x8E86
#define GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS 0x8E89
#define GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS 0x8E8A
#define GL_MAX_TESS_CONTROL_INPUT_COMPONENTS 0x886C
#define GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS 0x886D
#define GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS 0x8E1E
#define GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS 0x8E1F
#define GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER 0x84F0
#define GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER 0x84F1
#define GL_TESS_EVALUATION_SHADER 0x8E87
#define GL_TESS_CONTROL_SHADER 0x8E88
#define GL_TRANSFORM_FEEDBACK 0x8E22
#define GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED 0x8E23
#define GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE 0x8E24
#define GL_TRANSFORM_FEEDBACK_BINDING 0x8E25
#define GL_MAX_TRANSFORM_FEEDBACK_BUFFERS 0x8E70
#define GL_MAX_VERTEX_STREAMS 0x8E71

/* GL_VERSION_4_1 */

#define GL_FIXED 0x140C
#define GL_IMPLEMENTATION_COLOR_READ_TYPE 0x8B9A
#define GL_IMPLEMENTATION_COLOR_READ_FORMAT 0x8B9B
#define GL_LOW_FLOAT 0x8DF0
#define GL_MEDIUM_FLOAT 0x8DF1
#define GL_HIGH_FLOAT 0x8DF2
#define GL_LOW_INT 0x8DF3
#define GL_MEDIUM_INT 0x8DF4
#define GL_HIGH_INT 0x8DF5
#define GL_SHADER_COMPILER 0x8DFA
#define GL_SHADER_BINARY_FORMATS 0x8DF8
#define GL_NUM_SHADER_BINARY_FORMATS 0x8DF9
#define GL_MAX_VERTEX_UNIFORM_VECTORS 0x8DFB
#define GL_MAX_VARYING_VECTORS 0x8DFC
#define GL_MAX_FRAGMENT_UNIFORM_VECTORS 0x8DFD
#define GL_RGB565 0x8D62
#define GL_PROGRAM_BINARY_RETRIEVABLE_HINT 0x8257
#define GL_PROGRAM_BINARY_LENGTH 0x8741
#define GL_NUM_PROGRAM_BINARY_FORMATS 0x87FE
#define GL_PROGRAM_BINARY_FORMATS 0x87FF
#define GL_VERTEX_SHADER_BIT 0x00000001
#define GL_FRAGMENT_SHADER_BIT 0x00000002
#define GL_GEOMETRY_SHADER_BIT 0x00000004
#define GL_TESS_CONTROL_SHADER_BIT 0x00000008
#define GL_TESS_EVALUATION_SHADER_BIT 0x00000010
#define GL_ALL_SHADER_BITS 0xFFFFFFFF
#define GL_PROGRAM_SEPARABLE 0x8258
#define GL_ACTIVE_PROGRAM 0x8259
#define GL_PROGRAM_PIPELINE_BINDING 0x825A
#define GL_MAX_VIEWPORTS 0x825B
#define GL_VIEWPORT_SUBPIXEL_BITS 0x825C
#define GL_VIEWPORT_BOUNDS_RANGE 0x825D
#define GL_LAYER_PROVOKING_VERTEX 0x825E
#define GL_VIEWPORT_INDEX_PROVOKING_VERTEX 0x825F
#define GL_UNDEFINED_VERTEX 0x8260

/* GL_VERSION_4_2 */

#define GL_COPY_READ_BUFFER_BINDING 0x8F36
#define GL_COPY_WRITE_BUFFER_BINDING 0x8F37
#define GL_TRANSFORM_FEEDBACK_ACTIVE 0x8E24
#define GL_TRANSFORM_FEEDBACK_PAUSED 0x8E23
#define GL_UNPACK_COMPRESSED_BLOCK_WIDTH 0x9127
#define GL_UNPACK_COMPRESSED_BLOCK_HEIGHT 0x9128
#define GL_UNPACK_COMPRESSED_BLOCK_DEPTH 0x9129
#define GL_UNPACK_COMPRESSED_BLOCK_SIZE 0x912A
#define GL_PACK_COMPRESSED_BLOCK_WIDTH 0x912B
#define GL_PACK_COMPRESSED_BLOCK_HEIGHT 0x912C
#define GL_PACK_COMPRESSED_BLOCK_DEPTH 0x912D
#define GL_PACK_COMPRESSED_BLOCK_SIZE 0x912E
#define GL_NUM_SAMPLE_COUNTS 0x9380
#define GL_MIN_MAP_BUFFER_ALIGNMENT 0x90BC
#define GL_ATOMIC_COUNTER_BUFFER 0x92C0
#define GL_ATOMIC_COUNTER_BUFFER_BINDING 0x92C1
#define GL_ATOMIC_COUNTER_BUFFER_START 0x92C2
#define GL_ATOMIC_COUNTER_BUFFER_SIZE 0x92C3
#define GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE 0x92C4
#define GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS 0x92C5
#define GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES 0x92C6
#define GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER 0x92C7
#define GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER 0x92C8
#define GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER 0x92C9
#define GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER 0x92CA
#define GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER 0x92CB
#define GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS 0x92CC
#define GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS 0x92CD
#define GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS 0x92CE
#define GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS 0x92CF
#define GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS 0x92D0
#define GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS 0x92D1
#define GL_MAX_VERTEX_ATOMIC_COUNTERS 0x92D2
#define GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS 0x92D3
#define GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS 0x92D4
#define GL_MAX_GEOMETRY_ATOMIC_COUNTERS 0x92D5
#define GL_MAX_FRAGMENT_ATOMIC_COUNTERS 0x92D6
#define GL_MAX_COMBINED_ATOMIC_COUNTERS 0x92D7
#define GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE 0x92D8
#define GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS 0x92DC
#define GL_ACTIVE_ATOMIC_COUNTER_BUFFERS 0x92D9
#define GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX 0x92DA
#define GL_UNSIGNED_INT_ATOMIC_COUNTER 0x92DB
#define GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT 0x00000001
#define GL_ELEMENT_ARRAY_BARRIER_BIT 0x00000002
#define GL_UNIFORM_BARRIER_BIT 0x00000004
#define GL_TEXTURE_FETCH_BARRIER_BIT 0x00000008
#define GL_SHADER_IMAGE_ACCESS_BARRIER_BIT 0x00000020
#define GL_COMMAND_BARRIER_BIT 0x00000040
#define GL_PIXEL_BUFFER_BARRIER_BIT 0x00000080
#define GL_TEXTURE_UPDATE_BARRIER_BIT 0x00000100
#define GL_BUFFER_UPDATE_BARRIER_BIT 0x00000200
#define GL_FRAMEBUFFER_BARRIER_BIT 0x00000400
#define GL_TRANSFORM_FEEDBACK_BARRIER_BIT 0x00000800
#define GL_ATOMIC_COUNTER_BARRIER_BIT 0x00001000
#define GL_ALL_BARRIER_BITS 0xFFFFFFFF
#define GL_MAX_IMAGE_UNITS 0x8F38
#define GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS 0x8F39
#define GL_IMAGE_BINDING_NAME 0x8F3A
#define GL_IMAGE_BINDING_LEVEL 0x8F3B
#define GL_IMAGE_BINDING_LAYERED 0x8F3C
#define GL_IMAGE_BINDING_LAYER 0x8F3D
#define GL_IMAGE_BINDING_ACCESS 0x8F3E
#define GL_IMAGE_1D 0x904C
#define GL_IMAGE_2D 0x904D
#define GL_IMAGE_3D 0x904E
#define GL_IMAGE_2D_RECT 0x904F
#define GL_IMAGE_CUBE 0x9050
#define GL_IMAGE_BUFFER 0x9051
#define GL_IMAGE_1D_ARRAY 0x9052
#define GL_IMAGE_2D_ARRAY 0x9053
#define GL_IMAGE_CUBE_MAP_ARRAY 0x9054
#define GL_IMAGE_2D_MULTISAMPLE 0x9055
#define GL_IMAGE_2D_MULTISAMPLE_ARRAY 0x9056
#define GL_INT_IMAGE_1D 0x9057
#define GL_INT_IMAGE_2D 0x9058
#define GL_INT_IMAGE_3D 0x9059
#define GL_INT_IMAGE_2D_RECT 0x905A
#define GL_INT_IMAGE_CUBE 0x905B
#define GL_INT_IMAGE_BUFFER 0x905C
#define GL_INT_IMAGE_1D_ARRAY 0x905D
#define GL_INT_IMAGE_2D_ARRAY 0x905E
#define GL_INT_IMAGE_CUBE_MAP_ARRAY 0x905F
#define GL_INT_IMAGE_2D_MULTISAMPLE 0x9060
#define GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY 0x9061
#define GL_UNSIGNED_INT_IMAGE_1D 0x9062
#define GL_UNSIGNED_INT_IMAGE_2D 0x9063
#define GL_UNSIGNED_INT_IMAGE_3D 0x9064
#define GL_UNSIGNED_INT_IMAGE_2D_RECT 0x9065
#define GL_UNSIGNED_INT_IMAGE_CUBE 0x9066
#define GL_UNSIGNED_INT_IMAGE_BUFFER 0x9067
#define GL_UNSIGNED_INT_IMAGE_1D_ARRAY 0x9068
#define GL_UNSIGNED_INT_IMAGE_2D_ARRAY 0x9069
#define GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY 0x906A
#define GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE 0x906B
#define GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY 0x906C
#define GL_MAX_IMAGE_SAMPLES 0x906D
#define GL_IMAGE_BINDING_FORMAT 0x906E
#define GL_IMAGE_FORMAT_COMPATIBILITY_TYPE 0x90C7
#define GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE 0x90C8
#define GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS 0x90C9
#define GL_MAX_VERTEX_IMAGE_UNIFORMS 0x90CA
#define GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS 0x90CB
#define GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS 0x90CC
#define GL_MAX_GEOMETRY_IMAGE_UNIFORMS 0x90CD
#define GL_MAX_FRAGMENT_IMAGE_UNIFORMS 0x90CE
#define GL_MAX_COMBINED_IMAGE_UNIFORMS 0x90CF
#define GL_COMPRESSED_RGBA_BPTC_UNORM 0x8E8C
#define GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM 0x8E8D
#define GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT 0x8E8E
#define GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT 0x8E8F
#define GL_TEXTURE_IMMUTABLE_FORMAT 0x912F

/* GL_VERSION_4_3 */

#define GL_NUM_SHADING_LANGUAGE_VERSIONS 0x82E9
#define GL_VERTEX_ATTRIB_ARRAY_LONG 0x874E
#define GL_COMPRESSED_RGB8_ETC2 0x9274
#define GL_COMPRESSED_SRGB8_ETC2 0x9275
#define GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 0x9276
#define GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 0x9277
#define GL_COMPRESSED_RGBA8_ETC2_EAC 0x9278
#define GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC 0x9279
#define GL_COMPRESSED_R11_EAC 0x9270
#define GL_COMPRESSED_SIGNED_R11_EAC 0x9271
#define GL_COMPRESSED_RG11_EAC 0x9272
#define GL_COMPRESSED_SIGNED_RG11_EAC 0x9273
#define GL_PRIMITIVE_RESTART_FIXED_INDEX 0x8D69
#define GL_ANY_SAMPLES_PASSED_CONSERVATIVE 0x8D6A
#define GL_MAX_ELEMENT_INDEX 0x8D6B
#define GL_COMPUTE_SHADER 0x91B9
#define GL_MAX_COMPUTE_UNIFORM_BLOCKS 0x91BB
#define GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS 0x91BC
#define GL_MAX_COMPUTE_IMAGE_UNIFORMS 0x91BD
#define GL_MAX_COMPUTE_SHARED_MEMORY_SIZE 0x8262
#define GL_MAX_COMPUTE_UNIFORM_COMPONENTS 0x8263
#define GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS 0x8264
#define GL_MAX_COMPUTE_ATOMIC_COUNTERS 0x8265
#define GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS 0x8266
#define GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS 0x90EB
#define GL_MAX_COMPUTE_WORK_GROUP_COUNT 0x91BE
#define GL_MAX_COMPUTE_WORK_GROUP_SIZE 0x91BF
#define GL_COMPUTE_WORK_GROUP_SIZE 0x8267
#define GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER 0x90EC
#define GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER 0x90ED
#define GL_DISPATCH_INDIRECT_BUFFER 0x90EE
#define GL_DISPATCH_INDIRECT_BUFFER_BINDING 0x90EF
#define GL_COMPUTE_SHADER_BIT 0x00000020
#define GL_DEBUG_OUTPUT_SYNCHRONOUS 0x8242
#define GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH 0x8243
#define GL_DEBUG_CALLBACK_FUNCTION 0x8244
#define GL_DEBUG_CALLBACK_USER_PARAM 0x8245
#define GL_DEBUG_SOURCE_API 0x8246
#define GL_DEBUG_SOURCE_WINDOW_SYSTEM 0x8247
#define GL_DEBUG_SOURCE_SHADER_COMPILER 0x8248
#define GL_DEBUG_SOURCE_THIRD_PARTY 0x8249
#define GL_DEBUG_SOURCE_APPLICATION 0x824A
#define GL_DEBUG_SOURCE_OTHER 0x824B
#define GL_DEBUG_TYPE_ERROR 0x824C
#define GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR 0x824D
#define GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR 0x824E
#define GL_DEBUG_TYPE_PORTABILITY 0x824F
#define GL_DEBUG_TYPE_PERFORMANCE 0x8250
#define GL_DEBUG_TYPE_OTHER 0x8251
#define GL_MAX_DEBUG_MESSAGE_LENGTH 0x9143
#define GL_MAX_DEBUG_LOGGED_MESSAGES 0x9144
#define GL_DEBUG_LOGGED_MESSAGES 0x9145
#define GL_DEBUG_SEVERITY_HIGH 0x9146
#define GL_DEBUG_SEVERITY_MEDIUM 0x9147
#define GL_DEBUG_SEVERITY_LOW 0x9148
#define GL_DEBUG_TYPE_MARKER 0x8268
#define GL_DEBUG_TYPE_PUSH_GROUP 0x8269
#define GL_DEBUG_TYPE_POP_GROUP 0x826A
#define GL_DEBUG_SEVERITY_NOTIFICATION 0x826B
#define GL_MAX_DEBUG_GROUP_STACK_DEPTH 0x826C
#define GL_DEBUG_GROUP_STACK_DEPTH 0x826D
#define GL_BUFFER 0x82E0
#define GL_SHADER 0x82E1
#define GL_PROGRAM 0x82E2
#define GL_VERTEX_ARRAY 0x8074
#define GL_QUERY 0x82E3
#define GL_PROGRAM_PIPELINE 0x82E4
#define GL_SAMPLER 0x82E6
#define GL_MAX_LABEL_LENGTH 0x82E8
#define GL_DEBUG_OUTPUT 0x92E0
#define GL_CONTEXT_FLAG_DEBUG_BIT 0x00000002
#define GL_MAX_UNIFORM_LOCATIONS 0x826E
#define GL_FRAMEBUFFER_DEFAULT_WIDTH 0x9310
#define GL_FRAMEBUFFER_DEFAULT_HEIGHT 0x9311
#define GL_FRAMEBUFFER_DEFAULT_LAYERS 0x9312
#define GL_FRAMEBUFFER_DEFAULT_SAMPLES 0x9313
#define GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS 0x9314
#define GL_MAX_FRAMEBUFFER_WIDTH 0x9315
#define GL_MAX_FRAMEBUFFER_HEIGHT 0x9316
#define GL_MAX_FRAMEBUFFER_LAYERS 0x9317
#define GL_MAX_FRAMEBUFFER_SAMPLES 0x9318
#define GL_INTERNALFORMAT_SUPPORTED 0x826F
#define GL_INTERNALFORMAT_PREFERRED 0x8270
#define GL_INTERNALFORMAT_RED_SIZE 0x8271
#define GL_INTERNALFORMAT_GREEN_SIZE 0x8272
#define GL_INTERNALFORMAT_BLUE_SIZE 0x8273
#define GL_INTERNALFORMAT_ALPHA_SIZE 0x8274
#define GL_INTERNALFORMAT_DEPTH_SIZE 0x8275
#define GL_INTERNALFORMAT_STENCIL_SIZE 0x8276
#define GL_INTERNALFORMAT_SHARED_SIZE 0x8277
#define GL_INTERNALFORMAT_RED_TYPE 0x8278
#define GL_INTERNALFORMAT_GREEN_TYPE 0x8279
#define GL_INTERNALFORMAT_BLUE_TYPE 0x827A
#define GL_INTERNALFORMAT_ALPHA_TYPE 0x827B
#define GL_INTERNALFORMAT_DEPTH_TYPE 0x827C
#define GL_INTERNALFORMAT_STENCIL_TYPE 0x827D
#define GL_MAX_WIDTH 0x827E
#define GL_MAX_HEIGHT 0x827F
#define GL_MAX_DEPTH 0x8280
#define GL_MAX_LAYERS 0x8281
#define GL_MAX_COMBINED_DIMENSIONS 0x8282
#define GL_COLOR_COMPONENTS 0x8283
#define GL_DEPTH_COMPONENTS 0x8284
#define GL_STENCIL_COMPONENTS 0x8285
#define GL_COLOR_RENDERABLE 0x8286
#define GL_DEPTH_RENDERABLE 0x8287
#define GL_STENCIL_RENDERABLE 0x8288
#define GL_FRAMEBUFFER_RENDERABLE 0x8289
#define GL_FRAMEBUFFER_RENDERABLE_LAYERED 0x828A
#define GL_FRAMEBUFFER_BLEND 0x828B
#define GL_READ_PIXELS 0x828C
#define GL_READ_PIXELS_FORMAT 0x828D
#define GL_READ_PIXELS_TYPE 0x828E
#define GL_TEXTURE_IMAGE_FORMAT 0x828F
#define GL_TEXTURE_IMAGE_TYPE 0x8290
#define GL_GET_TEXTURE_IMAGE_FORMAT 0x8291
#define GL_GET_TEXTURE_IMAGE_TYPE 0x8292
#define GL_MIPMAP 0x8293
#define GL_MANUAL_GENERATE_MIPMAP 0x8294
#define GL_AUTO_GENERATE_MIPMAP 0x8295
#define GL_COLOR_ENCODING 0x8296
#define GL_SRGB_READ 0x8297
#define GL_SRGB_WRITE 0x8298
#define GL_FILTER 0x829A
#define GL_VERTEX_TEXTURE 0x829B
#define GL_TESS_CONTROL_TEXTURE 0x829C
#define GL_TESS_EVALUATION_TEXTURE 0x829D
#define GL_GEOMETRY_TEXTURE 0x829E
#define GL_FRAGMENT_TEXTURE 0x829F
#define GL_COMPUTE_TEXTURE 0x82A0
#define GL_TEXTURE_SHADOW 0x82A1
#define GL_TEXTURE_GATHER 0x82A2
#define GL_TEXTURE_GATHER_SHADOW 0x82A3
#define GL_SHADER_IMAGE_LOAD 0x82A4
#define GL_SHADER_IMAGE_STORE 0x82A5
#define GL_SHADER_IMAGE_ATOMIC 0x82A6
#define GL_IMAGE_TEXEL_SIZE 0x82A7
#define GL_IMAGE_COMPATIBILITY_CLASS 0x82A8
#define GL_IMAGE_PIXEL_FORMAT 0x82A9
#define GL_IMAGE_PIXEL_TYPE 0x82AA
#define GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST 0x82AC
#define GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST 0x82AD
#define GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE 0x82AE
#define GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE 0x82AF
#define GL_TEXTURE_COMPRESSED_BLOCK_WIDTH 0x82B1
#define GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT 0x82B2
#define GL_TEXTURE_COMPRESSED_BLOCK_SIZE 0x82B3
#define GL_CLEAR_BUFFER 0x82B4
#define GL_TEXTURE_VIEW 0x82B5
#define GL_VIEW_COMPATIBILITY_CLASS 0x82B6
#define GL_FULL_SUPPORT 0x82B7
#define GL_CAVEAT_SUPPORT 0x82B8
#define GL_IMAGE_CLASS_4_X_32 0x82B9
#define GL_IMAGE_CLASS_2_X_32 0x82BA
#define GL_IMAGE_CLASS_1_X_32 0x82BB
#define GL_IMAGE_CLASS_4_X_16 0x82BC
#define GL_IMAGE_CLASS_2_X_16 0x82BD
#define GL_IMAGE_CLASS_1_X_16 0x82BE
#define GL_IMAGE_CLASS_4_X_8 0x82BF
#define GL_IMAGE_CLASS_2_X_8 0x82C0
#define GL_IMAGE_CLASS_1_X_8 0x82C1
#define GL_IMAGE_CLASS_11_11_10 0x82C2
#define GL_IMAGE_CLASS_10_10_10_2 0x82C3
#define GL_VIEW_CLASS_128_BITS 0x82C4
#define GL_VIEW_CLASS_96_BITS 0x82C5
#define GL_VIEW_CLASS_64_BITS 0x82C6
#define GL_VIEW_CLASS_48_BITS 0x82C7
#define GL_VIEW_CLASS_32_BITS 0x82C8
#define GL_VIEW_CLASS_24_BITS 0x82C9
#define GL_VIEW_CLASS_16_BITS 0x82CA
#define GL_VIEW_CLASS_8_BITS 0x82CB
#define GL_VIEW_CLASS_S3TC_DXT1_RGB 0x82CC
#define GL_VIEW_CLASS_S3TC_DXT1_RGBA 0x82CD
#define GL_VIEW_CLASS_S3TC_DXT3_RGBA 0x82CE
#define GL_VIEW_CLASS_S3TC_DXT5_RGBA 0x82CF
#define GL_VIEW_CLASS_RGTC1_RED 0x82D0
#define GL_VIEW_CLASS_RGTC2_RG 0x82D1
#define GL_VIEW_CLASS_BPTC_UNORM 0x82D2
#define GL_VIEW_CLASS_BPTC_FLOAT 0x82D3
#define GL_UNIFORM 0x92E1
#define GL_UNIFORM_BLOCK 0x92E2
#define GL_PROGRAM_INPUT 0x92E3
#define GL_PROGRAM_OUTPUT 0x92E4
#define GL_BUFFER_VARIABLE 0x92E5
#define GL_SHADER_STORAGE_BLOCK 0x92E6
#define GL_VERTEX_SUBROUTINE 0x92E8
#define GL_TESS_CONTROL_SUBROUTINE 0x92E9
#define GL_TESS_EVALUATION_SUBROUTINE 0x92EA
#define GL_GEOMETRY_SUBROUTINE 0x92EB
#define GL_FRAGMENT_SUBROUTINE 0x92EC
#define GL_COMPUTE_SUBROUTINE 0x92ED
#define GL_VERTEX_SUBROUTINE_UNIFORM 0x92EE
#define GL_TESS_CONTROL_SUBROUTINE_UNIFORM 0x92EF
#define GL_TESS_EVALUATION_SUBROUTINE_UNIFORM 0x92F0
#define GL_GEOMETRY_SUBROUTINE_UNIFORM 0x92F1
#define GL_FRAGMENT_SUBROUTINE_UNIFORM 0x92F2
#define GL_COMPUTE_SUBROUTINE_UNIFORM 0x92F3
#define GL_TRANSFORM_FEEDBACK_VARYING 0x92F4
#define GL_ACTIVE_RESOURCES 0x92F5
#define GL_MAX_NAME_LENGTH 0x92F6
#define GL_MAX_NUM_ACTIVE_VARIABLES 0x92F7
#define GL_MAX_NUM_COMPATIBLE_SUBROUTINES 0x92F8
#define GL_NAME_LENGTH 0x92F9
#define GL_TYPE 0x92FA
#define GL_ARRAY_SIZE 0x92FB
#define GL_OFFSET 0x92FC
#define GL_BLOCK_INDEX 0x92FD
#define GL_ARRAY_STRIDE 0x92FE
#define GL_MATRIX_STRIDE 0x92FF
#define GL_IS_ROW_MAJOR 0x9300
#define GL_ATOMIC_COUNTER_BUFFER_INDEX 0x9301
#define GL_BUFFER_BINDING 0x9302
#define GL_BUFFER_DATA_SIZE 0x9303
#define GL_NUM_ACTIVE_VARIABLES 0x9304
#define GL_ACTIVE_VARIABLES 0x9305
#define GL_REFERENCED_BY_VERTEX_SHADER 0x9306
#define GL_REFERENCED_BY_TESS_CONTROL_SHADER 0x9307
#define GL_REFERENCED_BY_TESS_EVALUATION_SHADER 0x9308
#define GL_REFERENCED_BY_GEOMETRY_SHADER 0x9309
#define GL_REFERENCED_BY_FRAGMENT_SHADER 0x930A
#define GL_REFERENCED_BY_COMPUTE_SHADER 0x930B
#define GL_TOP_LEVEL_ARRAY_SIZE 0x930C
#define GL_TOP_LEVEL_ARRAY_STRIDE 0x930D
#define GL_LOCATION 0x930E
#define GL_LOCATION_INDEX 0x930F
#define GL_IS_PER_PATCH 0x92E7
#define GL_SHADER_STORAGE_BUFFER 0x90D2
#define GL_SHADER_STORAGE_BUFFER_BINDING 0x90D3
#define GL_SHADER_STORAGE_BUFFER_START 0x90D4
#define GL_SHADER_STORAGE_BUFFER_SIZE 0x90D5
#define GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS 0x90D6
#define GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS 0x90D7
#define GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS 0x90D8
#define GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS 0x90D9
#define GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS 0x90DA
#define GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS 0x90DB
#define GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS 0x90DC
#define GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS 0x90DD
#define GL_MAX_SHADER_STORAGE_BLOCK_SIZE 0x90DE
#define GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT 0x90DF
#define GL_SHADER_STORAGE_BARRIER_BIT 0x00002000
#define GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES 0x8F39
#define GL_DEPTH_STENCIL_TEXTURE_MODE 0x90EA
#define GL_TEXTURE_BUFFER_OFFSET 0x919D
#define GL_TEXTURE_BUFFER_SIZE 0x919E
#define GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT 0x919F
#define GL_TEXTURE_VIEW_MIN_LEVEL 0x82DB
#define GL_TEXTURE_VIEW_NUM_LEVELS 0x82DC
#define GL_TEXTURE_VIEW_MIN_LAYER 0x82DD
#define GL_TEXTURE_VIEW_NUM_LAYERS 0x82DE
#define GL_TEXTURE_IMMUTABLE_LEVELS 0x82DF
#define GL_VERTEX_ATTRIB_BINDING 0x82D4
#define GL_VERTEX_ATTRIB_RELATIVE_OFFSET 0x82D5
#define GL_VERTEX_BINDING_DIVISOR 0x82D6
#define GL_VERTEX_BINDING_OFFSET 0x82D7
#define GL_VERTEX_BINDING_STRIDE 0x82D8
#define GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET 0x82D9
#define GL_MAX_VERTEX_ATTRIB_BINDINGS 0x82DA
#define GL_VERTEX_BINDING_BUFFER 0x8F4F
#define GL_STACK_UNDERFLOW 0x0504
#define GL_STACK_OVERFLOW 0x0503

/* GL_VERSION_4_4 */

#define GL_MAX_VERTEX_ATTRIB_STRIDE 0x82E5
#define GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED 0x8221
#define GL_TEXTURE_BUFFER_BINDING 0x8C2A
#define GL_MAP_READ_BIT 0x0001
#define GL_MAP_WRITE_BIT 0x0002
#define GL_MAP_PERSISTENT_BIT 0x0040
#define GL_MAP_COHERENT_BIT 0x0080
#define GL_DYNAMIC_STORAGE_BIT 0x0100
#define GL_CLIENT_STORAGE_BIT 0x0200
#define GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT 0x00004000
#define GL_BUFFER_IMMUTABLE_STORAGE 0x821F
#define GL_BUFFER_STORAGE_FLAGS 0x8220
#define GL_CLEAR_TEXTURE 0x9365
#define GL_LOCATION_COMPONENT 0x934A
#define GL_TRANSFORM_FEEDBACK_BUFFER 0x8C8E
#define GL_TRANSFORM_FEEDBACK_BUFFER_INDEX 0x934B
#define GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE 0x934C
#define GL_QUERY_BUFFER 0x9192
#define GL_QUERY_BUFFER_BARRIER_BIT 0x00008000
#define GL_QUERY_BUFFER_BINDING 0x9193
#define GL_QUERY_RESULT_NO_WAIT 0x9194
#define GL_MIRROR_CLAMP_TO_EDGE 0x8743
#define GL_STENCIL_INDEX 0x1901
#define GL_STENCIL_INDEX8 0x8D48
#define GL_UNSIGNED_INT_10F_11F_11F_REV 0x8C3B

/* GL_VERSION_4_5 */

#define GL_CONTEXT_LOST 0x0507
#define GL_LOWER_LEFT 0x8CA1
#define GL_UPPER_LEFT 0x8CA2
#define GL_NEGATIVE_ONE_TO_ONE 0x935E
#define GL_ZERO_TO_ONE 0x935F
#define GL_CLIP_ORIGIN 0x935C
#define GL_CLIP_DEPTH_MODE 0x935D
#define GL_QUERY_WAIT_INVERTED 0x8E17
#define GL_QUERY_NO_WAIT_INVERTED 0x8E18
#define GL_QUERY_BY_REGION_WAIT_INVERTED 0x8E19
#define GL_QUERY_BY_REGION_NO_WAIT_INVERTED 0x8E1A
#define GL_MAX_CULL_DISTANCES 0x82F9
#define GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES 0x82FA
#define GL_TEXTURE_TARGET 0x1006
#define GL_QUERY_TARGET 0x82EA
#define GL_TEXTURE_BINDING_1D 0x8068
#define GL_TEXTURE_BINDING_1D_ARRAY 0x8C1C
#define GL_TEXTURE_BINDING_2D 0x8069
#define GL_TEXTURE_BINDING_2D_ARRAY 0x8C1D
#define GL_TEXTURE_BINDING_2D_MULTISAMPLE 0x9104
#define GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY 0x9105
#define GL_TEXTURE_BINDING_3D 0x806A
#define GL_TEXTURE_BINDING_BUFFER 0x8C2C
#define GL_TEXTURE_BINDING_CUBE_MAP 0x8514
#define GL_TEXTURE_BINDING_CUBE_MAP_ARRAY 0x900A
#define GL_TEXTURE_BINDING_RECTANGLE 0x84F6
#define GL_BACK 0x0405
#define GL_NO_ERROR 0
#define GL_GUILTY_CONTEXT_RESET 0x8253
#define GL_INNOCENT_CONTEXT_RESET 0x8254
#define GL_UNKNOWN_CONTEXT_RESET 0x8255
#define GL_RESET_NOTIFICATION_STRATEGY 0x8256
#define GL_LOSE_CONTEXT_ON_RESET 0x8252
#define GL_NO_RESET_NOTIFICATION 0x8261
#define GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT 0x00000004
#define GL_CONTEXT_LOST 0x0507
#define GL_CONTEXT_RELEASE_BEHAVIOR 0x82FB
#define GL_NONE 0
#define GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH 0x82FC

/* GL_VERSION_4_6 */

#define GL_CONTEXT_RELEASE_BEHAVIOR 0x82FB
#define GL_NONE 0
#define GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH 0x82FC
#define GL_SHADER_BINARY_FORMAT_SPIR_V 0x9551
#define GL_SPIR_V_BINARY 0x9552
#define GL_PARAMETER_BUFFER 0x80EE
#define GL_PARAMETER_BUFFER_BINDING 0x80EF
#define GL_CONTEXT_FLAG_NO_ERROR_BIT 0x00000008
#define GL_VERTICES_SUBMITTED 0x82EE
#define GL_PRIMITIVES_SUBMITTED 0x82EF
#define GL_VERTEX_SHADER_INVOCATIONS 0x82F0
#define GL_TESS_CONTROL_SHADER_PATCHES 0x82F1
#define GL_TESS_EVALUATION_SHADER_INVOCATIONS 0x82F2
#define GL_GEOMETRY_SHADER_INVOCATIONS 0x887F
#define GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED 0x82F3
#define GL_FRAGMENT_SHADER_INVOCATIONS 0x82F4
#define GL_COMPUTE_SHADER_INVOCATIONS 0x82F5
#define GL_CLIPPING_INPUT_PRIMITIVES 0x82F6
#define GL_CLIPPING_OUTPUT_PRIMITIVES 0x82F7
#define GL_POLYGON_OFFSET_CLAMP 0x8E1B
#define GL_SPIR_V_EXTENSIONS 0x9553
#define GL_NUM_SPIR_V_EXTENSIONS 0x9554
#define GL_TEXTURE_MAX_ANISOTROPY 0x84FE
#define GL_MAX_TEXTURE_MAX_ANISOTROPY 0x84FF
#define GL_TRANSFORM_FEEDBACK_OVERFLOW 0x82EC
#define GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW 0x82ED

/* GL_EXT_texture_sRGB */

#define GL_SRGB_EXT 0x8C40
#define GL_SRGB8_EXT 0x8C41
#define GL_SRGB_ALPHA_EXT 0x8C42
#define GL_SRGB8_ALPHA8_EXT 0x8C43
#define GL_SLUMINANCE_ALPHA_EXT 0x8C44
#define GL_SLUMINANCE8_ALPHA8_EXT 0x8C45
#define GL_SLUMINANCE_EXT 0x8C46
#define GL_SLUMINANCE8_EXT 0x8C47
#define GL_COMPRESSED_SRGB_EXT 0x8C48
#define GL_COMPRESSED_SRGB_ALPHA_EXT 0x8C49
#define GL_COMPRESSED_SLUMINANCE_EXT 0x8C4A
#define GL_COMPRESSED_SLUMINANCE_ALPHA_EXT 0x8C4B
#define GL_COMPRESSED_SRGB_S3TC_DXT1_EXT 0x8C4C
#define GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT 0x8C4D
#define GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT 0x8C4E
#define GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT 0x8C4F

/* GL_AMD_sample_positions */

#define GL_SUBSAMPLE_DISTANCE_AMD 0x883F

/* GL_ARB_robustness */

#define GL_NO_ERROR 0
#define GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT_ARB 0x00000004
#define GL_LOSE_CONTEXT_ON_RESET_ARB 0x8252
#define GL_GUILTY_CONTEXT_RESET_ARB 0x8253
#define GL_INNOCENT_CONTEXT_RESET_ARB 0x8254
#define GL_UNKNOWN_CONTEXT_RESET_ARB 0x8255
#define GL_RESET_NOTIFICATION_STRATEGY_ARB 0x8256
#define GL_NO_RESET_NOTIFICATION_ARB 0x8261

/* GL_ARB_bindless_texture */

#define GL_UNSIGNED_INT64_ARB 0x140F

/* GL_ARB_compute_variable_group_size */

#define GL_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB 0x9344
#define GL_MAX_COMPUTE_FIXED_GROUP_INVOCATIONS_ARB 0x90EB
#define GL_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB 0x9345
#define GL_MAX_COMPUTE_FIXED_GROUP_SIZE_ARB 0x91BF

/* GL_ARB_seamless_cubemap_per_texture */

#define GL_TEXTURE_CUBE_MAP_SEAMLESS 0x884F

/* GL_ARB_sparse_texture */

#define GL_TEXTURE_SPARSE_ARB 0x91A6
#define GL_VIRTUAL_PAGE_SIZE_INDEX_ARB 0x91A7
#define GL_NUM_SPARSE_LEVELS_ARB 0x91AA
#define GL_NUM_VIRTUAL_PAGE_SIZES_ARB 0x91A8
#define GL_VIRTUAL_PAGE_SIZE_X_ARB 0x9195
#define GL_VIRTUAL_PAGE_SIZE_Y_ARB 0x9196
#define GL_VIRTUAL_PAGE_SIZE_Z_ARB 0x9197
#define GL_MAX_SPARSE_TEXTURE_SIZE_ARB 0x9198
#define GL_MAX_SPARSE_3D_TEXTURE_SIZE_ARB 0x9199
#define GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_ARB 0x919A
#define GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB 0x91A9

/* GL_ARB_sparse_buffer */

#define GL_SPARSE_STORAGE_BIT_ARB 0x0400
#define GL_SPARSE_BUFFER_PAGE_SIZE_ARB 0x82F8

/* GL_ARB_ES3_2_compatibility */

#define GL_PRIMITIVE_BOUNDING_BOX_ARB 0x92BE
#define GL_MULTISAMPLE_LINE_WIDTH_RANGE_ARB 0x9381
#define GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY_ARB 0x9382

/* GL_ARB_sample_locations */

#define GL_SAMPLE_LOCATION_SUBPIXEL_BITS_ARB 0x933D
#define GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_ARB 0x933E
#define GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_ARB 0x933F
#define GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_ARB 0x9340
#define GL_SAMPLE_LOCATION_ARB 0x8E50
#define GL_PROGRAMMABLE_SAMPLE_LOCATION_ARB 0x9341
#define GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_ARB 0x9342
#define GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_ARB 0x9343

/* GL_ATI_texture_mirror_once */

#define GL_MIRROR_CLAMP_ATI 0x8742
#define GL_MIRROR_CLAMP_TO_EDGE_ATI 0x8743

/* GL_EXT_texture_compression_s3tc */

#define GL_COMPRESSED_RGB_S3TC_DXT1_EXT 0x83F0
#define GL_COMPRESSED_RGBA_S3TC_DXT1_EXT 0x83F1
#define GL_COMPRESSED_RGBA_S3TC_DXT3_EXT 0x83F2
#define GL_COMPRESSED_RGBA_S3TC_DXT5_EXT 0x83F3

/* GL_EXT_texture_mirror_clamp */

#define GL_MIRROR_CLAMP_EXT 0x8742
#define GL_MIRROR_CLAMP_TO_EDGE_EXT 0x8743
#define GL_MIRROR_CLAMP_TO_BORDER_EXT 0x8912

/* GL_EXT_texture_sRGB_decode */

#define GL_TEXTURE_SRGB_DECODE_EXT 0x8A48
#define GL_DECODE_EXT 0x8A49
#define GL_SKIP_DECODE_EXT 0x8A4A

/* GL_EXT_debug_label */

#define GL_PROGRAM_PIPELINE_OBJECT_EXT 0x8A4F
#define GL_PROGRAM_OBJECT_EXT 0x8B40
#define GL_SHADER_OBJECT_EXT 0x8B48
#define GL_BUFFER_OBJECT_EXT 0x9151
#define GL_QUERY_OBJECT_EXT 0x9153
#define GL_VERTEX_ARRAY_OBJECT_EXT 0x9154
#define GL_SAMPLER 0x82E6
#define GL_TRANSFORM_FEEDBACK 0x8E22

/* GL_EXT_texture_sRGB_R8 */

#define GL_SR8_EXT 0x8FBD

/* GL_KHR_texture_compression_astc_ldr */

#define GL_COMPRESSED_RGBA_ASTC_4x4_KHR 0x93B0
#define GL_COMPRESSED_RGBA_ASTC_5x4_KHR 0x93B1
#define GL_COMPRESSED_RGBA_ASTC_5x5_KHR 0x93B2
#define GL_COMPRESSED_RGBA_ASTC_6x5_KHR 0x93B3
#define GL_COMPRESSED_RGBA_ASTC_6x6_KHR 0x93B4
#define GL_COMPRESSED_RGBA_ASTC_8x5_KHR 0x93B5
#define GL_COMPRESSED_RGBA_ASTC_8x6_KHR 0x93B6
#define GL_COMPRESSED_RGBA_ASTC_8x8_KHR 0x93B7
#define GL_COMPRESSED_RGBA_ASTC_10x5_KHR 0x93B8
#define GL_COMPRESSED_RGBA_ASTC_10x6_KHR 0x93B9
#define GL_COMPRESSED_RGBA_ASTC_10x8_KHR 0x93BA
#define GL_COMPRESSED_RGBA_ASTC_10x10_KHR 0x93BB
#define GL_COMPRESSED_RGBA_ASTC_12x10_KHR 0x93BC
#define GL_COMPRESSED_RGBA_ASTC_12x12_KHR 0x93BD
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR 0x93D0
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR 0x93D1
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR 0x93D2
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR 0x93D3
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR 0x93D4
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR 0x93D5
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR 0x93D6
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR 0x93D7
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR 0x93D8
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR 0x93D9
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR 0x93DA
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR 0x93DB
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR 0x93DC
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR 0x93DD

/* GL_KHR_blend_equation_advanced */

#define GL_MULTIPLY_KHR 0x9294
#define GL_SCREEN_KHR 0x9295
#define GL_OVERLAY_KHR 0x9296
#define GL_DARKEN_KHR 0x9297
#define GL_LIGHTEN_KHR 0x9298
#define GL_COLORDODGE_KHR 0x9299
#define GL_COLORBURN_KHR 0x929A
#define GL_HARDLIGHT_KHR 0x929B
#define GL_SOFTLIGHT_KHR 0x929C
#define GL_DIFFERENCE_KHR 0x929E
#define GL_EXCLUSION_KHR 0x92A0
#define GL_HSL_HUE_KHR 0x92AD
#define GL_HSL_SATURATION_KHR 0x92AE
#define GL_HSL_COLOR_KHR 0x92AF
#define GL_HSL_LUMINOSITY_KHR 0x92B0

/* GL_KHR_blend_equation_advanced_coherent */

#define GL_BLEND_ADVANCED_COHERENT_KHR 0x9285

/* GL_NV_sample_locations */

#define GL_SAMPLE_LOCATION_SUBPIXEL_BITS_NV 0x933D
#define GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_NV 0x933E
#define GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_NV 0x933F
#define GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_NV 0x9340
#define GL_SAMPLE_LOCATION_NV 0x8E50
#define GL_PROGRAMMABLE_SAMPLE_LOCATION_NV 0x9341
#define GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_NV 0x9342
#define GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_NV 0x9343

/* GL_OVR_multiview */

#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR 0x9630
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR 0x9632
#define GL_MAX_VIEWS_OVR 0x9631
#define GL_FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR 0x9633

/* Function prototypes. Put into a struct in order to handle thread-localness
   and globals unique across shared libs, this also means way less symbols is
   exported, saving on binary size. Contexts on NVidia 390 drivers don't have
   correct statically linked GL 1.0 and 1.1 functions (such as glGetString())
   and one has to retrieve them explicitly using eglGetProcAddress(), which is
   why those functions aren't listed as direct prototypes. */
struct FlextGL {

    /* GL_AMD_sample_positions */

    void(APIENTRY *SetMultisamplefvAMD)(GLenum, GLuint, const GLfloat *);

    /* GL_ARB_ES3_2_compatibility */

    void(APIENTRY *PrimitiveBoundingBoxARB)(GLfloat, GLfloat, GLfloat, GLfloat, GLfloat, GLfloat, GLfloat, GLfloat);

    /* GL_ARB_bindless_texture */

    GLuint64(APIENTRY *GetImageHandleARB)(GLuint, GLint, GLboolean, GLint, GLenum);
    GLuint64(APIENTRY *GetTextureHandleARB)(GLuint);
    GLuint64(APIENTRY *GetTextureSamplerHandleARB)(GLuint, GLuint);
    void(APIENTRY *GetVertexAttribLui64vARB)(GLuint, GLenum, GLuint64EXT *);
    GLboolean(APIENTRY *IsImageHandleResidentARB)(GLuint64);
    GLboolean(APIENTRY *IsTextureHandleResidentARB)(GLuint64);
    void(APIENTRY *MakeImageHandleNonResidentARB)(GLuint64);
    void(APIENTRY *MakeImageHandleResidentARB)(GLuint64, GLenum);
    void(APIENTRY *MakeTextureHandleNonResidentARB)(GLuint64);
    void(APIENTRY *MakeTextureHandleResidentARB)(GLuint64);
    void(APIENTRY *ProgramUniformHandleui64ARB)(GLuint, GLint, GLuint64);
    void(APIENTRY *ProgramUniformHandleui64vARB)(GLuint, GLint, GLsizei, const GLuint64 *);
    void(APIENTRY *UniformHandleui64ARB)(GLint, GLuint64);
    void(APIENTRY *UniformHandleui64vARB)(GLint, GLsizei, const GLuint64 *);
    void(APIENTRY *VertexAttribL1ui64ARB)(GLuint, GLuint64EXT);
    void(APIENTRY *VertexAttribL1ui64vARB)(GLuint, const GLuint64EXT *);

    /* GL_ARB_compute_variable_group_size */

    void(APIENTRY *DispatchComputeGroupSizeARB)(GLuint, GLuint, GLuint, GLuint, GLuint, GLuint);

    /* GL_ARB_robustness */

    GLenum(APIENTRY *GetGraphicsResetStatusARB)(void);
    void(APIENTRY *GetnCompressedTexImageARB)(GLenum, GLint, GLsizei, void *);
    void(APIENTRY *GetnTexImageARB)(GLenum, GLint, GLenum, GLenum, GLsizei, void *);
    void(APIENTRY *GetnUniformdvARB)(GLuint, GLint, GLsizei, GLdouble *);
    void(APIENTRY *GetnUniformfvARB)(GLuint, GLint, GLsizei, GLfloat *);
    void(APIENTRY *GetnUniformivARB)(GLuint, GLint, GLsizei, GLint *);
    void(APIENTRY *GetnUniformuivARB)(GLuint, GLint, GLsizei, GLuint *);
    void(APIENTRY *ReadnPixelsARB)(GLint, GLint, GLsizei, GLsizei, GLenum, GLenum, GLsizei, void *);

    /* GL_ARB_sample_locations */

    void(APIENTRY *EvaluateDepthValuesARB)(void);
    void(APIENTRY *FramebufferSampleLocationsfvARB)(GLenum, GLuint, GLsizei, const GLfloat *);
    void(APIENTRY *NamedFramebufferSampleLocationsfvARB)(GLuint, GLuint, GLsizei, const GLfloat *);

    /* GL_ARB_sparse_buffer */

    void(APIENTRY *BufferPageCommitmentARB)(GLenum, GLintptr, GLsizeiptr, GLboolean);
    void(APIENTRY *NamedBufferPageCommitmentARB)(GLuint, GLintptr, GLsizeiptr, GLboolean);
    void(APIENTRY *NamedBufferPageCommitmentEXT)(GLuint, GLintptr, GLsizeiptr, GLboolean);

    /* GL_ARB_sparse_texture */

    void(APIENTRY *TexPageCommitmentARB)(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLboolean);

    /* GL_EXT_debug_label */

    void(APIENTRY *GetObjectLabelEXT)(GLenum, GLuint, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *LabelObjectEXT)(GLenum, GLuint, GLsizei, const GLchar *);

    /* GL_EXT_debug_marker */

    void(APIENTRY *InsertEventMarkerEXT)(GLsizei, const GLchar *);
    void(APIENTRY *PopGroupMarkerEXT)(void);
    void(APIENTRY *PushGroupMarkerEXT)(GLsizei, const GLchar *);

    /* GL_GREMEDY_string_marker */

    void(APIENTRY *StringMarkerGREMEDY)(GLsizei, const void *);

    /* GL_KHR_blend_equation_advanced */

    void(APIENTRY *BlendBarrierKHR)(void);

    /* GL_NV_sample_locations */

    void(APIENTRY *FramebufferSampleLocationsfvNV)(GLenum, GLuint, GLsizei, const GLfloat *);
    void(APIENTRY *NamedFramebufferSampleLocationsfvNV)(GLuint, GLuint, GLsizei, const GLfloat *);
    void(APIENTRY *ResolveDepthValuesNV)(void);

    /* GL_OVR_multiview */

    void(APIENTRY *FramebufferTextureMultiviewOVR)(GLenum, GLenum, GLuint, GLint, GLint, GLsizei);

    /* GL_VERSION_1_0 */

    void(APIENTRY *BlendFunc)(GLenum, GLenum);
    void(APIENTRY *Clear)(GLbitfield);
    void(APIENTRY *ClearColor)(GLfloat, GLfloat, GLfloat, GLfloat);
    void(APIENTRY *ClearDepth)(GLdouble);
    void(APIENTRY *ClearStencil)(GLint);
    void(APIENTRY *ColorMask)(GLboolean, GLboolean, GLboolean, GLboolean);
    void(APIENTRY *CullFace)(GLenum);
    void(APIENTRY *DepthFunc)(GLenum);
    void(APIENTRY *DepthMask)(GLboolean);
    void(APIENTRY *DepthRange)(GLdouble, GLdouble);
    void(APIENTRY *Disable)(GLenum);
    void(APIENTRY *DrawBuffer)(GLenum);
    void(APIENTRY *Enable)(GLenum);
    void(APIENTRY *Finish)(void);
    void(APIENTRY *Flush)(void);
    void(APIENTRY *FrontFace)(GLenum);
    void(APIENTRY *GetBooleanv)(GLenum, GLboolean *);
    void(APIENTRY *GetDoublev)(GLenum, GLdouble *);
    GLenum(APIENTRY *GetError)(void);
    void(APIENTRY *GetFloatv)(GLenum, GLfloat *);
    void(APIENTRY *GetIntegerv)(GLenum, GLint *);
    const GLubyte *(APIENTRY *GetString)(GLenum);
    void(APIENTRY *GetTexImage)(GLenum, GLint, GLenum, GLenum, void *);
    void(APIENTRY *GetTexLevelParameterfv)(GLenum, GLint, GLenum, GLfloat *);
    void(APIENTRY *GetTexLevelParameteriv)(GLenum, GLint, GLenum, GLint *);
    void(APIENTRY *GetTexParameterfv)(GLenum, GLenum, GLfloat *);
    void(APIENTRY *GetTexParameteriv)(GLenum, GLenum, GLint *);
    void(APIENTRY *Hint)(GLenum, GLenum);
    GLboolean(APIENTRY *IsEnabled)(GLenum);
    void(APIENTRY *LineWidth)(GLfloat);
    void(APIENTRY *LogicOp)(GLenum);
    void(APIENTRY *PixelStoref)(GLenum, GLfloat);
    void(APIENTRY *PixelStorei)(GLenum, GLint);
    void(APIENTRY *PointSize)(GLfloat);
    void(APIENTRY *PolygonMode)(GLenum, GLenum);
    void(APIENTRY *ReadBuffer)(GLenum);
    void(APIENTRY *ReadPixels)(GLint, GLint, GLsizei, GLsizei, GLenum, GLenum, void *);
    void(APIENTRY *Scissor)(GLint, GLint, GLsizei, GLsizei);
    void(APIENTRY *StencilFunc)(GLenum, GLint, GLuint);
    void(APIENTRY *StencilMask)(GLuint);
    void(APIENTRY *StencilOp)(GLenum, GLenum, GLenum);
    void(APIENTRY *TexImage1D)(GLenum, GLint, GLint, GLsizei, GLint, GLenum, GLenum, const void *);
    void(APIENTRY *TexImage2D)(GLenum, GLint, GLint, GLsizei, GLsizei, GLint, GLenum, GLenum, const void *);
    void(APIENTRY *TexParameterf)(GLenum, GLenum, GLfloat);
    void(APIENTRY *TexParameterfv)(GLenum, GLenum, const GLfloat *);
    void(APIENTRY *TexParameteri)(GLenum, GLenum, GLint);
    void(APIENTRY *TexParameteriv)(GLenum, GLenum, const GLint *);
    void(APIENTRY *Viewport)(GLint, GLint, GLsizei, GLsizei);

    /* GL_VERSION_1_1 */

    void(APIENTRY *BindTexture)(GLenum, GLuint);
    void(APIENTRY *CopyTexImage1D)(GLenum, GLint, GLenum, GLint, GLint, GLsizei, GLint);
    void(APIENTRY *CopyTexImage2D)(GLenum, GLint, GLenum, GLint, GLint, GLsizei, GLsizei, GLint);
    void(APIENTRY *CopyTexSubImage1D)(GLenum, GLint, GLint, GLint, GLint, GLsizei);
    void(APIENTRY *CopyTexSubImage2D)(GLenum, GLint, GLint, GLint, GLint, GLint, GLsizei, GLsizei);
    void(APIENTRY *DeleteTextures)(GLsizei, const GLuint *);
    void(APIENTRY *DrawArrays)(GLenum, GLint, GLsizei);
    void(APIENTRY *DrawElements)(GLenum, GLsizei, GLenum, const void *);
    void(APIENTRY *GenTextures)(GLsizei, GLuint *);
    GLboolean(APIENTRY *IsTexture)(GLuint);
    void(APIENTRY *PolygonOffset)(GLfloat, GLfloat);
    void(APIENTRY *TexSubImage1D)(GLenum, GLint, GLint, GLsizei, GLenum, GLenum, const void *);
    void(APIENTRY *TexSubImage2D)(GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLenum, const void *);

    /* GL_VERSION_1_2 */

    void(APIENTRY *CopyTexSubImage3D)(GLenum, GLint, GLint, GLint, GLint, GLint, GLint, GLsizei, GLsizei);
    void(APIENTRY *DrawRangeElements)(GLenum, GLuint, GLuint, GLsizei, GLenum, const void *);
    void(APIENTRY *TexImage3D)(GLenum, GLint, GLint, GLsizei, GLsizei, GLsizei, GLint, GLenum, GLenum, const void *);
    void(APIENTRY *TexSubImage3D)(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLenum, const void *);

    /* GL_VERSION_1_3 */

    void(APIENTRY *ActiveTexture)(GLenum);
    void(APIENTRY *CompressedTexImage1D)(GLenum, GLint, GLenum, GLsizei, GLint, GLsizei, const void *);
    void(APIENTRY *CompressedTexImage2D)(GLenum, GLint, GLenum, GLsizei, GLsizei, GLint, GLsizei, const void *);
    void(APIENTRY *CompressedTexImage3D)(GLenum, GLint, GLenum, GLsizei, GLsizei, GLsizei, GLint, GLsizei, const void *);
    void(APIENTRY *CompressedTexSubImage1D)(GLenum, GLint, GLint, GLsizei, GLenum, GLsizei, const void *);
    void(APIENTRY *CompressedTexSubImage2D)(GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLsizei, const void *);
    void(APIENTRY *CompressedTexSubImage3D)(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const void *);
    void(APIENTRY *GetCompressedTexImage)(GLenum, GLint, void *);
    void(APIENTRY *SampleCoverage)(GLfloat, GLboolean);

    /* GL_VERSION_1_4 */

    void(APIENTRY *BlendColor)(GLfloat, GLfloat, GLfloat, GLfloat);
    void(APIENTRY *BlendEquation)(GLenum);
    void(APIENTRY *BlendFuncSeparate)(GLenum, GLenum, GLenum, GLenum);
    void(APIENTRY *MultiDrawArrays)(GLenum, const GLint *, const GLsizei *, GLsizei);
    void(APIENTRY *MultiDrawElements)(GLenum, const GLsizei *, GLenum, const void *const*, GLsizei);
    void(APIENTRY *PointParameterf)(GLenum, GLfloat);
    void(APIENTRY *PointParameterfv)(GLenum, const GLfloat *);
    void(APIENTRY *PointParameteri)(GLenum, GLint);
    void(APIENTRY *PointParameteriv)(GLenum, const GLint *);

    /* GL_VERSION_1_5 */

    void(APIENTRY *BeginQuery)(GLenum, GLuint);
    void(APIENTRY *BindBuffer)(GLenum, GLuint);
    void(APIENTRY *BufferData)(GLenum, GLsizeiptr, const void *, GLenum);
    void(APIENTRY *BufferSubData)(GLenum, GLintptr, GLsizeiptr, const void *);
    void(APIENTRY *DeleteBuffers)(GLsizei, const GLuint *);
    void(APIENTRY *DeleteQueries)(GLsizei, const GLuint *);
    void(APIENTRY *EndQuery)(GLenum);
    void(APIENTRY *GenBuffers)(GLsizei, GLuint *);
    void(APIENTRY *GenQueries)(GLsizei, GLuint *);
    void(APIENTRY *GetBufferParameteriv)(GLenum, GLenum, GLint *);
    void(APIENTRY *GetBufferPointerv)(GLenum, GLenum, void **);
    void(APIENTRY *GetBufferSubData)(GLenum, GLintptr, GLsizeiptr, void *);
    void(APIENTRY *GetQueryObjectiv)(GLuint, GLenum, GLint *);
    void(APIENTRY *GetQueryObjectuiv)(GLuint, GLenum, GLuint *);
    void(APIENTRY *GetQueryiv)(GLenum, GLenum, GLint *);
    GLboolean(APIENTRY *IsBuffer)(GLuint);
    GLboolean(APIENTRY *IsQuery)(GLuint);
    void *(APIENTRY *MapBuffer)(GLenum, GLenum);
    GLboolean(APIENTRY *UnmapBuffer)(GLenum);

    /* GL_VERSION_2_0 */

    void(APIENTRY *AttachShader)(GLuint, GLuint);
    void(APIENTRY *BindAttribLocation)(GLuint, GLuint, const GLchar *);
    void(APIENTRY *BlendEquationSeparate)(GLenum, GLenum);
    void(APIENTRY *CompileShader)(GLuint);
    GLuint(APIENTRY *CreateProgram)(void);
    GLuint(APIENTRY *CreateShader)(GLenum);
    void(APIENTRY *DeleteProgram)(GLuint);
    void(APIENTRY *DeleteShader)(GLuint);
    void(APIENTRY *DetachShader)(GLuint, GLuint);
    void(APIENTRY *DisableVertexAttribArray)(GLuint);
    void(APIENTRY *DrawBuffers)(GLsizei, const GLenum *);
    void(APIENTRY *EnableVertexAttribArray)(GLuint);
    void(APIENTRY *GetActiveAttrib)(GLuint, GLuint, GLsizei, GLsizei *, GLint *, GLenum *, GLchar *);
    void(APIENTRY *GetActiveUniform)(GLuint, GLuint, GLsizei, GLsizei *, GLint *, GLenum *, GLchar *);
    void(APIENTRY *GetAttachedShaders)(GLuint, GLsizei, GLsizei *, GLuint *);
    GLint(APIENTRY *GetAttribLocation)(GLuint, const GLchar *);
    void(APIENTRY *GetProgramInfoLog)(GLuint, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetProgramiv)(GLuint, GLenum, GLint *);
    void(APIENTRY *GetShaderInfoLog)(GLuint, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetShaderSource)(GLuint, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetShaderiv)(GLuint, GLenum, GLint *);
    GLint(APIENTRY *GetUniformLocation)(GLuint, const GLchar *);
    void(APIENTRY *GetUniformfv)(GLuint, GLint, GLfloat *);
    void(APIENTRY *GetUniformiv)(GLuint, GLint, GLint *);
    void(APIENTRY *GetVertexAttribPointerv)(GLuint, GLenum, void **);
    void(APIENTRY *GetVertexAttribdv)(GLuint, GLenum, GLdouble *);
    void(APIENTRY *GetVertexAttribfv)(GLuint, GLenum, GLfloat *);
    void(APIENTRY *GetVertexAttribiv)(GLuint, GLenum, GLint *);
    GLboolean(APIENTRY *IsProgram)(GLuint);
    GLboolean(APIENTRY *IsShader)(GLuint);
    void(APIENTRY *LinkProgram)(GLuint);
    void(APIENTRY *ShaderSource)(GLuint, GLsizei, const GLchar *const*, const GLint *);
    void(APIENTRY *StencilFuncSeparate)(GLenum, GLenum, GLint, GLuint);
    void(APIENTRY *StencilMaskSeparate)(GLenum, GLuint);
    void(APIENTRY *StencilOpSeparate)(GLenum, GLenum, GLenum, GLenum);
    void(APIENTRY *Uniform1f)(GLint, GLfloat);
    void(APIENTRY *Uniform1fv)(GLint, GLsizei, const GLfloat *);
    void(APIENTRY *Uniform1i)(GLint, GLint);
    void(APIENTRY *Uniform1iv)(GLint, GLsizei, const GLint *);
    void(APIENTRY *Uniform2f)(GLint, GLfloat, GLfloat);
    void(APIENTRY *Uniform2fv)(GLint, GLsizei, const GLfloat *);
    void(APIENTRY *Uniform2i)(GLint, GLint, GLint);
    void(APIENTRY *Uniform2iv)(GLint, GLsizei, const GLint *);
    void(APIENTRY *Uniform3f)(GLint, GLfloat, GLfloat, GLfloat);
    void(APIENTRY *Uniform3fv)(GLint, GLsizei, const GLfloat *);
    void(APIENTRY *Uniform3i)(GLint, GLint, GLint, GLint);
    void(APIENTRY *Uniform3iv)(GLint, GLsizei, const GLint *);
    void(APIENTRY *Uniform4f)(GLint, GLfloat, GLfloat, GLfloat, GLfloat);
    void(APIENTRY *Uniform4fv)(GLint, GLsizei, const GLfloat *);
    void(APIENTRY *Uniform4i)(GLint, GLint, GLint, GLint, GLint);
    void(APIENTRY *Uniform4iv)(GLint, GLsizei, const GLint *);
    void(APIENTRY *UniformMatrix2fv)(GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *UniformMatrix3fv)(GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *UniformMatrix4fv)(GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *UseProgram)(GLuint);
    void(APIENTRY *ValidateProgram)(GLuint);
    void(APIENTRY *VertexAttrib1d)(GLuint, GLdouble);
    void(APIENTRY *VertexAttrib1dv)(GLuint, const GLdouble *);
    void(APIENTRY *VertexAttrib1f)(GLuint, GLfloat);
    void(APIENTRY *VertexAttrib1fv)(GLuint, const GLfloat *);
    void(APIENTRY *VertexAttrib1s)(GLuint, GLshort);
    void(APIENTRY *VertexAttrib1sv)(GLuint, const GLshort *);
    void(APIENTRY *VertexAttrib2d)(GLuint, GLdouble, GLdouble);
    void(APIENTRY *VertexAttrib2dv)(GLuint, const GLdouble *);
    void(APIENTRY *VertexAttrib2f)(GLuint, GLfloat, GLfloat);
    void(APIENTRY *VertexAttrib2fv)(GLuint, const GLfloat *);
    void(APIENTRY *VertexAttrib2s)(GLuint, GLshort, GLshort);
    void(APIENTRY *VertexAttrib2sv)(GLuint, const GLshort *);
    void(APIENTRY *VertexAttrib3d)(GLuint, GLdouble, GLdouble, GLdouble);
    void(APIENTRY *VertexAttrib3dv)(GLuint, const GLdouble *);
    void(APIENTRY *VertexAttrib3f)(GLuint, GLfloat, GLfloat, GLfloat);
    void(APIENTRY *VertexAttrib3fv)(GLuint, const GLfloat *);
    void(APIENTRY *VertexAttrib3s)(GLuint, GLshort, GLshort, GLshort);
    void(APIENTRY *VertexAttrib3sv)(GLuint, const GLshort *);
    void(APIENTRY *VertexAttrib4Nbv)(GLuint, const GLbyte *);
    void(APIENTRY *VertexAttrib4Niv)(GLuint, const GLint *);
    void(APIENTRY *VertexAttrib4Nsv)(GLuint, const GLshort *);
    void(APIENTRY *VertexAttrib4Nub)(GLuint, GLubyte, GLubyte, GLubyte, GLubyte);
    void(APIENTRY *VertexAttrib4Nubv)(GLuint, const GLubyte *);
    void(APIENTRY *VertexAttrib4Nuiv)(GLuint, const GLuint *);
    void(APIENTRY *VertexAttrib4Nusv)(GLuint, const GLushort *);
    void(APIENTRY *VertexAttrib4bv)(GLuint, const GLbyte *);
    void(APIENTRY *VertexAttrib4d)(GLuint, GLdouble, GLdouble, GLdouble, GLdouble);
    void(APIENTRY *VertexAttrib4dv)(GLuint, const GLdouble *);
    void(APIENTRY *VertexAttrib4f)(GLuint, GLfloat, GLfloat, GLfloat, GLfloat);
    void(APIENTRY *VertexAttrib4fv)(GLuint, const GLfloat *);
    void(APIENTRY *VertexAttrib4iv)(GLuint, const GLint *);
    void(APIENTRY *VertexAttrib4s)(GLuint, GLshort, GLshort, GLshort, GLshort);
    void(APIENTRY *VertexAttrib4sv)(GLuint, const GLshort *);
    void(APIENTRY *VertexAttrib4ubv)(GLuint, const GLubyte *);
    void(APIENTRY *VertexAttrib4uiv)(GLuint, const GLuint *);
    void(APIENTRY *VertexAttrib4usv)(GLuint, const GLushort *);
    void(APIENTRY *VertexAttribPointer)(GLuint, GLint, GLenum, GLboolean, GLsizei, const void *);

    /* GL_VERSION_2_1 */

    void(APIENTRY *UniformMatrix2x3fv)(GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *UniformMatrix2x4fv)(GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *UniformMatrix3x2fv)(GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *UniformMatrix3x4fv)(GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *UniformMatrix4x2fv)(GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *UniformMatrix4x3fv)(GLint, GLsizei, GLboolean, const GLfloat *);

    /* GL_VERSION_3_0 */

    void(APIENTRY *BeginConditionalRender)(GLuint, GLenum);
    void(APIENTRY *BeginTransformFeedback)(GLenum);
    void(APIENTRY *BindBufferBase)(GLenum, GLuint, GLuint);
    void(APIENTRY *BindBufferRange)(GLenum, GLuint, GLuint, GLintptr, GLsizeiptr);
    void(APIENTRY *BindFragDataLocation)(GLuint, GLuint, const GLchar *);
    void(APIENTRY *BindFramebuffer)(GLenum, GLuint);
    void(APIENTRY *BindRenderbuffer)(GLenum, GLuint);
    void(APIENTRY *BindVertexArray)(GLuint);
    void(APIENTRY *BlitFramebuffer)(GLint, GLint, GLint, GLint, GLint, GLint, GLint, GLint, GLbitfield, GLenum);
    GLenum(APIENTRY *CheckFramebufferStatus)(GLenum);
    void(APIENTRY *ClampColor)(GLenum, GLenum);
    void(APIENTRY *ClearBufferfi)(GLenum, GLint, GLfloat, GLint);
    void(APIENTRY *ClearBufferfv)(GLenum, GLint, const GLfloat *);
    void(APIENTRY *ClearBufferiv)(GLenum, GLint, const GLint *);
    void(APIENTRY *ClearBufferuiv)(GLenum, GLint, const GLuint *);
    void(APIENTRY *ColorMaski)(GLuint, GLboolean, GLboolean, GLboolean, GLboolean);
    void(APIENTRY *DeleteFramebuffers)(GLsizei, const GLuint *);
    void(APIENTRY *DeleteRenderbuffers)(GLsizei, const GLuint *);
    void(APIENTRY *DeleteVertexArrays)(GLsizei, const GLuint *);
    void(APIENTRY *Disablei)(GLenum, GLuint);
    void(APIENTRY *Enablei)(GLenum, GLuint);
    void(APIENTRY *EndConditionalRender)(void);
    void(APIENTRY *EndTransformFeedback)(void);
    void(APIENTRY *FlushMappedBufferRange)(GLenum, GLintptr, GLsizeiptr);
    void(APIENTRY *FramebufferRenderbuffer)(GLenum, GLenum, GLenum, GLuint);
    void(APIENTRY *FramebufferTexture1D)(GLenum, GLenum, GLenum, GLuint, GLint);
    void(APIENTRY *FramebufferTexture2D)(GLenum, GLenum, GLenum, GLuint, GLint);
    void(APIENTRY *FramebufferTexture3D)(GLenum, GLenum, GLenum, GLuint, GLint, GLint);
    void(APIENTRY *FramebufferTextureLayer)(GLenum, GLenum, GLuint, GLint, GLint);
    void(APIENTRY *GenFramebuffers)(GLsizei, GLuint *);
    void(APIENTRY *GenRenderbuffers)(GLsizei, GLuint *);
    void(APIENTRY *GenVertexArrays)(GLsizei, GLuint *);
    void(APIENTRY *GenerateMipmap)(GLenum);
    void(APIENTRY *GetBooleani_v)(GLenum, GLuint, GLboolean *);
    GLint(APIENTRY *GetFragDataLocation)(GLuint, const GLchar *);
    void(APIENTRY *GetFramebufferAttachmentParameteriv)(GLenum, GLenum, GLenum, GLint *);
    void(APIENTRY *GetIntegeri_v)(GLenum, GLuint, GLint *);
    void(APIENTRY *GetRenderbufferParameteriv)(GLenum, GLenum, GLint *);
    const GLubyte *(APIENTRY *GetStringi)(GLenum, GLuint);
    void(APIENTRY *GetTexParameterIiv)(GLenum, GLenum, GLint *);
    void(APIENTRY *GetTexParameterIuiv)(GLenum, GLenum, GLuint *);
    void(APIENTRY *GetTransformFeedbackVarying)(GLuint, GLuint, GLsizei, GLsizei *, GLsizei *, GLenum *, GLchar *);
    void(APIENTRY *GetUniformuiv)(GLuint, GLint, GLuint *);
    void(APIENTRY *GetVertexAttribIiv)(GLuint, GLenum, GLint *);
    void(APIENTRY *GetVertexAttribIuiv)(GLuint, GLenum, GLuint *);
    GLboolean(APIENTRY *IsEnabledi)(GLenum, GLuint);
    GLboolean(APIENTRY *IsFramebuffer)(GLuint);
    GLboolean(APIENTRY *IsRenderbuffer)(GLuint);
    GLboolean(APIENTRY *IsVertexArray)(GLuint);
    void *(APIENTRY *MapBufferRange)(GLenum, GLintptr, GLsizeiptr, GLbitfield);
    void(APIENTRY *RenderbufferStorage)(GLenum, GLenum, GLsizei, GLsizei);
    void(APIENTRY *RenderbufferStorageMultisample)(GLenum, GLsizei, GLenum, GLsizei, GLsizei);
    void(APIENTRY *TexParameterIiv)(GLenum, GLenum, const GLint *);
    void(APIENTRY *TexParameterIuiv)(GLenum, GLenum, const GLuint *);
    void(APIENTRY *TransformFeedbackVaryings)(GLuint, GLsizei, const GLchar *const*, GLenum);
    void(APIENTRY *Uniform1ui)(GLint, GLuint);
    void(APIENTRY *Uniform1uiv)(GLint, GLsizei, const GLuint *);
    void(APIENTRY *Uniform2ui)(GLint, GLuint, GLuint);
    void(APIENTRY *Uniform2uiv)(GLint, GLsizei, const GLuint *);
    void(APIENTRY *Uniform3ui)(GLint, GLuint, GLuint, GLuint);
    void(APIENTRY *Uniform3uiv)(GLint, GLsizei, const GLuint *);
    void(APIENTRY *Uniform4ui)(GLint, GLuint, GLuint, GLuint, GLuint);
    void(APIENTRY *Uniform4uiv)(GLint, GLsizei, const GLuint *);
    void(APIENTRY *VertexAttribI1i)(GLuint, GLint);
    void(APIENTRY *VertexAttribI1iv)(GLuint, const GLint *);
    void(APIENTRY *VertexAttribI1ui)(GLuint, GLuint);
    void(APIENTRY *VertexAttribI1uiv)(GLuint, const GLuint *);
    void(APIENTRY *VertexAttribI2i)(GLuint, GLint, GLint);
    void(APIENTRY *VertexAttribI2iv)(GLuint, const GLint *);
    void(APIENTRY *VertexAttribI2ui)(GLuint, GLuint, GLuint);
    void(APIENTRY *VertexAttribI2uiv)(GLuint, const GLuint *);
    void(APIENTRY *VertexAttribI3i)(GLuint, GLint, GLint, GLint);
    void(APIENTRY *VertexAttribI3iv)(GLuint, const GLint *);
    void(APIENTRY *VertexAttribI3ui)(GLuint, GLuint, GLuint, GLuint);
    void(APIENTRY *VertexAttribI3uiv)(GLuint, const GLuint *);
    void(APIENTRY *VertexAttribI4bv)(GLuint, const GLbyte *);
    void(APIENTRY *VertexAttribI4i)(GLuint, GLint, GLint, GLint, GLint);
    void(APIENTRY *VertexAttribI4iv)(GLuint, const GLint *);
    void(APIENTRY *VertexAttribI4sv)(GLuint, const GLshort *);
    void(APIENTRY *VertexAttribI4ubv)(GLuint, const GLubyte *);
    void(APIENTRY *VertexAttribI4ui)(GLuint, GLuint, GLuint, GLuint, GLuint);
    void(APIENTRY *VertexAttribI4uiv)(GLuint, const GLuint *);
    void(APIENTRY *VertexAttribI4usv)(GLuint, const GLushort *);
    void(APIENTRY *VertexAttribIPointer)(GLuint, GLint, GLenum, GLsizei, const void *);

    /* GL_VERSION_3_1 */

    void(APIENTRY *CopyBufferSubData)(GLenum, GLenum, GLintptr, GLintptr, GLsizeiptr);
    void(APIENTRY *DrawArraysInstanced)(GLenum, GLint, GLsizei, GLsizei);
    void(APIENTRY *DrawElementsInstanced)(GLenum, GLsizei, GLenum, const void *, GLsizei);
    void(APIENTRY *GetActiveUniformBlockName)(GLuint, GLuint, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetActiveUniformBlockiv)(GLuint, GLuint, GLenum, GLint *);
    void(APIENTRY *GetActiveUniformName)(GLuint, GLuint, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetActiveUniformsiv)(GLuint, GLsizei, const GLuint *, GLenum, GLint *);
    GLuint(APIENTRY *GetUniformBlockIndex)(GLuint, const GLchar *);
    void(APIENTRY *GetUniformIndices)(GLuint, GLsizei, const GLchar *const*, GLuint *);
    void(APIENTRY *PrimitiveRestartIndex)(GLuint);
    void(APIENTRY *TexBuffer)(GLenum, GLenum, GLuint);
    void(APIENTRY *UniformBlockBinding)(GLuint, GLuint, GLuint);

    /* GL_VERSION_3_2 */

    GLenum(APIENTRY *ClientWaitSync)(GLsync, GLbitfield, GLuint64);
    void(APIENTRY *DeleteSync)(GLsync);
    void(APIENTRY *DrawElementsBaseVertex)(GLenum, GLsizei, GLenum, const void *, GLint);
    void(APIENTRY *DrawElementsInstancedBaseVertex)(GLenum, GLsizei, GLenum, const void *, GLsizei, GLint);
    void(APIENTRY *DrawRangeElementsBaseVertex)(GLenum, GLuint, GLuint, GLsizei, GLenum, const void *, GLint);
    GLsync(APIENTRY *FenceSync)(GLenum, GLbitfield);
    void(APIENTRY *FramebufferTexture)(GLenum, GLenum, GLuint, GLint);
    void(APIENTRY *GetBufferParameteri64v)(GLenum, GLenum, GLint64 *);
    void(APIENTRY *GetInteger64i_v)(GLenum, GLuint, GLint64 *);
    void(APIENTRY *GetInteger64v)(GLenum, GLint64 *);
    void(APIENTRY *GetMultisamplefv)(GLenum, GLuint, GLfloat *);
    void(APIENTRY *GetSynciv)(GLsync, GLenum, GLsizei, GLsizei *, GLint *);
    GLboolean(APIENTRY *IsSync)(GLsync);
    void(APIENTRY *MultiDrawElementsBaseVertex)(GLenum, const GLsizei *, GLenum, const void *const*, GLsizei, const GLint *);
    void(APIENTRY *ProvokingVertex)(GLenum);
    void(APIENTRY *SampleMaski)(GLuint, GLbitfield);
    void(APIENTRY *TexImage2DMultisample)(GLenum, GLsizei, GLenum, GLsizei, GLsizei, GLboolean);
    void(APIENTRY *TexImage3DMultisample)(GLenum, GLsizei, GLenum, GLsizei, GLsizei, GLsizei, GLboolean);
    void(APIENTRY *WaitSync)(GLsync, GLbitfield, GLuint64);

    /* GL_VERSION_3_3 */

    void(APIENTRY *BindFragDataLocationIndexed)(GLuint, GLuint, GLuint, const GLchar *);
    void(APIENTRY *BindSampler)(GLuint, GLuint);
    void(APIENTRY *DeleteSamplers)(GLsizei, const GLuint *);
    void(APIENTRY *GenSamplers)(GLsizei, GLuint *);
    GLint(APIENTRY *GetFragDataIndex)(GLuint, const GLchar *);
    void(APIENTRY *GetQueryObjecti64v)(GLuint, GLenum, GLint64 *);
    void(APIENTRY *GetQueryObjectui64v)(GLuint, GLenum, GLuint64 *);
    void(APIENTRY *GetSamplerParameterIiv)(GLuint, GLenum, GLint *);
    void(APIENTRY *GetSamplerParameterIuiv)(GLuint, GLenum, GLuint *);
    void(APIENTRY *GetSamplerParameterfv)(GLuint, GLenum, GLfloat *);
    void(APIENTRY *GetSamplerParameteriv)(GLuint, GLenum, GLint *);
    GLboolean(APIENTRY *IsSampler)(GLuint);
    void(APIENTRY *QueryCounter)(GLuint, GLenum);
    void(APIENTRY *SamplerParameterIiv)(GLuint, GLenum, const GLint *);
    void(APIENTRY *SamplerParameterIuiv)(GLuint, GLenum, const GLuint *);
    void(APIENTRY *SamplerParameterf)(GLuint, GLenum, GLfloat);
    void(APIENTRY *SamplerParameterfv)(GLuint, GLenum, const GLfloat *);
    void(APIENTRY *SamplerParameteri)(GLuint, GLenum, GLint);
    void(APIENTRY *SamplerParameteriv)(GLuint, GLenum, const GLint *);
    void(APIENTRY *VertexAttribDivisor)(GLuint, GLuint);
    void(APIENTRY *VertexAttribP1ui)(GLuint, GLenum, GLboolean, GLuint);
    void(APIENTRY *VertexAttribP1uiv)(GLuint, GLenum, GLboolean, const GLuint *);
    void(APIENTRY *VertexAttribP2ui)(GLuint, GLenum, GLboolean, GLuint);
    void(APIENTRY *VertexAttribP2uiv)(GLuint, GLenum, GLboolean, const GLuint *);
    void(APIENTRY *VertexAttribP3ui)(GLuint, GLenum, GLboolean, GLuint);
    void(APIENTRY *VertexAttribP3uiv)(GLuint, GLenum, GLboolean, const GLuint *);
    void(APIENTRY *VertexAttribP4ui)(GLuint, GLenum, GLboolean, GLuint);
    void(APIENTRY *VertexAttribP4uiv)(GLuint, GLenum, GLboolean, const GLuint *);

    /* GL_VERSION_4_0 */

    void(APIENTRY *BeginQueryIndexed)(GLenum, GLuint, GLuint);
    void(APIENTRY *BindTransformFeedback)(GLenum, GLuint);
    void(APIENTRY *BlendEquationSeparatei)(GLuint, GLenum, GLenum);
    void(APIENTRY *BlendEquationi)(GLuint, GLenum);
    void(APIENTRY *BlendFuncSeparatei)(GLuint, GLenum, GLenum, GLenum, GLenum);
    void(APIENTRY *BlendFunci)(GLuint, GLenum, GLenum);
    void(APIENTRY *DeleteTransformFeedbacks)(GLsizei, const GLuint *);
    void(APIENTRY *DrawArraysIndirect)(GLenum, const void *);
    void(APIENTRY *DrawElementsIndirect)(GLenum, GLenum, const void *);
    void(APIENTRY *DrawTransformFeedback)(GLenum, GLuint);
    void(APIENTRY *DrawTransformFeedbackStream)(GLenum, GLuint, GLuint);
    void(APIENTRY *EndQueryIndexed)(GLenum, GLuint);
    void(APIENTRY *GenTransformFeedbacks)(GLsizei, GLuint *);
    void(APIENTRY *GetActiveSubroutineName)(GLuint, GLenum, GLuint, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetActiveSubroutineUniformName)(GLuint, GLenum, GLuint, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetActiveSubroutineUniformiv)(GLuint, GLenum, GLuint, GLenum, GLint *);
    void(APIENTRY *GetProgramStageiv)(GLuint, GLenum, GLenum, GLint *);
    void(APIENTRY *GetQueryIndexediv)(GLenum, GLuint, GLenum, GLint *);
    GLuint(APIENTRY *GetSubroutineIndex)(GLuint, GLenum, const GLchar *);
    GLint(APIENTRY *GetSubroutineUniformLocation)(GLuint, GLenum, const GLchar *);
    void(APIENTRY *GetUniformSubroutineuiv)(GLenum, GLint, GLuint *);
    void(APIENTRY *GetUniformdv)(GLuint, GLint, GLdouble *);
    GLboolean(APIENTRY *IsTransformFeedback)(GLuint);
    void(APIENTRY *MinSampleShading)(GLfloat);
    void(APIENTRY *PatchParameterfv)(GLenum, const GLfloat *);
    void(APIENTRY *PatchParameteri)(GLenum, GLint);
    void(APIENTRY *PauseTransformFeedback)(void);
    void(APIENTRY *ResumeTransformFeedback)(void);
    void(APIENTRY *Uniform1d)(GLint, GLdouble);
    void(APIENTRY *Uniform1dv)(GLint, GLsizei, const GLdouble *);
    void(APIENTRY *Uniform2d)(GLint, GLdouble, GLdouble);
    void(APIENTRY *Uniform2dv)(GLint, GLsizei, const GLdouble *);
    void(APIENTRY *Uniform3d)(GLint, GLdouble, GLdouble, GLdouble);
    void(APIENTRY *Uniform3dv)(GLint, GLsizei, const GLdouble *);
    void(APIENTRY *Uniform4d)(GLint, GLdouble, GLdouble, GLdouble, GLdouble);
    void(APIENTRY *Uniform4dv)(GLint, GLsizei, const GLdouble *);
    void(APIENTRY *UniformMatrix2dv)(GLint, GLsizei, GLboolean, const GLdouble *);
    void(APIENTRY *UniformMatrix2x3dv)(GLint, GLsizei, GLboolean, const GLdouble *);
    void(APIENTRY *UniformMatrix2x4dv)(GLint, GLsizei, GLboolean, const GLdouble *);
    void(APIENTRY *UniformMatrix3dv)(GLint, GLsizei, GLboolean, const GLdouble *);
    void(APIENTRY *UniformMatrix3x2dv)(GLint, GLsizei, GLboolean, const GLdouble *);
    void(APIENTRY *UniformMatrix3x4dv)(GLint, GLsizei, GLboolean, const GLdouble *);
    void(APIENTRY *UniformMatrix4dv)(GLint, GLsizei, GLboolean, const GLdouble *);
    void(APIENTRY *UniformMatrix4x2dv)(GLint, GLsizei, GLboolean, const GLdouble *);
    void(APIENTRY *UniformMatrix4x3dv)(GLint, GLsizei, GLboolean, const GLdouble *);
    void(APIENTRY *UniformSubroutinesuiv)(GLenum, GLsizei, const GLuint *);

    /* GL_VERSION_4_1 */

    void(APIENTRY *ActiveShaderProgram)(GLuint, GLuint);
    void(APIENTRY *BindProgramPipeline)(GLuint);
    void(APIENTRY *ClearDepthf)(GLfloat);
    GLuint(APIENTRY *CreateShaderProgramv)(GLenum, GLsizei, const GLchar *const*);
    void(APIENTRY *DeleteProgramPipelines)(GLsizei, const GLuint *);
    void(APIENTRY *DepthRangeArrayv)(GLuint, GLsizei, const GLdouble *);
    void(APIENTRY *DepthRangeIndexed)(GLuint, GLdouble, GLdouble);
    void(APIENTRY *DepthRangef)(GLfloat, GLfloat);
    void(APIENTRY *GenProgramPipelines)(GLsizei, GLuint *);
    void(APIENTRY *GetDoublei_v)(GLenum, GLuint, GLdouble *);
    void(APIENTRY *GetFloati_v)(GLenum, GLuint, GLfloat *);
    void(APIENTRY *GetProgramBinary)(GLuint, GLsizei, GLsizei *, GLenum *, void *);
    void(APIENTRY *GetProgramPipelineInfoLog)(GLuint, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetProgramPipelineiv)(GLuint, GLenum, GLint *);
    void(APIENTRY *GetShaderPrecisionFormat)(GLenum, GLenum, GLint *, GLint *);
    void(APIENTRY *GetVertexAttribLdv)(GLuint, GLenum, GLdouble *);
    GLboolean(APIENTRY *IsProgramPipeline)(GLuint);
    void(APIENTRY *ProgramBinary)(GLuint, GLenum, const void *, GLsizei);
    void(APIENTRY *ProgramParameteri)(GLuint, GLenum, GLint);
    void(APIENTRY *ProgramUniform1d)(GLuint, GLint, GLdouble);
    void(APIENTRY *ProgramUniform1dv)(GLuint, GLint, GLsizei, const GLdouble *);
    void(APIENTRY *ProgramUniform1f)(GLuint, GLint, GLfloat);
    void(APIENTRY *ProgramUniform1fv)(GLuint, GLint, GLsizei, const GLfloat *);
    void(APIENTRY *ProgramUniform1i)(GLuint, GLint, GLint);
    void(APIENTRY *ProgramUniform1iv)(GLuint, GLint, GLsizei, const GLint *);
    void(APIENTRY *ProgramUniform1ui)(GLuint, GLint, GLuint);
    void(APIENTRY *ProgramUniform1uiv)(GLuint, GLint, GLsizei, const GLuint *);
    void(APIENTRY *ProgramUniform2d)(GLuint, GLint, GLdouble, GLdouble);
    void(APIENTRY *ProgramUniform2dv)(GLuint, GLint, GLsizei, const GLdouble *);
    void(APIENTRY *ProgramUniform2f)(GLuint, GLint, GLfloat, GLfloat);
    void(APIENTRY *ProgramUniform2fv)(GLuint, GLint, GLsizei, const GLfloat *);
    void(APIENTRY *ProgramUniform2i)(GLuint, GLint, GLint, GLint);
    void(APIENTRY *ProgramUniform2iv)(GLuint, GLint, GLsizei, const GLint *);
    void(APIENTRY *ProgramUniform2ui)(GLuint, GLint, GLuint, GLuint);
    void(APIENTRY *ProgramUniform2uiv)(GLuint, GLint, GLsizei, const GLuint *);
    void(APIENTRY *ProgramUniform3d)(GLuint, GLint, GLdouble, GLdouble, GLdouble);
    void(APIENTRY *ProgramUniform3dv)(GLuint, GLint, GLsizei, const GLdouble *);
    void(APIENTRY *ProgramUniform3f)(GLuint, GLint, GLfloat, GLfloat, GLfloat);
    void(APIENTRY *ProgramUniform3fv)(GLuint, GLint, GLsizei, const GLfloat *);
    void(APIENTRY *ProgramUniform3i)(GLuint, GLint, GLint, GLint, GLint);
    void(APIENTRY *ProgramUniform3iv)(GLuint, GLint, GLsizei, const GLint *);
    void(APIENTRY *ProgramUniform3ui)(GLuint, GLint, GLuint, GLuint, GLuint);
    void(APIENTRY *ProgramUniform3uiv)(GLuint, GLint, GLsizei, const GLuint *);
    void(APIENTRY *ProgramUniform4d)(GLuint, GLint, GLdouble, GLdouble, GLdouble, GLdouble);
    void(APIENTRY *ProgramUniform4dv)(GLuint, GLint, GLsizei, const GLdouble *);
    void(APIENTRY *ProgramUniform4f)(GLuint, GLint, GLfloat, GLfloat, GLfloat, GLfloat);
    void(APIENTRY *ProgramUniform4fv)(GLuint, GLint, GLsizei, const GLfloat *);
    void(APIENTRY *ProgramUniform4i)(GLuint, GLint, GLint, GLint, GLint, GLint);
    void(APIENTRY *ProgramUniform4iv)(GLuint, GLint, GLsizei, const GLint *);
    void(APIENTRY *ProgramUniform4ui)(GLuint, GLint, GLuint, GLuint, GLuint, GLuint);
    void(APIENTRY *ProgramUniform4uiv)(GLuint, GLint, GLsizei, const GLuint *);
    void(APIENTRY *ProgramUniformMatrix2dv)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
    void(APIENTRY *ProgramUniformMatrix2fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix2x3dv)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
    void(APIENTRY *ProgramUniformMatrix2x3fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix2x4dv)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
    void(APIENTRY *ProgramUniformMatrix2x4fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix3dv)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
    void(APIENTRY *ProgramUniformMatrix3fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix3x2dv)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
    void(APIENTRY *ProgramUniformMatrix3x2fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix3x4dv)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
    void(APIENTRY *ProgramUniformMatrix3x4fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix4dv)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
    void(APIENTRY *ProgramUniformMatrix4fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix4x2dv)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
    void(APIENTRY *ProgramUniformMatrix4x2fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix4x3dv)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
    void(APIENTRY *ProgramUniformMatrix4x3fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ReleaseShaderCompiler)(void);
    void(APIENTRY *ScissorArrayv)(GLuint, GLsizei, const GLint *);
    void(APIENTRY *ScissorIndexed)(GLuint, GLint, GLint, GLsizei, GLsizei);
    void(APIENTRY *ScissorIndexedv)(GLuint, const GLint *);
    void(APIENTRY *ShaderBinary)(GLsizei, const GLuint *, GLenum, const void *, GLsizei);
    void(APIENTRY *UseProgramStages)(GLuint, GLbitfield, GLuint);
    void(APIENTRY *ValidateProgramPipeline)(GLuint);
    void(APIENTRY *VertexAttribL1d)(GLuint, GLdouble);
    void(APIENTRY *VertexAttribL1dv)(GLuint, const GLdouble *);
    void(APIENTRY *VertexAttribL2d)(GLuint, GLdouble, GLdouble);
    void(APIENTRY *VertexAttribL2dv)(GLuint, const GLdouble *);
    void(APIENTRY *VertexAttribL3d)(GLuint, GLdouble, GLdouble, GLdouble);
    void(APIENTRY *VertexAttribL3dv)(GLuint, const GLdouble *);
    void(APIENTRY *VertexAttribL4d)(GLuint, GLdouble, GLdouble, GLdouble, GLdouble);
    void(APIENTRY *VertexAttribL4dv)(GLuint, const GLdouble *);
    void(APIENTRY *VertexAttribLPointer)(GLuint, GLint, GLenum, GLsizei, const void *);
    void(APIENTRY *ViewportArrayv)(GLuint, GLsizei, const GLfloat *);
    void(APIENTRY *ViewportIndexedf)(GLuint, GLfloat, GLfloat, GLfloat, GLfloat);
    void(APIENTRY *ViewportIndexedfv)(GLuint, const GLfloat *);

    /* GL_VERSION_4_2 */

    void(APIENTRY *BindImageTexture)(GLuint, GLuint, GLint, GLboolean, GLint, GLenum, GLenum);
    void(APIENTRY *DrawArraysInstancedBaseInstance)(GLenum, GLint, GLsizei, GLsizei, GLuint);
    void(APIENTRY *DrawElementsInstancedBaseInstance)(GLenum, GLsizei, GLenum, const void *, GLsizei, GLuint);
    void(APIENTRY *DrawElementsInstancedBaseVertexBaseInstance)(GLenum, GLsizei, GLenum, const void *, GLsizei, GLint, GLuint);
    void(APIENTRY *DrawTransformFeedbackInstanced)(GLenum, GLuint, GLsizei);
    void(APIENTRY *DrawTransformFeedbackStreamInstanced)(GLenum, GLuint, GLuint, GLsizei);
    void(APIENTRY *GetActiveAtomicCounterBufferiv)(GLuint, GLuint, GLenum, GLint *);
    void(APIENTRY *GetInternalformativ)(GLenum, GLenum, GLenum, GLsizei, GLint *);
    void(APIENTRY *MemoryBarrier)(GLbitfield);
    void(APIENTRY *TexStorage1D)(GLenum, GLsizei, GLenum, GLsizei);
    void(APIENTRY *TexStorage2D)(GLenum, GLsizei, GLenum, GLsizei, GLsizei);
    void(APIENTRY *TexStorage3D)(GLenum, GLsizei, GLenum, GLsizei, GLsizei, GLsizei);

    /* GL_VERSION_4_3 */

    void(APIENTRY *BindVertexBuffer)(GLuint, GLuint, GLintptr, GLsizei);
    void(APIENTRY *ClearBufferData)(GLenum, GLenum, GLenum, GLenum, const void *);
    void(APIENTRY *ClearBufferSubData)(GLenum, GLenum, GLintptr, GLsizeiptr, GLenum, GLenum, const void *);
    void(APIENTRY *CopyImageSubData)(GLuint, GLenum, GLint, GLint, GLint, GLint, GLuint, GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei);
    void(APIENTRY *DebugMessageCallback)(GLDEBUGPROC, const void *);
    void(APIENTRY *DebugMessageControl)(GLenum, GLenum, GLenum, GLsizei, const GLuint *, GLboolean);
    void(APIENTRY *DebugMessageInsert)(GLenum, GLenum, GLuint, GLenum, GLsizei, const GLchar *);
    void(APIENTRY *DispatchCompute)(GLuint, GLuint, GLuint);
    void(APIENTRY *DispatchComputeIndirect)(GLintptr);
    void(APIENTRY *FramebufferParameteri)(GLenum, GLenum, GLint);
    GLuint(APIENTRY *GetDebugMessageLog)(GLuint, GLsizei, GLenum *, GLenum *, GLuint *, GLenum *, GLsizei *, GLchar *);
    void(APIENTRY *GetFramebufferParameteriv)(GLenum, GLenum, GLint *);
    void(APIENTRY *GetInternalformati64v)(GLenum, GLenum, GLenum, GLsizei, GLint64 *);
    void(APIENTRY *GetObjectLabel)(GLenum, GLuint, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetObjectPtrLabel)(const void *, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetPointerv)(GLenum, void **);
    void(APIENTRY *GetProgramInterfaceiv)(GLuint, GLenum, GLenum, GLint *);
    GLuint(APIENTRY *GetProgramResourceIndex)(GLuint, GLenum, const GLchar *);
    GLint(APIENTRY *GetProgramResourceLocation)(GLuint, GLenum, const GLchar *);
    GLint(APIENTRY *GetProgramResourceLocationIndex)(GLuint, GLenum, const GLchar *);
    void(APIENTRY *GetProgramResourceName)(GLuint, GLenum, GLuint, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetProgramResourceiv)(GLuint, GLenum, GLuint, GLsizei, const GLenum *, GLsizei, GLsizei *, GLint *);
    void(APIENTRY *InvalidateBufferData)(GLuint);
    void(APIENTRY *InvalidateBufferSubData)(GLuint, GLintptr, GLsizeiptr);
    void(APIENTRY *InvalidateFramebuffer)(GLenum, GLsizei, const GLenum *);
    void(APIENTRY *InvalidateSubFramebuffer)(GLenum, GLsizei, const GLenum *, GLint, GLint, GLsizei, GLsizei);
    void(APIENTRY *InvalidateTexImage)(GLuint, GLint);
    void(APIENTRY *InvalidateTexSubImage)(GLuint, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei);
    void(APIENTRY *MultiDrawArraysIndirect)(GLenum, const void *, GLsizei, GLsizei);
    void(APIENTRY *MultiDrawElementsIndirect)(GLenum, GLenum, const void *, GLsizei, GLsizei);
    void(APIENTRY *ObjectLabel)(GLenum, GLuint, GLsizei, const GLchar *);
    void(APIENTRY *ObjectPtrLabel)(const void *, GLsizei, const GLchar *);
    void(APIENTRY *PopDebugGroup)(void);
    void(APIENTRY *PushDebugGroup)(GLenum, GLuint, GLsizei, const GLchar *);
    void(APIENTRY *ShaderStorageBlockBinding)(GLuint, GLuint, GLuint);
    void(APIENTRY *TexBufferRange)(GLenum, GLenum, GLuint, GLintptr, GLsizeiptr);
    void(APIENTRY *TexStorage2DMultisample)(GLenum, GLsizei, GLenum, GLsizei, GLsizei, GLboolean);
    void(APIENTRY *TexStorage3DMultisample)(GLenum, GLsizei, GLenum, GLsizei, GLsizei, GLsizei, GLboolean);
    void(APIENTRY *TextureView)(GLuint, GLenum, GLuint, GLenum, GLuint, GLuint, GLuint, GLuint);
    void(APIENTRY *VertexAttribBinding)(GLuint, GLuint);
    void(APIENTRY *VertexAttribFormat)(GLuint, GLint, GLenum, GLboolean, GLuint);
    void(APIENTRY *VertexAttribIFormat)(GLuint, GLint, GLenum, GLuint);
    void(APIENTRY *VertexAttribLFormat)(GLuint, GLint, GLenum, GLuint);
    void(APIENTRY *VertexBindingDivisor)(GLuint, GLuint);

    /* GL_VERSION_4_4 */

    void(APIENTRY *BindBuffersBase)(GLenum, GLuint, GLsizei, const GLuint *);
    void(APIENTRY *BindBuffersRange)(GLenum, GLuint, GLsizei, const GLuint *, const GLintptr *, const GLsizeiptr *);
    void(APIENTRY *BindImageTextures)(GLuint, GLsizei, const GLuint *);
    void(APIENTRY *BindSamplers)(GLuint, GLsizei, const GLuint *);
    void(APIENTRY *BindTextures)(GLuint, GLsizei, const GLuint *);
    void(APIENTRY *BindVertexBuffers)(GLuint, GLsizei, const GLuint *, const GLintptr *, const GLsizei *);
    void(APIENTRY *BufferStorage)(GLenum, GLsizeiptr, const void *, GLbitfield);
    void(APIENTRY *ClearTexImage)(GLuint, GLint, GLenum, GLenum, const void *);
    void(APIENTRY *ClearTexSubImage)(GLuint, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLenum, const void *);

    /* GL_VERSION_4_5 */

    void(APIENTRY *BindTextureUnit)(GLuint, GLuint);
    void(APIENTRY *BlitNamedFramebuffer)(GLuint, GLuint, GLint, GLint, GLint, GLint, GLint, GLint, GLint, GLint, GLbitfield, GLenum);
    GLenum(APIENTRY *CheckNamedFramebufferStatus)(GLuint, GLenum);
    void(APIENTRY *ClearNamedBufferData)(GLuint, GLenum, GLenum, GLenum, const void *);
    void(APIENTRY *ClearNamedBufferSubData)(GLuint, GLenum, GLintptr, GLsizeiptr, GLenum, GLenum, const void *);
    void(APIENTRY *ClearNamedFramebufferfi)(GLuint, GLenum, GLint, GLfloat, GLint);
    void(APIENTRY *ClearNamedFramebufferfv)(GLuint, GLenum, GLint, const GLfloat *);
    void(APIENTRY *ClearNamedFramebufferiv)(GLuint, GLenum, GLint, const GLint *);
    void(APIENTRY *ClearNamedFramebufferuiv)(GLuint, GLenum, GLint, const GLuint *);
    void(APIENTRY *ClipControl)(GLenum, GLenum);
    void(APIENTRY *CompressedTextureSubImage1D)(GLuint, GLint, GLint, GLsizei, GLenum, GLsizei, const void *);
    void(APIENTRY *CompressedTextureSubImage2D)(GLuint, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLsizei, const void *);
    void(APIENTRY *CompressedTextureSubImage3D)(GLuint, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const void *);
    void(APIENTRY *CopyNamedBufferSubData)(GLuint, GLuint, GLintptr, GLintptr, GLsizeiptr);
    void(APIENTRY *CopyTextureSubImage1D)(GLuint, GLint, GLint, GLint, GLint, GLsizei);
    void(APIENTRY *CopyTextureSubImage2D)(GLuint, GLint, GLint, GLint, GLint, GLint, GLsizei, GLsizei);
    void(APIENTRY *CopyTextureSubImage3D)(GLuint, GLint, GLint, GLint, GLint, GLint, GLint, GLsizei, GLsizei);
    void(APIENTRY *CreateBuffers)(GLsizei, GLuint *);
    void(APIENTRY *CreateFramebuffers)(GLsizei, GLuint *);
    void(APIENTRY *CreateProgramPipelines)(GLsizei, GLuint *);
    void(APIENTRY *CreateQueries)(GLenum, GLsizei, GLuint *);
    void(APIENTRY *CreateRenderbuffers)(GLsizei, GLuint *);
    void(APIENTRY *CreateSamplers)(GLsizei, GLuint *);
    void(APIENTRY *CreateTextures)(GLenum, GLsizei, GLuint *);
    void(APIENTRY *CreateTransformFeedbacks)(GLsizei, GLuint *);
    void(APIENTRY *CreateVertexArrays)(GLsizei, GLuint *);
    void(APIENTRY *DisableVertexArrayAttrib)(GLuint, GLuint);
    void(APIENTRY *EnableVertexArrayAttrib)(GLuint, GLuint);
    void(APIENTRY *FlushMappedNamedBufferRange)(GLuint, GLintptr, GLsizeiptr);
    void(APIENTRY *GenerateTextureMipmap)(GLuint);
    void(APIENTRY *GetCompressedTextureImage)(GLuint, GLint, GLsizei, void *);
    void(APIENTRY *GetCompressedTextureSubImage)(GLuint, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLsizei, void *);
    GLenum(APIENTRY *GetGraphicsResetStatus)(void);
    void(APIENTRY *GetNamedBufferParameteri64v)(GLuint, GLenum, GLint64 *);
    void(APIENTRY *GetNamedBufferParameteriv)(GLuint, GLenum, GLint *);
    void(APIENTRY *GetNamedBufferPointerv)(GLuint, GLenum, void **);
    void(APIENTRY *GetNamedBufferSubData)(GLuint, GLintptr, GLsizeiptr, void *);
    void(APIENTRY *GetNamedFramebufferAttachmentParameteriv)(GLuint, GLenum, GLenum, GLint *);
    void(APIENTRY *GetNamedFramebufferParameteriv)(GLuint, GLenum, GLint *);
    void(APIENTRY *GetNamedRenderbufferParameteriv)(GLuint, GLenum, GLint *);
    void(APIENTRY *GetQueryBufferObjecti64v)(GLuint, GLuint, GLenum, GLintptr);
    void(APIENTRY *GetQueryBufferObjectiv)(GLuint, GLuint, GLenum, GLintptr);
    void(APIENTRY *GetQueryBufferObjectui64v)(GLuint, GLuint, GLenum, GLintptr);
    void(APIENTRY *GetQueryBufferObjectuiv)(GLuint, GLuint, GLenum, GLintptr);
    void(APIENTRY *GetTextureImage)(GLuint, GLint, GLenum, GLenum, GLsizei, void *);
    void(APIENTRY *GetTextureLevelParameterfv)(GLuint, GLint, GLenum, GLfloat *);
    void(APIENTRY *GetTextureLevelParameteriv)(GLuint, GLint, GLenum, GLint *);
    void(APIENTRY *GetTextureParameterIiv)(GLuint, GLenum, GLint *);
    void(APIENTRY *GetTextureParameterIuiv)(GLuint, GLenum, GLuint *);
    void(APIENTRY *GetTextureParameterfv)(GLuint, GLenum, GLfloat *);
    void(APIENTRY *GetTextureParameteriv)(GLuint, GLenum, GLint *);
    void(APIENTRY *GetTextureSubImage)(GLuint, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLenum, GLsizei, void *);
    void(APIENTRY *GetTransformFeedbacki64_v)(GLuint, GLenum, GLuint, GLint64 *);
    void(APIENTRY *GetTransformFeedbacki_v)(GLuint, GLenum, GLuint, GLint *);
    void(APIENTRY *GetTransformFeedbackiv)(GLuint, GLenum, GLint *);
    void(APIENTRY *GetVertexArrayIndexed64iv)(GLuint, GLuint, GLenum, GLint64 *);
    void(APIENTRY *GetVertexArrayIndexediv)(GLuint, GLuint, GLenum, GLint *);
    void(APIENTRY *GetVertexArrayiv)(GLuint, GLenum, GLint *);
    void(APIENTRY *GetnCompressedTexImage)(GLenum, GLint, GLsizei, void *);
    void(APIENTRY *GetnTexImage)(GLenum, GLint, GLenum, GLenum, GLsizei, void *);
    void(APIENTRY *GetnUniformdv)(GLuint, GLint, GLsizei, GLdouble *);
    void(APIENTRY *GetnUniformfv)(GLuint, GLint, GLsizei, GLfloat *);
    void(APIENTRY *GetnUniformiv)(GLuint, GLint, GLsizei, GLint *);
    void(APIENTRY *GetnUniformuiv)(GLuint, GLint, GLsizei, GLuint *);
    void(APIENTRY *InvalidateNamedFramebufferData)(GLuint, GLsizei, const GLenum *);
    void(APIENTRY *InvalidateNamedFramebufferSubData)(GLuint, GLsizei, const GLenum *, GLint, GLint, GLsizei, GLsizei);
    void *(APIENTRY *MapNamedBuffer)(GLuint, GLenum);
    void *(APIENTRY *MapNamedBufferRange)(GLuint, GLintptr, GLsizeiptr, GLbitfield);
    void(APIENTRY *MemoryBarrierByRegion)(GLbitfield);
    void(APIENTRY *NamedBufferData)(GLuint, GLsizeiptr, const void *, GLenum);
    void(APIENTRY *NamedBufferStorage)(GLuint, GLsizeiptr, const void *, GLbitfield);
    void(APIENTRY *NamedBufferSubData)(GLuint, GLintptr, GLsizeiptr, const void *);
    void(APIENTRY *NamedFramebufferDrawBuffer)(GLuint, GLenum);
    void(APIENTRY *NamedFramebufferDrawBuffers)(GLuint, GLsizei, const GLenum *);
    void(APIENTRY *NamedFramebufferParameteri)(GLuint, GLenum, GLint);
    void(APIENTRY *NamedFramebufferReadBuffer)(GLuint, GLenum);
    void(APIENTRY *NamedFramebufferRenderbuffer)(GLuint, GLenum, GLenum, GLuint);
    void(APIENTRY *NamedFramebufferTexture)(GLuint, GLenum, GLuint, GLint);
    void(APIENTRY *NamedFramebufferTextureLayer)(GLuint, GLenum, GLuint, GLint, GLint);
    void(APIENTRY *NamedRenderbufferStorage)(GLuint, GLenum, GLsizei, GLsizei);
    void(APIENTRY *NamedRenderbufferStorageMultisample)(GLuint, GLsizei, GLenum, GLsizei, GLsizei);
    void(APIENTRY *ReadnPixels)(GLint, GLint, GLsizei, GLsizei, GLenum, GLenum, GLsizei, void *);
    void(APIENTRY *TextureBarrier)(void);
    void(APIENTRY *TextureBuffer)(GLuint, GLenum, GLuint);
    void(APIENTRY *TextureBufferRange)(GLuint, GLenum, GLuint, GLintptr, GLsizeiptr);
    void(APIENTRY *TextureParameterIiv)(GLuint, GLenum, const GLint *);
    void(APIENTRY *TextureParameterIuiv)(GLuint, GLenum, const GLuint *);
    void(APIENTRY *TextureParameterf)(GLuint, GLenum, GLfloat);
    void(APIENTRY *TextureParameterfv)(GLuint, GLenum, const GLfloat *);
    void(APIENTRY *TextureParameteri)(GLuint, GLenum, GLint);
    void(APIENTRY *TextureParameteriv)(GLuint, GLenum, const GLint *);
    void(APIENTRY *TextureStorage1D)(GLuint, GLsizei, GLenum, GLsizei);
    void(APIENTRY *TextureStorage2D)(GLuint, GLsizei, GLenum, GLsizei, GLsizei);
    void(APIENTRY *TextureStorage2DMultisample)(GLuint, GLsizei, GLenum, GLsizei, GLsizei, GLboolean);
    void(APIENTRY *TextureStorage3D)(GLuint, GLsizei, GLenum, GLsizei, GLsizei, GLsizei);
    void(APIENTRY *TextureStorage3DMultisample)(GLuint, GLsizei, GLenum, GLsizei, GLsizei, GLsizei, GLboolean);
    void(APIENTRY *TextureSubImage1D)(GLuint, GLint, GLint, GLsizei, GLenum, GLenum, const void *);
    void(APIENTRY *TextureSubImage2D)(GLuint, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLenum, const void *);
    void(APIENTRY *TextureSubImage3D)(GLuint, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLenum, const void *);
    void(APIENTRY *TransformFeedbackBufferBase)(GLuint, GLuint, GLuint);
    void(APIENTRY *TransformFeedbackBufferRange)(GLuint, GLuint, GLuint, GLintptr, GLsizeiptr);
    GLboolean(APIENTRY *UnmapNamedBuffer)(GLuint);
    void(APIENTRY *VertexArrayAttribBinding)(GLuint, GLuint, GLuint);
    void(APIENTRY *VertexArrayAttribFormat)(GLuint, GLuint, GLint, GLenum, GLboolean, GLuint);
    void(APIENTRY *VertexArrayAttribIFormat)(GLuint, GLuint, GLint, GLenum, GLuint);
    void(APIENTRY *VertexArrayAttribLFormat)(GLuint, GLuint, GLint, GLenum, GLuint);
    void(APIENTRY *VertexArrayBindingDivisor)(GLuint, GLuint, GLuint);
    void(APIENTRY *VertexArrayElementBuffer)(GLuint, GLuint);
    void(APIENTRY *VertexArrayVertexBuffer)(GLuint, GLuint, GLuint, GLintptr, GLsizei);
    void(APIENTRY *VertexArrayVertexBuffers)(GLuint, GLuint, GLsizei, const GLuint *, const GLintptr *, const GLsizei *);

    /* GL_VERSION_4_6 */

    void(APIENTRY *MultiDrawArraysIndirectCount)(GLenum, const void *, GLintptr, GLsizei, GLsizei);
    void(APIENTRY *MultiDrawElementsIndirectCount)(GLenum, GLenum, const void *, GLintptr, GLsizei, GLsizei);
    void(APIENTRY *PolygonOffsetClamp)(GLfloat, GLfloat, GLfloat);
    void(APIENTRY *SpecializeShader)(GLuint, const GLchar *, GLuint, const GLuint *, const GLuint *);
};

extern FLEXTGL_EXPORT FlextGL flextGL;

/* GL_AMD_sample_positions */

#define glSetMultisamplefvAMD flextGL.SetMultisamplefvAMD

/* GL_ARB_ES3_2_compatibility */

#define glPrimitiveBoundingBoxARB flextGL.PrimitiveBoundingBoxARB

/* GL_ARB_bindless_texture */

#define glGetImageHandleARB flextGL.GetImageHandleARB
#define glGetTextureHandleARB flextGL.GetTextureHandleARB
#define glGetTextureSamplerHandleARB flextGL.GetTextureSamplerHandleARB
#define glGetVertexAttribLui64vARB flextGL.GetVertexAttribLui64vARB
#define glIsImageHandleResidentARB flextGL.IsImageHandleResidentARB
#define glIsTextureHandleResidentARB flextGL.IsTextureHandleResidentARB
#define glMakeImageHandleNonResidentARB flextGL.MakeImageHandleNonResidentARB
#define glMakeImageHandleResidentARB flextGL.MakeImageHandleResidentARB
#define glMakeTextureHandleNonResidentARB flextGL.MakeTextureHandleNonResidentARB
#define glMakeTextureHandleResidentARB flextGL.MakeTextureHandleResidentARB
#define glProgramUniformHandleui64ARB flextGL.ProgramUniformHandleui64ARB
#define glProgramUniformHandleui64vARB flextGL.ProgramUniformHandleui64vARB
#define glUniformHandleui64ARB flextGL.UniformHandleui64ARB
#define glUniformHandleui64vARB flextGL.UniformHandleui64vARB
#define glVertexAttribL1ui64ARB flextGL.VertexAttribL1ui64ARB
#define glVertexAttribL1ui64vARB flextGL.VertexAttribL1ui64vARB

/* GL_ARB_compute_variable_group_size */

#define glDispatchComputeGroupSizeARB flextGL.DispatchComputeGroupSizeARB

/* GL_ARB_robustness */

#define glGetGraphicsResetStatusARB flextGL.GetGraphicsResetStatusARB
#define glGetnCompressedTexImageARB flextGL.GetnCompressedTexImageARB
#define glGetnTexImageARB flextGL.GetnTexImageARB
#define glGetnUniformdvARB flextGL.GetnUniformdvARB
#define glGetnUniformfvARB flextGL.GetnUniformfvARB
#define glGetnUniformivARB flextGL.GetnUniformivARB
#define glGetnUniformuivARB flextGL.GetnUniformuivARB
#define glReadnPixelsARB flextGL.ReadnPixelsARB

/* GL_ARB_sample_locations */

#define glEvaluateDepthValuesARB flextGL.EvaluateDepthValuesARB
#define glFramebufferSampleLocationsfvARB flextGL.FramebufferSampleLocationsfvARB
#define glNamedFramebufferSampleLocationsfvARB flextGL.NamedFramebufferSampleLocationsfvARB

/* GL_ARB_sparse_buffer */

#define glBufferPageCommitmentARB flextGL.BufferPageCommitmentARB
#define glNamedBufferPageCommitmentARB flextGL.NamedBufferPageCommitmentARB
#define glNamedBufferPageCommitmentEXT flextGL.NamedBufferPageCommitmentEXT

/* GL_ARB_sparse_texture */

#define glTexPageCommitmentARB flextGL.TexPageCommitmentARB

/* GL_EXT_debug_label */

#define glGetObjectLabelEXT flextGL.GetObjectLabelEXT
#define glLabelObjectEXT flextGL.LabelObjectEXT

/* GL_EXT_debug_marker */

#define glInsertEventMarkerEXT flextGL.InsertEventMarkerEXT
#define glPopGroupMarkerEXT flextGL.PopGroupMarkerEXT
#define glPushGroupMarkerEXT flextGL.PushGroupMarkerEXT

/* GL_GREMEDY_string_marker */

#define glStringMarkerGREMEDY flextGL.StringMarkerGREMEDY

/* GL_KHR_blend_equation_advanced */

#define glBlendBarrierKHR flextGL.BlendBarrierKHR

/* GL_NV_sample_locations */

#define glFramebufferSampleLocationsfvNV flextGL.FramebufferSampleLocationsfvNV
#define glNamedFramebufferSampleLocationsfvNV flextGL.NamedFramebufferSampleLocationsfvNV
#define glResolveDepthValuesNV flextGL.ResolveDepthValuesNV

/* GL_OVR_multiview */

#define glFramebufferTextureMultiviewOVR flextGL.FramebufferTextureMultiviewOVR

/* GL_VERSION_1_0 */

#define glBlendFunc flextGL.BlendFunc
#define glClear flextGL.Clear
#define glClearColor flextGL.ClearColor
#define glClearDepth flextGL.ClearDepth
#define glClearStencil flextGL.ClearStencil
#define glColorMask flextGL.ColorMask
#define glCullFace flextGL.CullFace
#define glDepthFunc flextGL.DepthFunc
#define glDepthMask flextGL.DepthMask
#define glDepthRange flextGL.DepthRange
#define glDisable flextGL.Disable
#define glDrawBuffer flextGL.DrawBuffer
#define glEnable flextGL.Enable
#define glFinish flextGL.Finish
#define glFlush flextGL.Flush
#define glFrontFace flextGL.FrontFace
#define glGetBooleanv flextGL.GetBooleanv
#define glGetDoublev flextGL.GetDoublev
#define glGetError flextGL.GetError
#define glGetFloatv flextGL.GetFloatv
#define glGetIntegerv flextGL.GetIntegerv
#define glGetString flextGL.GetString
#define glGetTexImage flextGL.GetTexImage
#define glGetTexLevelParameterfv flextGL.GetTexLevelParameterfv
#define glGetTexLevelParameteriv flextGL.GetTexLevelParameteriv
#define glGetTexParameterfv flextGL.GetTexParameterfv
#define glGetTexParameteriv flextGL.GetTexParameteriv
#define glHint flextGL.Hint
#define glIsEnabled flextGL.IsEnabled
#define glLineWidth flextGL.LineWidth
#define glLogicOp flextGL.LogicOp
#define glPixelStoref flextGL.PixelStoref
#define glPixelStorei flextGL.PixelStorei
#define glPointSize flextGL.PointSize
#define glPolygonMode flextGL.PolygonMode
#define glReadBuffer flextGL.ReadBuffer
#define glReadPixels flextGL.ReadPixels
#define glScissor flextGL.Scissor
#define glStencilFunc flextGL.StencilFunc
#define glStencilMask flextGL.StencilMask
#define glStencilOp flextGL.StencilOp
#define glTexImage1D flextGL.TexImage1D
#define glTexImage2D flextGL.TexImage2D
#define glTexParameterf flextGL.TexParameterf
#define glTexParameterfv flextGL.TexParameterfv
#define glTexParameteri flextGL.TexParameteri
#define glTexParameteriv flextGL.TexParameteriv
#define glViewport flextGL.Viewport

/* GL_VERSION_1_1 */

#define glBindTexture flextGL.BindTexture
#define glCopyTexImage1D flextGL.CopyTexImage1D
#define glCopyTexImage2D flextGL.CopyTexImage2D
#define glCopyTexSubImage1D flextGL.CopyTexSubImage1D
#define glCopyTexSubImage2D flextGL.CopyTexSubImage2D
#define glDeleteTextures flextGL.DeleteTextures
#define glDrawArrays flextGL.DrawArrays
#define glDrawElements flextGL.DrawElements
#define glGenTextures flextGL.GenTextures
#define glIsTexture flextGL.IsTexture
#define glPolygonOffset flextGL.PolygonOffset
#define glTexSubImage1D flextGL.TexSubImage1D
#define glTexSubImage2D flextGL.TexSubImage2D

/* GL_VERSION_1_2 */

#define glCopyTexSubImage3D flextGL.CopyTexSubImage3D
#define glDrawRangeElements flextGL.DrawRangeElements
#define glTexImage3D flextGL.TexImage3D
#define glTexSubImage3D flextGL.TexSubImage3D

/* GL_VERSION_1_3 */

#define glActiveTexture flextGL.ActiveTexture
#define glCompressedTexImage1D flextGL.CompressedTexImage1D
#define glCompressedTexImage2D flextGL.CompressedTexImage2D
#define glCompressedTexImage3D flextGL.CompressedTexImage3D
#define glCompressedTexSubImage1D flextGL.CompressedTexSubImage1D
#define glCompressedTexSubImage2D flextGL.CompressedTexSubImage2D
#define glCompressedTexSubImage3D flextGL.CompressedTexSubImage3D
#define glGetCompressedTexImage flextGL.GetCompressedTexImage
#define glSampleCoverage flextGL.SampleCoverage

/* GL_VERSION_1_4 */

#define glBlendColor flextGL.BlendColor
#define glBlendEquation flextGL.BlendEquation
#define glBlendFuncSeparate flextGL.BlendFuncSeparate
#define glMultiDrawArrays flextGL.MultiDrawArrays
#define glMultiDrawElements flextGL.MultiDrawElements
#define glPointParameterf flextGL.PointParameterf
#define glPointParameterfv flextGL.PointParameterfv
#define glPointParameteri flextGL.PointParameteri
#define glPointParameteriv flextGL.PointParameteriv

/* GL_VERSION_1_5 */

#define glBeginQuery flextGL.BeginQuery
#define glBindBuffer flextGL.BindBuffer
#define glBufferData flextGL.BufferData
#define glBufferSubData flextGL.BufferSubData
#define glDeleteBuffers flextGL.DeleteBuffers
#define glDeleteQueries flextGL.DeleteQueries
#define glEndQuery flextGL.EndQuery
#define glGenBuffers flextGL.GenBuffers
#define glGenQueries flextGL.GenQueries
#define glGetBufferParameteriv flextGL.GetBufferParameteriv
#define glGetBufferPointerv flextGL.GetBufferPointerv
#define glGetBufferSubData flextGL.GetBufferSubData
#define glGetQueryObjectiv flextGL.GetQueryObjectiv
#define glGetQueryObjectuiv flextGL.GetQueryObjectuiv
#define glGetQueryiv flextGL.GetQueryiv
#define glIsBuffer flextGL.IsBuffer
#define glIsQuery flextGL.IsQuery
#define glMapBuffer flextGL.MapBuffer
#define glUnmapBuffer flextGL.UnmapBuffer

/* GL_VERSION_2_0 */

#define glAttachShader flextGL.AttachShader
#define glBindAttribLocation flextGL.BindAttribLocation
#define glBlendEquationSeparate flextGL.BlendEquationSeparate
#define glCompileShader flextGL.CompileShader
#define glCreateProgram flextGL.CreateProgram
#define glCreateShader flextGL.CreateShader
#define glDeleteProgram flextGL.DeleteProgram
#define glDeleteShader flextGL.DeleteShader
#define glDetachShader flextGL.DetachShader
#define glDisableVertexAttribArray flextGL.DisableVertexAttribArray
#define glDrawBuffers flextGL.DrawBuffers
#define glEnableVertexAttribArray flextGL.EnableVertexAttribArray
#define glGetActiveAttrib flextGL.GetActiveAttrib
#define glGetActiveUniform flextGL.GetActiveUniform
#define glGetAttachedShaders flextGL.GetAttachedShaders
#define glGetAttribLocation flextGL.GetAttribLocation
#define glGetProgramInfoLog flextGL.GetProgramInfoLog
#define glGetProgramiv flextGL.GetProgramiv
#define glGetShaderInfoLog flextGL.GetShaderInfoLog
#define glGetShaderSource flextGL.GetShaderSource
#define glGetShaderiv flextGL.GetShaderiv
#define glGetUniformLocation flextGL.GetUniformLocation
#define glGetUniformfv flextGL.GetUniformfv
#define glGetUniformiv flextGL.GetUniformiv
#define glGetVertexAttribPointerv flextGL.GetVertexAttribPointerv
#define glGetVertexAttribdv flextGL.GetVertexAttribdv
#define glGetVertexAttribfv flextGL.GetVertexAttribfv
#define glGetVertexAttribiv flextGL.GetVertexAttribiv
#define glIsProgram flextGL.IsProgram
#define glIsShader flextGL.IsShader
#define glLinkProgram flextGL.LinkProgram
#define glShaderSource flextGL.ShaderSource
#define glStencilFuncSeparate flextGL.StencilFuncSeparate
#define glStencilMaskSeparate flextGL.StencilMaskSeparate
#define glStencilOpSeparate flextGL.StencilOpSeparate
#define glUniform1f flextGL.Uniform1f
#define glUniform1fv flextGL.Uniform1fv
#define glUniform1i flextGL.Uniform1i
#define glUniform1iv flextGL.Uniform1iv
#define glUniform2f flextGL.Uniform2f
#define glUniform2fv flextGL.Uniform2fv
#define glUniform2i flextGL.Uniform2i
#define glUniform2iv flextGL.Uniform2iv
#define glUniform3f flextGL.Uniform3f
#define glUniform3fv flextGL.Uniform3fv
#define glUniform3i flextGL.Uniform3i
#define glUniform3iv flextGL.Uniform3iv
#define glUniform4f flextGL.Uniform4f
#define glUniform4fv flextGL.Uniform4fv
#define glUniform4i flextGL.Uniform4i
#define glUniform4iv flextGL.Uniform4iv
#define glUniformMatrix2fv flextGL.UniformMatrix2fv
#define glUniformMatrix3fv flextGL.UniformMatrix3fv
#define glUniformMatrix4fv flextGL.UniformMatrix4fv
#define glUseProgram flextGL.UseProgram
#define glValidateProgram flextGL.ValidateProgram
#define glVertexAttrib1d flextGL.VertexAttrib1d
#define glVertexAttrib1dv flextGL.VertexAttrib1dv
#define glVertexAttrib1f flextGL.VertexAttrib1f
#define glVertexAttrib1fv flextGL.VertexAttrib1fv
#define glVertexAttrib1s flextGL.VertexAttrib1s
#define glVertexAttrib1sv flextGL.VertexAttrib1sv
#define glVertexAttrib2d flextGL.VertexAttrib2d
#define glVertexAttrib2dv flextGL.VertexAttrib2dv
#define glVertexAttrib2f flextGL.VertexAttrib2f
#define glVertexAttrib2fv flextGL.VertexAttrib2fv
#define glVertexAttrib2s flextGL.VertexAttrib2s
#define glVertexAttrib2sv flextGL.VertexAttrib2sv
#define glVertexAttrib3d flextGL.VertexAttrib3d
#define glVertexAttrib3dv flextGL.VertexAttrib3dv
#define glVertexAttrib3f flextGL.VertexAttrib3f
#define glVertexAttrib3fv flextGL.VertexAttrib3fv
#define glVertexAttrib3s flextGL.VertexAttrib3s
#define glVertexAttrib3sv flextGL.VertexAttrib3sv
#define glVertexAttrib4Nbv flextGL.VertexAttrib4Nbv
#define glVertexAttrib4Niv flextGL.VertexAttrib4Niv
#define glVertexAttrib4Nsv flextGL.VertexAttrib4Nsv
#define glVertexAttrib4Nub flextGL.VertexAttrib4Nub
#define glVertexAttrib4Nubv flextGL.VertexAttrib4Nubv
#define glVertexAttrib4Nuiv flextGL.VertexAttrib4Nuiv
#define glVertexAttrib4Nusv flextGL.VertexAttrib4Nusv
#define glVertexAttrib4bv flextGL.VertexAttrib4bv
#define glVertexAttrib4d flextGL.VertexAttrib4d
#define glVertexAttrib4dv flextGL.VertexAttrib4dv
#define glVertexAttrib4f flextGL.VertexAttrib4f
#define glVertexAttrib4fv flextGL.VertexAttrib4fv
#define glVertexAttrib4iv flextGL.VertexAttrib4iv
#define glVertexAttrib4s flextGL.VertexAttrib4s
#define glVertexAttrib4sv flextGL.VertexAttrib4sv
#define glVertexAttrib4ubv flextGL.VertexAttrib4ubv
#define glVertexAttrib4uiv flextGL.VertexAttrib4uiv
#define glVertexAttrib4usv flextGL.VertexAttrib4usv
#define glVertexAttribPointer flextGL.VertexAttribPointer

/* GL_VERSION_2_1 */

#define glUniformMatrix2x3fv flextGL.UniformMatrix2x3fv
#define glUniformMatrix2x4fv flextGL.UniformMatrix2x4fv
#define glUniformMatrix3x2fv flextGL.UniformMatrix3x2fv
#define glUniformMatrix3x4fv flextGL.UniformMatrix3x4fv
#define glUniformMatrix4x2fv flextGL.UniformMatrix4x2fv
#define glUniformMatrix4x3fv flextGL.UniformMatrix4x3fv

/* GL_VERSION_3_0 */

#define glBeginConditionalRender flextGL.BeginConditionalRender
#define glBeginTransformFeedback flextGL.BeginTransformFeedback
#define glBindBufferBase flextGL.BindBufferBase
#define glBindBufferRange flextGL.BindBufferRange
#define glBindFragDataLocation flextGL.BindFragDataLocation
#define glBindFramebuffer flextGL.BindFramebuffer
#define glBindRenderbuffer flextGL.BindRenderbuffer
#define glBindVertexArray flextGL.BindVertexArray
#define glBlitFramebuffer flextGL.BlitFramebuffer
#define glCheckFramebufferStatus flextGL.CheckFramebufferStatus
#define glClampColor flextGL.ClampColor
#define glClearBufferfi flextGL.ClearBufferfi
#define glClearBufferfv flextGL.ClearBufferfv
#define glClearBufferiv flextGL.ClearBufferiv
#define glClearBufferuiv flextGL.ClearBufferuiv
#define glColorMaski flextGL.ColorMaski
#define glDeleteFramebuffers flextGL.DeleteFramebuffers
#define glDeleteRenderbuffers flextGL.DeleteRenderbuffers
#define glDeleteVertexArrays flextGL.DeleteVertexArrays
#define glDisablei flextGL.Disablei
#define glEnablei flextGL.Enablei
#define glEndConditionalRender flextGL.EndConditionalRender
#define glEndTransformFeedback flextGL.EndTransformFeedback
#define glFlushMappedBufferRange flextGL.FlushMappedBufferRange
#define glFramebufferRenderbuffer flextGL.FramebufferRenderbuffer
#define glFramebufferTexture1D flextGL.FramebufferTexture1D
#define glFramebufferTexture2D flextGL.FramebufferTexture2D
#define glFramebufferTexture3D flextGL.FramebufferTexture3D
#define glFramebufferTextureLayer flextGL.FramebufferTextureLayer
#define glGenFramebuffers flextGL.GenFramebuffers
#define glGenRenderbuffers flextGL.GenRenderbuffers
#define glGenVertexArrays flextGL.GenVertexArrays
#define glGenerateMipmap flextGL.GenerateMipmap
#define glGetBooleani_v flextGL.GetBooleani_v
#define glGetFragDataLocation flextGL.GetFragDataLocation
#define glGetFramebufferAttachmentParameteriv flextGL.GetFramebufferAttachmentParameteriv
#define glGetIntegeri_v flextGL.GetIntegeri_v
#define glGetRenderbufferParameteriv flextGL.GetRenderbufferParameteriv
#define glGetStringi flextGL.GetStringi
#define glGetTexParameterIiv flextGL.GetTexParameterIiv
#define glGetTexParameterIuiv flextGL.GetTexParameterIuiv
#define glGetTransformFeedbackVarying flextGL.GetTransformFeedbackVarying
#define glGetUniformuiv flextGL.GetUniformuiv
#define glGetVertexAttribIiv flextGL.GetVertexAttribIiv
#define glGetVertexAttribIuiv flextGL.GetVertexAttribIuiv
#define glIsEnabledi flextGL.IsEnabledi
#define glIsFramebuffer flextGL.IsFramebuffer
#define glIsRenderbuffer flextGL.IsRenderbuffer
#define glIsVertexArray flextGL.IsVertexArray
#define glMapBufferRange flextGL.MapBufferRange
#define glRenderbufferStorage flextGL.RenderbufferStorage
#define glRenderbufferStorageMultisample flextGL.RenderbufferStorageMultisample
#define glTexParameterIiv flextGL.TexParameterIiv
#define glTexParameterIuiv flextGL.TexParameterIuiv
#define glTransformFeedbackVaryings flextGL.TransformFeedbackVaryings
#define glUniform1ui flextGL.Uniform1ui
#define glUniform1uiv flextGL.Uniform1uiv
#define glUniform2ui flextGL.Uniform2ui
#define glUniform2uiv flextGL.Uniform2uiv
#define glUniform3ui flextGL.Uniform3ui
#define glUniform3uiv flextGL.Uniform3uiv
#define glUniform4ui flextGL.Uniform4ui
#define glUniform4uiv flextGL.Uniform4uiv
#define glVertexAttribI1i flextGL.VertexAttribI1i
#define glVertexAttribI1iv flextGL.VertexAttribI1iv
#define glVertexAttribI1ui flextGL.VertexAttribI1ui
#define glVertexAttribI1uiv flextGL.VertexAttribI1uiv
#define glVertexAttribI2i flextGL.VertexAttribI2i
#define glVertexAttribI2iv flextGL.VertexAttribI2iv
#define glVertexAttribI2ui flextGL.VertexAttribI2ui
#define glVertexAttribI2uiv flextGL.VertexAttribI2uiv
#define glVertexAttribI3i flextGL.VertexAttribI3i
#define glVertexAttribI3iv flextGL.VertexAttribI3iv
#define glVertexAttribI3ui flextGL.VertexAttribI3ui
#define glVertexAttribI3uiv flextGL.VertexAttribI3uiv
#define glVertexAttribI4bv flextGL.VertexAttribI4bv
#define glVertexAttribI4i flextGL.VertexAttribI4i
#define glVertexAttribI4iv flextGL.VertexAttribI4iv
#define glVertexAttribI4sv flextGL.VertexAttribI4sv
#define glVertexAttribI4ubv flextGL.VertexAttribI4ubv
#define glVertexAttribI4ui flextGL.VertexAttribI4ui
#define glVertexAttribI4uiv flextGL.VertexAttribI4uiv
#define glVertexAttribI4usv flextGL.VertexAttribI4usv
#define glVertexAttribIPointer flextGL.VertexAttribIPointer

/* GL_VERSION_3_1 */

#define glCopyBufferSubData flextGL.CopyBufferSubData
#define glDrawArraysInstanced flextGL.DrawArraysInstanced
#define glDrawElementsInstanced flextGL.DrawElementsInstanced
#define glGetActiveUniformBlockName flextGL.GetActiveUniformBlockName
#define glGetActiveUniformBlockiv flextGL.GetActiveUniformBlockiv
#define glGetActiveUniformName flextGL.GetActiveUniformName
#define glGetActiveUniformsiv flextGL.GetActiveUniformsiv
#define glGetUniformBlockIndex flextGL.GetUniformBlockIndex
#define glGetUniformIndices flextGL.GetUniformIndices
#define glPrimitiveRestartIndex flextGL.PrimitiveRestartIndex
#define glTexBuffer flextGL.TexBuffer
#define glUniformBlockBinding flextGL.UniformBlockBinding

/* GL_VERSION_3_2 */

#define glClientWaitSync flextGL.ClientWaitSync
#define glDeleteSync flextGL.DeleteSync
#define glDrawElementsBaseVertex flextGL.DrawElementsBaseVertex
#define glDrawElementsInstancedBaseVertex flextGL.DrawElementsInstancedBaseVertex
#define glDrawRangeElementsBaseVertex flextGL.DrawRangeElementsBaseVertex
#define glFenceSync flextGL.FenceSync
#define glFramebufferTexture flextGL.FramebufferTexture
#define glGetBufferParameteri64v flextGL.GetBufferParameteri64v
#define glGetInteger64i_v flextGL.GetInteger64i_v
#define glGetInteger64v flextGL.GetInteger64v
#define glGetMultisamplefv flextGL.GetMultisamplefv
#define glGetSynciv flextGL.GetSynciv
#define glIsSync flextGL.IsSync
#define glMultiDrawElementsBaseVertex flextGL.MultiDrawElementsBaseVertex
#define glProvokingVertex flextGL.ProvokingVertex
#define glSampleMaski flextGL.SampleMaski
#define glTexImage2DMultisample flextGL.TexImage2DMultisample
#define glTexImage3DMultisample flextGL.TexImage3DMultisample
#define glWaitSync flextGL.WaitSync

/* GL_VERSION_3_3 */

#define glBindFragDataLocationIndexed flextGL.BindFragDataLocationIndexed
#define glBindSampler flextGL.BindSampler
#define glDeleteSamplers flextGL.DeleteSamplers
#define glGenSamplers flextGL.GenSamplers
#define glGetFragDataIndex flextGL.GetFragDataIndex
#define glGetQueryObjecti64v flextGL.GetQueryObjecti64v
#define glGetQueryObjectui64v flextGL.GetQueryObjectui64v
#define glGetSamplerParameterIiv flextGL.GetSamplerParameterIiv
#define glGetSamplerParameterIuiv flextGL.GetSamplerParameterIuiv
#define glGetSamplerParameterfv flextGL.GetSamplerParameterfv
#define glGetSamplerParameteriv flextGL.GetSamplerParameteriv
#define glIsSampler flextGL.IsSampler
#define glQueryCounter flextGL.QueryCounter
#define glSamplerParameterIiv flextGL.SamplerParameterIiv
#define glSamplerParameterIuiv flextGL.SamplerParameterIuiv
#define glSamplerParameterf flextGL.SamplerParameterf
#define glSamplerParameterfv flextGL.SamplerParameterfv
#define glSamplerParameteri flextGL.SamplerParameteri
#define glSamplerParameteriv flextGL.SamplerParameteriv
#define glVertexAttribDivisor flextGL.VertexAttribDivisor
#define glVertexAttribP1ui flextGL.VertexAttribP1ui
#define glVertexAttribP1uiv flextGL.VertexAttribP1uiv
#define glVertexAttribP2ui flextGL.VertexAttribP2ui
#define glVertexAttribP2uiv flextGL.VertexAttribP2uiv
#define glVertexAttribP3ui flextGL.VertexAttribP3ui
#define glVertexAttribP3uiv flextGL.VertexAttribP3uiv
#define glVertexAttribP4ui flextGL.VertexAttribP4ui
#define glVertexAttribP4uiv flextGL.VertexAttribP4uiv

/* GL_VERSION_4_0 */

#define glBeginQueryIndexed flextGL.BeginQueryIndexed
#define glBindTransformFeedback flextGL.BindTransformFeedback
#define glBlendEquationSeparatei flextGL.BlendEquationSeparatei
#define glBlendEquationi flextGL.BlendEquationi
#define glBlendFuncSeparatei flextGL.BlendFuncSeparatei
#define glBlendFunci flextGL.BlendFunci
#define glDeleteTransformFeedbacks flextGL.DeleteTransformFeedbacks
#define glDrawArraysIndirect flextGL.DrawArraysIndirect
#define glDrawElementsIndirect flextGL.DrawElementsIndirect
#define glDrawTransformFeedback flextGL.DrawTransformFeedback
#define glDrawTransformFeedbackStream flextGL.DrawTransformFeedbackStream
#define glEndQueryIndexed flextGL.EndQueryIndexed
#define glGenTransformFeedbacks flextGL.GenTransformFeedbacks
#define glGetActiveSubroutineName flextGL.GetActiveSubroutineName
#define glGetActiveSubroutineUniformName flextGL.GetActiveSubroutineUniformName
#define glGetActiveSubroutineUniformiv flextGL.GetActiveSubroutineUniformiv
#define glGetProgramStageiv flextGL.GetProgramStageiv
#define glGetQueryIndexediv flextGL.GetQueryIndexediv
#define glGetSubroutineIndex flextGL.GetSubroutineIndex
#define glGetSubroutineUniformLocation flextGL.GetSubroutineUniformLocation
#define glGetUniformSubroutineuiv flextGL.GetUniformSubroutineuiv
#define glGetUniformdv flextGL.GetUniformdv
#define glIsTransformFeedback flextGL.IsTransformFeedback
#define glMinSampleShading flextGL.MinSampleShading
#define glPatchParameterfv flextGL.PatchParameterfv
#define glPatchParameteri flextGL.PatchParameteri
#define glPauseTransformFeedback flextGL.PauseTransformFeedback
#define glResumeTransformFeedback flextGL.ResumeTransformFeedback
#define glUniform1d flextGL.Uniform1d
#define glUniform1dv flextGL.Uniform1dv
#define glUniform2d flextGL.Uniform2d
#define glUniform2dv flextGL.Uniform2dv
#define glUniform3d flextGL.Uniform3d
#define glUniform3dv flextGL.Uniform3dv
#define glUniform4d flextGL.Uniform4d
#define glUniform4dv flextGL.Uniform4dv
#define glUniformMatrix2dv flextGL.UniformMatrix2dv
#define glUniformMatrix2x3dv flextGL.UniformMatrix2x3dv
#define glUniformMatrix2x4dv flextGL.UniformMatrix2x4dv
#define glUniformMatrix3dv flextGL.UniformMatrix3dv
#define glUniformMatrix3x2dv flextGL.UniformMatrix3x2dv
#define glUniformMatrix3x4dv flextGL.UniformMatrix3x4dv
#define glUniformMatrix4dv flextGL.UniformMatrix4dv
#define glUniformMatrix4x2dv flextGL.UniformMatrix4x2dv
#define glUniformMatrix4x3dv flextGL.UniformMatrix4x3dv
#define glUniformSubroutinesuiv flextGL.UniformSubroutinesuiv

/* GL_VERSION_4_1 */

#define glActiveShaderProgram flextGL.ActiveShaderProgram
#define glBindProgramPipeline flextGL.BindProgramPipeline
#define glClearDepthf flextGL.ClearDepthf
#define glCreateShaderProgramv flextGL.CreateShaderProgramv
#define glDeleteProgramPipelines flextGL.DeleteProgramPipelines
#define glDepthRangeArrayv flextGL.DepthRangeArrayv
#define glDepthRangeIndexed flextGL.DepthRangeIndexed
#define glDepthRangef flextGL.DepthRangef
#define glGenProgramPipelines flextGL.GenProgramPipelines
#define glGetDoublei_v flextGL.GetDoublei_v
#define glGetFloati_v flextGL.GetFloati_v
#define glGetProgramBinary flextGL.GetProgramBinary
#define glGetProgramPipelineInfoLog flextGL.GetProgramPipelineInfoLog
#define glGetProgramPipelineiv flextGL.GetProgramPipelineiv
#define glGetShaderPrecisionFormat flextGL.GetShaderPrecisionFormat
#define glGetVertexAttribLdv flextGL.GetVertexAttribLdv
#define glIsProgramPipeline flextGL.IsProgramPipeline
#define glProgramBinary flextGL.ProgramBinary
#define glProgramParameteri flextGL.ProgramParameteri
#define glProgramUniform1d flextGL.ProgramUniform1d
#define glProgramUniform1dv flextGL.ProgramUniform1dv
#define glProgramUniform1f flextGL.ProgramUniform1f
#define glProgramUniform1fv flextGL.ProgramUniform1fv
#define glProgramUniform1i flextGL.ProgramUniform1i
#define glProgramUniform1iv flextGL.ProgramUniform1iv
#define glProgramUniform1ui flextGL.ProgramUniform1ui
#define glProgramUniform1uiv flextGL.ProgramUniform1uiv
#define glProgramUniform2d flextGL.ProgramUniform2d
#define glProgramUniform2dv flextGL.ProgramUniform2dv
#define glProgramUniform2f flextGL.ProgramUniform2f
#define glProgramUniform2fv flextGL.ProgramUniform2fv
#define glProgramUniform2i flextGL.ProgramUniform2i
#define glProgramUniform2iv flextGL.ProgramUniform2iv
#define glProgramUniform2ui flextGL.ProgramUniform2ui
#define glProgramUniform2uiv flextGL.ProgramUniform2uiv
#define glProgramUniform3d flextGL.ProgramUniform3d
#define glProgramUniform3dv flextGL.ProgramUniform3dv
#define glProgramUniform3f flextGL.ProgramUniform3f
#define glProgramUniform3fv flextGL.ProgramUniform3fv
#define glProgramUniform3i flextGL.ProgramUniform3i
#define glProgramUniform3iv flextGL.ProgramUniform3iv
#define glProgramUniform3ui flextGL.ProgramUniform3ui
#define glProgramUniform3uiv flextGL.ProgramUniform3uiv
#define glProgramUniform4d flextGL.ProgramUniform4d
#define glProgramUniform4dv flextGL.ProgramUniform4dv
#define glProgramUniform4f flextGL.ProgramUniform4f
#define glProgramUniform4fv flextGL.ProgramUniform4fv
#define glProgramUniform4i flextGL.ProgramUniform4i
#define glProgramUniform4iv flextGL.ProgramUniform4iv
#define glProgramUniform4ui flextGL.ProgramUniform4ui
#define glProgramUniform4uiv flextGL.ProgramUniform4uiv
#define glProgramUniformMatrix2dv flextGL.ProgramUniformMatrix2dv
#define glProgramUniformMatrix2fv flextGL.ProgramUniformMatrix2fv
#define glProgramUniformMatrix2x3dv flextGL.ProgramUniformMatrix2x3dv
#define glProgramUniformMatrix2x3fv flextGL.ProgramUniformMatrix2x3fv
#define glProgramUniformMatrix2x4dv flextGL.ProgramUniformMatrix2x4dv
#define glProgramUniformMatrix2x4fv flextGL.ProgramUniformMatrix2x4fv
#define glProgramUniformMatrix3dv flextGL.ProgramUniformMatrix3dv
#define glProgramUniformMatrix3fv flextGL.ProgramUniformMatrix3fv
#define glProgramUniformMatrix3x2dv flextGL.ProgramUniformMatrix3x2dv
#define glProgramUniformMatrix3x2fv flextGL.ProgramUniformMatrix3x2fv
#define glProgramUniformMatrix3x4dv flextGL.ProgramUniformMatrix3x4dv
#define glProgramUniformMatrix3x4fv flextGL.ProgramUniformMatrix3x4fv
#define glProgramUniformMatrix4dv flextGL.ProgramUniformMatrix4dv
#define glProgramUniformMatrix4fv flextGL.ProgramUniformMatrix4fv
#define glProgramUniformMatrix4x2dv flextGL.ProgramUniformMatrix4x2dv
#define glProgramUniformMatrix4x2fv flextGL.ProgramUniformMatrix4x2fv
#define glProgramUniformMatrix4x3dv flextGL.ProgramUniformMatrix4x3dv
#define glProgramUniformMatrix4x3fv flextGL.ProgramUniformMatrix4x3fv
#define glReleaseShaderCompiler flextGL.ReleaseShaderCompiler
#define glScissorArrayv flextGL.ScissorArrayv
#define glScissorIndexed flextGL.ScissorIndexed
#define glScissorIndexedv flextGL.ScissorIndexedv
#define glShaderBinary flextGL.ShaderBinary
#define glUseProgramStages flextGL.UseProgramStages
#define glValidateProgramPipeline flextGL.ValidateProgramPipeline
#define glVertexAttribL1d flextGL.VertexAttribL1d
#define glVertexAttribL1dv flextGL.VertexAttribL1dv
#define glVertexAttribL2d flextGL.VertexAttribL2d
#define glVertexAttribL2dv flextGL.VertexAttribL2dv
#define glVertexAttribL3d flextGL.VertexAttribL3d
#define glVertexAttribL3dv flextGL.VertexAttribL3dv
#define glVertexAttribL4d flextGL.VertexAttribL4d
#define glVertexAttribL4dv flextGL.VertexAttribL4dv
#define glVertexAttribLPointer flextGL.VertexAttribLPointer
#define glViewportArrayv flextGL.ViewportArrayv
#define glViewportIndexedf flextGL.ViewportIndexedf
#define glViewportIndexedfv flextGL.ViewportIndexedfv

/* GL_VERSION_4_2 */

#define glBindImageTexture flextGL.BindImageTexture
#define glDrawArraysInstancedBaseInstance flextGL.DrawArraysInstancedBaseInstance
#define glDrawElementsInstancedBaseInstance flextGL.DrawElementsInstancedBaseInstance
#define glDrawElementsInstancedBaseVertexBaseInstance flextGL.DrawElementsInstancedBaseVertexBaseInstance
#define glDrawTransformFeedbackInstanced flextGL.DrawTransformFeedbackInstanced
#define glDrawTransformFeedbackStreamInstanced flextGL.DrawTransformFeedbackStreamInstanced
#define glGetActiveAtomicCounterBufferiv flextGL.GetActiveAtomicCounterBufferiv
#define glGetInternalformativ flextGL.GetInternalformativ
#define glMemoryBarrier flextGL.MemoryBarrier
#define glTexStorage1D flextGL.TexStorage1D
#define glTexStorage2D flextGL.TexStorage2D
#define glTexStorage3D flextGL.TexStorage3D

/* GL_VERSION_4_3 */

#define glBindVertexBuffer flextGL.BindVertexBuffer
#define glClearBufferData flextGL.ClearBufferData
#define glClearBufferSubData flextGL.ClearBufferSubData
#define glCopyImageSubData flextGL.CopyImageSubData
#define glDebugMessageCallback flextGL.DebugMessageCallback
#define glDebugMessageControl flextGL.DebugMessageControl
#define glDebugMessageInsert flextGL.DebugMessageInsert
#define glDispatchCompute flextGL.DispatchCompute
#define glDispatchComputeIndirect flextGL.DispatchComputeIndirect
#define glFramebufferParameteri flextGL.FramebufferParameteri
#define glGetDebugMessageLog flextGL.GetDebugMessageLog
#define glGetFramebufferParameteriv flextGL.GetFramebufferParameteriv
#define glGetInternalformati64v flextGL.GetInternalformati64v
#define glGetObjectLabel flextGL.GetObjectLabel
#define glGetObjectPtrLabel flextGL.GetObjectPtrLabel
#define glGetPointerv flextGL.GetPointerv
#define glGetProgramInterfaceiv flextGL.GetProgramInterfaceiv
#define glGetProgramResourceIndex flextGL.GetProgramResourceIndex
#define glGetProgramResourceLocation flextGL.GetProgramResourceLocation
#define glGetProgramResourceLocationIndex flextGL.GetProgramResourceLocationIndex
#define glGetProgramResourceName flextGL.GetProgramResourceName
#define glGetProgramResourceiv flextGL.GetProgramResourceiv
#define glInvalidateBufferData flextGL.InvalidateBufferData
#define glInvalidateBufferSubData flextGL.InvalidateBufferSubData
#define glInvalidateFramebuffer flextGL.InvalidateFramebuffer
#define glInvalidateSubFramebuffer flextGL.InvalidateSubFramebuffer
#define glInvalidateTexImage flextGL.InvalidateTexImage
#define glInvalidateTexSubImage flextGL.InvalidateTexSubImage
#define glMultiDrawArraysIndirect flextGL.MultiDrawArraysIndirect
#define glMultiDrawElementsIndirect flextGL.MultiDrawElementsIndirect
#define glObjectLabel flextGL.ObjectLabel
#define glObjectPtrLabel flextGL.ObjectPtrLabel
#define glPopDebugGroup flextGL.PopDebugGroup
#define glPushDebugGroup flextGL.PushDebugGroup
#define glShaderStorageBlockBinding flextGL.ShaderStorageBlockBinding
#define glTexBufferRange flextGL.TexBufferRange
#define glTexStorage2DMultisample flextGL.TexStorage2DMultisample
#define glTexStorage3DMultisample flextGL.TexStorage3DMultisample
#define glTextureView flextGL.TextureView
#define glVertexAttribBinding flextGL.VertexAttribBinding
#define glVertexAttribFormat flextGL.VertexAttribFormat
#define glVertexAttribIFormat flextGL.VertexAttribIFormat
#define glVertexAttribLFormat flextGL.VertexAttribLFormat
#define glVertexBindingDivisor flextGL.VertexBindingDivisor

/* GL_VERSION_4_4 */

#define glBindBuffersBase flextGL.BindBuffersBase
#define glBindBuffersRange flextGL.BindBuffersRange
#define glBindImageTextures flextGL.BindImageTextures
#define glBindSamplers flextGL.BindSamplers
#define glBindTextures flextGL.BindTextures
#define glBindVertexBuffers flextGL.BindVertexBuffers
#define glBufferStorage flextGL.BufferStorage
#define glClearTexImage flextGL.ClearTexImage
#define glClearTexSubImage flextGL.ClearTexSubImage

/* GL_VERSION_4_5 */

#define glBindTextureUnit flextGL.BindTextureUnit
#define glBlitNamedFramebuffer flextGL.BlitNamedFramebuffer
#define glCheckNamedFramebufferStatus flextGL.CheckNamedFramebufferStatus
#define glClearNamedBufferData flextGL.ClearNamedBufferData
#define glClearNamedBufferSubData flextGL.ClearNamedBufferSubData
#define glClearNamedFramebufferfi flextGL.ClearNamedFramebufferfi
#define glClearNamedFramebufferfv flextGL.ClearNamedFramebufferfv
#define glClearNamedFramebufferiv flextGL.ClearNamedFramebufferiv
#define glClearNamedFramebufferuiv flextGL.ClearNamedFramebufferuiv
#define glClipControl flextGL.ClipControl
#define glCompressedTextureSubImage1D flextGL.CompressedTextureSubImage1D
#define glCompressedTextureSubImage2D flextGL.CompressedTextureSubImage2D
#define glCompressedTextureSubImage3D flextGL.CompressedTextureSubImage3D
#define glCopyNamedBufferSubData flextGL.CopyNamedBufferSubData
#define glCopyTextureSubImage1D flextGL.CopyTextureSubImage1D
#define glCopyTextureSubImage2D flextGL.CopyTextureSubImage2D
#define glCopyTextureSubImage3D flextGL.CopyTextureSubImage3D
#define glCreateBuffers flextGL.CreateBuffers
#define glCreateFramebuffers flextGL.CreateFramebuffers
#define glCreateProgramPipelines flextGL.CreateProgramPipelines
#define glCreateQueries flextGL.CreateQueries
#define glCreateRenderbuffers flextGL.CreateRenderbuffers
#define glCreateSamplers flextGL.CreateSamplers
#define glCreateTextures flextGL.CreateTextures
#define glCreateTransformFeedbacks flextGL.CreateTransformFeedbacks
#define glCreateVertexArrays flextGL.CreateVertexArrays
#define glDisableVertexArrayAttrib flextGL.DisableVertexArrayAttrib
#define glEnableVertexArrayAttrib flextGL.EnableVertexArrayAttrib
#define glFlushMappedNamedBufferRange flextGL.FlushMappedNamedBufferRange
#define glGenerateTextureMipmap flextGL.GenerateTextureMipmap
#define glGetCompressedTextureImage flextGL.GetCompressedTextureImage
#define glGetCompressedTextureSubImage flextGL.GetCompressedTextureSubImage
#define glGetGraphicsResetStatus flextGL.GetGraphicsResetStatus
#define glGetNamedBufferParameteri64v flextGL.GetNamedBufferParameteri64v
#define glGetNamedBufferParameteriv flextGL.GetNamedBufferParameteriv
#define glGetNamedBufferPointerv flextGL.GetNamedBufferPointerv
#define glGetNamedBufferSubData flextGL.GetNamedBufferSubData
#define glGetNamedFramebufferAttachmentParameteriv flextGL.GetNamedFramebufferAttachmentParameteriv
#define glGetNamedFramebufferParameteriv flextGL.GetNamedFramebufferParameteriv
#define glGetNamedRenderbufferParameteriv flextGL.GetNamedRenderbufferParameteriv
#define glGetQueryBufferObjecti64v flextGL.GetQueryBufferObjecti64v
#define glGetQueryBufferObjectiv flextGL.GetQueryBufferObjectiv
#define glGetQueryBufferObjectui64v flextGL.GetQueryBufferObjectui64v
#define glGetQueryBufferObjectuiv flextGL.GetQueryBufferObjectuiv
#define glGetTextureImage flextGL.GetTextureImage
#define glGetTextureLevelParameterfv flextGL.GetTextureLevelParameterfv
#define glGetTextureLevelParameteriv flextGL.GetTextureLevelParameteriv
#define glGetTextureParameterIiv flextGL.GetTextureParameterIiv
#define glGetTextureParameterIuiv flextGL.GetTextureParameterIuiv
#define glGetTextureParameterfv flextGL.GetTextureParameterfv
#define glGetTextureParameteriv flextGL.GetTextureParameteriv
#define glGetTextureSubImage flextGL.GetTextureSubImage
#define glGetTransformFeedbacki64_v flextGL.GetTransformFeedbacki64_v
#define glGetTransformFeedbacki_v flextGL.GetTransformFeedbacki_v
#define glGetTransformFeedbackiv flextGL.GetTransformFeedbackiv
#define glGetVertexArrayIndexed64iv flextGL.GetVertexArrayIndexed64iv
#define glGetVertexArrayIndexediv flextGL.GetVertexArrayIndexediv
#define glGetVertexArrayiv flextGL.GetVertexArrayiv
#define glGetnCompressedTexImage flextGL.GetnCompressedTexImage
#define glGetnTexImage flextGL.GetnTexImage
#define glGetnUniformdv flextGL.GetnUniformdv
#define glGetnUniformfv flextGL.GetnUniformfv
#define glGetnUniformiv flextGL.GetnUniformiv
#define glGetnUniformuiv flextGL.GetnUniformuiv
#define glInvalidateNamedFramebufferData flextGL.InvalidateNamedFramebufferData
#define glInvalidateNamedFramebufferSubData flextGL.InvalidateNamedFramebufferSubData
#define glMapNamedBuffer flextGL.MapNamedBuffer
#define glMapNamedBufferRange flextGL.MapNamedBufferRange
#define glMemoryBarrierByRegion flextGL.MemoryBarrierByRegion
#define glNamedBufferData flextGL.NamedBufferData
#define glNamedBufferStorage flextGL.NamedBufferStorage
#define glNamedBufferSubData flextGL.NamedBufferSubData
#define glNamedFramebufferDrawBuffer flextGL.NamedFramebufferDrawBuffer
#define glNamedFramebufferDrawBuffers flextGL.NamedFramebufferDrawBuffers
#define glNamedFramebufferParameteri flextGL.NamedFramebufferParameteri
#define glNamedFramebufferReadBuffer flextGL.NamedFramebufferReadBuffer
#define glNamedFramebufferRenderbuffer flextGL.NamedFramebufferRenderbuffer
#define glNamedFramebufferTexture flextGL.NamedFramebufferTexture
#define glNamedFramebufferTextureLayer flextGL.NamedFramebufferTextureLayer
#define glNamedRenderbufferStorage flextGL.NamedRenderbufferStorage
#define glNamedRenderbufferStorageMultisample flextGL.NamedRenderbufferStorageMultisample
#define glReadnPixels flextGL.ReadnPixels
#define glTextureBarrier flextGL.TextureBarrier
#define glTextureBuffer flextGL.TextureBuffer
#define glTextureBufferRange flextGL.TextureBufferRange
#define glTextureParameterIiv flextGL.TextureParameterIiv
#define glTextureParameterIuiv flextGL.TextureParameterIuiv
#define glTextureParameterf flextGL.TextureParameterf
#define glTextureParameterfv flextGL.TextureParameterfv
#define glTextureParameteri flextGL.TextureParameteri
#define glTextureParameteriv flextGL.TextureParameteriv
#define glTextureStorage1D flextGL.TextureStorage1D
#define glTextureStorage2D flextGL.TextureStorage2D
#define glTextureStorage2DMultisample flextGL.TextureStorage2DMultisample
#define glTextureStorage3D flextGL.TextureStorage3D
#define glTextureStorage3DMultisample flextGL.TextureStorage3DMultisample
#define glTextureSubImage1D flextGL.TextureSubImage1D
#define glTextureSubImage2D flextGL.TextureSubImage2D
#define glTextureSubImage3D flextGL.TextureSubImage3D
#define glTransformFeedbackBufferBase flextGL.TransformFeedbackBufferBase
#define glTransformFeedbackBufferRange flextGL.TransformFeedbackBufferRange
#define glUnmapNamedBuffer flextGL.UnmapNamedBuffer
#define glVertexArrayAttribBinding flextGL.VertexArrayAttribBinding
#define glVertexArrayAttribFormat flextGL.VertexArrayAttribFormat
#define glVertexArrayAttribIFormat flextGL.VertexArrayAttribIFormat
#define glVertexArrayAttribLFormat flextGL.VertexArrayAttribLFormat
#define glVertexArrayBindingDivisor flextGL.VertexArrayBindingDivisor
#define glVertexArrayElementBuffer flextGL.VertexArrayElementBuffer
#define glVertexArrayVertexBuffer flextGL.VertexArrayVertexBuffer
#define glVertexArrayVertexBuffers flextGL.VertexArrayVertexBuffers

/* GL_VERSION_4_6 */

#define glMultiDrawArraysIndirectCount flextGL.MultiDrawArraysIndirectCount
#define glMultiDrawElementsIndirectCount flextGL.MultiDrawElementsIndirectCount
#define glPolygonOffsetClamp flextGL.PolygonOffsetClamp
#define glSpecializeShader flextGL.SpecializeShader
#endif

#ifdef __cplusplus
}
#endif

#endif
