/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx;

import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class TimeSection
implements Comparable<TimeSection> {
    public final TimeSectionEvent ENTERED_EVENT = new TimeSectionEvent((Object)this, null, TimeSectionEvent.TIME_SECTION_ENTERED);
    public final TimeSectionEvent LEFT_EVENT = new TimeSectionEvent((Object)this, null, TimeSectionEvent.TIME_SECTION_LEFT);
    private LocalTime _start;
    private ObjectProperty<LocalTime> start;
    private LocalTime _stop;
    private ObjectProperty<LocalTime> stop;
    private String _text;
    private StringProperty text;
    private Image _icon;
    private ObjectProperty<Image> icon;
    private Color _color;
    private ObjectProperty<Color> color;
    private Color _highlightColor;
    private ObjectProperty<Color> highlightColor;
    private Color _textColor;
    private ObjectProperty<Color> textColor;
    private LocalTime checkedValue;
    private boolean _active;
    private BooleanProperty active;
    private Set<DayOfWeek> days;
    private ObjectProperty<EventHandler<TimeSectionEvent>> onTimeSectionEntered = new SimpleObjectProperty<EventHandler<TimeSectionEvent>>(this, "onTimeSectionEntered");
    private ObjectProperty<EventHandler<TimeSectionEvent>> onTimeSectionLeft = new SimpleObjectProperty<EventHandler<TimeSectionEvent>>(this, "onTimeSectionLeft");

    public TimeSection(String JSON_STRING) {
        Object obj = JSONValue.parse(JSON_STRING);
        JSONObject jsonObj = (JSONObject)obj;
        this._start = LocalTime.parse(((Object)jsonObj.getOrDefault("start", LocalTime.now())).toString());
        this._stop = LocalTime.parse(((Object)jsonObj.getOrDefault("stop", LocalTime.now())).toString());
        this._text = jsonObj.getOrDefault("text", "").toString();
        this._color = Color.web(jsonObj.getOrDefault("color", "#00000000").toString());
        this._highlightColor = Color.web(jsonObj.getOrDefault("highlightColor", "#00000000").toString());
        this._textColor = Color.web(jsonObj.getOrDefault("textColor", "#00000000").toString());
        this._active = Boolean.parseBoolean(jsonObj.getOrDefault("active", "false").toString());
        this._icon = null;
        this.checkedValue = LocalTime.MIN;
        this.days = new HashSet<DayOfWeek>(8);
        this.days.addAll(Arrays.asList(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY));
    }

    public TimeSection() {
        this(LocalTime.now(), LocalTime.now(), "", null, Color.TRANSPARENT, Color.TRANSPARENT, Color.TRANSPARENT, false, DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    public TimeSection(LocalTime START, LocalTime STOP) {
        this(START, STOP, "", null, Color.TRANSPARENT, Color.TRANSPARENT, Color.TRANSPARENT, false, DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    public TimeSection(LocalTime START, LocalTime STOP, Color COLOR) {
        this(START, STOP, "", null, COLOR, COLOR, Color.TRANSPARENT, false, DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    public TimeSection(LocalTime START, LocalTime STOP, Color COLOR, Color HIGHLIGHT_COLOR) {
        this(START, STOP, "", null, COLOR, HIGHLIGHT_COLOR, Color.TRANSPARENT, false, DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    public TimeSection(LocalTime START, LocalTime STOP, Color COLOR, Color HIGHLIGHT_COLOR, DayOfWeek ... DAYS) {
        this(START, STOP, "", null, COLOR, HIGHLIGHT_COLOR, Color.TRANSPARENT, false, DAYS);
    }

    public TimeSection(LocalTime START, LocalTime STOP, Image ICON, Color COLOR) {
        this(START, STOP, "", ICON, COLOR, COLOR, Color.WHITE, false, DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    public TimeSection(LocalTime START, LocalTime STOP, String TEXT, Color COLOR) {
        this(START, STOP, TEXT, null, COLOR, COLOR, Color.WHITE, false, DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    public TimeSection(LocalTime START, LocalTime STOP, String TEXT, Color COLOR, Color TEXT_COLOR) {
        this(START, STOP, TEXT, null, COLOR, COLOR, TEXT_COLOR, false, DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    public TimeSection(LocalTime START, LocalTime STOP, String TEXT, Image ICON, Color COLOR, Color TEXT_COLOR) {
        this(START, STOP, TEXT, ICON, COLOR, COLOR, TEXT_COLOR, false, DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    public TimeSection(LocalTime START, LocalTime STOP, String TEXT, Image ICON, Color COLOR, Color HIGHLIGHT_COLOR, Color TEXT_COLOR, boolean ACTIVE, DayOfWeek ... DAYS) {
        this._start = START;
        this._stop = STOP;
        this._text = TEXT;
        this._icon = ICON;
        this._color = COLOR;
        this._highlightColor = HIGHLIGHT_COLOR;
        this._textColor = TEXT_COLOR;
        this.checkedValue = LocalTime.MIN;
        this._active = ACTIVE;
        this.days = new HashSet<DayOfWeek>(8);
        this.days.addAll(Arrays.asList(DAYS));
    }

    public LocalTime getStart() {
        return null == this.start ? this._start : (LocalTime)this.start.get();
    }

    public void setStart(LocalTime START) {
        if (null == this.start) {
            this._start = START;
        } else {
            this.start.set(START);
        }
    }

    public ObjectProperty<LocalTime> startProperty() {
        if (null == this.start) {
            this.start = new SimpleObjectProperty<LocalTime>(this, "start", this._start);
        }
        return this.start;
    }

    public LocalTime getStop() {
        return null == this.stop ? this._stop : (LocalTime)this.stop.get();
    }

    public void setStop(LocalTime STOP) {
        if (null == this.stop) {
            this._stop = STOP;
        } else {
            this.stop.set(STOP);
        }
    }

    public ObjectProperty<LocalTime> stopProperty() {
        if (null == this.stop) {
            this.stop = new SimpleObjectProperty<LocalTime>(this, "stop", this._stop);
        }
        return this.stop;
    }

    public String getText() {
        return null == this.text ? this._text : (String)this.text.get();
    }

    public void setText(String TEXT) {
        if (null == this.text) {
            this._text = TEXT;
        } else {
            this.text.set(TEXT);
        }
    }

    public StringProperty textProperty() {
        if (null == this.text) {
            this.text = new SimpleStringProperty(this, "text", this._text);
        }
        return this.text;
    }

    public Image getImage() {
        return null == this.icon ? this._icon : (Image)this.icon.get();
    }

    public void setIcon(Image IMAGE) {
        if (null == this.icon) {
            this._icon = IMAGE;
        } else {
            this.icon.set(IMAGE);
        }
    }

    public ObjectProperty<Image> iconProperty() {
        if (null == this.icon) {
            this.icon = new SimpleObjectProperty<Image>(this, "icon", this._icon);
        }
        return this.icon;
    }

    public Color getColor() {
        return null == this.color ? this._color : (Color)this.color.get();
    }

    public void setColor(Color COLOR) {
        if (null == this.color) {
            this._color = COLOR;
        } else {
            this.color.set(COLOR);
        }
    }

    public ObjectProperty<Color> colorProperty() {
        if (null == this.color) {
            this.color = new SimpleObjectProperty<Color>(this, "color", this._color);
        }
        return this.color;
    }

    public Color getHighlightColor() {
        return null == this.highlightColor ? this._highlightColor : (Color)this.highlightColor.get();
    }

    public void setHighlightColor(Color COLOR) {
        if (null == this.highlightColor) {
            this._highlightColor = COLOR;
        } else {
            this.highlightColor.set(COLOR);
        }
    }

    public ObjectProperty<Color> highlightColorProperty() {
        if (null == this.highlightColor) {
            this.highlightColor = new SimpleObjectProperty<Color>(this, "highlightColor", this._highlightColor);
        }
        return this.highlightColor;
    }

    public Color getTextColor() {
        return null == this.textColor ? this._textColor : (Color)this.textColor.get();
    }

    public void setTextColor(Color COLOR) {
        if (null == this.textColor) {
            this._textColor = COLOR;
        } else {
            this.textColor.set(COLOR);
        }
    }

    public ObjectProperty<Color> textColorProperty() {
        if (null == this.textColor) {
            this.textColor = new SimpleObjectProperty<Color>(this, "textColor", this._textColor);
        }
        return this.textColor;
    }

    public boolean isActive() {
        return null == this.active ? this._active : this.active.get();
    }

    public void setActive(boolean ACTIVE) {
        if (null == this.active) {
            this._active = ACTIVE;
        } else {
            this.active.set(ACTIVE);
        }
    }

    public ReadOnlyBooleanProperty activeProperty() {
        if (null == this.active) {
            this.active = new BooleanPropertyBase(this._active){

                @Override
                public Object getBean() {
                    return TimeSection.this;
                }

                @Override
                public String getName() {
                    return "active";
                }
            };
        }
        return this.active;
    }

    public Set<DayOfWeek> getDays() {
        return this.days;
    }

    public List<DayOfWeek> getDaysAsList() {
        return new ArrayList<DayOfWeek>(this.days);
    }

    public void setDays(DayOfWeek ... DAYS) {
        this.days.clear();
        Collections.addAll(this.days, DAYS);
    }

    public void setDays(Set<DayOfWeek> DAYS) {
        this.days.clear();
        this.days.addAll(DAYS);
    }

    public void addDay(DayOfWeek DAY) {
        this.days.add(DAY);
    }

    public void removeDay(DayOfWeek DAY) {
        this.days.remove(DAY);
    }

    public void clearDays() {
        this.days.clear();
    }

    public boolean contains(LocalTime VALUE) {
        return VALUE.isAfter(this.getStart()) && VALUE.isBefore(this.getStop());
    }

    public void checkForTime(LocalTime VALUE) {
        if (!this.isActive()) {
            return;
        }
        boolean wasInSection = this.contains(this.checkedValue);
        boolean isInSection = this.contains(VALUE);
        if (!wasInSection && isInSection) {
            this.fireTimeSectionEvent(this.ENTERED_EVENT);
        } else if (wasInSection && !isInSection) {
            this.fireTimeSectionEvent(this.LEFT_EVENT);
        }
        this.checkedValue = VALUE;
    }

    public void checkForTimeAndDay(LocalTime VALUE, DayOfWeek DAY) {
        if (this.days.contains(DAY)) {
            this.checkForTime(VALUE);
        }
    }

    public void checkForTimeAndDate(ZonedDateTime DATE_TIME) {
        if (this.days.contains(DATE_TIME.getDayOfWeek())) {
            this.checkForTime(DATE_TIME.toLocalTime());
        }
    }

    public boolean equals(TimeSection SECTION) {
        return SECTION.getStart().equals(this.getStart()) && SECTION.getStop().equals(this.getStop()) && SECTION.getText().equals(this.getText());
    }

    @Override
    public int compareTo(TimeSection SECTION) {
        if (this.getStart().isBefore(SECTION.getStart())) {
            return -1;
        }
        if (this.getStart().isAfter(SECTION.getStart())) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "{\n" + "\"text\":\"" + this.getText() + "\",\n" + "\"startValue\":" + this.getStart() + ",\n" + "\"stopValue\":" + this.getStop() + ",\n" + "\"color\":\"" + this.getColor().toString().substring(0, 8).replace("0x", "#") + "\",\n" + "\"highlightColor\":\"" + this.getHighlightColor().toString().substring(0, 8).replace("0x", "#") + "\",\n" + "\"textColor\":\"" + this.getTextColor().toString().substring(0, 8).replace("0x", "#") + "\"\n" + "}";
    }

    public JSONObject toJSON() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("start", this.getStart().toString());
        jsonObject.put("stop", this.getStop().toString());
        jsonObject.put("text", this.getText());
        jsonObject.put("color", this.getColor().toString().replace("0x", "#"));
        jsonObject.put("highlightColor", this.getHighlightColor().toString().replace("0x", "#"));
        jsonObject.put("textColor", this.getTextColor().toString().replace("0x", "#"));
        jsonObject.put("active", this.isActive());
        return jsonObject;
    }

    public String toJSONString() {
        return this.toJSON().toJSONString();
    }

    public final ObjectProperty<EventHandler<TimeSectionEvent>> onTimeSectionEnteredProperty() {
        return this.onTimeSectionEntered;
    }

    public final void setOnTimeSectionEntered(EventHandler<TimeSectionEvent> value) {
        this.onTimeSectionEnteredProperty().set(value);
    }

    public final EventHandler<TimeSectionEvent> getOnTimeSectionEntered() {
        return (EventHandler)this.onTimeSectionEnteredProperty().get();
    }

    public final ObjectProperty<EventHandler<TimeSectionEvent>> onTimeSectionLeftProperty() {
        return this.onTimeSectionLeft;
    }

    public final void setOnTimeSectionLeft(EventHandler<TimeSectionEvent> value) {
        this.onTimeSectionLeftProperty().set(value);
    }

    public final EventHandler<TimeSectionEvent> getOnTimeSectionLeft() {
        return (EventHandler)this.onTimeSectionLeftProperty().get();
    }

    public void fireTimeSectionEvent(TimeSectionEvent EVENT) {
        EventType<? extends Event> TYPE2 = EVENT.getEventType();
        EventHandler<TimeSectionEvent> HANDLER = TimeSectionEvent.TIME_SECTION_ENTERED == TYPE2 ? this.getOnTimeSectionEntered() : (TimeSectionEvent.TIME_SECTION_LEFT == TYPE2 ? this.getOnTimeSectionLeft() : null);
        if (null == HANDLER) {
            return;
        }
        HANDLER.handle(EVENT);
    }

    public static class TimeSectionEvent
    extends Event {
        public static final EventType<TimeSectionEvent> TIME_SECTION_ENTERED = new EventType(ANY, "TIME_SECTION_ENTERED");
        public static final EventType<TimeSectionEvent> TIME_SECTION_LEFT = new EventType(ANY, "TIME_SECTION_LEFT");

        public TimeSectionEvent(Object SOURCE, EventTarget TARGET, EventType<TimeSectionEvent> TYPE2) {
            super(SOURCE, TARGET, TYPE2);
        }
    }
}

